/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.appletextendedsecurity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.jnlp.security.appletextendedsecurity.ExecuteAppletAction;

public class AppletSecurityActions
implements Iterable<ExecuteAppletAction> {
    private final List<ExecuteAppletAction> actions = new ArrayList<ExecuteAppletAction>();
    public static final int UNSIGNED_APPLET_ACTION = 0;
    public static final int MATCHING_ALACA_ACTION = 1;
    public static final int REMEMBER_COLUMNS_COUNT = Collections.max(Arrays.asList(0, 1)) + 1;

    public static AppletSecurityActions createDefault() {
        AppletSecurityActions asas = new AppletSecurityActions();
        asas.setUnsignedAppletAction(ExecuteAppletAction.UNSET);
        asas.setMatchingAlacaAction(ExecuteAppletAction.UNSET);
        return asas;
    }

    public static AppletSecurityActions fromAction(int id, ExecuteAppletAction s) {
        if (s == null) {
            s = ExecuteAppletAction.UNSET;
        }
        AppletSecurityActions asas = new AppletSecurityActions();
        asas.setAction(id, s);
        return asas;
    }

    static AppletSecurityActions fromString(String s) {
        if (s == null) {
            s = "";
        }
        s = s.trim();
        AppletSecurityActions asas = new AppletSecurityActions();
        for (char x : s.toCharArray()) {
            if (Character.isWhitespace(x)) break;
            asas.actions.add(ExecuteAppletAction.fromChar(x));
        }
        return asas;
    }

    public ExecuteAppletAction getAction(int i) {
        if (i >= this.actions.size()) {
            return ExecuteAppletAction.UNSET;
        }
        return this.actions.get(i);
    }

    public void setAction(int i, ExecuteAppletAction a) {
        while (this.actions.size() <= i) {
            this.actions.add(ExecuteAppletAction.UNSET);
        }
        this.actions.set(i, a);
    }

    public ExecuteAppletAction getUnsignedAppletAction() {
        return this.getAction(0);
    }

    public void setUnsignedAppletAction(ExecuteAppletAction a) {
        this.setAction(0, a);
    }

    public ExecuteAppletAction getMatchingAlacaAction() {
        return this.getAction(1);
    }

    public void setMatchingAlacaAction(ExecuteAppletAction a) {
        this.setAction(1, a);
    }

    public String toString() {
        return this.toShortString();
    }

    public String toLongString() {
        StringBuilder sb = new StringBuilder();
        for (ExecuteAppletAction executeAppletAction : this.actions) {
            sb.append(executeAppletAction.toString()).append("; ");
        }
        return sb.toString();
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder();
        for (ExecuteAppletAction executeAppletAction : this.actions) {
            sb.append(executeAppletAction.toChar());
        }
        return sb.toString();
    }

    public int getRealCount() {
        return this.actions.size();
    }

    List<ExecuteAppletAction> getActions() {
        return this.actions;
    }

    @Override
    public Iterator<ExecuteAppletAction> iterator() {
        return this.actions.iterator();
    }
}

