/*
 * Decompiled with CFR 0.152.
 */
package jadx.cli.tools;

import jadx.api.JadxArgs;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.android.TextResMapFile;
import jadx.core.xmlgen.ResTableParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertArscFile {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertArscFile.class);
    private static int rewritesCount;

    public static void usage() {
        LOG.info("<res-map file> <input .arsc files>");
        LOG.info("");
        LOG.info("Note: If res-map already exists - it will be merged and updated");
    }

    public static void main(String[] args) throws IOException {
        List inputPaths;
        Path resMapFile;
        if (args.length < 2) {
            ConvertArscFile.usage();
            System.exit(1);
        }
        HashMap<Integer, String> resMap = Files.isReadable(resMapFile = (Path)(inputPaths = Stream.of(args).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList())).remove(0)) ? TextResMapFile.read((Path)resMapFile) : new HashMap<Integer, String>();
        LOG.info("Input entries count: {}", (Object)resMap.size());
        RootNode root = new RootNode(new JadxArgs());
        rewritesCount = 0;
        for (Path resFile : inputPaths) {
            ResTableParser resTableParser;
            block41: {
                Throwable throwable;
                LOG.info("Processing {}", (Object)resFile);
                resTableParser = new ResTableParser(root, true);
                if (resFile.getFileName().toString().endsWith(".jar")) {
                    ZipFile zip = new ZipFile(resFile.toFile());
                    throwable = null;
                    try {
                        ZipEntry entry = zip.getEntry("resources.arsc");
                        if (entry == null) {
                            LOG.error("Failed to load \"resources.arsc\" from {}", (Object)resFile);
                            continue;
                        }
                        try (InputStream inputStream = zip.getInputStream(entry);){
                            resTableParser.decode(inputStream);
                            break block41;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (zip == null) continue;
                        if (throwable != null) {
                            try {
                                zip.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        zip.close();
                        continue;
                    }
                }
                throwable = null;
                try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(resFile, new OpenOption[0]));){
                    resTableParser.decode((InputStream)inputStream);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            Map singleResMap = resTableParser.getResStorage().getResourcesNames();
            ConvertArscFile.mergeResMaps(resMap, singleResMap);
            LOG.info("{} entries count: {}, after merge: {}", new Object[]{resFile.getFileName(), singleResMap.size(), resMap.size()});
        }
        LOG.info("Output entries count: {}", (Object)resMap.size());
        LOG.info("Total rewrites count: {}", (Object)rewritesCount);
        TextResMapFile.write((Path)resMapFile, resMap);
        LOG.info("Result file size: {} B", (Object)resMapFile.toFile().length());
        LOG.info("done");
    }

    private static void mergeResMaps(Map<Integer, String> mainResMap, Map<Integer, String> newResMap) {
        for (Map.Entry<Integer, String> entry : newResMap.entrySet()) {
            String name;
            Integer id = entry.getKey();
            String prevName = mainResMap.put(id, name = entry.getValue());
            if (prevName == null || name.equals(prevName)) continue;
            LOG.debug("Rewrite id: {} from: '{}' to: '{}'", new Object[]{Integer.toHexString(id), prevName, name});
            ++rewritesCount;
        }
    }
}

