/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Random;
import javax.swing.tree.DefaultMutableTreeNode;

public class DynamicTreeNode
extends DefaultMutableTreeNode {
    protected static float nameCount;
    protected static final String[] NAMES;
    protected static Font[] fonts;
    protected static Random nameGen;
    protected static final int DEFAULT_CHILDREN_COUNT = 7;
    protected boolean hasLoaded;

    public DynamicTreeNode(Object o) {
        super(o);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getChildCount() {
        if (!this.hasLoaded) {
            this.loadChildren();
        }
        return super.getChildCount();
    }

    protected void loadChildren() {
        for (int counter = 0; counter < 7; ++counter) {
            int randomIndex = (int)(nameGen.nextFloat() * nameCount);
            String displayString = NAMES[randomIndex];
            Font font = fonts == null || fonts[randomIndex].canDisplayUpTo(displayString) != -1 ? null : fonts[randomIndex];
            SampleData data = counter % 2 == 0 ? new SampleData(font, Color.red, displayString) : new SampleData(font, Color.blue, displayString);
            DynamicTreeNode newNode = new DynamicTreeNode(data);
            this.insert(newNode, counter);
        }
        this.hasLoaded = true;
    }

    static {
        String[] fontNames;
        try {
            fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        catch (Exception e) {
            fontNames = null;
        }
        if (fontNames == null || fontNames.length == 0) {
            NAMES = new String[]{"Mark Andrews", "Tom Ball", "Alan Chung", "Rob Davis", "Jeff Dinkins", "Amy Fowler", "James Gosling", "David Karlton", "Dave Kloba", "Dave Moore", "Hans Muller", "Rick Levenson", "Tim Prinzing", "Chester Rose", "Ray Ryan", "Georges Saab", "Scott Violet", "Kathy Walrath", "Arnaud Weber"};
        } else {
            int fontSize = 12;
            NAMES = fontNames;
            fonts = new Font[NAMES.length];
            int maxCounter = NAMES.length;
            for (int counter = 0; counter < maxCounter; ++counter) {
                try {
                    DynamicTreeNode.fonts[counter] = new Font(fontNames[counter], 0, fontSize);
                }
                catch (Exception e) {
                    DynamicTreeNode.fonts[counter] = null;
                }
                fontSize = (fontSize + 2 - 12) % 12 + 12;
            }
        }
        nameCount = NAMES.length;
        nameGen = new Random(System.currentTimeMillis());
    }
}

