/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.jibri;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.conference.JitsiMeetConferenceImpl;
import org.jitsi.jicofo.jibri.JibriDetector;
import org.jitsi.jicofo.jibri.JibriSession;
import org.jitsi.jicofo.util.ErrorResponse;
import org.jitsi.jicofo.xmpp.IqProcessingResult;
import org.jitsi.jicofo.xmpp.IqRequest;
import org.jitsi.jicofo.xmpp.UtilKt;
import org.jitsi.jicofo.xmpp.muc.MemberRole;
import org.jitsi.jicofo.xmpp.muc.MemberRoleKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.queue.PacketQueue;
import org.jitsi.xmpp.extensions.jibri.JibriIq;
import org.jitsi.xmpp.util.XmlStringBuilderUtil;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.Jid;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0004J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u000eH$J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001c\u001a\u00020\u000eH$J\u0018\u0010\"\u001a\u00020#2\u0010\u0010$\u001a\f\u0012\u0004\u0012\u00020\u000e0\rj\u0002`\u000fJ\u0010\u0010%\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u000eH$J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000e0\rj\u0002`\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006("}, d2={"Lorg/jitsi/jicofo/jibri/BaseJibri;", "Lorg/jitsi/jicofo/jibri/JibriSession$StateListener;", "conference", "Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "jibriDetector", "Lorg/jitsi/jicofo/jibri/JibriDetector;", "(Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl;Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/jicofo/jibri/JibriDetector;)V", "getConference", "()Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl;", "incomingIqQueue", "Lorg/jitsi/utils/queue/PacketQueue;", "Lorg/jitsi/jicofo/xmpp/IqRequest;", "Lorg/jitsi/xmpp/extensions/jibri/JibriIq;", "Lorg/jitsi/jicofo/jibri/JibriRequest;", "getJibriDetector", "()Lorg/jitsi/jicofo/jibri/JibriDetector;", "jibriSessions", "", "Lorg/jitsi/jicofo/jibri/JibriSession;", "getJibriSessions", "()Ljava/util/List;", "logger", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "accept", "", "iq", "acceptType", "packet", "doHandleIQRequest", "Lorg/jivesoftware/smack/packet/IQ;", "getJibriSessionForMeetIq", "handleJibriRequest", "Lorg/jitsi/jicofo/xmpp/IqProcessingResult;", "request", "handleStartRequest", "verifyModeratorRole", "Lorg/jivesoftware/smack/packet/StanzaError;", "jicofo"})
public abstract class BaseJibri
implements JibriSession.StateListener {
    @NotNull
    private final JitsiMeetConferenceImpl conference;
    @NotNull
    private final JibriDetector jibriDetector;
    @NotNull
    private final PacketQueue<IqRequest<JibriIq>> incomingIqQueue;
    @NotNull
    private final Logger logger;

    public BaseJibri(@NotNull JitsiMeetConferenceImpl conference, @NotNull Logger parentLogger, @NotNull JibriDetector jibriDetector) {
        Intrinsics.checkNotNullParameter(conference, "conference");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(jibriDetector, "jibriDetector");
        this.conference = conference;
        this.jibriDetector = jibriDetector;
        this.incomingIqQueue = new PacketQueue<IqRequest>(Integer.MAX_VALUE, true, "jibri-iq-queue", arg_0 -> BaseJibri.incomingIqQueue$lambda$0(this, arg_0), TaskPools.Companion.getIoPool());
        Logger logger = parentLogger.createChildLogger(Reflection.getOrCreateKotlinClass(BaseJibri.class).getSimpleName());
        Intrinsics.checkNotNullExpressionValue(logger, "createChildLogger(...)");
        this.logger = logger;
    }

    @NotNull
    protected final JitsiMeetConferenceImpl getConference() {
        return this.conference;
    }

    @NotNull
    public final JibriDetector getJibriDetector() {
        return this.jibriDetector;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final IqProcessingResult handleJibriRequest(@NotNull IqRequest<JibriIq> request) {
        IqProcessingResult iqProcessingResult;
        Intrinsics.checkNotNullParameter(request, "request");
        if (this.accept(request.getIq())) {
            this.logger.info("Accepted jibri request: " + XmlStringBuilderUtil.Companion.toStringOpt(request.getIq()));
            this.incomingIqQueue.add(request);
            iqProcessingResult = new IqProcessingResult.AcceptedWithNoResponse();
        } else {
            iqProcessingResult = new IqProcessingResult.NotProcessed();
        }
        return iqProcessingResult;
    }

    @Nullable
    protected abstract JibriSession getJibriSessionForMeetIq(@NotNull JibriIq var1);

    @NotNull
    public abstract List<JibriSession> getJibriSessions();

    @NotNull
    protected abstract IQ handleStartRequest(@NotNull JibriIq var1);

    protected final boolean accept(@NotNull JibriIq iq) {
        boolean bl;
        Intrinsics.checkNotNullParameter(iq, "iq");
        JibriSession session = this.getJibriSessionForMeetIq(iq);
        if (session != null && session.accept(iq)) {
            return true;
        }
        if (!this.acceptType(iq)) {
            return false;
        }
        Jid from = iq.getFrom();
        BareJid roomName = from.asBareJid();
        if (!this.conference.getRoomName().equals(roomName)) {
            return false;
        }
        boolean $this$accept_u24lambda_u241 = bl = this.conference.hasMember(from);
        boolean bl2 = false;
        if (!$this$accept_u24lambda_u241) {
            this.logger.warn("No chat member found for: " + from);
        }
        return bl;
    }

    protected abstract boolean acceptType(@NotNull JibriIq var1);

    private final IQ doHandleIQRequest(JibriIq iq) {
        IQ iQ;
        this.logger.debug(() -> BaseJibri.doHandleIQRequest$lambda$2(iq));
        JibriSession session = this.getJibriSessionForMeetIq(iq);
        if (session != null && session.accept(iq)) {
            IQ iQ2 = session.processJibriIqRequestFromJibri(iq);
            Intrinsics.checkNotNullExpressionValue(iQ2, "processJibriIqRequestFromJibri(...)");
            return iQ2;
        }
        StanzaError stanzaError = this.verifyModeratorRole(iq);
        if (stanzaError != null) {
            StanzaError it = stanzaError;
            boolean bl = false;
            this.logger.warn("Ignored Jibri request from non-moderator.");
            ErrorIQ errorIQ = IQ.createErrorResponse((IQ)iq, it);
            Intrinsics.checkNotNullExpressionValue(errorIQ, "createErrorResponse(...)");
            return errorIQ;
        }
        JibriIq.Action action = iq.getAction();
        switch (action == null ? -1 : WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
            case 1: {
                IQ iQ3;
                if (session == null) {
                    iQ3 = this.handleStartRequest(iq);
                } else {
                    this.logger.info("Will not start a Jibri session, a session is already active");
                    iQ3 = ErrorResponse.create(iq, StanzaError.Condition.unexpected_request, "Recording or live streaming is already enabled");
                }
                IQ iQ4 = iQ3;
                Intrinsics.checkNotNull(iQ4);
                iQ = iQ4;
                break;
            }
            case 2: {
                IQ iQ5;
                if (session == null) {
                    this.logger.warn("Rejecting STOP request for an unknown session.: " + XmlStringBuilderUtil.Companion.toStringOpt(iq));
                    iQ5 = ErrorResponse.create(iq, StanzaError.Condition.item_not_found, "Unknown session");
                } else {
                    session.stop(iq.getFrom());
                    iQ5 = IQ.createResultIQ(iq);
                }
                IQ iQ6 = iQ5;
                Intrinsics.checkNotNull(iQ6);
                iQ = iQ6;
                break;
            }
            case -1: 
            case 3: {
                ErrorIQ errorIQ = ErrorResponse.create(iq, StanzaError.Condition.bad_request, "undefined action " + XmlStringBuilderUtil.Companion.toStringOpt(iq));
                Intrinsics.checkNotNullExpressionValue(errorIQ, "create(...)");
                return errorIQ;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return iQ;
    }

    private final StanzaError verifyModeratorRole(JibriIq iq) {
        MemberRole role = this.conference.getRoleForMucJid(iq.getFrom());
        return role == null ? StanzaError.getBuilder(StanzaError.Condition.forbidden).build() : (MemberRoleKt.hasModeratorRights(role) ? null : StanzaError.getBuilder(StanzaError.Condition.not_allowed).build());
    }

    private static final boolean incomingIqQueue$lambda$0(BaseJibri this$0, IqRequest jibriRequest) {
        IQ iQ;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            iQ = this$0.doHandleIQRequest((JibriIq)jibriRequest.getIq());
        }
        catch (Exception e) {
            this$0.logger.warn("Failed to handle request: " + jibriRequest.getIq(), e);
            XMPPConnection xMPPConnection = jibriRequest.getConnection();
            ErrorIQ errorIQ = IQ.createErrorResponse(jibriRequest.getIq(), StanzaError.Condition.internal_server_error);
            Intrinsics.checkNotNullExpressionValue(errorIQ, "createErrorResponse(...)");
            UtilKt.tryToSendStanza(xMPPConnection, errorIQ);
            return true;
        }
        IQ response = iQ;
        UtilKt.tryToSendStanza(jibriRequest.getConnection(), response);
        return true;
    }

    private static final String doHandleIQRequest$lambda$2(JibriIq $iq) {
        Intrinsics.checkNotNullParameter($iq, "$iq");
        return "Jibri request. IQ: " + XmlStringBuilderUtil.Companion.toStringOpt($iq);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JibriIq.Action.values().length];
            try {
                nArray[JibriIq.Action.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JibriIq.Action.STOP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JibriIq.Action.UNDEFINED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

