/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmDataManager;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

public class UntaggedWay
extends Test {
    protected static final int EMPTY_WAY = 301;
    protected static final int UNTAGGED_WAY = 302;
    protected static final int UNNAMED_WAY = 303;
    protected static final int ONE_NODE_WAY = 304;
    protected static final int UNNAMED_JUNCTION = 305;
    protected static final int COMMENTED_WAY = 306;
    private Set<Way> waysUsedInRelations;
    static final Set<String> NAMED_WAYS = new HashSet<String>();
    static final Set<String> WHITELIST;

    public UntaggedWay() {
        super(I18n.tr("Untagged, empty and one node ways", new Object[0]), I18n.tr("This test checks for untagged, empty and one node ways.", new Object[0]));
    }

    @Override
    public void visit(Way w) {
        String highway;
        if (!w.isUsable()) {
            return;
        }
        TagMap tags = w.getKeys();
        if (!(tags.isEmpty() || (highway = (String)tags.get("highway")) == null || !NAMED_WAYS.contains(highway) || tags.containsKey("name") || tags.containsKey("ref") || "yes".equals(tags.get("noname")))) {
            boolean isJunction = false;
            boolean hasName = false;
            for (String key : tags.keySet()) {
                boolean bl = hasName = key.startsWith("name:") || key.endsWith("_name") || key.endsWith("_ref");
                if (hasName) break;
                if (!"junction".equals(key)) continue;
                isJunction = true;
                break;
            }
            if (!hasName && !isJunction) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 303).message(I18n.tr("Unnamed ways", new Object[0])).primitives(w).build());
            } else if (isJunction) {
                this.errors.add(TestError.builder(this, Severity.OTHER, 305).message(I18n.tr("Unnamed junction", new Object[0])).primitives(w).build());
            }
        }
        if (!w.isTagged() && !this.waysUsedInRelations.contains(w)) {
            if (w.hasKeys()) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 306).message(I18n.tr("Untagged ways (commented)", new Object[0])).primitives(w).build());
            } else {
                this.errors.add(TestError.builder(this, Severity.WARNING, 302).message(I18n.tr("Untagged ways", new Object[0])).primitives(w).build());
            }
        }
        if (w.getNodesCount() == 0) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 301).message(I18n.tr("Empty ways", new Object[0])).primitives(w).build());
        } else if (w.getNodesCount() == 1) {
            this.errors.add(TestError.builder(this, Severity.ERROR, 304).message(I18n.tr("One node ways", new Object[0])).primitives(w).build());
        }
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        DataSet ds = OsmDataManager.getInstance().getEditDataSet();
        if (ds == null) {
            return;
        }
        this.waysUsedInRelations = new HashSet<Way>();
        for (Relation r : ds.getRelations()) {
            if (!r.isUsable()) continue;
            for (RelationMember m : r.getMembers()) {
                OsmPrimitive member;
                if (!r.isMultipolygon() && !WHITELIST.contains(m.getRole()) || !((member = m.getMember()) instanceof Way) || !member.isUsable() || member.isTagged()) continue;
                this.waysUsedInRelations.add((Way)member);
            }
        }
    }

    @Override
    public void endTest() {
        this.waysUsedInRelations = null;
        super.endTest();
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof UntaggedWay) {
            return testError.getCode() == 301 || testError.getCode() == 304;
        }
        return false;
    }

    @Override
    public Command fixError(TestError testError) {
        return this.deletePrimitivesIfNeeded(testError.getPrimitives());
    }

    @Override
    public boolean isPrimitiveUsable(OsmPrimitive p) {
        return p.isUsable();
    }

    static {
        NAMED_WAYS.add("motorway");
        NAMED_WAYS.add("trunk");
        NAMED_WAYS.add("primary");
        NAMED_WAYS.add("secondary");
        NAMED_WAYS.add("tertiary");
        NAMED_WAYS.add("residential");
        NAMED_WAYS.add("pedestrian");
        WHITELIST = new HashSet<String>();
        WHITELIST.add("outer");
        WHITELIST.add("inner");
        WHITELIST.add("perimeter");
        WHITELIST.add("edge");
        WHITELIST.add("outline");
    }
}

