/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.conversion.CoordinateFormatManager;
import org.openstreetmap.josm.data.coor.conversion.DecimalDegreesCoordinateFormat;
import org.openstreetmap.josm.data.coor.conversion.ICoordinateFormat;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.preferences.imagery.ImageryPreference;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.FileWatcher;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.spi.lifecycle.InitializationSequence;
import org.openstreetmap.josm.spi.lifecycle.InitializationTask;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.OverpassTurboQueryWizard;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.RightAndLefthandTraffic;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Territories;
import org.openstreetmap.josm.tools.Utils;

public class MainInitialization
implements InitializationSequence {
    private final MainApplication application;

    public MainInitialization(MainApplication application) {
        this.application = Objects.requireNonNull(application);
    }

    @Override
    public List<InitializationTask> beforeInitializationTasks() {
        InitializationTask[] initializationTaskArray = new InitializationTask[6];
        initializationTaskArray[0] = new InitializationTask(I18n.tr("Initializing coordinate format", new Object[0]), () -> {
            ICoordinateFormat fmt = CoordinateFormatManager.getCoordinateFormat(Config.getPref().get("coordinates"));
            if (fmt == null) {
                fmt = DecimalDegreesCoordinateFormat.INSTANCE;
            }
            CoordinateFormatManager.setCoordinateFormat(fmt);
        });
        initializationTaskArray[1] = new InitializationTask(I18n.tr("Starting file watcher", new Object[0]), FileWatcher.getDefaultInstance()::start);
        initializationTaskArray[2] = new InitializationTask(I18n.tr("Executing platform startup hook", new Object[0]), () -> PlatformManager.getPlatform().startupHook(MainApplication::askUpdateJava));
        initializationTaskArray[3] = new InitializationTask(I18n.tr("Building main menu", new Object[0]), this.application::initializeMainWindow);
        initializationTaskArray[4] = new InitializationTask(I18n.tr("Updating user interface", new Object[0]), () -> {
            UndoRedoHandler.getInstance().addCommandQueueListener(this.application.redoUndoListener);
            GuiHelper.runInEDTAndWait(() -> MainApplication.contentPanePrivate.add((Component)MainApplication.toolbar.control, "North"));
            MainApplication.registerActionShortcut(MainApplication.menu.help, Shortcut.registerShortcut("system:help", I18n.tr("Help", new Object[0]), 112, 5003));
        });
        initializationTaskArray[5] = new InitializationTask(I18n.tr("Initializing internal boundaries data", new Object[0]), Territories::initialize);
        return Arrays.asList(initializationTaskArray);
    }

    @Override
    public Collection<InitializationTask> parallelInitializationTasks() {
        return Arrays.asList(new InitializationTask(I18n.tr("Initializing OSM API", new Object[0]), () -> {
            OsmApi.addOsmApiInitializationListener(api -> {
                if (MainApplication.isDisplayingMapView()) {
                    for (Layer layer : MainApplication.getLayerManager().getLayersOfType(ImageryLayer.class)) {
                        if (!((ImageryLayer)layer).getInfo().isBlacklisted()) continue;
                        Logging.info(I18n.tr("Removed layer {0} because it is not allowed by the configured API.", layer.getName()));
                        MainApplication.getLayerManager().removeLayer(layer);
                    }
                }
            });
            try {
                OsmApi.getOsmApi().initialize(null, true);
            }
            catch (SecurityException | OsmApiInitializationException | OsmTransferCanceledException e) {
                Logging.warn(Logging.getErrorMessage(Utils.getRootCause(e)));
            }
        }), new InitializationTask(I18n.tr("Initializing internal traffic data", new Object[0]), RightAndLefthandTraffic::initialize), new InitializationTask(I18n.tr("Initializing validator", new Object[0]), OsmValidator::initialize), new InitializationTask(I18n.tr("Initializing presets", new Object[0]), TaggingPresets::initialize), new InitializationTask(I18n.tr("Initializing map styles", new Object[0]), MapPaintPreference::initialize), new InitializationTask(I18n.tr("Loading imagery preferences", new Object[0]), ImageryPreference::initialize));
    }

    @Override
    public List<Callable<?>> asynchronousCallableTasks() {
        return Arrays.asList(OverpassTurboQueryWizard::getInstance);
    }

    @Override
    public List<Runnable> asynchronousRunnableTasks() {
        return Arrays.asList(TMSLayer::getCache, OsmValidator::initializeTests);
    }

    @Override
    public List<InitializationTask> afterInitializationTasks() {
        return Arrays.asList(new InitializationTask(I18n.tr("Updating user interface", new Object[0]), () -> GuiHelper.runInEDTAndWait(() -> {
            FeatureAdapter.registerBrowserAdapter(OpenBrowser::displayUrl);
            FeatureAdapter.registerImageAdapter(ImageProvider::read);
            FeatureAdapter.registerTranslationAdapter(I18n::tr);
            FeatureAdapter.registerLoggingAdapter(name -> Logging.getLogger());
            MainApplication.toolbar.refreshToolbarControl();
            MainApplication.toolbar.control.updateUI();
            MainApplication.contentPanePrivate.updateUI();
        })));
    }
}

