/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.mappers;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.resteasy.reactive.jackson.runtime.security.RolesAllowedConfigExpStorage;
import io.quarkus.security.identity.SecurityIdentity;
import java.lang.annotation.Annotation;

public class JacksonMapperUtil {
    public static boolean includeSecureField(String[] rolesAllowed) {
        SecurityIdentity securityIdentity = RolesAllowedHolder.SECURITY_IDENTITY;
        if (securityIdentity == null) {
            return false;
        }
        RolesAllowedConfigExpStorage rolesConfigExpStorage = RolesAllowedHolder.ROLES_ALLOWED_CONFIG_EXP_STORAGE;
        for (String role : rolesAllowed) {
            String[] roles;
            if (rolesConfigExpStorage != null && (roles = rolesConfigExpStorage.getRoles(role)) != null) {
                for (String r : roles) {
                    if (!securityIdentity.hasRole(r)) continue;
                    return true;
                }
                continue;
            }
            if (!securityIdentity.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    private static class RolesAllowedHolder {
        private static final ArcContainer ARC_CONTAINER = Arc.container();
        private static final SecurityIdentity SECURITY_IDENTITY = RolesAllowedHolder.createSecurityIdentity();
        private static final RolesAllowedConfigExpStorage ROLES_ALLOWED_CONFIG_EXP_STORAGE = RolesAllowedHolder.createRolesAllowedConfigExpStorage();

        private RolesAllowedHolder() {
        }

        private static SecurityIdentity createSecurityIdentity() {
            if (ARC_CONTAINER == null) {
                return null;
            }
            InstanceHandle instance = ARC_CONTAINER.instance(SecurityIdentity.class, new Annotation[0]);
            return instance.isAvailable() ? (SecurityIdentity)instance.get() : null;
        }

        private static RolesAllowedConfigExpStorage createRolesAllowedConfigExpStorage() {
            if (ARC_CONTAINER == null) {
                return null;
            }
            InstanceHandle rolesAllowedConfigExpStorage = ARC_CONTAINER.instance(RolesAllowedConfigExpStorage.class, new Annotation[0]);
            return rolesAllowedConfigExpStorage.isAvailable() ? (RolesAllowedConfigExpStorage)rolesAllowedConfigExpStorage.get() : null;
        }
    }
}

