/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.list;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.ListBucket;
import org.infinispan.multimap.impl.function.list.ListBucketBaseFunction;

public final class OfferFunction<K, V>
implements ListBucketBaseFunction<K, V, Void> {
    public static final AdvancedExternalizer<OfferFunction> EXTERNALIZER = new Externalizer();
    private final Collection<V> value;
    private final boolean first;

    public OfferFunction(V value, boolean first) {
        this.value = Arrays.asList(value);
        this.first = first;
    }

    public OfferFunction(Collection<V> value, boolean first) {
        this.value = value;
        this.first = first;
    }

    public Void apply(EntryView.ReadWriteEntryView<K, ListBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            ListBucket<V> newBucket = ((ListBucket)existing.get()).offer(this.value, this.first);
            if (newBucket != null) {
                entryView.set(newBucket, new MetaParam.Writable[0]);
            }
        } else if (this.first) {
            ArrayList<V> copy = new ArrayList<V>(this.value);
            Collections.reverse(copy);
            entryView.set(ListBucket.create(copy), new MetaParam.Writable[0]);
        } else {
            entryView.set(ListBucket.create(this.value), new MetaParam.Writable[0]);
        }
        return null;
    }

    private static class Externalizer
    implements AdvancedExternalizer<OfferFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends OfferFunction>> getTypeClasses() {
            return Collections.singleton(OfferFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.OFFER_FUNCTION;
        }

        public void writeObject(ObjectOutput output, OfferFunction object) throws IOException {
            output.writeInt(object.value.size());
            for (Object e : object.value) {
                output.writeObject(e);
            }
            output.writeBoolean(object.first);
        }

        public OfferFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int size = input.readInt();
            ArrayList<Object> array = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                array.add(input.readObject());
            }
            return new OfferFunction(array, input.readBoolean());
        }
    }
}

