/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.Cancellable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class UniResponseHandler
implements ServerRestHandler {
    @Override
    public void handle(final ResteasyReactiveRequestContext requestContext) throws Exception {
        Object object = requestContext.getResult();
        if (object instanceof Uni) {
            Uni result = (Uni)object;
            requestContext.suspend();
            final AtomicBoolean done = new AtomicBoolean();
            final Cancellable cancellable = result.subscribe().with((Consumer)new Consumer<Object>(){

                @Override
                public void accept(Object v) {
                    done.set(true);
                    requestContext.setResult(v);
                    requestContext.resume();
                }
            }, (Consumer)new Consumer<Throwable>(){

                @Override
                public void accept(Throwable t) {
                    done.set(true);
                    requestContext.resume(t, true);
                }
            });
            requestContext.serverResponse().addCloseHandler(new Runnable(){

                @Override
                public void run() {
                    if (!done.get()) {
                        cancellable.cancel();
                        try {
                            requestContext.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }
}

