/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants;

import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.core.Response;
import java.util.Set;
import org.keycloak.events.EventType;
import org.keycloak.protocol.oidc.TokenExchangeContext;
import org.keycloak.protocol.oidc.TokenExchangeProvider;
import org.keycloak.protocol.oidc.grants.OAuth2GrantType;
import org.keycloak.protocol.oidc.grants.OAuth2GrantTypeBase;

public class TokenExchangeGrantType
extends OAuth2GrantTypeBase {
    private static final Set<String> SUPPORTED_DUPLICATED_PARAMETERS = Set.of("audience", "resource");

    public Response process(OAuth2GrantType.Context context) {
        this.setContext(context);
        this.event.detail("auth_method", "token_exchange");
        this.event.client(this.client);
        TokenExchangeContext exchange = new TokenExchangeContext(this.session, this.formParams, this.cors, this.realm, this.event, this.client, this.clientConnection, this.headers, (Object)this.tokenManager, this.clientAuthAttributes);
        return this.session.getKeycloakSessionFactory().getProviderFactoriesStream(TokenExchangeProvider.class).sorted((f1, f2) -> f2.order() - f1.order()).map(f -> (TokenExchangeProvider)this.session.getProvider(TokenExchangeProvider.class, f.getId())).filter(p -> p.supports(exchange)).findFirst().orElseThrow(() -> new InternalServerErrorException("No token exchange provider available")).exchange(exchange);
    }

    public EventType getEventType() {
        return EventType.TOKEN_EXCHANGE;
    }

    public Set<String> getSupportedMultivaluedRequestParameters() {
        return SUPPORTED_DUPLICATED_PARAMETERS;
    }
}

