
#ifndef QMOBIPOCKET_EXPORT_H
#define QMOBIPOCKET_EXPORT_H

#ifdef QMOBIPOCKET_STATIC_DEFINE
#  define QMOBIPOCKET_EXPORT
#  define QMOBIPOCKET_NO_EXPORT
#else
#  ifndef QMOBIPOCKET_EXPORT
#    ifdef qmobipocket_EXPORTS
        /* We are building this library */
#      define QMOBIPOCKET_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define QMOBIPOCKET_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef QMOBIPOCKET_NO_EXPORT
#    define QMOBIPOCKET_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef QMOBIPOCKET_DECL_DEPRECATED
#  define QMOBIPOCKET_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef QMOBIPOCKET_DECL_DEPRECATED_EXPORT
#  define QMOBIPOCKET_DECL_DEPRECATED_EXPORT QMOBIPOCKET_EXPORT QMOBIPOCKET_DECL_DEPRECATED
#endif

#ifndef QMOBIPOCKET_DECL_DEPRECATED_NO_EXPORT
#  define QMOBIPOCKET_DECL_DEPRECATED_NO_EXPORT QMOBIPOCKET_NO_EXPORT QMOBIPOCKET_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef QMOBIPOCKET_NO_DEPRECATED
#    define QMOBIPOCKET_NO_DEPRECATED
#  endif
#endif
#include <qmobipocket_version.h>

#define QMOBIPOCKET_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(QMOBIPOCKET_NO_DEPRECATED)
#  undef QMOBIPOCKET_DEPRECATED
#  define QMOBIPOCKET_DEPRECATED_EXPORT QMOBIPOCKET_EXPORT
#  define QMOBIPOCKET_DEPRECATED_NO_EXPORT QMOBIPOCKET_NO_EXPORT
#elif defined(QMOBIPOCKET_NO_DEPRECATED_WARNINGS)
#  define QMOBIPOCKET_DEPRECATED
#  define QMOBIPOCKET_DEPRECATED_EXPORT QMOBIPOCKET_EXPORT
#  define QMOBIPOCKET_DEPRECATED_NO_EXPORT QMOBIPOCKET_NO_EXPORT
#else
#  define QMOBIPOCKET_DEPRECATED QMOBIPOCKET_DECL_DEPRECATED
#  define QMOBIPOCKET_DEPRECATED_EXPORT QMOBIPOCKET_DECL_DEPRECATED_EXPORT
#  define QMOBIPOCKET_DEPRECATED_NO_EXPORT QMOBIPOCKET_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define QMOBIPOCKET_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define QMOBIPOCKET_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef QMOBIPOCKET_NO_DEPRECATED
#  define QMOBIPOCKET_DISABLE_DEPRECATED_BEFORE_AND_AT QMOBIPOCKET_VERSION
#endif
#ifdef QMOBIPOCKET_NO_DEPRECATED_WARNINGS
#  define QMOBIPOCKET_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef QMOBIPOCKET_DEPRECATED_WARNINGS_SINCE
#  ifdef QMOBIPOCKET_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define QMOBIPOCKET_DEPRECATED_WARNINGS_SINCE QMOBIPOCKET_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define QMOBIPOCKET_DEPRECATED_WARNINGS_SINCE QMOBIPOCKET_VERSION
#  endif
#endif

#ifndef QMOBIPOCKET_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define QMOBIPOCKET_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef QMOBIPOCKET_DEPRECATED
#  define QMOBIPOCKET_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > QMOBIPOCKET_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define QMOBIPOCKET_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* QMOBIPOCKET_EXPORT_H */
