CREATE TABLE IF NOT EXISTS "migrations" ("id" integer primary key autoincrement not null, "migration" varchar not null, "batch" integer not null);
CREATE TABLE IF NOT EXISTS "access_points" ("accesspoint_id" integer primary key autoincrement not null, "device_id" integer not null, "name" varchar not null, "radio_number" integer, "type" varchar not null, "mac_addr" varchar not null, "deleted" tinyint(1) not null default '0', "channel" integer not null default '0', "txpow" integer not null default '0', "radioutil" integer not null default '0', "numasoclients" integer not null default '0', "nummonclients" integer not null default '0', "numactbssid" integer not null default '0', "nummonbssid" integer not null default '0', "interference" integer not null);
CREATE INDEX "name" on "access_points" ("name", "radio_number");
CREATE INDEX "access_points_deleted_index" on "access_points" ("deleted");
CREATE TABLE IF NOT EXISTS "alert_device_map" ("id" integer primary key autoincrement not null, "rule_id" integer not null, "device_id" integer not null);
CREATE UNIQUE INDEX "alert_device_map_rule_id_device_id_unique" on "alert_device_map" ("rule_id", "device_id");
CREATE TABLE IF NOT EXISTS "alert_group_map" ("id" integer primary key autoincrement not null, "rule_id" integer not null, "group_id" integer not null);
CREATE UNIQUE INDEX "alert_group_map_rule_id_group_id_unique" on "alert_group_map" ("rule_id", "group_id");
CREATE TABLE IF NOT EXISTS "alert_log" ("id" integer primary key autoincrement not null, "rule_id" integer not null, "device_id" integer not null, "state" integer not null, "details" blob, "time_logged" datetime not null default CURRENT_TIMESTAMP);
CREATE INDEX "alert_log_rule_id_index" on "alert_log" ("rule_id");
CREATE INDEX "alert_log_device_id_index" on "alert_log" ("device_id");
CREATE INDEX "alert_log_time_logged_index" on "alert_log" ("time_logged");
CREATE TABLE IF NOT EXISTS "alert_rules" ("id" integer primary key autoincrement not null, "rule" text not null, "severity" varchar check ("severity" in ('ok', 'warning', 'critical')) not null, "extra" varchar not null, "disabled" tinyint(1) not null, "name" varchar not null, "query" text not null, "builder" text not null, "proc" varchar, "invert_map" tinyint(1) not null default '0', "notes" text);
CREATE UNIQUE INDEX "alert_rules_name_unique" on "alert_rules" ("name");
CREATE TABLE IF NOT EXISTS "alert_schedulables" ("item_id" integer primary key autoincrement not null, "schedule_id" integer not null, "alert_schedulable_id" integer not null, "alert_schedulable_type" varchar not null);
CREATE INDEX "schedulable_morph_index" on "alert_schedulables" ("alert_schedulable_type", "alert_schedulable_id");
CREATE INDEX "alert_schedulables_schedule_id_index" on "alert_schedulables" ("schedule_id");
CREATE TABLE IF NOT EXISTS "alert_template_map" ("id" integer primary key autoincrement not null, "alert_templates_id" integer not null, "alert_rule_id" integer not null);
CREATE INDEX "alert_templates_id" on "alert_template_map" ("alert_templates_id", "alert_rule_id");
CREATE TABLE IF NOT EXISTS "alert_templates" ("id" integer primary key autoincrement not null, "name" varchar not null, "template" text not null, "title" varchar, "title_rec" varchar);
CREATE TABLE IF NOT EXISTS "alert_transport_groups" ("transport_group_id" integer primary key autoincrement not null, "transport_group_name" varchar not null);
CREATE TABLE IF NOT EXISTS "alert_transport_map" ("id" integer primary key autoincrement not null, "rule_id" integer not null, "transport_or_group_id" integer not null, "target_type" varchar not null);
CREATE TABLE IF NOT EXISTS "alert_transports" ("transport_id" integer primary key autoincrement not null, "transport_name" varchar not null, "transport_type" varchar not null default 'mail', "is_default" tinyint(1) not null default '0', "transport_config" text);
CREATE TABLE IF NOT EXISTS "alerts" ("id" integer primary key autoincrement not null, "device_id" integer not null, "rule_id" integer not null, "state" integer not null, "alerted" integer not null, "open" integer not null, "note" text, "timestamp" datetime not null default CURRENT_TIMESTAMP, "info" text not null);
CREATE UNIQUE INDEX "alerts_device_id_rule_id_unique" on "alerts" ("device_id", "rule_id");
CREATE INDEX "alerts_device_id_index" on "alerts" ("device_id");
CREATE INDEX "alerts_rule_id_index" on "alerts" ("rule_id");
CREATE TABLE IF NOT EXISTS "api_tokens" ("id" integer primary key autoincrement not null, "user_id" integer not null, "token_hash" varchar, "description" varchar not null, "disabled" tinyint(1) not null default '0');
CREATE UNIQUE INDEX "api_tokens_token_hash_unique" on "api_tokens" ("token_hash");
CREATE TABLE IF NOT EXISTS "authlog" ("id" integer primary key autoincrement not null, "datetime" datetime not null default CURRENT_TIMESTAMP, "user" text not null, "address" text not null, "result" text not null);
CREATE TABLE IF NOT EXISTS "bill_data" ("id" integer primary key autoincrement not null, "bill_id" integer not null, "timestamp" datetime not null, "period" integer not null, "delta" integer not null, "in_delta" integer not null, "out_delta" integer not null);
CREATE INDEX "bill_data_bill_id_index" on "bill_data" ("bill_id");
CREATE TABLE IF NOT EXISTS "bill_history" ("bill_hist_id" integer primary key autoincrement not null, "bill_id" integer not null, "updated" datetime not null default CURRENT_TIMESTAMP, "bill_datefrom" datetime not null, "bill_dateto" datetime not null, "bill_type" text not null, "bill_allowed" integer not null, "bill_used" integer not null, "bill_overuse" integer not null, "bill_percent" numeric not null, "rate_95th_in" integer not null, "rate_95th_out" integer not null, "rate_95th" integer not null, "dir_95th" varchar not null, "rate_average" integer not null, "rate_average_in" integer not null, "rate_average_out" integer not null, "traf_in" integer not null, "traf_out" integer not null, "traf_total" integer not null, "pdf" blob, "bill_peak_out" integer, "bill_peak_in" integer);
CREATE UNIQUE INDEX "bill_history_bill_id_bill_datefrom_bill_dateto_unique" on "bill_history" ("bill_id", "bill_datefrom", "bill_dateto");
CREATE INDEX "bill_history_bill_id_index" on "bill_history" ("bill_id");
CREATE TABLE IF NOT EXISTS "bill_perms" ("id" integer primary key autoincrement not null, "user_id" integer not null, "bill_id" integer not null);
CREATE TABLE IF NOT EXISTS "bill_port_counters" ("port_id" integer not null, "timestamp" datetime not null default CURRENT_TIMESTAMP, "in_counter" integer, "in_delta" integer not null default '0', "out_counter" integer, "out_delta" integer not null default '0', "bill_id" integer not null, primary key ("port_id", "bill_id"));
CREATE TABLE IF NOT EXISTS "bill_ports" ("id" integer primary key autoincrement not null, "bill_id" integer not null, "port_id" integer not null, "bill_port_autoadded" tinyint(1) not null default '0');
CREATE TABLE IF NOT EXISTS "bills" ("bill_id" integer primary key autoincrement not null, "bill_name" text not null, "bill_type" text not null, "bill_cdr" integer, "bill_day" integer not null default '1', "bill_quota" integer, "rate_95th_in" integer not null, "rate_95th_out" integer not null, "rate_95th" integer not null, "dir_95th" varchar not null, "total_data" integer not null, "total_data_in" integer not null, "total_data_out" integer not null, "rate_average_in" integer not null, "rate_average_out" integer not null, "rate_average" integer not null, "bill_last_calc" datetime not null, "bill_custid" varchar not null, "bill_ref" varchar not null, "bill_notes" varchar not null, "bill_autoadded" tinyint(1) not null);
CREATE TABLE IF NOT EXISTS "callback" ("callback_id" integer primary key autoincrement not null, "name" varchar not null, "value" varchar not null);
CREATE TABLE IF NOT EXISTS "cef_switching" ("cef_switching_id" integer primary key autoincrement not null, "device_id" integer not null, "entPhysicalIndex" integer not null, "afi" varchar not null, "cef_index" integer not null, "cef_path" varchar not null, "drop" integer not null, "punt" integer not null, "punt2host" integer not null, "drop_prev" integer not null, "punt_prev" integer not null, "punt2host_prev" integer not null, "updated" integer not null, "updated_prev" integer not null);
CREATE UNIQUE INDEX "cef_switching_device_id_entphysicalindex_afi_cef_index_unique" on "cef_switching" ("device_id", "entPhysicalIndex", "afi", "cef_index");
CREATE TABLE IF NOT EXISTS "component_prefs" ("id" integer primary key autoincrement not null, "component" integer not null, "attribute" varchar not null, "value" text not null);
CREATE INDEX "component_prefs_component_index" on "component_prefs" ("component");
CREATE TABLE IF NOT EXISTS "component_statuslog" ("id" integer primary key autoincrement not null, "component_id" integer not null, "status" tinyint(1) not null default '0', "message" text, "timestamp" datetime not null default CURRENT_TIMESTAMP);
CREATE INDEX "component_statuslog_component_id_index" on "component_statuslog" ("component_id");
CREATE TABLE IF NOT EXISTS "component" ("id" integer primary key autoincrement not null, "device_id" integer not null, "type" varchar not null, "label" varchar, "status" tinyint(1) not null default '0', "disabled" tinyint(1) not null default '0', "ignore" tinyint(1) not null default '0', "error" varchar);
CREATE INDEX "component_device_id_index" on "component" ("device_id");
CREATE INDEX "component_type_index" on "component" ("type");
CREATE TABLE IF NOT EXISTS "customers" ("customer_id" integer primary key autoincrement not null, "username" varchar not null, "password" varchar not null, "string" varchar not null, "level" integer not null default '0');
CREATE UNIQUE INDEX "customers_username_unique" on "customers" ("username");
CREATE TABLE IF NOT EXISTS "dashboards" ("dashboard_id" integer primary key autoincrement not null, "user_id" integer not null default '0', "dashboard_name" varchar not null, "access" tinyint(1) not null default '0');
CREATE TABLE IF NOT EXISTS "device_graphs" ("id" integer primary key autoincrement not null, "device_id" integer not null, "graph" varchar);
CREATE INDEX "device_graphs_device_id_index" on "device_graphs" ("device_id");
CREATE TABLE IF NOT EXISTS "device_group_device" ("device_group_id" integer not null, "device_id" integer not null, primary key ("device_group_id", "device_id"));
CREATE INDEX "device_group_device_device_group_id_index" on "device_group_device" ("device_group_id");
CREATE INDEX "device_group_device_device_id_index" on "device_group_device" ("device_id");
CREATE TABLE IF NOT EXISTS "device_relationships" ("parent_device_id" integer not null default '0', "child_device_id" integer not null, primary key ("parent_device_id", "child_device_id"));
CREATE INDEX "device_relationships_child_device_id_index" on "device_relationships" ("child_device_id");
CREATE TABLE IF NOT EXISTS "devices_perms" ("id" integer primary key autoincrement not null, "user_id" integer not null, "device_id" integer not null);
CREATE INDEX "devices_perms_user_id_index" on "devices_perms" ("user_id");
CREATE TABLE IF NOT EXISTS "entPhysical_state" ("id" integer primary key autoincrement not null, "device_id" integer not null, "entPhysicalIndex" varchar not null, "subindex" varchar, "group" varchar not null, "key" varchar not null, "value" varchar not null);
CREATE INDEX "device_id_index" on "entPhysical_state" ("device_id", "entPhysicalIndex");
CREATE TABLE IF NOT EXISTS "entityState" ("entity_state_id" integer primary key autoincrement not null, "device_id" integer, "entPhysical_id" integer, "entStateLastChanged" datetime, "entStateAdmin" integer, "entStateOper" integer, "entStateUsage" integer, "entStateAlarm" text, "entStateStandby" integer);
CREATE INDEX "entitystate_device_id_index" on "entityState" ("device_id");
CREATE TABLE IF NOT EXISTS "eventlog" ("event_id" integer primary key autoincrement not null, "device_id" integer, "datetime" datetime not null default '1970-01-02 00:00:01', "message" text, "type" varchar, "reference" varchar, "username" varchar, "severity" integer not null default '2');
CREATE INDEX "eventlog_device_id_index" on "eventlog" ("device_id");
CREATE INDEX "eventlog_datetime_index" on "eventlog" ("datetime");
CREATE TABLE IF NOT EXISTS "graph_types" ("graph_type" varchar not null, "graph_subtype" varchar not null, "graph_section" varchar not null, "graph_descr" varchar, "graph_order" integer not null, primary key ("graph_type", "graph_subtype", "graph_section"));
CREATE INDEX "graph_types_graph_type_index" on "graph_types" ("graph_type");
CREATE INDEX "graph_types_graph_subtype_index" on "graph_types" ("graph_subtype");
CREATE INDEX "graph_types_graph_section_index" on "graph_types" ("graph_section");
CREATE TABLE IF NOT EXISTS "hrDevice" ("hrDevice_id" integer primary key autoincrement not null, "device_id" integer not null, "hrDeviceIndex" integer not null, "hrDeviceDescr" text not null, "hrDeviceType" text not null, "hrDeviceErrors" integer not null default '0', "hrDeviceStatus" text not null, "hrProcessorLoad" integer);
CREATE INDEX "hrdevice_device_id_index" on "hrDevice" ("device_id");
CREATE TABLE IF NOT EXISTS "ipsec_tunnels" ("tunnel_id" integer primary key autoincrement not null, "device_id" integer not null, "peer_port" integer not null, "peer_addr" varchar not null, "local_addr" varchar not null, "local_port" integer not null, "tunnel_name" varchar not null, "tunnel_status" varchar not null);
CREATE UNIQUE INDEX "ipsec_tunnels_device_id_peer_addr_unique" on "ipsec_tunnels" ("device_id", "peer_addr");
CREATE TABLE IF NOT EXISTS "ipv4_addresses" ("ipv4_address_id" integer primary key autoincrement not null, "ipv4_address" varchar not null, "ipv4_prefixlen" integer not null, "ipv4_network_id" varchar not null, "port_id" integer not null, "context_name" varchar);
CREATE INDEX "ipv4_addresses_port_id_index" on "ipv4_addresses" ("port_id");
CREATE TABLE IF NOT EXISTS "ipv4_mac" ("id" integer primary key autoincrement not null, "port_id" integer not null, "device_id" integer, "mac_address" varchar not null, "ipv4_address" varchar not null, "context_name" varchar not null);
CREATE INDEX "ipv4_mac_port_id_index" on "ipv4_mac" ("port_id");
CREATE INDEX "ipv4_mac_mac_address_index" on "ipv4_mac" ("mac_address");
CREATE TABLE IF NOT EXISTS "ipv4_networks" ("ipv4_network_id" integer primary key autoincrement not null, "ipv4_network" varchar not null, "context_name" varchar);
CREATE TABLE IF NOT EXISTS "ipv6_addresses" ("ipv6_address_id" integer primary key autoincrement not null, "ipv6_address" varchar not null, "ipv6_compressed" varchar not null, "ipv6_prefixlen" integer not null, "ipv6_origin" varchar not null, "ipv6_network_id" varchar not null, "port_id" integer not null, "context_name" varchar);
CREATE INDEX "ipv6_addresses_port_id_index" on "ipv6_addresses" ("port_id");
CREATE TABLE IF NOT EXISTS "ipv6_networks" ("ipv6_network_id" integer primary key autoincrement not null, "ipv6_network" varchar not null, "context_name" varchar);
CREATE TABLE IF NOT EXISTS "juniAtmVp" ("id" integer primary key autoincrement not null, "juniAtmVp_id" integer not null, "port_id" integer not null, "vp_id" integer not null, "vp_descr" varchar not null);
CREATE INDEX "juniatmvp_port_id_index" on "juniAtmVp" ("port_id");
CREATE TABLE IF NOT EXISTS "links" ("id" integer primary key autoincrement not null, "local_port_id" integer, "local_device_id" integer not null, "remote_port_id" integer, "active" tinyint(1) not null default '1', "protocol" varchar, "remote_hostname" varchar not null, "remote_device_id" integer not null, "remote_port" varchar not null, "remote_platform" varchar, "remote_version" varchar not null);
CREATE INDEX "local_device_id" on "links" ("local_device_id", "remote_device_id");
CREATE INDEX "links_local_port_id_index" on "links" ("local_port_id");
CREATE INDEX "links_remote_port_id_index" on "links" ("remote_port_id");
CREATE TABLE IF NOT EXISTS "loadbalancer_rservers" ("rserver_id" integer primary key autoincrement not null, "farm_id" varchar not null, "device_id" integer not null, "StateDescr" varchar not null);
CREATE TABLE IF NOT EXISTS "loadbalancer_vservers" ("id" integer primary key autoincrement not null, "classmap_id" integer not null, "classmap" varchar not null, "serverstate" varchar not null, "device_id" integer not null);
CREATE INDEX "loadbalancer_vservers_device_id_index" on "loadbalancer_vservers" ("device_id");
CREATE TABLE IF NOT EXISTS "locations" ("id" integer primary key autoincrement not null, "location" varchar not null, "lat" float, "lng" float, "timestamp" datetime not null, "fixed_coordinates" tinyint(1) not null default '0');
CREATE UNIQUE INDEX "locations_location_unique" on "locations" ("location");
CREATE TABLE IF NOT EXISTS "mac_accounting" ("ma_id" integer primary key autoincrement not null, "port_id" integer not null, "mac" varchar not null, "in_oid" varchar not null, "out_oid" varchar not null, "bps_out" integer not null, "bps_in" integer not null, "cipMacHCSwitchedBytes_input" integer, "cipMacHCSwitchedBytes_input_prev" integer, "cipMacHCSwitchedBytes_input_delta" integer, "cipMacHCSwitchedBytes_input_rate" integer, "cipMacHCSwitchedBytes_output" integer, "cipMacHCSwitchedBytes_output_prev" integer, "cipMacHCSwitchedBytes_output_delta" integer, "cipMacHCSwitchedBytes_output_rate" integer, "cipMacHCSwitchedPkts_input" integer, "cipMacHCSwitchedPkts_input_prev" integer, "cipMacHCSwitchedPkts_input_delta" integer, "cipMacHCSwitchedPkts_input_rate" integer, "cipMacHCSwitchedPkts_output" integer, "cipMacHCSwitchedPkts_output_prev" integer, "cipMacHCSwitchedPkts_output_delta" integer, "cipMacHCSwitchedPkts_output_rate" integer, "poll_time" integer, "poll_prev" integer, "poll_period" integer);
CREATE INDEX "mac_accounting_port_id_index" on "mac_accounting" ("port_id");
CREATE TABLE IF NOT EXISTS "mefinfo" ("id" integer primary key autoincrement not null, "device_id" integer not null, "mefID" integer not null, "mefType" varchar not null, "mefIdent" varchar not null, "mefMTU" integer not null default '1500', "mefAdmState" varchar not null, "mefRowState" varchar not null);
CREATE INDEX "mefinfo_device_id_index" on "mefinfo" ("device_id");
CREATE INDEX "mefinfo_mefid_index" on "mefinfo" ("mefID");
CREATE TABLE IF NOT EXISTS "munin_plugins_ds" ("mplug_id" integer not null, "ds_name" varchar not null, "ds_type" varchar check ("ds_type" in ('COUNTER', 'ABSOLUTE', 'DERIVE', 'GAUGE')) not null default 'GAUGE', "ds_label" varchar not null, "ds_cdef" varchar not null, "ds_draw" varchar not null, "ds_graph" varchar check ("ds_graph" in ('no', 'yes')) not null default 'yes', "ds_info" varchar not null, "ds_extinfo" text not null, "ds_max" varchar not null, "ds_min" varchar not null, "ds_negative" varchar not null, "ds_warning" varchar not null, "ds_critical" varchar not null, "ds_colour" varchar not null, "ds_sum" text not null, "ds_stack" text not null, "ds_line" varchar not null);
CREATE UNIQUE INDEX "munin_plugins_ds_mplug_id_ds_name_unique" on "munin_plugins_ds" ("mplug_id", "ds_name");
CREATE TABLE IF NOT EXISTS "munin_plugins" ("mplug_id" integer primary key autoincrement not null, "device_id" integer not null, "mplug_type" varchar not null, "mplug_instance" varchar, "mplug_category" varchar, "mplug_title" varchar, "mplug_info" text, "mplug_vlabel" varchar, "mplug_args" varchar, "mplug_total" tinyint(1) not null default '0', "mplug_graph" tinyint(1) not null default '1');
CREATE UNIQUE INDEX "munin_plugins_device_id_mplug_type_unique" on "munin_plugins" ("device_id", "mplug_type");
CREATE INDEX "munin_plugins_device_id_index" on "munin_plugins" ("device_id");
CREATE TABLE IF NOT EXISTS "netscaler_vservers" ("vsvr_id" integer primary key autoincrement not null, "device_id" integer not null, "vsvr_name" varchar not null, "vsvr_ip" varchar not null, "vsvr_port" integer not null, "vsvr_type" varchar not null, "vsvr_state" varchar not null, "vsvr_clients" integer not null, "vsvr_server" integer not null, "vsvr_req_rate" integer not null, "vsvr_bps_in" integer not null, "vsvr_bps_out" integer not null);
CREATE TABLE IF NOT EXISTS "notifications_attribs" ("attrib_id" integer primary key autoincrement not null, "notifications_id" integer not null, "user_id" integer not null, "key" varchar not null default '', "value" varchar not null default '');
CREATE TABLE IF NOT EXISTS "notifications" ("notifications_id" integer primary key autoincrement not null, "title" varchar not null default '', "body" text not null, "severity" integer default '0', "source" varchar not null default '', "checksum" varchar not null, "datetime" datetime not null default '1970-01-02 00:00:00');
CREATE INDEX "notifications_severity_index" on "notifications" ("severity");
CREATE UNIQUE INDEX "notifications_checksum_unique" on "notifications" ("checksum");
CREATE TABLE IF NOT EXISTS "pdb_ix_peers" ("pdb_ix_peers_id" integer primary key autoincrement not null, "ix_id" integer not null, "peer_id" integer not null, "remote_asn" integer not null, "remote_ipaddr4" varchar, "remote_ipaddr6" varchar, "name" varchar, "timestamp" integer);
CREATE TABLE IF NOT EXISTS "pdb_ix" ("pdb_ix_id" integer primary key autoincrement not null, "ix_id" integer not null, "name" varchar not null, "asn" integer not null, "timestamp" integer not null);
CREATE TABLE IF NOT EXISTS "plugins" ("plugin_id" integer primary key autoincrement not null, "plugin_name" varchar not null, "plugin_active" integer not null, "version" integer not null default '1', "settings" text);
CREATE TABLE IF NOT EXISTS "poller_cluster_stats" ("id" integer primary key autoincrement not null, "parent_poller" integer not null default '0', "poller_type" varchar not null default '', "depth" integer not null, "devices" integer not null, "worker_seconds" float not null, "workers" integer not null, "frequency" integer not null);
CREATE UNIQUE INDEX "poller_cluster_stats_parent_poller_poller_type_unique" on "poller_cluster_stats" ("parent_poller", "poller_type");
CREATE TABLE IF NOT EXISTS "poller_cluster" ("id" integer primary key autoincrement not null, "node_id" varchar not null, "poller_name" varchar not null, "poller_version" varchar not null default '', "poller_groups" varchar not null default '', "last_report" datetime not null, "master" tinyint(1) not null, "poller_enabled" tinyint(1), "poller_frequency" integer, "poller_workers" integer, "poller_down_retry" integer, "discovery_enabled" tinyint(1), "discovery_frequency" integer, "discovery_workers" integer, "services_enabled" tinyint(1), "services_frequency" integer, "services_workers" integer, "billing_enabled" tinyint(1), "billing_frequency" integer, "billing_calculate_frequency" integer, "alerting_enabled" tinyint(1), "alerting_frequency" integer, "ping_enabled" tinyint(1), "ping_frequency" integer, "update_enabled" tinyint(1), "update_frequency" integer, "loglevel" varchar, "watchdog_enabled" tinyint(1), "watchdog_log" varchar);
CREATE UNIQUE INDEX "poller_cluster_node_id_unique" on "poller_cluster" ("node_id");
CREATE TABLE IF NOT EXISTS "poller_groups" ("id" integer primary key autoincrement not null, "group_name" varchar not null, "descr" varchar not null);
CREATE TABLE IF NOT EXISTS "pollers" ("id" integer primary key autoincrement not null, "poller_name" varchar not null, "last_polled" datetime not null, "devices" integer not null, "time_taken" float not null);
CREATE UNIQUE INDEX "pollers_poller_name_unique" on "pollers" ("poller_name");
CREATE TABLE IF NOT EXISTS "ports_fdb" ("ports_fdb_id" integer primary key autoincrement not null, "port_id" integer not null, "mac_address" varchar not null, "vlan_id" integer not null, "device_id" integer not null, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "ports_fdb_port_id_index" on "ports_fdb" ("port_id");
CREATE INDEX "ports_fdb_mac_address_index" on "ports_fdb" ("mac_address");
CREATE INDEX "ports_fdb_vlan_id_index" on "ports_fdb" ("vlan_id");
CREATE INDEX "ports_fdb_device_id_index" on "ports_fdb" ("device_id");
CREATE TABLE IF NOT EXISTS "ports_perms" ("id" integer primary key autoincrement not null, "user_id" integer not null, "port_id" integer not null);
CREATE TABLE IF NOT EXISTS "ports_stack" ("id" integer primary key autoincrement not null, "device_id" integer not null, "high_ifIndex" integer not null, "high_port_id" integer, "low_ifIndex" integer not null, "low_port_id" integer, "ifStackStatus" varchar not null);
CREATE UNIQUE INDEX "ports_stack_device_id_high_ifindex_low_ifindex_unique" on "ports_stack" ("device_id", "high_ifIndex", "low_ifIndex");
CREATE TABLE IF NOT EXISTS "ports_vlans" ("port_vlan_id" integer primary key autoincrement not null, "device_id" integer not null, "port_id" integer not null, "vlan" integer not null, "baseport" integer not null, "priority" integer not null, "state" varchar not null, "cost" integer not null, "untagged" tinyint(1) not null default '0');
CREATE UNIQUE INDEX "ports_vlans_device_id_port_id_vlan_unique" on "ports_vlans" ("device_id", "port_id", "vlan");
CREATE TABLE IF NOT EXISTS "processors" ("processor_id" integer primary key autoincrement not null, "entPhysicalIndex" integer not null default '0', "hrDeviceIndex" integer, "device_id" integer not null, "processor_oid" varchar not null, "processor_index" varchar not null, "processor_type" varchar not null, "processor_usage" integer not null, "processor_descr" varchar not null, "processor_precision" integer not null default '1', "processor_perc_warn" integer default '75');
CREATE INDEX "processors_device_id_index" on "processors" ("device_id");
CREATE TABLE IF NOT EXISTS "proxmox_ports" ("id" integer primary key autoincrement not null, "vm_id" integer not null, "port" varchar not null, "last_seen" datetime not null default CURRENT_TIMESTAMP);
CREATE UNIQUE INDEX "proxmox_ports_vm_id_port_unique" on "proxmox_ports" ("vm_id", "port");
CREATE TABLE IF NOT EXISTS "proxmox" ("id" integer primary key autoincrement not null, "device_id" integer not null default '0', "vmid" integer not null, "cluster" varchar not null, "description" varchar, "last_seen" datetime not null default CURRENT_TIMESTAMP);
CREATE UNIQUE INDEX "proxmox_cluster_vmid_unique" on "proxmox" ("cluster", "vmid");
CREATE TABLE IF NOT EXISTS "sensors" ("sensor_id" integer primary key autoincrement not null, "sensor_deleted" tinyint(1) not null default '0', "sensor_class" varchar not null, "device_id" integer not null default '0', "poller_type" varchar not null default 'snmp', "sensor_oid" varchar not null, "sensor_index" varchar, "sensor_type" varchar not null, "sensor_descr" varchar, "group" varchar, "sensor_divisor" integer not null default '1', "sensor_multiplier" integer not null default '1', "sensor_current" float, "sensor_limit" float, "sensor_limit_warn" float, "sensor_limit_low" float, "sensor_limit_low_warn" float, "sensor_alert" tinyint(1) not null default '1', "sensor_custom" varchar check ("sensor_custom" in ('No', 'Yes')) not null default 'No', "entPhysicalIndex" varchar, "entPhysicalIndex_measured" varchar, "lastupdate" datetime not null default CURRENT_TIMESTAMP, "sensor_prev" float, "user_func" varchar, "rrd_type" varchar check ("rrd_type" in ('GAUGE', 'COUNTER', 'DERIVE', 'DCOUNTER', 'DDERIVE', 'ABSOLUTE')) not null default 'GAUGE');
CREATE INDEX "sensors_sensor_class_index" on "sensors" ("sensor_class");
CREATE INDEX "sensors_device_id_index" on "sensors" ("device_id");
CREATE INDEX "sensors_sensor_type_index" on "sensors" ("sensor_type");
CREATE TABLE IF NOT EXISTS "sensors_to_state_indexes" ("sensors_to_state_translations_id" integer primary key autoincrement not null, "sensor_id" integer not null, "state_index_id" integer not null);
CREATE UNIQUE INDEX "sensors_to_state_indexes_sensor_id_state_index_id_unique" on "sensors_to_state_indexes" ("sensor_id", "state_index_id");
CREATE INDEX "sensors_to_state_indexes_state_index_id_index" on "sensors_to_state_indexes" ("state_index_id");
CREATE TABLE IF NOT EXISTS "session" ("session_id" integer primary key autoincrement not null, "session_username" varchar not null, "session_value" varchar not null, "session_token" varchar not null, "session_auth" varchar not null, "session_expiry" integer not null);
CREATE UNIQUE INDEX "session_session_value_unique" on "session" ("session_value");
CREATE TABLE IF NOT EXISTS "state_indexes" ("state_index_id" integer primary key autoincrement not null, "state_name" varchar not null);
CREATE UNIQUE INDEX "state_indexes_state_name_unique" on "state_indexes" ("state_name");
CREATE TABLE IF NOT EXISTS "state_translations" ("state_translation_id" integer primary key autoincrement not null, "state_index_id" integer not null, "state_descr" varchar not null, "state_draw_graph" tinyint(1) not null, "state_value" integer not null default '0', "state_generic_value" tinyint(1) not null, "state_lastupdated" datetime not null default CURRENT_TIMESTAMP);
CREATE UNIQUE INDEX "state_translations_state_index_id_state_value_unique" on "state_translations" ("state_index_id", "state_value");
CREATE TABLE IF NOT EXISTS "storage" ("storage_id" integer primary key autoincrement not null, "device_id" integer not null, "storage_mib" varchar not null, "storage_index" varchar, "storage_type" varchar, "storage_descr" text not null, "storage_size" integer not null, "storage_units" integer not null, "storage_used" integer not null default '0', "storage_free" integer not null default '0', "storage_perc" integer not null default '0', "storage_perc_warn" integer default '60', "storage_deleted" tinyint(1) not null default '0');
CREATE UNIQUE INDEX "storage_device_id_storage_mib_storage_index_unique" on "storage" ("device_id", "storage_mib", "storage_index");
CREATE INDEX "storage_device_id_index" on "storage" ("device_id");
CREATE TABLE IF NOT EXISTS "stp" ("stp_id" integer primary key autoincrement not null, "device_id" integer not null, "rootBridge" tinyint(1) not null, "bridgeAddress" varchar not null, "protocolSpecification" varchar not null, "priority" integer not null, "timeSinceTopologyChange" varchar not null, "topChanges" integer not null, "designatedRoot" varchar not null, "rootCost" integer not null, "rootPort" integer, "maxAge" integer not null, "helloTime" integer not null, "holdTime" integer not null, "forwardDelay" integer not null, "bridgeMaxAge" integer not null, "bridgeHelloTime" integer not null, "bridgeForwardDelay" integer not null, "vlan" integer);
CREATE INDEX "stp_device_id_index" on "stp" ("device_id");
CREATE TABLE IF NOT EXISTS "syslog" ("device_id" integer, "facility" varchar, "priority" varchar, "level" varchar, "tag" varchar, "timestamp" datetime not null default CURRENT_TIMESTAMP, "program" varchar, "msg" text, "seq" integer primary key autoincrement not null);
CREATE INDEX "syslog_priority_level_index" on "syslog" ("priority", "level");
CREATE INDEX "syslog_device_id_timestamp_index" on "syslog" ("device_id", "timestamp");
CREATE INDEX "syslog_device_id_index" on "syslog" ("device_id");
CREATE INDEX "syslog_timestamp_index" on "syslog" ("timestamp");
CREATE INDEX "syslog_program_index" on "syslog" ("program");
CREATE TABLE IF NOT EXISTS "tnmsneinfo" ("id" integer primary key autoincrement not null, "device_id" integer not null, "neID" integer not null, "neType" varchar not null, "neName" varchar not null, "neLocation" varchar not null, "neAlarm" varchar not null, "neOpMode" varchar not null, "neOpState" varchar not null);
CREATE INDEX "tnmsneinfo_device_id_index" on "tnmsneinfo" ("device_id");
CREATE INDEX "tnmsneinfo_neid_index" on "tnmsneinfo" ("neID");
CREATE TABLE IF NOT EXISTS "transport_group_transport" ("id" integer primary key autoincrement not null, "transport_group_id" integer not null, "transport_id" integer not null);
CREATE TABLE IF NOT EXISTS "ucd_diskio" ("diskio_id" integer primary key autoincrement not null, "device_id" integer not null, "diskio_index" integer not null, "diskio_descr" varchar not null);
CREATE INDEX "ucd_diskio_device_id_index" on "ucd_diskio" ("device_id");
CREATE TABLE IF NOT EXISTS "users_prefs" ("user_id" integer not null, "pref" varchar not null, "value" varchar not null);
CREATE UNIQUE INDEX "users_prefs_user_id_pref_unique" on "users_prefs" ("user_id", "pref");
CREATE TABLE IF NOT EXISTS "vlans" ("vlan_id" integer primary key autoincrement not null, "device_id" integer, "vlan_vlan" integer, "vlan_domain" integer, "vlan_name" varchar, "vlan_type" varchar, "vlan_mtu" integer);
CREATE INDEX "device_id" on "vlans" ("device_id", "vlan_vlan");
CREATE TABLE IF NOT EXISTS "vrf_lite_cisco" ("vrf_lite_cisco_id" integer primary key autoincrement not null, "device_id" integer not null, "context_name" varchar not null, "intance_name" varchar default '', "vrf_name" varchar default 'Default');
CREATE INDEX "vrf_lite_cisco_device_id_context_name_vrf_name_index" on "vrf_lite_cisco" ("device_id", "context_name", "vrf_name");
CREATE INDEX "vrf_lite_cisco_device_id_index" on "vrf_lite_cisco" ("device_id");
CREATE INDEX "vrf_lite_cisco_context_name_index" on "vrf_lite_cisco" ("context_name");
CREATE INDEX "vrf_lite_cisco_vrf_name_index" on "vrf_lite_cisco" ("vrf_name");
CREATE TABLE IF NOT EXISTS "vrfs" ("vrf_id" integer primary key autoincrement not null, "vrf_oid" varchar not null, "vrf_name" varchar, "mplsVpnVrfRouteDistinguisher" varchar, "mplsVpnVrfDescription" text not null, "device_id" integer not null, "bgpLocalAs" integer);
CREATE INDEX "vrfs_device_id_index" on "vrfs" ("device_id");
CREATE TABLE IF NOT EXISTS "wireless_sensors" ("sensor_id" integer primary key autoincrement not null, "sensor_deleted" tinyint(1) not null default '0', "sensor_class" varchar not null, "device_id" integer not null default '0', "sensor_index" varchar, "sensor_type" varchar not null, "sensor_descr" varchar, "sensor_divisor" integer not null default '1', "sensor_multiplier" integer not null default '1', "sensor_aggregator" varchar not null default 'sum', "sensor_current" float, "sensor_prev" float, "sensor_limit" float, "sensor_limit_warn" float, "sensor_limit_low" float, "sensor_limit_low_warn" float, "sensor_alert" tinyint(1) not null default '1', "sensor_custom" varchar check ("sensor_custom" in ('No', 'Yes')) not null default 'No', "entPhysicalIndex" varchar, "entPhysicalIndex_measured" varchar, "lastupdate" datetime not null default CURRENT_TIMESTAMP, "sensor_oids" text not null, "access_point_id" integer, "rrd_type" varchar check ("rrd_type" in ('GAUGE', 'COUNTER', 'DERIVE', 'DCOUNTER', 'DDERIVE', 'ABSOLUTE')) not null default 'GAUGE');
CREATE INDEX "wireless_sensors_sensor_class_index" on "wireless_sensors" ("sensor_class");
CREATE INDEX "wireless_sensors_device_id_index" on "wireless_sensors" ("device_id");
CREATE INDEX "wireless_sensors_sensor_type_index" on "wireless_sensors" ("sensor_type");
CREATE TABLE ports_nac (ports_nac_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, auth_id VARCHAR(255) NOT NULL, device_id INTEGER NOT NULL, port_id INTEGER NOT NULL, domain VARCHAR(255) NOT NULL, username VARCHAR(255) NOT NULL, mac_address VARCHAR(255) NOT NULL, ip_address VARCHAR(255) NOT NULL, host_mode VARCHAR(255) NOT NULL, authz_status VARCHAR(255) NOT NULL, authz_by VARCHAR(255) NOT NULL, authc_status VARCHAR(255) NOT NULL, method VARCHAR(255) NOT NULL, timeout VARCHAR(255) NOT NULL, time_left VARCHAR(50) DEFAULT NULL, "vlan" integer, "time_elapsed" varchar, "created_at" datetime, "updated_at" datetime, "historical" tinyint(1) not null default '0');
CREATE INDEX ports_nac_device_id_index ON ports_nac (device_id);
CREATE INDEX ports_nac_port_id_mac_address_index ON ports_nac (port_id, mac_address);
CREATE TABLE IF NOT EXISTS "route" ("route_id" integer primary key autoincrement not null, "created_at" datetime, "updated_at" datetime, "device_id" integer not null, "port_id" integer not null, "context_name" varchar, "inetCidrRouteIfIndex" integer not null, "inetCidrRouteType" integer not null, "inetCidrRouteProto" integer not null, "inetCidrRouteNextHopAS" integer not null, "inetCidrRouteMetric1" integer not null, "inetCidrRouteDestType" varchar not null, "inetCidrRouteDest" varchar not null, "inetCidrRouteNextHopType" varchar not null, "inetCidrRouteNextHop" varchar not null, "inetCidrRoutePolicy" varchar not null, "inetCidrRoutePfxLen" integer not null);
CREATE TABLE IF NOT EXISTS "mpls_lsps" ("lsp_id" integer primary key autoincrement not null, "vrf_oid" integer not null, "lsp_oid" integer not null, "device_id" integer not null, "mplsLspRowStatus" varchar check ("mplsLspRowStatus" in ('active', 'notInService', 'notReady', 'createAndGo', 'createAndWait', 'destroy')) not null, "mplsLspLastChange" integer, "mplsLspName" varchar not null, "mplsLspAdminState" varchar check ("mplsLspAdminState" in ('noop', 'inService', 'outOfService')) not null, "mplsLspOperState" varchar check ("mplsLspOperState" in ('unknown', 'inService', 'outOfService', 'transition')) not null, "mplsLspFromAddr" varchar not null, "mplsLspToAddr" varchar not null, "mplsLspType" varchar check ("mplsLspType" in ('unknown', 'dynamic', 'static', 'bypassOnly', 'p2mpLsp', 'p2mpAuto', 'mplsTp', 'meshP2p', 'oneHopP2p', 'srTe', 'meshP2pSrTe', 'oneHopP2pSrTe')) not null, "mplsLspFastReroute" varchar check ("mplsLspFastReroute" in ('true', 'false')) not null, "mplsLspAge" integer, "mplsLspTimeUp" integer, "mplsLspTimeDown" integer, "mplsLspPrimaryTimeUp" integer, "mplsLspTransitions" integer, "mplsLspLastTransition" integer, "mplsLspConfiguredPaths" integer, "mplsLspStandbyPaths" integer, "mplsLspOperationalPaths" integer);
CREATE INDEX "mpls_lsps_device_id_index" on "mpls_lsps" ("device_id");
CREATE TABLE device_groups (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, name VARCHAR(255) DEFAULT '' NOT NULL COLLATE "BINARY", "desc" VARCHAR(255) DEFAULT '' NOT NULL COLLATE "BINARY", pattern CLOB DEFAULT NULL COLLATE "BINARY");
CREATE UNIQUE INDEX device_groups_name_unique ON device_groups (name);
CREATE TABLE IF NOT EXISTS "mpls_sdp_binds" ("bind_id" integer primary key autoincrement not null, "sdp_id" integer not null, "svc_id" integer not null, "sdp_oid" integer not null, "svc_oid" integer not null, "device_id" integer not null, "sdpBindRowStatus" varchar check ("sdpBindRowStatus" in ('active', 'notInService', 'notReady', 'createAndGo', 'createAndWait', 'destroy')), "sdpBindAdminStatus" varchar check ("sdpBindAdminStatus" in ('up', 'down')), "sdpBindOperStatus" varchar check ("sdpBindOperStatus" in ('up', 'down')), "sdpBindLastMgmtChange" integer, "sdpBindLastStatusChange" integer, "sdpBindType" varchar check ("sdpBindType" in ('spoke', 'mesh')), "sdpBindVcType" varchar check ("sdpBindVcType" in ('undef', 'ether', 'vlan', 'mirrior', 'atmSduatmCell', 'atmVcc', 'atmVpc', 'frDlci', 'ipipe', 'satopE1', 'satopT1', 'satopE3', 'satopT3', 'cesopsn', 'cesopsnCas')), "sdpBindBaseStatsIngFwdPackets" integer, "sdpBindBaseStatsIngFwdOctets" integer, "sdpBindBaseStatsEgrFwdPackets" integer, "sdpBindBaseStatsEgrFwdOctets" integer);
CREATE INDEX "mpls_sdp_binds_device_id_index" on "mpls_sdp_binds" ("device_id");
CREATE TABLE IF NOT EXISTS "mpls_services" ("svc_id" integer primary key autoincrement not null, "svc_oid" integer not null, "device_id" integer not null, "svcRowStatus" varchar check ("svcRowStatus" in ('active', 'notInService', 'notReady', 'createAndGo', 'createAndWait', 'destroy')), "svcType" varchar check ("svcType" in ('unknown', 'epipe', 'tls', 'vprn', 'ies', 'mirror', 'apipe', 'fpipe', 'ipipe', 'cpipe', 'intTls', 'evpnIsaTls')), "svcCustId" integer, "svcAdminStatus" varchar check ("svcAdminStatus" in ('up', 'down')), "svcOperStatus" varchar check ("svcOperStatus" in ('up', 'down')), "svcDescription" varchar, "svcMtu" integer, "svcNumSaps" integer, "svcNumSdps" integer, "svcLastMgmtChange" integer, "svcLastStatusChange" integer, "svcVRouterId" integer, "svcTlsMacLearning" varchar check ("svcTlsMacLearning" in ('enabled', 'disabled')), "svcTlsStpAdminStatus" varchar check ("svcTlsStpAdminStatus" in ('enabled', 'disabled')), "svcTlsStpOperStatus" varchar check ("svcTlsStpOperStatus" in ('up', 'down')), "svcTlsFdbTableSize" integer, "svcTlsFdbNumEntries" integer);
CREATE INDEX "mpls_services_device_id_index" on "mpls_services" ("device_id");
CREATE TABLE IF NOT EXISTS "mpls_saps" ("sap_id" integer primary key autoincrement not null, "svc_id" integer not null, "svc_oid" integer not null, "sapPortId" integer not null, "ifName" varchar, "device_id" integer not null, "sapEncapValue" varchar, "sapRowStatus" varchar check ("sapRowStatus" in ('active', 'notInService', 'notReady', 'createAndGo', 'createAndWait', 'destroy')), "sapType" varchar check ("sapType" in ('unknown', 'epipe', 'tls', 'vprn', 'ies', 'mirror', 'apipe', 'fpipe', 'ipipe', 'cpipe', 'intTls', 'evpnIsaTls')), "sapDescription" varchar, "sapAdminStatus" varchar check ("sapAdminStatus" in ('up', 'down')), "sapOperStatus" varchar check ("sapOperStatus" in ('up', 'down')), "sapLastMgmtChange" integer, "sapLastStatusChange" integer);
CREATE INDEX "mpls_saps_device_id_index" on "mpls_saps" ("device_id");
CREATE INDEX "notifications_attribs_notifications_id_user_id_index" on "notifications_attribs" ("notifications_id", "user_id");
CREATE TABLE IF NOT EXISTS "devices_group_perms" ("user_id" integer not null, "device_group_id" integer not null, primary key ("device_group_id", "user_id"));
CREATE INDEX "devices_group_perms_user_id_index" on "devices_group_perms" ("user_id");
CREATE INDEX "devices_group_perms_device_group_id_index" on "devices_group_perms" ("device_group_id");
CREATE TABLE IF NOT EXISTS "mpls_tunnel_ar_hops" ("ar_hop_id" integer primary key autoincrement not null, "mplsTunnelARHopListIndex" integer not null, "mplsTunnelARHopIndex" integer not null, "device_id" integer not null, "lsp_path_id" integer not null, "mplsTunnelARHopAddrType" varchar check ("mplsTunnelARHopAddrType" in ('unknown', 'ipV4', 'ipV6', 'asNumber', 'lspid', 'unnum')), "mplsTunnelARHopIpv4Addr" varchar, "mplsTunnelARHopIpv6Addr" varchar, "mplsTunnelARHopAsNumber" integer, "mplsTunnelARHopStrictOrLoose" varchar check ("mplsTunnelARHopStrictOrLoose" in ('strict', 'loose')), "mplsTunnelARHopRouterId" varchar, "localProtected" varchar check ("localProtected" in ('false', 'true')) not null default 'false', "linkProtectionInUse" varchar check ("linkProtectionInUse" in ('false', 'true')) not null default 'false', "bandwidthProtected" varchar check ("bandwidthProtected" in ('false', 'true')) not null default 'false', "nextNodeProtected" varchar check ("nextNodeProtected" in ('false', 'true')) not null default 'false');
CREATE INDEX "mpls_tunnel_ar_hops_device_id_index" on "mpls_tunnel_ar_hops" ("device_id");
CREATE TABLE IF NOT EXISTS "mpls_tunnel_c_hops" ("c_hop_id" integer primary key autoincrement not null, "mplsTunnelCHopListIndex" integer not null, "mplsTunnelCHopIndex" integer not null, "device_id" integer not null, "lsp_path_id" integer, "mplsTunnelCHopAddrType" varchar check ("mplsTunnelCHopAddrType" in ('unknown', 'ipV4', 'ipV6', 'asNumber', 'lspid', 'unnum')), "mplsTunnelCHopIpv4Addr" varchar, "mplsTunnelCHopIpv6Addr" varchar, "mplsTunnelCHopAsNumber" integer, "mplsTunnelCHopStrictOrLoose" varchar check ("mplsTunnelCHopStrictOrLoose" in ('strict', 'loose')), "mplsTunnelCHopRouterId" varchar);
CREATE INDEX "mpls_tunnel_c_hops_device_id_index" on "mpls_tunnel_c_hops" ("device_id");
CREATE TABLE IF NOT EXISTS "customoids" ("customoid_id" integer primary key autoincrement not null, "device_id" integer not null default '0', "customoid_descr" varchar default '', "customoid_deleted" integer not null default '0', "customoid_current" float, "customoid_prev" float, "customoid_oid" varchar, "customoid_datatype" varchar not null default 'GAUGE', "customoid_unit" varchar, "customoid_divisor" integer not null default '1', "customoid_multiplier" integer not null default '1', "customoid_limit" float, "customoid_limit_warn" float, "customoid_limit_low" float, "customoid_limit_low_warn" float, "customoid_alert" integer not null default '0', "customoid_passed" integer not null default '0', "lastupdate" datetime not null default CURRENT_TIMESTAMP, "user_func" varchar);
CREATE TABLE mpls_lsp_paths (lsp_path_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, lsp_id INTEGER NOT NULL, path_oid INTEGER NOT NULL, device_id INTEGER NOT NULL, mplsLspPathRowStatus VARCHAR(255) NOT NULL, mplsLspPathLastChange INTEGER NOT NULL, mplsLspPathType VARCHAR(255) NOT NULL, mplsLspPathBandwidth INTEGER NOT NULL, mplsLspPathOperBandwidth INTEGER NOT NULL, mplsLspPathAdminState VARCHAR(255) NOT NULL, mplsLspPathOperState VARCHAR(255) NOT NULL, mplsLspPathState VARCHAR(255) NOT NULL, mplsLspPathFailCode VARCHAR(255) NOT NULL, mplsLspPathFailNodeAddr VARCHAR(255) NOT NULL, mplsLspPathMetric INTEGER NOT NULL, mplsLspPathOperMetric INTEGER UNSIGNED DEFAULT NULL, mplsLspPathTimeUp INTEGER DEFAULT NULL, mplsLspPathTimeDown INTEGER DEFAULT NULL, mplsLspPathTransitionCount INTEGER DEFAULT NULL, mplsLspPathTunnelARHopListIndex INTEGER DEFAULT NULL, mplsLspPathTunnelCHopListIndex INTEGER DEFAULT NULL);
CREATE INDEX mpls_lsp_paths_device_id_index ON mpls_lsp_paths (device_id);
CREATE TABLE IF NOT EXISTS "alert_location_map" ("id" integer primary key autoincrement not null, "rule_id" integer not null, "location_id" integer not null);
CREATE UNIQUE INDEX "alert_location_map_rule_id_location_id_uindex" on "alert_location_map" ("rule_id", "location_id");
CREATE TABLE alert_schedule (schedule_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, recurring BOOLEAN DEFAULT 0 NOT NULL, start DATETIME DEFAULT '1970-01-02 00:00:01' NOT NULL, "end" DATETIME DEFAULT '1970-01-02 00:00:01' NOT NULL, recurring_day VARCHAR(255) DEFAULT NULL COLLATE "BINARY", title VARCHAR(255) NOT NULL COLLATE "BINARY", notes CLOB NOT NULL COLLATE "BINARY");
CREATE TABLE application_metrics (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, app_id INTEGER NOT NULL, metric VARCHAR(64) NOT NULL, value DOUBLE PRECISION DEFAULT NULL, value_prev DOUBLE PRECISION DEFAULT NULL);
CREATE UNIQUE INDEX application_metrics_app_id_metric_unique ON application_metrics (app_id, metric);
CREATE TABLE availability (availability_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER NOT NULL, duration INTEGER NOT NULL, availability_perc NUMERIC(9, 6) DEFAULT '0' NOT NULL);
CREATE INDEX availability_device_id_index ON availability (device_id);
CREATE UNIQUE INDEX availability_device_id_duration_unique ON availability (device_id, duration);
CREATE TABLE devices (device_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, hostname VARCHAR(255) NOT NULL, sysName VARCHAR(255) DEFAULT NULL, ip BLOB DEFAULT NULL, community VARCHAR(255) DEFAULT NULL, authlevel VARCHAR(255) DEFAULT NULL, authname VARCHAR(255) DEFAULT NULL, authpass VARCHAR(255) DEFAULT NULL, authalgo VARCHAR(10) DEFAULT NULL, cryptopass VARCHAR(255) DEFAULT NULL, cryptoalgo VARCHAR(10) DEFAULT NULL, snmpver VARCHAR(255) DEFAULT 'v2c' NOT NULL, port INTEGER DEFAULT 161 NOT NULL, transport VARCHAR(255) DEFAULT 'udp' NOT NULL, timeout INTEGER DEFAULT NULL, retries INTEGER DEFAULT NULL, snmp_disable BOOLEAN DEFAULT 0 NOT NULL, bgpLocalAs INTEGER DEFAULT NULL, sysObjectID VARCHAR(255) DEFAULT NULL, sysDescr CLOB DEFAULT NULL, sysContact CLOB DEFAULT NULL, version CLOB DEFAULT NULL, hardware CLOB DEFAULT NULL, features CLOB DEFAULT NULL, location_id INTEGER DEFAULT NULL, os VARCHAR(255) DEFAULT NULL, status BOOLEAN DEFAULT 0 NOT NULL, status_reason VARCHAR(255) NOT NULL, "ignore" BOOLEAN DEFAULT 0 NOT NULL, disabled BOOLEAN DEFAULT 0 NOT NULL, uptime INTEGER DEFAULT NULL, agent_uptime INTEGER DEFAULT 0 NOT NULL, last_polled DATETIME DEFAULT NULL, last_poll_attempted DATETIME DEFAULT NULL, last_polled_timetaken DOUBLE PRECISION DEFAULT NULL, last_discovered_timetaken DOUBLE PRECISION DEFAULT NULL, last_discovered DATETIME DEFAULT NULL, last_ping DATETIME DEFAULT NULL, last_ping_timetaken DOUBLE PRECISION DEFAULT NULL, purpose CLOB DEFAULT NULL, type VARCHAR(255) DEFAULT '' NOT NULL, serial CLOB DEFAULT NULL, icon VARCHAR(255) DEFAULT NULL, poller_group INTEGER DEFAULT 0 NOT NULL, override_sysLocation BOOLEAN DEFAULT 0, notes CLOB DEFAULT NULL, port_association_mode INTEGER DEFAULT 1 NOT NULL, max_depth INTEGER DEFAULT 0 NOT NULL, overwrite_ip VARCHAR(255) DEFAULT NULL, disable_notify BOOLEAN DEFAULT 0 NOT NULL, inserted DATETIME DEFAULT NULL, "display" varchar, "ignore_status" tinyint(1) not null default '0');
CREATE INDEX devices_last_poll_attempted_index ON devices (last_poll_attempted);
CREATE INDEX devices_last_polled_index ON devices (last_polled);
CREATE INDEX devices_status_index ON devices (status);
CREATE INDEX devices_os_index ON devices (os);
CREATE INDEX devices_sysname_index ON devices (sysName);
CREATE TABLE device_outages (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER NOT NULL, going_down INTEGER NOT NULL, up_again INTEGER DEFAULT NULL);
CREATE INDEX device_outages_device_id_index ON device_outages (device_id);
CREATE UNIQUE INDEX device_outages_device_id_going_down_unique ON device_outages (device_id, going_down);
CREATE TABLE IF NOT EXISTS "cache" ("key" varchar not null, "value" text not null, "expiration" integer not null);
CREATE UNIQUE INDEX "cache_key_unique" on "cache" ("key");
CREATE TABLE IF NOT EXISTS "service_templates_device_group" ("service_template_id" integer not null, "device_group_id" integer not null, primary key ("service_template_id", "device_group_id"));
CREATE INDEX "service_templates_device_group_service_template_id_index" on "service_templates_device_group" ("service_template_id");
CREATE INDEX "service_templates_device_group_device_group_id_index" on "service_templates_device_group" ("device_group_id");
CREATE TABLE IF NOT EXISTS "service_templates_device" ("service_template_id" integer not null, "device_id" integer not null, primary key ("service_template_id", "device_id"));
CREATE INDEX "service_templates_device_service_template_id_index" on "service_templates_device" ("service_template_id");
CREATE INDEX "service_templates_device_device_id_index" on "service_templates_device" ("device_id");
CREATE TABLE services (service_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER NOT NULL, service_ip CLOB DEFAULT NULL, service_type VARCHAR(255) NOT NULL, service_desc CLOB DEFAULT NULL, service_param CLOB DEFAULT NULL, service_ignore BOOLEAN DEFAULT 0 NOT NULL, service_status INTEGER DEFAULT 0 NOT NULL, service_changed INTEGER DEFAULT 0 NOT NULL, service_message CLOB DEFAULT NULL, service_disabled BOOLEAN DEFAULT 0 NOT NULL, service_ds CLOB DEFAULT NULL, "service_template_id" integer not null default '0', "service_name" varchar);
CREATE INDEX services_device_id_index ON services (device_id);
CREATE INDEX "alert_log_rule_id_device_id_index" on "alert_log" ("rule_id", "device_id");
CREATE INDEX "alert_log_rule_id_device_id_state_index" on "alert_log" ("rule_id", "device_id", "state");
CREATE TABLE IF NOT EXISTS "cache_locks" ("key" varchar not null, "owner" varchar not null, "expiration" integer not null, primary key ("key"));
CREATE TABLE mempools (mempool_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, mempool_index VARCHAR(255) NOT NULL COLLATE "BINARY", entPhysicalIndex INTEGER DEFAULT NULL, mempool_type VARCHAR(255) NOT NULL COLLATE "BINARY", mempool_precision INTEGER DEFAULT 1 NOT NULL, mempool_descr VARCHAR(255) NOT NULL COLLATE "BINARY", device_id INTEGER NOT NULL, mempool_perc INTEGER NOT NULL, mempool_used INTEGER NOT NULL, mempool_free INTEGER NOT NULL, mempool_total INTEGER NOT NULL, mempool_largestfree INTEGER DEFAULT NULL, mempool_lowestfree INTEGER DEFAULT NULL, mempool_deleted BOOLEAN DEFAULT 0 NOT NULL, mempool_perc_warn INTEGER DEFAULT NULL);
CREATE INDEX mempools_device_id_index ON mempools (device_id);
CREATE TABLE IF NOT EXISTS "port_group_port" ("port_group_id" integer not null, "port_id" integer not null, primary key ("port_group_id", "port_id"));
CREATE INDEX "port_group_port_port_group_id_index" on "port_group_port" ("port_group_id");
CREATE INDEX "port_group_port_port_id_index" on "port_group_port" ("port_id");
CREATE TABLE IF NOT EXISTS "port_groups" ("id" integer primary key autoincrement not null, "name" varchar not null, "desc" varchar);
CREATE UNIQUE INDEX "port_groups_name_unique" on "port_groups" ("name");
CREATE TABLE printer_supplies (supply_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER DEFAULT 0 NOT NULL, supply_index INTEGER NOT NULL, supply_type VARCHAR(255) NOT NULL COLLATE "BINARY", supply_oid VARCHAR(255) NOT NULL COLLATE "BINARY", supply_descr VARCHAR(255) DEFAULT '' NOT NULL COLLATE "BINARY", supply_capacity INTEGER DEFAULT 0 NOT NULL, supply_current INTEGER DEFAULT 0 NOT NULL, supply_capacity_oid VARCHAR(255) DEFAULT NULL);
CREATE INDEX toner_device_id_index ON printer_supplies (device_id);
CREATE TABLE service_templates (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, ip CLOB DEFAULT NULL COLLATE "BINARY", "check" VARCHAR(255) NOT NULL COLLATE "BINARY", type VARCHAR(255) DEFAULT 'static' NOT NULL COLLATE "BINARY", rules CLOB DEFAULT NULL, "desc" CLOB DEFAULT NULL COLLATE "BINARY", param CLOB DEFAULT NULL COLLATE "BINARY", "ignore" BOOLEAN DEFAULT 0 NOT NULL, changed DATETIME DEFAULT CURRENT_TIMESTAMP NOT NULL, disabled BOOLEAN DEFAULT 0 NOT NULL, name VARCHAR(255) NOT NULL COLLATE "BINARY");
CREATE TABLE IF NOT EXISTS "sessions" ("id" varchar not null, "user_id" integer, "ip_address" varchar, "user_agent" text, "payload" text not null, "last_activity" integer not null, primary key ("id"));
CREATE INDEX "sessions_user_id_index" on "sessions" ("user_id");
CREATE INDEX "sessions_last_activity_index" on "sessions" ("last_activity");
CREATE INDEX "syslog_device_id_program_index" on "syslog" ("device_id", "program");
CREATE INDEX "syslog_device_id_priority_index" on "syslog" ("device_id", "priority");
CREATE TABLE config (config_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, config_name VARCHAR(255) NOT NULL, config_value CLOB NOT NULL);
CREATE UNIQUE INDEX config_config_name_unique ON config (config_name);
CREATE TABLE IF NOT EXISTS "push_subscriptions" ("id" integer primary key autoincrement not null, "subscribable_type" varchar not null, "subscribable_id" integer not null, "endpoint" varchar not null, "public_key" varchar, "auth_token" varchar, "content_encoding" varchar, "description" varchar, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "push_subscriptions_subscribable_type_subscribable_id_index" on "push_subscriptions" ("subscribable_type", "subscribable_id");
CREATE UNIQUE INDEX "push_subscriptions_endpoint_unique" on "push_subscriptions" ("endpoint");
CREATE TABLE hrSystem (hrSystem_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER NOT NULL, hrSystemNumUsers INTEGER DEFAULT NULL, hrSystemProcesses INTEGER DEFAULT NULL, hrSystemMaxProcesses INTEGER DEFAULT NULL);
CREATE INDEX hrsystem_device_id_index ON hrSystem (device_id);
CREATE TABLE devices_attribs (attrib_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER NOT NULL, attrib_type VARCHAR(64) NOT NULL, attrib_value CLOB NOT NULL, updated DATETIME DEFAULT CURRENT_TIMESTAMP NOT NULL);
CREATE INDEX devices_attribs_device_id_index ON devices_attribs (device_id);
CREATE TABLE pseudowires (pseudowire_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER NOT NULL, port_id INTEGER NOT NULL, peer_device_id INTEGER NOT NULL, peer_ldp_id INTEGER NOT NULL, cpwVcID INTEGER UNSIGNED NOT NULL, cpwOid INTEGER NOT NULL, pw_type VARCHAR(255) NOT NULL, pw_psntype VARCHAR(255) NOT NULL, pw_local_mtu INTEGER NOT NULL, pw_peer_mtu INTEGER NOT NULL, pw_descr VARCHAR(255) NOT NULL);
CREATE INDEX "devices_hostname_sysname_display_index" on "devices" ("hostname", "sysName", "display");
CREATE TABLE ports_stp (port_stp_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER NOT NULL, port_id INTEGER NOT NULL, priority INTEGER NOT NULL, state VARCHAR(255) NOT NULL, enable VARCHAR(255) NOT NULL, pathCost INTEGER NOT NULL, designatedRoot VARCHAR(255) NOT NULL, designatedCost INTEGER UNSIGNED NOT NULL, designatedBridge VARCHAR(255) NOT NULL, designatedPort INTEGER NOT NULL, forwardTransitions INTEGER NOT NULL, vlan INTEGER DEFAULT NULL, port_index INTEGER DEFAULT 0 NOT NULL);
CREATE UNIQUE INDEX ports_stp_device_id_vlan_port_index_unique ON ports_stp (device_id, vlan, port_index);
CREATE TABLE isis_adjacencies (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER NOT NULL, port_id INTEGER DEFAULT NULL, ifIndex INTEGER NOT NULL, isisISAdjState VARCHAR(255) NOT NULL, isisISAdjNeighSysType VARCHAR(128) DEFAULT NULL, isisISAdjNeighSysID VARCHAR(128) DEFAULT NULL, isisISAdjNeighPriority VARCHAR(128) DEFAULT NULL, isisISAdjLastUpTime BIGINT UNSIGNED DEFAULT NULL, isisISAdjAreaAddress VARCHAR(128) DEFAULT NULL, isisISAdjIPAddrType VARCHAR(128) DEFAULT NULL, isisISAdjIPAddrAddress VARCHAR(128) DEFAULT NULL, isisCircAdminState VARCHAR(255) DEFAULT 'off' NOT NULL, "index" varchar);
CREATE INDEX isis_adjacencies_ifindex_index ON isis_adjacencies (ifIndex);
CREATE INDEX isis_adjacencies_port_id_index ON isis_adjacencies (port_id);
CREATE INDEX isis_adjacencies_device_id_index ON isis_adjacencies (device_id);
CREATE TABLE users_widgets (user_widget_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, user_id INTEGER NOT NULL, col INTEGER NOT NULL, "row" INTEGER NOT NULL, size_x INTEGER NOT NULL, size_y INTEGER NOT NULL, title VARCHAR(255) NOT NULL COLLATE "BINARY", refresh INTEGER DEFAULT 60 NOT NULL, settings CLOB NOT NULL COLLATE "BINARY", dashboard_id INTEGER NOT NULL, widget VARCHAR(32) NOT NULL COLLATE "BINARY");
CREATE UNIQUE INDEX "plugins_version_plugin_name_unique" on "plugins" ("version", "plugin_name");
CREATE TABLE IF NOT EXISTS "ports_vdsl" ("port_id" integer not null, "port_vdsl_updated" datetime not null default CURRENT_TIMESTAMP, "xdsl2LineStatusAttainableRateDs" integer not null default '0', "xdsl2LineStatusAttainableRateUs" integer not null default '0', "xdsl2ChStatusActDataRateXtur" integer not null default '0', "xdsl2ChStatusActDataRateXtuc" integer not null default '0', "xdsl2LineStatusActAtpDs" numeric not null default '0', "xdsl2LineStatusActAtpUs" numeric not null default '0');
CREATE UNIQUE INDEX "ports_vdsl_port_id_unique" on "ports_vdsl" ("port_id");
CREATE TABLE ports_adsl (port_id INTEGER NOT NULL, port_adsl_updated DATETIME DEFAULT CURRENT_TIMESTAMP NOT NULL, adslLineCoding VARCHAR(8) DEFAULT '' NOT NULL, adslLineType VARCHAR(16) DEFAULT '' NOT NULL, adslAtucInvVendorID VARCHAR(16) DEFAULT '' NOT NULL, adslAtucInvVersionNumber VARCHAR(16) DEFAULT '' NOT NULL, adslAtucCurrSnrMgn NUMERIC(5, 1) DEFAULT '0' NOT NULL, adslAtucCurrAtn NUMERIC(5, 1) DEFAULT '0' NOT NULL, adslAtucCurrOutputPwr NUMERIC(5, 1) DEFAULT '0' NOT NULL, adslAtucCurrAttainableRate INTEGER DEFAULT 0 NOT NULL, adslAtucChanCurrTxRate INTEGER DEFAULT 0 NOT NULL, adslAturInvSerialNumber VARCHAR(32) DEFAULT '' NOT NULL, adslAturInvVendorID VARCHAR(16) DEFAULT '' NOT NULL, adslAturInvVersionNumber VARCHAR(16) DEFAULT '' NOT NULL, adslAturChanCurrTxRate INTEGER DEFAULT 0 NOT NULL, adslAturCurrSnrMgn NUMERIC(5, 1) DEFAULT '0' NOT NULL, adslAturCurrAtn NUMERIC(5, 1) DEFAULT '0' NOT NULL, adslAturCurrOutputPwr NUMERIC(5, 1) DEFAULT '0' NOT NULL, adslAturCurrAttainableRate INTEGER DEFAULT 0 NOT NULL);
CREATE UNIQUE INDEX ports_adsl_port_id_unique ON ports_adsl (port_id);
CREATE TABLE ports (port_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER DEFAULT 0 NOT NULL, port_descr_type VARCHAR(255) DEFAULT NULL COLLATE "BINARY", port_descr_descr VARCHAR(255) DEFAULT NULL COLLATE "BINARY", port_descr_circuit VARCHAR(255) DEFAULT NULL COLLATE "BINARY", port_descr_speed VARCHAR(255) DEFAULT NULL COLLATE "BINARY", port_descr_notes VARCHAR(255) DEFAULT NULL COLLATE "BINARY", ifDescr VARCHAR(255) DEFAULT NULL COLLATE "BINARY", ifName VARCHAR(255) DEFAULT NULL COLLATE "BINARY", portName VARCHAR(255) DEFAULT NULL COLLATE "BINARY", ifIndex INTEGER DEFAULT 0, ifSpeed INTEGER DEFAULT NULL, ifConnectorPresent VARCHAR(255) DEFAULT NULL COLLATE "BINARY", ifOperStatus VARCHAR(255) DEFAULT NULL COLLATE "BINARY", ifOperStatus_prev VARCHAR(255) DEFAULT NULL COLLATE "BINARY", ifAdminStatus VARCHAR(255) DEFAULT NULL COLLATE "BINARY", ifAdminStatus_prev VARCHAR(255) DEFAULT NULL COLLATE "BINARY", ifDuplex VARCHAR(255) DEFAULT NULL COLLATE "BINARY", ifMtu INTEGER DEFAULT NULL, ifType VARCHAR(64) DEFAULT NULL COLLATE "BINARY", ifAlias VARCHAR(255) DEFAULT NULL COLLATE "BINARY", ifPhysAddress VARCHAR(64) DEFAULT NULL COLLATE "BINARY", ifLastChange INTEGER DEFAULT 0 NOT NULL, ifVlan VARCHAR(255) DEFAULT '' NOT NULL COLLATE "BINARY", ifTrunk VARCHAR(255) DEFAULT NULL COLLATE "BINARY", ifVrf INTEGER DEFAULT 0 NOT NULL, "ignore" BOOLEAN DEFAULT 0 NOT NULL, disabled BOOLEAN DEFAULT 0 NOT NULL, deleted BOOLEAN DEFAULT 0 NOT NULL, pagpOperationMode VARCHAR(255) DEFAULT NULL COLLATE "BINARY", pagpPortState VARCHAR(255) DEFAULT NULL COLLATE "BINARY", pagpPartnerDeviceId VARCHAR(255) DEFAULT NULL COLLATE "BINARY", pagpPartnerLearnMethod VARCHAR(255) DEFAULT NULL COLLATE "BINARY", pagpPartnerIfIndex INTEGER DEFAULT NULL, pagpPartnerGroupIfIndex INTEGER DEFAULT NULL, pagpPartnerDeviceName VARCHAR(255) DEFAULT NULL COLLATE "BINARY", pagpEthcOperationMode VARCHAR(255) DEFAULT NULL COLLATE "BINARY", pagpDeviceId VARCHAR(255) DEFAULT NULL COLLATE "BINARY", pagpGroupIfIndex INTEGER DEFAULT NULL, ifInUcastPkts INTEGER DEFAULT NULL, ifInUcastPkts_prev INTEGER DEFAULT NULL, ifInUcastPkts_delta INTEGER DEFAULT NULL, ifInUcastPkts_rate INTEGER DEFAULT NULL, ifOutUcastPkts INTEGER DEFAULT NULL, ifOutUcastPkts_prev INTEGER DEFAULT NULL, ifOutUcastPkts_delta INTEGER DEFAULT NULL, ifOutUcastPkts_rate INTEGER DEFAULT NULL, ifInErrors INTEGER DEFAULT NULL, ifInErrors_prev INTEGER DEFAULT NULL, ifInErrors_delta INTEGER DEFAULT NULL, ifInErrors_rate INTEGER DEFAULT NULL, ifOutErrors INTEGER DEFAULT NULL, ifOutErrors_prev INTEGER DEFAULT NULL, ifOutErrors_delta INTEGER DEFAULT NULL, ifOutErrors_rate INTEGER DEFAULT NULL, ifInOctets INTEGER DEFAULT NULL, ifInOctets_prev INTEGER DEFAULT NULL, ifInOctets_delta INTEGER DEFAULT NULL, ifInOctets_rate INTEGER DEFAULT NULL, ifOutOctets INTEGER DEFAULT NULL, ifOutOctets_prev INTEGER DEFAULT NULL, ifOutOctets_delta INTEGER DEFAULT NULL, ifOutOctets_rate INTEGER DEFAULT NULL, poll_time INTEGER DEFAULT NULL, poll_prev INTEGER DEFAULT NULL, poll_period INTEGER DEFAULT NULL, ifSpeed_prev INTEGER DEFAULT NULL);
CREATE INDEX ports_ifdescr_ifname_index ON ports (ifDescr, ifName);
CREATE INDEX ports_ifalias_port_descr_descr_portname_index ON ports (ifAlias, port_descr_descr, portName);
CREATE UNIQUE INDEX ports_device_id_ifindex_unique ON ports (device_id, ifIndex);
CREATE TABLE slas (sla_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER NOT NULL, sla_nr INTEGER UNSIGNED NOT NULL, owner VARCHAR(255) NOT NULL COLLATE "BINARY", tag VARCHAR(255) NOT NULL COLLATE "BINARY", rtt_type VARCHAR(255) NOT NULL COLLATE "BINARY", status BOOLEAN NOT NULL, deleted BOOLEAN DEFAULT 0 NOT NULL, rtt DOUBLE PRECISION DEFAULT NULL, opstatus INTEGER DEFAULT 0 NOT NULL);
CREATE INDEX slas_device_id_index ON slas (device_id);
CREATE UNIQUE INDEX slas_device_id_sla_nr_unique ON slas (device_id, sla_nr);
CREATE TABLE IF NOT EXISTS "abilities" ("id" integer primary key autoincrement not null, "name" varchar not null, "title" varchar, "entity_id" integer, "entity_type" varchar, "only_owned" tinyint(1) not null default '0', "options" text, "scope" integer, "created_at" datetime, "updated_at" datetime);
CREATE INDEX "abilities_scope_index" on "abilities" ("scope");
CREATE TABLE IF NOT EXISTS "roles" ("id" integer primary key autoincrement not null, "name" varchar not null, "title" varchar, "scope" integer, "created_at" datetime, "updated_at" datetime);
CREATE UNIQUE INDEX "roles_name_unique" on "roles" ("name", "scope");
CREATE INDEX "roles_scope_index" on "roles" ("scope");
CREATE TABLE IF NOT EXISTS "assigned_roles" ("id" integer primary key autoincrement not null, "role_id" integer not null, "entity_id" integer not null, "entity_type" varchar not null, "restricted_to_id" integer, "restricted_to_type" varchar, "scope" integer, foreign key("role_id") references "roles"("id") on delete cascade on update cascade);
CREATE INDEX "assigned_roles_entity_index" on "assigned_roles" ("entity_id", "entity_type", "scope");
CREATE INDEX "assigned_roles_role_id_index" on "assigned_roles" ("role_id");
CREATE INDEX "assigned_roles_scope_index" on "assigned_roles" ("scope");
CREATE TABLE IF NOT EXISTS "permissions" ("id" integer primary key autoincrement not null, "ability_id" integer not null, "entity_id" integer, "entity_type" varchar, "forbidden" tinyint(1) not null default '0', "scope" integer, foreign key("ability_id") references "abilities"("id") on delete cascade on update cascade);
CREATE INDEX "permissions_entity_index" on "permissions" ("entity_id", "entity_type", "scope");
CREATE INDEX "permissions_ability_id_index" on "permissions" ("ability_id");
CREATE INDEX "permissions_scope_index" on "permissions" ("scope");
CREATE TABLE users (user_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, auth_type VARCHAR(255) DEFAULT NULL COLLATE "BINARY", auth_id VARCHAR(255) DEFAULT NULL COLLATE "BINARY", username VARCHAR(255) NOT NULL COLLATE "BINARY", password VARCHAR(255) DEFAULT NULL COLLATE "BINARY", realname VARCHAR(255) NOT NULL COLLATE "BINARY", email VARCHAR(255) NOT NULL COLLATE "BINARY", descr VARCHAR(255) NOT NULL COLLATE "BINARY", can_modify_passwd BOOLEAN DEFAULT 1 NOT NULL, created_at DATETIME DEFAULT '1970-01-02 00:00:01' NOT NULL, updated_at DATETIME DEFAULT CURRENT_TIMESTAMP NOT NULL, remember_token VARCHAR(255) DEFAULT NULL COLLATE "BINARY", enabled BOOLEAN DEFAULT 1 NOT NULL);
CREATE UNIQUE INDEX users_auth_type_username_unique ON users (auth_type, username);
CREATE TABLE vendor_ouis (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, vendor VARCHAR(255) NOT NULL, oui VARCHAR(12) NOT NULL);
CREATE UNIQUE INDEX "vendor_ouis_oui_unique" on "vendor_ouis" ("oui");
CREATE TABLE applications (app_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER NOT NULL, app_type VARCHAR(255) NOT NULL, app_state VARCHAR(255) DEFAULT 'UNKNOWN' NOT NULL, discovered INTEGER DEFAULT 0 NOT NULL, app_state_prev VARCHAR(255) DEFAULT NULL, app_status VARCHAR(1024) DEFAULT '' NOT NULL, timestamp DATETIME DEFAULT CURRENT_TIMESTAMP NOT NULL, app_instance VARCHAR(255) DEFAULT '' NOT NULL, data CLOB DEFAULT NULL, deleted_at DATETIME DEFAULT NULL);
CREATE UNIQUE INDEX applications_device_id_app_type_unique ON applications (device_id, app_type);
CREATE TABLE processes (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER NOT NULL, pid INTEGER NOT NULL, vsz INTEGER NOT NULL, rss INTEGER NOT NULL, cputime VARCHAR(14) NOT NULL, user VARCHAR(255) NOT NULL, command CLOB NOT NULL);
CREATE INDEX processes_device_id_index ON processes (device_id);
CREATE TABLE bgpPeers_cbgp (device_id INTEGER NOT NULL, bgpPeerIdentifier VARCHAR(255) NOT NULL, afi VARCHAR(255) NOT NULL, safi VARCHAR(255) NOT NULL, AcceptedPrefixes INTEGER UNSIGNED NOT NULL, DeniedPrefixes INTEGER UNSIGNED NOT NULL, PrefixAdminLimit INTEGER UNSIGNED NOT NULL, PrefixThreshold INTEGER UNSIGNED NOT NULL, PrefixClearThreshold INTEGER UNSIGNED NOT NULL, AdvertisedPrefixes INTEGER UNSIGNED NOT NULL, SuppressedPrefixes INTEGER UNSIGNED NOT NULL, WithdrawnPrefixes INTEGER UNSIGNED NOT NULL, AcceptedPrefixes_delta INTEGER NOT NULL, AcceptedPrefixes_prev INTEGER UNSIGNED NOT NULL, DeniedPrefixes_delta INTEGER NOT NULL, DeniedPrefixes_prev INTEGER UNSIGNED NOT NULL, AdvertisedPrefixes_delta INTEGER NOT NULL, AdvertisedPrefixes_prev INTEGER UNSIGNED NOT NULL, SuppressedPrefixes_delta INTEGER NOT NULL, SuppressedPrefixes_prev INTEGER UNSIGNED NOT NULL, WithdrawnPrefixes_delta INTEGER NOT NULL, WithdrawnPrefixes_prev INTEGER UNSIGNED NOT NULL, context_name VARCHAR(255) DEFAULT NULL);
CREATE INDEX bgppeers_cbgp_device_id_bgppeeridentifier_context_name_index ON bgpPeers_cbgp (device_id, bgpPeerIdentifier, context_name);
CREATE UNIQUE INDEX bgppeers_cbgp_device_id_bgppeeridentifier_afi_safi_unique ON bgpPeers_cbgp (device_id, bgpPeerIdentifier, afi, safi);
CREATE TABLE bgpPeers (bgpPeer_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER NOT NULL, astext VARCHAR(255) NOT NULL, bgpPeerIdentifier CLOB NOT NULL, bgpPeerRemoteAs INTEGER NOT NULL, bgpPeerState CLOB NOT NULL, bgpPeerAdminStatus CLOB NOT NULL, bgpLocalAddr CLOB NOT NULL, bgpPeerRemoteAddr CLOB NOT NULL, bgpPeerDescr VARCHAR(255) DEFAULT '' NOT NULL, bgpPeerInUpdates INTEGER UNSIGNED NOT NULL, bgpPeerOutUpdates INTEGER UNSIGNED NOT NULL, bgpPeerInTotalMessages INTEGER UNSIGNED NOT NULL, bgpPeerOutTotalMessages INTEGER UNSIGNED NOT NULL, bgpPeerFsmEstablishedTime INTEGER UNSIGNED NOT NULL, bgpPeerInUpdateElapsedTime INTEGER UNSIGNED NOT NULL, context_name VARCHAR(255) DEFAULT NULL, vrf_id INTEGER DEFAULT NULL, bgpPeerLastErrorCode INTEGER DEFAULT NULL, bgpPeerLastErrorSubCode INTEGER DEFAULT NULL, bgpPeerLastErrorText VARCHAR(255) DEFAULT NULL, bgpPeerIface INTEGER DEFAULT NULL);
CREATE INDEX bgppeers_device_id_context_name_index ON bgpPeers (device_id, context_name);
CREATE TABLE ports_statistics (port_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, ifInNUcastPkts BIGINT UNSIGNED DEFAULT NULL, ifInNUcastPkts_prev BIGINT UNSIGNED DEFAULT NULL, ifInNUcastPkts_delta BIGINT DEFAULT NULL, ifInNUcastPkts_rate BIGINT DEFAULT NULL, ifOutNUcastPkts BIGINT UNSIGNED DEFAULT NULL, ifOutNUcastPkts_prev BIGINT UNSIGNED DEFAULT NULL, ifOutNUcastPkts_delta BIGINT DEFAULT NULL, ifOutNUcastPkts_rate BIGINT DEFAULT NULL, ifInDiscards BIGINT UNSIGNED DEFAULT NULL, ifInDiscards_prev BIGINT UNSIGNED DEFAULT NULL, ifInDiscards_delta BIGINT DEFAULT NULL, ifInDiscards_rate BIGINT DEFAULT NULL, ifOutDiscards BIGINT UNSIGNED DEFAULT NULL, ifOutDiscards_prev BIGINT UNSIGNED DEFAULT NULL, ifOutDiscards_delta BIGINT DEFAULT NULL, ifOutDiscards_rate BIGINT DEFAULT NULL, ifInUnknownProtos BIGINT UNSIGNED DEFAULT NULL, ifInUnknownProtos_prev BIGINT UNSIGNED DEFAULT NULL, ifInUnknownProtos_delta BIGINT DEFAULT NULL, ifInUnknownProtos_rate BIGINT DEFAULT NULL, ifInBroadcastPkts BIGINT UNSIGNED DEFAULT NULL, ifInBroadcastPkts_prev BIGINT UNSIGNED DEFAULT NULL, ifInBroadcastPkts_delta BIGINT DEFAULT NULL, ifInBroadcastPkts_rate BIGINT DEFAULT NULL, ifOutBroadcastPkts BIGINT UNSIGNED DEFAULT NULL, ifOutBroadcastPkts_prev BIGINT UNSIGNED DEFAULT NULL, ifOutBroadcastPkts_delta BIGINT DEFAULT NULL, ifOutBroadcastPkts_rate BIGINT DEFAULT NULL, ifInMulticastPkts BIGINT UNSIGNED DEFAULT NULL, ifInMulticastPkts_prev BIGINT UNSIGNED DEFAULT NULL, ifInMulticastPkts_delta BIGINT DEFAULT NULL, ifInMulticastPkts_rate BIGINT DEFAULT NULL, ifOutMulticastPkts BIGINT UNSIGNED DEFAULT NULL, ifOutMulticastPkts_prev BIGINT UNSIGNED DEFAULT NULL, ifOutMulticastPkts_delta BIGINT DEFAULT NULL, ifOutMulticastPkts_rate BIGINT UNSIGNED DEFAULT NULL);
CREATE TABLE ciscoASA (ciscoASA_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER NOT NULL, oid VARCHAR(255) NOT NULL, data INTEGER NOT NULL, high_alert BIGINT DEFAULT -1 NOT NULL, low_alert BIGINT DEFAULT 0 NOT NULL, disabled INTEGER DEFAULT 0 NOT NULL);
CREATE INDEX ciscoasa_device_id_index ON ciscoASA (device_id);
CREATE TABLE ospf_areas (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER NOT NULL, ospfAreaId VARCHAR(255) NOT NULL, ospfAuthType VARCHAR(64) DEFAULT NULL, ospfImportAsExtern VARCHAR(255) NOT NULL, ospfSpfRuns INTEGER UNSIGNED NOT NULL, ospfAreaBdrRtrCount INTEGER UNSIGNED NOT NULL, ospfAsBdrRtrCount INTEGER UNSIGNED NOT NULL, ospfAreaLsaCount INTEGER UNSIGNED NOT NULL, ospfAreaLsaCksumSum INTEGER NOT NULL, ospfAreaSummary VARCHAR(255) NOT NULL, ospfAreaStatus VARCHAR(255) NOT NULL, context_name VARCHAR(255) DEFAULT NULL);
CREATE UNIQUE INDEX ospf_areas_device_id_ospfareaid_context_name_unique ON ospf_areas (device_id, ospfAreaId, context_name);
CREATE TABLE ospf_instances (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER NOT NULL, ospf_instance_id INTEGER NOT NULL, ospfRouterId VARCHAR(255) NOT NULL, ospfAdminStat VARCHAR(255) NOT NULL, ospfVersionNumber VARCHAR(255) NOT NULL, ospfAreaBdrRtrStatus VARCHAR(255) NOT NULL, ospfASBdrRtrStatus VARCHAR(255) NOT NULL, ospfExternLsaCount INTEGER UNSIGNED NOT NULL, ospfExternLsaCksumSum INTEGER NOT NULL, ospfTOSSupport VARCHAR(255) NOT NULL, ospfOriginateNewLsas INTEGER UNSIGNED NOT NULL, ospfRxNewLsas INTEGER UNSIGNED NOT NULL, ospfExtLsdbLimit INTEGER DEFAULT NULL, ospfMulticastExtensions INTEGER DEFAULT NULL, ospfExitOverflowInterval INTEGER DEFAULT NULL, ospfDemandExtensions VARCHAR(255) DEFAULT NULL, context_name VARCHAR(255) DEFAULT NULL);
CREATE UNIQUE INDEX ospf_instances_device_id_ospf_instance_id_context_name_unique ON ospf_instances (device_id, ospf_instance_id, context_name);
CREATE TABLE ospf_nbrs (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER NOT NULL, port_id INTEGER DEFAULT NULL, ospf_nbr_id VARCHAR(255) NOT NULL, ospfNbrIpAddr VARCHAR(255) NOT NULL, ospfNbrAddressLessIndex INTEGER NOT NULL, ospfNbrRtrId VARCHAR(255) NOT NULL, ospfNbrOptions INTEGER NOT NULL, ospfNbrPriority INTEGER NOT NULL, ospfNbrState VARCHAR(255) NOT NULL, ospfNbrEvents INTEGER UNSIGNED NOT NULL, ospfNbrLsRetransQLen INTEGER UNSIGNED NOT NULL, ospfNbmaNbrStatus VARCHAR(255) NOT NULL, ospfNbmaNbrPermanence VARCHAR(255) NOT NULL, ospfNbrHelloSuppressed VARCHAR(255) NOT NULL, context_name VARCHAR(255) DEFAULT NULL);
CREATE UNIQUE INDEX ospf_nbrs_device_id_ospf_nbr_id_context_name_unique ON ospf_nbrs (device_id, ospf_nbr_id, context_name);
CREATE TABLE ospf_ports (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER NOT NULL, port_id INTEGER NOT NULL, ospf_port_id VARCHAR(255) NOT NULL, ospfIfIpAddress VARCHAR(255) NOT NULL, ospfAddressLessIf INTEGER NOT NULL, ospfIfAreaId VARCHAR(255) NOT NULL, ospfIfType VARCHAR(255) DEFAULT NULL, ospfIfAdminStat VARCHAR(255) DEFAULT NULL, ospfIfRtrPriority INTEGER DEFAULT NULL, ospfIfTransitDelay INTEGER DEFAULT NULL, ospfIfRetransInterval INTEGER DEFAULT NULL, ospfIfHelloInterval INTEGER DEFAULT NULL, ospfIfRtrDeadInterval INTEGER DEFAULT NULL, ospfIfPollInterval INTEGER DEFAULT NULL, ospfIfState VARCHAR(255) DEFAULT NULL, ospfIfDesignatedRouter VARCHAR(255) DEFAULT NULL, ospfIfBackupDesignatedRouter VARCHAR(255) DEFAULT NULL, ospfIfEvents INTEGER UNSIGNED DEFAULT NULL, ospfIfAuthKey VARCHAR(255) DEFAULT NULL, ospfIfStatus VARCHAR(255) DEFAULT NULL, ospfIfMulticastForwarding VARCHAR(255) DEFAULT NULL, ospfIfDemand VARCHAR(255) DEFAULT NULL, ospfIfAuthType VARCHAR(255) DEFAULT NULL, context_name VARCHAR(255) DEFAULT NULL, ospfIfMetricIpAddress VARCHAR(255) DEFAULT NULL, ospfIfMetricAddressLessIf INTEGER DEFAULT NULL, ospfIfMetricTOS INTEGER DEFAULT NULL, ospfIfMetricValue INTEGER DEFAULT NULL, ospfIfMetricStatus VARCHAR(255) DEFAULT NULL);
CREATE UNIQUE INDEX ospf_ports_device_id_ospf_port_id_context_name_unique ON ospf_ports (device_id, ospf_port_id, context_name);
CREATE TABLE packages (pkg_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER NOT NULL, name VARCHAR(128) NOT NULL, manager VARCHAR(255) DEFAULT '1' NOT NULL, status BOOLEAN NOT NULL, version VARCHAR(255) NOT NULL, build VARCHAR(255) NOT NULL, arch VARCHAR(255) NOT NULL, size INTEGER DEFAULT NULL);
CREATE INDEX packages_device_id_index ON packages (device_id);
CREATE UNIQUE INDEX packages_device_id_name_manager_arch_version_build_unique ON packages (device_id, name, manager, arch, version, build);
CREATE TABLE vminfo (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER NOT NULL, vm_type VARCHAR(255) DEFAULT 'vmware' NOT NULL, vmwVmVMID INTEGER NOT NULL, vmwVmDisplayName VARCHAR(255) NOT NULL, vmwVmGuestOS VARCHAR(256) DEFAULT NULL, vmwVmMemSize INTEGER NOT NULL, vmwVmCpus INTEGER NOT NULL, vmwVmState SMALLINT UNSIGNED NOT NULL);
CREATE INDEX vminfo_vmwvmvmid_index ON vminfo (vmwVmVMID);
CREATE INDEX vminfo_device_id_index ON vminfo (device_id);
CREATE TABLE IF NOT EXISTS "custom_map_nodes" ("custom_map_node_id" integer primary key autoincrement not null, "custom_map_id" integer not null, "device_id" integer, "label" varchar not null, "style" varchar not null, "icon" varchar, "size" integer not null, "border_width" integer not null, "text_face" varchar not null, "text_size" integer not null, "text_colour" varchar not null, "colour_bg" varchar, "colour_bdr" varchar, "x_pos" integer not null, "y_pos" integer not null, "created_at" datetime, "updated_at" datetime, "image" varchar not null default '', "linked_custom_map_id" integer, foreign key("device_id") references "devices"("device_id") on delete set null, foreign key("custom_map_id") references "custom_maps"("custom_map_id") on delete cascade);
CREATE INDEX "custom_map_nodes_custom_map_id_index" on "custom_map_nodes" ("custom_map_id");
CREATE INDEX "custom_map_nodes_device_id_index" on "custom_map_nodes" ("device_id");
CREATE TABLE IF NOT EXISTS "custom_map_edges" ("custom_map_edge_id" integer primary key autoincrement not null, "custom_map_id" integer not null, "custom_map_node1_id" integer not null, "custom_map_node2_id" integer not null, "port_id" integer, "reverse" tinyint(1) not null, "style" varchar not null, "showpct" tinyint(1) not null, "text_face" varchar not null, "text_size" integer not null, "text_colour" varchar not null, "mid_x" integer not null, "mid_y" integer not null, "created_at" datetime, "updated_at" datetime, "showbps" tinyint(1) not null default '0', "label" varchar not null default '', foreign key("custom_map_id") references "custom_maps"("custom_map_id") on delete cascade, foreign key("port_id") references "ports"("port_id") on delete set null, foreign key("custom_map_node1_id") references "custom_map_nodes"("custom_map_node_id") on delete cascade, foreign key("custom_map_node2_id") references "custom_map_nodes"("custom_map_node_id") on delete cascade);
CREATE INDEX "custom_map_edges_custom_map_id_index" on "custom_map_edges" ("custom_map_id");
CREATE INDEX "custom_map_edges_custom_map_node1_id_index" on "custom_map_edges" ("custom_map_node1_id");
CREATE INDEX "custom_map_edges_custom_map_node2_id_index" on "custom_map_edges" ("custom_map_node2_id");
CREATE INDEX "custom_map_edges_port_id_index" on "custom_map_edges" ("port_id");
CREATE TABLE IF NOT EXISTS "custom_map_backgrounds" ("custom_map_background_id" integer primary key autoincrement not null, "created_at" datetime, "updated_at" datetime, "custom_map_id" integer not null, "background_image" blob not null, foreign key("custom_map_id") references "custom_maps"("custom_map_id") on delete cascade);
CREATE UNIQUE INDEX "custom_map_backgrounds_custom_map_id_unique" on "custom_map_backgrounds" ("custom_map_id");
CREATE TABLE mpls_sdps (sdp_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, sdp_oid INTEGER NOT NULL, device_id INTEGER NOT NULL, sdpRowStatus VARCHAR(255) DEFAULT NULL COLLATE "BINARY", sdpDelivery VARCHAR(255) DEFAULT NULL COLLATE "BINARY", sdpDescription VARCHAR(255) DEFAULT NULL COLLATE "BINARY", sdpAdminStatus VARCHAR(255) DEFAULT NULL COLLATE "BINARY", sdpOperStatus VARCHAR(255) DEFAULT NULL COLLATE "BINARY", sdpAdminPathMtu INTEGER DEFAULT NULL, sdpOperPathMtu INTEGER DEFAULT NULL, sdpLastMgmtChange INTEGER DEFAULT NULL, sdpLastStatusChange INTEGER DEFAULT NULL, sdpActiveLspType VARCHAR(255) DEFAULT NULL COLLATE "BINARY", sdpFarEndInetAddress VARCHAR(255) DEFAULT NULL COLLATE "BINARY", "sdpFarEndInetAddressType" varchar check ("sdpFarEndInetAddressType" in ('unknown', 'ipv4', 'ipv6', 'ipv4z', 'ipv6z', 'dns')));
CREATE INDEX mpls_sdps_device_id_index ON mpls_sdps (device_id);
CREATE INDEX "custom_map_nodes_linked_custom_map_id_index" on "custom_map_nodes" ("linked_custom_map_id");
CREATE INDEX "bill_data_bill_id_timestamp_index" on "bill_data" ("bill_id", "timestamp");
CREATE TABLE custom_maps (custom_map_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, name VARCHAR(255) NOT NULL COLLATE "BINARY", width VARCHAR(255) NOT NULL COLLATE "BINARY", height VARCHAR(255) NOT NULL COLLATE "BINARY", options CLOB DEFAULT NULL COLLATE "BINARY", newnodeconfig CLOB NOT NULL COLLATE "BINARY", newedgeconfig CLOB NOT NULL COLLATE "BINARY", created_at DATETIME DEFAULT NULL, updated_at DATETIME DEFAULT NULL, node_align INTEGER DEFAULT 0 NOT NULL, reverse_arrows BOOLEAN DEFAULT 0 NOT NULL, edge_separation INTEGER DEFAULT 10 NOT NULL, legend_x INTEGER DEFAULT -1 NOT NULL, legend_y INTEGER DEFAULT -1 NOT NULL, legend_steps INTEGER DEFAULT 7 NOT NULL, legend_font_size INTEGER DEFAULT 14 NOT NULL, legend_hide_invalid BOOLEAN DEFAULT 0 NOT NULL, legend_hide_overspeed BOOLEAN DEFAULT 0 NOT NULL, menu_group VARCHAR(255) DEFAULT NULL COLLATE "BINARY", background_type VARCHAR(255) DEFAULT 'none' NOT NULL COLLATE "BINARY", background_data CLOB DEFAULT NULL COLLATE "BINARY");
CREATE TABLE entPhysical (entPhysical_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, device_id INTEGER NOT NULL, entPhysicalIndex INTEGER NOT NULL, entPhysicalDescr CLOB DEFAULT NULL, entPhysicalClass CLOB DEFAULT NULL, entPhysicalName CLOB DEFAULT NULL, entPhysicalHardwareRev VARCHAR(255) DEFAULT NULL, entPhysicalFirmwareRev VARCHAR(255) DEFAULT NULL, entPhysicalSoftwareRev VARCHAR(255) DEFAULT NULL, entPhysicalAlias VARCHAR(255) DEFAULT NULL, entPhysicalAssetID VARCHAR(255) DEFAULT NULL, entPhysicalIsFRU VARCHAR(255) DEFAULT NULL, entPhysicalModelName CLOB DEFAULT NULL, entPhysicalVendorType CLOB DEFAULT NULL, entPhysicalSerialNum CLOB DEFAULT NULL, entPhysicalContainedIn INTEGER DEFAULT 0 NOT NULL, entPhysicalParentRelPos INTEGER DEFAULT -1 NOT NULL, entPhysicalMfgName CLOB DEFAULT NULL, ifIndex INTEGER DEFAULT NULL);
CREATE INDEX entphysical_device_id_index ON entPhysical (device_id);
INSERT INTO migrations VALUES(1,'2018_07_03_091314_create_access_points_table',1);
INSERT INTO migrations VALUES(2,'2018_07_03_091314_create_alert_device_map_table',1);
INSERT INTO migrations VALUES(3,'2018_07_03_091314_create_alert_group_map_table',1);
INSERT INTO migrations VALUES(4,'2018_07_03_091314_create_alert_log_table',1);
INSERT INTO migrations VALUES(5,'2018_07_03_091314_create_alert_rules_table',1);
INSERT INTO migrations VALUES(6,'2018_07_03_091314_create_alert_schedulables_table',1);
INSERT INTO migrations VALUES(7,'2018_07_03_091314_create_alert_schedule_table',1);
INSERT INTO migrations VALUES(8,'2018_07_03_091314_create_alert_template_map_table',1);
INSERT INTO migrations VALUES(9,'2018_07_03_091314_create_alert_templates_table',1);
INSERT INTO migrations VALUES(10,'2018_07_03_091314_create_alert_transport_groups_table',1);
INSERT INTO migrations VALUES(11,'2018_07_03_091314_create_alert_transport_map_table',1);
INSERT INTO migrations VALUES(12,'2018_07_03_091314_create_alert_transports_table',1);
INSERT INTO migrations VALUES(13,'2018_07_03_091314_create_alerts_table',1);
INSERT INTO migrations VALUES(14,'2018_07_03_091314_create_api_tokens_table',1);
INSERT INTO migrations VALUES(15,'2018_07_03_091314_create_application_metrics_table',1);
INSERT INTO migrations VALUES(16,'2018_07_03_091314_create_applications_table',1);
INSERT INTO migrations VALUES(17,'2018_07_03_091314_create_authlog_table',1);
INSERT INTO migrations VALUES(18,'2018_07_03_091314_create_bgpPeers_cbgp_table',1);
INSERT INTO migrations VALUES(19,'2018_07_03_091314_create_bgpPeers_table',1);
INSERT INTO migrations VALUES(20,'2018_07_03_091314_create_bill_data_table',1);
INSERT INTO migrations VALUES(21,'2018_07_03_091314_create_bill_history_table',1);
INSERT INTO migrations VALUES(22,'2018_07_03_091314_create_bill_perms_table',1);
INSERT INTO migrations VALUES(23,'2018_07_03_091314_create_bill_port_counters_table',1);
INSERT INTO migrations VALUES(24,'2018_07_03_091314_create_bill_ports_table',1);
INSERT INTO migrations VALUES(25,'2018_07_03_091314_create_bills_table',1);
INSERT INTO migrations VALUES(26,'2018_07_03_091314_create_callback_table',1);
INSERT INTO migrations VALUES(27,'2018_07_03_091314_create_cef_switching_table',1);
INSERT INTO migrations VALUES(28,'2018_07_03_091314_create_ciscoASA_table',1);
INSERT INTO migrations VALUES(29,'2018_07_03_091314_create_component_prefs_table',1);
INSERT INTO migrations VALUES(30,'2018_07_03_091314_create_component_statuslog_table',1);
INSERT INTO migrations VALUES(31,'2018_07_03_091314_create_component_table',1);
INSERT INTO migrations VALUES(32,'2018_07_03_091314_create_config_table',1);
INSERT INTO migrations VALUES(33,'2018_07_03_091314_create_customers_table',1);
INSERT INTO migrations VALUES(34,'2018_07_03_091314_create_dashboards_table',1);
INSERT INTO migrations VALUES(35,'2018_07_03_091314_create_dbSchema_table',1);
INSERT INTO migrations VALUES(36,'2018_07_03_091314_create_device_graphs_table',1);
INSERT INTO migrations VALUES(37,'2018_07_03_091314_create_device_group_device_table',1);
INSERT INTO migrations VALUES(38,'2018_07_03_091314_create_device_groups_table',1);
INSERT INTO migrations VALUES(39,'2018_07_03_091314_create_device_mibs_table',1);
INSERT INTO migrations VALUES(40,'2018_07_03_091314_create_device_oids_table',1);
INSERT INTO migrations VALUES(41,'2018_07_03_091314_create_device_perf_table',1);
INSERT INTO migrations VALUES(42,'2018_07_03_091314_create_device_relationships_table',1);
INSERT INTO migrations VALUES(43,'2018_07_03_091314_create_devices_attribs_table',1);
INSERT INTO migrations VALUES(44,'2018_07_03_091314_create_devices_perms_table',1);
INSERT INTO migrations VALUES(45,'2018_07_03_091314_create_devices_table',1);
INSERT INTO migrations VALUES(46,'2018_07_03_091314_create_entPhysical_state_table',1);
INSERT INTO migrations VALUES(47,'2018_07_03_091314_create_entPhysical_table',1);
INSERT INTO migrations VALUES(48,'2018_07_03_091314_create_entityState_table',1);
INSERT INTO migrations VALUES(49,'2018_07_03_091314_create_eventlog_table',1);
INSERT INTO migrations VALUES(50,'2018_07_03_091314_create_graph_types_table',1);
INSERT INTO migrations VALUES(51,'2018_07_03_091314_create_hrDevice_table',1);
INSERT INTO migrations VALUES(52,'2018_07_03_091314_create_ipsec_tunnels_table',1);
INSERT INTO migrations VALUES(53,'2018_07_03_091314_create_ipv4_addresses_table',1);
INSERT INTO migrations VALUES(54,'2018_07_03_091314_create_ipv4_mac_table',1);
INSERT INTO migrations VALUES(55,'2018_07_03_091314_create_ipv4_networks_table',1);
INSERT INTO migrations VALUES(56,'2018_07_03_091314_create_ipv6_addresses_table',1);
INSERT INTO migrations VALUES(57,'2018_07_03_091314_create_ipv6_networks_table',1);
INSERT INTO migrations VALUES(58,'2018_07_03_091314_create_juniAtmVp_table',1);
INSERT INTO migrations VALUES(59,'2018_07_03_091314_create_links_table',1);
INSERT INTO migrations VALUES(60,'2018_07_03_091314_create_loadbalancer_rservers_table',1);
INSERT INTO migrations VALUES(61,'2018_07_03_091314_create_loadbalancer_vservers_table',1);
INSERT INTO migrations VALUES(62,'2018_07_03_091314_create_locations_table',1);
INSERT INTO migrations VALUES(63,'2018_07_03_091314_create_mac_accounting_table',1);
INSERT INTO migrations VALUES(64,'2018_07_03_091314_create_mefinfo_table',1);
INSERT INTO migrations VALUES(65,'2018_07_03_091314_create_mempools_table',1);
INSERT INTO migrations VALUES(66,'2018_07_03_091314_create_mibdefs_table',1);
INSERT INTO migrations VALUES(67,'2018_07_03_091314_create_munin_plugins_ds_table',1);
INSERT INTO migrations VALUES(68,'2018_07_03_091314_create_munin_plugins_table',1);
INSERT INTO migrations VALUES(69,'2018_07_03_091314_create_netscaler_vservers_table',1);
INSERT INTO migrations VALUES(70,'2018_07_03_091314_create_notifications_attribs_table',1);
INSERT INTO migrations VALUES(71,'2018_07_03_091314_create_notifications_table',1);
INSERT INTO migrations VALUES(72,'2018_07_03_091314_create_ospf_areas_table',1);
INSERT INTO migrations VALUES(73,'2018_07_03_091314_create_ospf_instances_table',1);
INSERT INTO migrations VALUES(74,'2018_07_03_091314_create_ospf_nbrs_table',1);
INSERT INTO migrations VALUES(75,'2018_07_03_091314_create_ospf_ports_table',1);
INSERT INTO migrations VALUES(76,'2018_07_03_091314_create_packages_table',1);
INSERT INTO migrations VALUES(77,'2018_07_03_091314_create_pdb_ix_peers_table',1);
INSERT INTO migrations VALUES(78,'2018_07_03_091314_create_pdb_ix_table',1);
INSERT INTO migrations VALUES(79,'2018_07_03_091314_create_perf_times_table',1);
INSERT INTO migrations VALUES(80,'2018_07_03_091314_create_plugins_table',1);
INSERT INTO migrations VALUES(81,'2018_07_03_091314_create_poller_cluster_stats_table',1);
INSERT INTO migrations VALUES(82,'2018_07_03_091314_create_poller_cluster_table',1);
INSERT INTO migrations VALUES(83,'2018_07_03_091314_create_poller_groups_table',1);
INSERT INTO migrations VALUES(84,'2018_07_03_091314_create_pollers_table',1);
INSERT INTO migrations VALUES(85,'2018_07_03_091314_create_ports_adsl_table',1);
INSERT INTO migrations VALUES(86,'2018_07_03_091314_create_ports_fdb_table',1);
INSERT INTO migrations VALUES(87,'2018_07_03_091314_create_ports_nac_table',1);
INSERT INTO migrations VALUES(88,'2018_07_03_091314_create_ports_perms_table',1);
INSERT INTO migrations VALUES(89,'2018_07_03_091314_create_ports_stack_table',1);
INSERT INTO migrations VALUES(90,'2018_07_03_091314_create_ports_statistics_table',1);
INSERT INTO migrations VALUES(91,'2018_07_03_091314_create_ports_stp_table',1);
INSERT INTO migrations VALUES(92,'2018_07_03_091314_create_ports_table',1);
INSERT INTO migrations VALUES(93,'2018_07_03_091314_create_ports_vlans_table',1);
INSERT INTO migrations VALUES(94,'2018_07_03_091314_create_processes_table',1);
INSERT INTO migrations VALUES(95,'2018_07_03_091314_create_processors_table',1);
INSERT INTO migrations VALUES(96,'2018_07_03_091314_create_proxmox_ports_table',1);
INSERT INTO migrations VALUES(97,'2018_07_03_091314_create_proxmox_table',1);
INSERT INTO migrations VALUES(98,'2018_07_03_091314_create_pseudowires_table',1);
INSERT INTO migrations VALUES(99,'2018_07_03_091314_create_route_table',1);
INSERT INTO migrations VALUES(100,'2018_07_03_091314_create_sensors_table',1);
INSERT INTO migrations VALUES(101,'2018_07_03_091314_create_sensors_to_state_indexes_table',1);
INSERT INTO migrations VALUES(102,'2018_07_03_091314_create_services_table',1);
INSERT INTO migrations VALUES(103,'2018_07_03_091314_create_session_table',1);
INSERT INTO migrations VALUES(104,'2018_07_03_091314_create_slas_table',1);
INSERT INTO migrations VALUES(105,'2018_07_03_091314_create_state_indexes_table',1);
INSERT INTO migrations VALUES(106,'2018_07_03_091314_create_state_translations_table',1);
INSERT INTO migrations VALUES(107,'2018_07_03_091314_create_storage_table',1);
INSERT INTO migrations VALUES(108,'2018_07_03_091314_create_stp_table',1);
INSERT INTO migrations VALUES(109,'2018_07_03_091314_create_syslog_table',1);
INSERT INTO migrations VALUES(110,'2018_07_03_091314_create_tnmsneinfo_table',1);
INSERT INTO migrations VALUES(111,'2018_07_03_091314_create_toner_table',1);
INSERT INTO migrations VALUES(112,'2018_07_03_091314_create_transport_group_transport_table',1);
INSERT INTO migrations VALUES(113,'2018_07_03_091314_create_ucd_diskio_table',1);
INSERT INTO migrations VALUES(114,'2018_07_03_091314_create_users_prefs_table',1);
INSERT INTO migrations VALUES(115,'2018_07_03_091314_create_users_table',1);
INSERT INTO migrations VALUES(116,'2018_07_03_091314_create_users_widgets_table',1);
INSERT INTO migrations VALUES(117,'2018_07_03_091314_create_vlans_table',1);
INSERT INTO migrations VALUES(118,'2018_07_03_091314_create_vminfo_table',1);
INSERT INTO migrations VALUES(119,'2018_07_03_091314_create_vrf_lite_cisco_table',1);
INSERT INTO migrations VALUES(120,'2018_07_03_091314_create_vrfs_table',1);
INSERT INTO migrations VALUES(121,'2018_07_03_091314_create_widgets_table',1);
INSERT INTO migrations VALUES(122,'2018_07_03_091314_create_wireless_sensors_table',1);
INSERT INTO migrations VALUES(123,'2018_07_03_091322_add_foreign_keys_to_component_prefs_table',1);
INSERT INTO migrations VALUES(124,'2018_07_03_091322_add_foreign_keys_to_component_statuslog_table',1);
INSERT INTO migrations VALUES(125,'2018_07_03_091322_add_foreign_keys_to_device_group_device_table',1);
INSERT INTO migrations VALUES(126,'2018_07_03_091322_add_foreign_keys_to_device_relationships_table',1);
INSERT INTO migrations VALUES(127,'2018_07_03_091322_add_foreign_keys_to_sensors_table',1);
INSERT INTO migrations VALUES(128,'2018_07_03_091322_add_foreign_keys_to_sensors_to_state_indexes_table',1);
INSERT INTO migrations VALUES(129,'2018_07_03_091322_add_foreign_keys_to_wireless_sensors_table',1);
INSERT INTO migrations VALUES(130,'2019_01_16_132200_add_vlan_and_elapsed_to_nac',1);
INSERT INTO migrations VALUES(131,'2019_01_16_195644_add_vrf_id_and_bgpLocalAs',1);
INSERT INTO migrations VALUES(132,'2019_02_05_140857_remove_config_definition_from_db',1);
INSERT INTO migrations VALUES(133,'2019_02_10_220000_add_dates_to_fdb',1);
INSERT INTO migrations VALUES(134,'2019_04_22_220000_update_route_table',1);
INSERT INTO migrations VALUES(135,'2019_05_12_202407_create_mpls_lsps_table',1);
INSERT INTO migrations VALUES(136,'2019_05_12_202408_create_mpls_lsp_paths_table',1);
INSERT INTO migrations VALUES(137,'2019_05_30_225937_device_groups_rewrite',1);
INSERT INTO migrations VALUES(138,'2019_06_30_190400_create_mpls_sdps_table',1);
INSERT INTO migrations VALUES(139,'2019_06_30_190401_create_mpls_sdp_binds_table',1);
INSERT INTO migrations VALUES(140,'2019_06_30_190402_create_mpls_services_table',1);
INSERT INTO migrations VALUES(141,'2019_07_03_132417_create_mpls_saps_table',1);
INSERT INTO migrations VALUES(142,'2019_07_09_150217_update_users_widgets_settings',1);
INSERT INTO migrations VALUES(143,'2019_08_10_223200_add_enabled_to_users',1);
INSERT INTO migrations VALUES(144,'2019_08_28_105051_fix-template-linefeeds',1);
INSERT INTO migrations VALUES(145,'2019_09_05_153524_create_notifications_attribs_index',1);
INSERT INTO migrations VALUES(146,'2019_09_29_114433_change_default_mempool_perc_warn_in_mempools_table',1);
INSERT INTO migrations VALUES(147,'2019_10_03_211702_serialize_config',1);
INSERT INTO migrations VALUES(148,'2019_10_21_105350_devices_group_perms',1);
INSERT INTO migrations VALUES(149,'2019_11_30_191013_create_mpls_tunnel_ar_hops_table',1);
INSERT INTO migrations VALUES(150,'2019_11_30_191013_create_mpls_tunnel_c_hops_table',1);
INSERT INTO migrations VALUES(151,'2019_12_01_165514_add_indexes_to_mpls_lsp_paths_table',1);
INSERT INTO migrations VALUES(152,'2019_12_05_164700_alerts_disable_on_update_current_timestamp',1);
INSERT INTO migrations VALUES(153,'2019_12_16_140000_create_customoids_table',1);
INSERT INTO migrations VALUES(154,'2019_12_17_151314_add_invert_map_to_alert_rules',1);
INSERT INTO migrations VALUES(155,'2019_12_28_180000_add_overwrite_ip_to_devices',1);
INSERT INTO migrations VALUES(156,'2020_01_09_1300_migrate_devices_attribs_table',1);
INSERT INTO migrations VALUES(157,'2020_01_10_075852_alter_mpls_lsp_paths_table',1);
INSERT INTO migrations VALUES(158,'2020_02_05_093457_add_inserted_to_devices',1);
INSERT INTO migrations VALUES(159,'2020_02_05_224042_device_inserted_null',1);
INSERT INTO migrations VALUES(160,'2020_02_10_223323_create_alert_location_map_table',1);
INSERT INTO migrations VALUES(161,'2020_03_24_0844_add_primary_key_to_device_graphs',1);
INSERT INTO migrations VALUES(162,'2020_03_25_165300_add_column_to_ports',1);
INSERT INTO migrations VALUES(163,'2020_04_06_001048_the_great_index_rename',1);
INSERT INTO migrations VALUES(164,'2020_04_08_172357_alert_schedule_utc',1);
INSERT INTO migrations VALUES(165,'2020_04_13_150500_add_last_error_fields_to_bgp_peers',1);
INSERT INTO migrations VALUES(166,'2020_04_19_010532_eventlog_sensor_reference_cleanup',1);
INSERT INTO migrations VALUES(167,'2020_05_22_020303_alter_metric_column',1);
INSERT INTO migrations VALUES(168,'2020_05_24_212054_poller_cluster_settings',1);
INSERT INTO migrations VALUES(169,'2020_05_30_162638_remove_mib_polling_tables',1);
INSERT INTO migrations VALUES(170,'2020_06_06_222222_create_device_outages_table',1);
INSERT INTO migrations VALUES(171,'2020_06_23_00522_alter_availability_perc_column',1);
INSERT INTO migrations VALUES(172,'2020_06_24_155119_drop_ports_if_high_speed',1);
INSERT INTO migrations VALUES(173,'2020_07_27_00522_alter_devices_snmp_algo_columns',1);
INSERT INTO migrations VALUES(174,'2020_07_29_143221_add_device_perf_index',1);
INSERT INTO migrations VALUES(175,'2020_08_28_212054_drop_uptime_column_outages',1);
INSERT INTO migrations VALUES(176,'2020_09_18_223431_create_cache_table',1);
INSERT INTO migrations VALUES(177,'2020_09_18_230114_create_service_templates_device_group_table',1);
INSERT INTO migrations VALUES(178,'2020_09_18_230114_create_service_templates_device_table',1);
INSERT INTO migrations VALUES(179,'2020_09_18_230114_create_service_templates_table',1);
INSERT INTO migrations VALUES(180,'2020_09_18_230114_extend_services_table_for_service_templates_table',1);
INSERT INTO migrations VALUES(181,'2020_09_19_230114_add_foreign_keys_to_service_templates_device_group_table',1);
INSERT INTO migrations VALUES(182,'2020_09_19_230114_add_foreign_keys_to_service_templates_device_table',1);
INSERT INTO migrations VALUES(183,'2020_09_22_172321_add_alert_log_index',1);
INSERT INTO migrations VALUES(184,'2020_09_24_000500_create_cache_locks_table',1);
INSERT INTO migrations VALUES(185,'2020_10_03_1000_add_primary_key_bill_perms',1);
INSERT INTO migrations VALUES(186,'2020_10_03_1000_add_primary_key_bill_ports',1);
INSERT INTO migrations VALUES(187,'2020_10_03_1000_add_primary_key_devices_perms',1);
INSERT INTO migrations VALUES(188,'2020_10_03_1000_add_primary_key_entPhysical_state',1);
INSERT INTO migrations VALUES(189,'2020_10_03_1000_add_primary_key_ipv4_mac',1);
INSERT INTO migrations VALUES(190,'2020_10_03_1000_add_primary_key_juniAtmVp',1);
INSERT INTO migrations VALUES(191,'2020_10_03_1000_add_primary_key_loadbalancer_vservers',1);
INSERT INTO migrations VALUES(192,'2020_10_03_1000_add_primary_key_ports_perms',1);
INSERT INTO migrations VALUES(193,'2020_10_03_1000_add_primary_key_processes',1);
INSERT INTO migrations VALUES(194,'2020_10_03_1000_add_primary_key_transport_group_transport',1);
INSERT INTO migrations VALUES(195,'2020_10_12_095504_mempools_add_oids',1);
INSERT INTO migrations VALUES(196,'2020_10_21_124101_allow_nullable_ospf_columns',1);
INSERT INTO migrations VALUES(197,'2020_10_30_093601_add_tos_to_ospf_ports',1);
INSERT INTO migrations VALUES(198,'2020_11_02_164331_add_powerstate_enum_to_vminfo',1);
INSERT INTO migrations VALUES(199,'2020_12_14_091314_create_port_group_port_table',1);
INSERT INTO migrations VALUES(200,'2020_12_14_091314_create_port_groups_table',1);
INSERT INTO migrations VALUES(201,'2021_02_08_224355_fix_invalid_dates',1);
INSERT INTO migrations VALUES(202,'2021_02_09_084318_remove_perf_times',1);
INSERT INTO migrations VALUES(203,'2021_02_09_122930_migrate_to_utf8mb4',1);
INSERT INTO migrations VALUES(204,'2021_02_21_203415_location_add_fixed_coordinates_flag',1);
INSERT INTO migrations VALUES(205,'2021_03_11_003540_rename_toner_table',1);
INSERT INTO migrations VALUES(206,'2021_03_11_003713_rename_printer_columns',1);
INSERT INTO migrations VALUES(207,'2021_03_17_160729_service_templates_cleanup',1);
INSERT INTO migrations VALUES(208,'2021_03_26_014054_change_cache_to_mediumtext',1);
INSERT INTO migrations VALUES(209,'2021_04_08_151101_add_foreign_keys_to_port_group_port_table',1);
INSERT INTO migrations VALUES(210,'2021_06_07_123600_create_sessions_table',1);
INSERT INTO migrations VALUES(211,'2021_06_11_084830_slas_add_rtt_field',1);
INSERT INTO migrations VALUES(212,'2021_07_06_1845_alter_bill_history_max_min',1);
INSERT INTO migrations VALUES(213,'2021_07_28_102443_plugins_add_version_and_settings',1);
INSERT INTO migrations VALUES(214,'2021_08_04_102914_add_syslog_indexes',1);
INSERT INTO migrations VALUES(215,'2021_08_26_093522_config_value_to_medium_text',1);
INSERT INTO migrations VALUES(216,'2021_09_07_094310_create_push_subscriptions_table',1);
INSERT INTO migrations VALUES(217,'2021_09_26_164200_create_hrsystem_table',1);
INSERT INTO migrations VALUES(218,'2021_10_02_190310_add_device_outages_index',1);
INSERT INTO migrations VALUES(219,'2021_10_03_164200_update_hrsystem_table',1);
INSERT INTO migrations VALUES(220,'2021_10_20_072929_disable_example_plugin',1);
INSERT INTO migrations VALUES(221,'2021_10_20_224207_increase_length_of_attrib_type_column',1);
INSERT INTO migrations VALUES(222,'2021_11_12_123037_change_cpwVcID_to_unsignedInteger',1);
INSERT INTO migrations VALUES(223,'2021_11_17_105321_device_add_display_field',1);
INSERT INTO migrations VALUES(224,'2021_11_29_160744_change_ports_text_fields_to_varchar',1);
INSERT INTO migrations VALUES(225,'2021_11_29_165046_improve_devices_search_index',1);
INSERT INTO migrations VALUES(226,'2021_11_29_165436_improve_ports_search_index',1);
INSERT INTO migrations VALUES(227,'2021_12_02_100709_remove_ports_stp_unique_index',1);
INSERT INTO migrations VALUES(228,'2021_12_02_101739_add_vlan_field_to_stp_table',1);
INSERT INTO migrations VALUES(229,'2021_12_02_101810_add_vlan_and_port_index_fields_to_ports_stp_table',1);
INSERT INTO migrations VALUES(230,'2021_12_02_110154_update_ports_stp_unique_index',1);
INSERT INTO migrations VALUES(231,'2021_12_02_113537_ports_stp_designated_cost_change_to_int',1);
INSERT INTO migrations VALUES(232,'2021_25_01_0127_create_isis_adjacencies_table',1);
INSERT INTO migrations VALUES(233,'2021_25_01_0128_isis_adjacencies_add_admin_status',1);
INSERT INTO migrations VALUES(234,'2021_25_01_0129_isis_adjacencies_nullable',1);
INSERT INTO migrations VALUES(235,'2022_02_03_164059_increase_auth_id_length',1);
INSERT INTO migrations VALUES(236,'2022_02_21_073500_add_iface_field_to_bgp_peers',1);
INSERT INTO migrations VALUES(237,'2022_04_08_085504_isis_adjacencies_table_add_index',1);
INSERT INTO migrations VALUES(238,'2022_05_25_084506_add_widgets_column_to_users_widgets_table',1);
INSERT INTO migrations VALUES(239,'2022_05_25_084617_migrate_widget_ids',1);
INSERT INTO migrations VALUES(240,'2022_05_25_085715_remove_user_widgets_id',1);
INSERT INTO migrations VALUES(241,'2022_05_25_090027_drop_widgets_table',1);
INSERT INTO migrations VALUES(242,'2022_05_30_084932_update-app-status-length',1);
INSERT INTO migrations VALUES(243,'2022_07_03_1947_add_app_data',1);
INSERT INTO migrations VALUES(244,'2022_07_19_081224_plugins_unique_index',1);
INSERT INTO migrations VALUES(245,'2022_08_15_084506_add_rrd_type_to_sensors_table',1);
INSERT INTO migrations VALUES(246,'2022_08_15_084507_add_rrd_type_to_wireless_sensors_table',1);
INSERT INTO migrations VALUES(247,'2022_08_15_091314_create_ports_vdsl_table',1);
INSERT INTO migrations VALUES(248,'2022_09_03_091314_update_ports_adsl_table_with_defaults',1);
INSERT INTO migrations VALUES(249,'2023_03_14_130653_migrate_empty_user_funcs_to_null',1);
INSERT INTO migrations VALUES(250,'2023_04_12_174529_modify_ports_table',1);
INSERT INTO migrations VALUES(251,'2023_04_26_185850_change_vminfo_vmw_vm_guest_o_s_nullable',1);
INSERT INTO migrations VALUES(252,'2023_04_27_164904_update_slas_opstatus_tinyint',1);
INSERT INTO migrations VALUES(253,'2023_05_12_071412_devices_expand_timetaken_doubles',1);
INSERT INTO migrations VALUES(254,'2023_06_02_230406_create_vendor_oui_table',1);
INSERT INTO migrations VALUES(255,'2023_06_18_195618_create_bouncer_tables',1);
INSERT INTO migrations VALUES(256,'2023_06_18_201914_migrate_level_to_roles',1);
INSERT INTO migrations VALUES(257,'2023_08_02_090027_drop_dbschema_table',1);
INSERT INTO migrations VALUES(258,'2023_08_02_120455_vendor_ouis_unique_index',1);
INSERT INTO migrations VALUES(259,'2023_08_30_105156_add_applications_soft_deleted',1);
INSERT INTO migrations VALUES(260,'2023_09_01_084057_application_new_defaults',1);
INSERT INTO migrations VALUES(261,'2023_10_07_170735_increase_processes_cputime_length',1);
INSERT INTO migrations VALUES(262,'2023_10_07_231037_application_metrics_add_primary_key',1);
INSERT INTO migrations VALUES(263,'2023_10_12_183306_ports_statistics_table_unsigned_stats',1);
INSERT INTO migrations VALUES(264,'2023_10_12_184311_bgp_peers_cbgp_table_unsigned_stats',1);
INSERT INTO migrations VALUES(265,'2023_10_12_184652_bgp_peers_table_unsigned_stats',1);
INSERT INTO migrations VALUES(266,'2023_10_14_162039_restore_ports_delta_fields',1);
INSERT INTO migrations VALUES(267,'2023_10_14_162234_restore_bgp_peers_cbgp_delta_fields',1);
INSERT INTO migrations VALUES(268,'2023_10_20_075853_cisco_asa_add_default_limits',1);
INSERT INTO migrations VALUES(269,'2023_10_31_074547_ospf_areas_unsigned',1);
INSERT INTO migrations VALUES(270,'2023_10_31_074901_ospf_instances_unsigned',1);
INSERT INTO migrations VALUES(271,'2023_10_31_075239_ospf_nbrs_unsigned',1);
INSERT INTO migrations VALUES(272,'2023_10_31_080052_ospf_ports_unsigned',1);
INSERT INTO migrations VALUES(273,'2023_11_04_125846_packages_increase_name_column_length',1);
INSERT INTO migrations VALUES(274,'2023_11_21_172239_increase_vminfo.vmwvmguestos_column_length',1);
INSERT INTO migrations VALUES(275,'2023_12_08_080319_create_custom_map_table',1);
INSERT INTO migrations VALUES(276,'2023_12_08_081420_create_custom_map_node_table',1);
INSERT INTO migrations VALUES(277,'2023_12_08_082518_create_custom_map_edge_table',1);
INSERT INTO migrations VALUES(278,'2023_12_08_083319_create_custom_map_background_table',1);
INSERT INTO migrations VALUES(279,'2023_12_08_184652_mpls_addrtype_fix',1);
INSERT INTO migrations VALUES(280,'2023_12_10_130000_historical_data_to_ports_nac',1);
INSERT INTO migrations VALUES(281,'2023_12_12_171400_alert_rule_note',1);
INSERT INTO migrations VALUES(282,'2023_12_15_105529_access_points_nummonbssid_integer',1);
INSERT INTO migrations VALUES(283,'2023_12_19_082112_custom_map_grid_snap',1);
INSERT INTO migrations VALUES(284,'2024_01_04_195618_add_ignore_status_to_devices_tables',1);
INSERT INTO migrations VALUES(285,'2024_01_08_223812_custom_map_node_image',1);
INSERT INTO migrations VALUES(286,'2024_01_09_211518_custom_map_node_maplink',1);
INSERT INTO migrations VALUES(287,'2024_01_09_223917_bill_data_new_primary',1);
INSERT INTO migrations VALUES(288,'2024_01_09_223927_bill_data_updated_indexes',1);
INSERT INTO migrations VALUES(289,'2024_02_03_201014_custom_map_edge_additions',1);
INSERT INTO migrations VALUES(290,'2024_02_07_151845_custom_map_additions',1);
INSERT INTO migrations VALUES(291,'2024_04_10_093513_remove_device_perf',1);
INSERT INTO migrations VALUES(292,'2024_04_22_161711_custom_maps_add_group',1);
INSERT INTO migrations VALUES(293,'2024_04_29_180911_custom_maps_add_background_type_and_background_data',1);
INSERT INTO migrations VALUES(294,'2024_04_29_183605_custom_maps_drop_background_suffix_and_background_version',1);
INSERT INTO migrations VALUES(295,'2024_07_13_133839_modify_ent_physical_defaults',1);
INSERT INTO migrations VALUES(296,'2024_07_19_120719_update_ports_stack_table',1);
