%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "/lilypond-2.24.4/input/regression/other/syntax-function-docstring.ly"
\sourcefileline 0
\version "2.23.8"

\header {
  texidoc = "Syntax functions' docstrings are preserved (mainly for the sake
of doc autogeneration)."
}

funOne =
#(define-music-function (m) (ly:music?)
   "Docstring"
   m)

funTwo =
#(define-music-function (m) (ly:music?)
   ;; no docstring
   m)

funThree =
#(define-music-function (m) (ly:music?)
   ;; docstring marked translatable should be kept
   (_i "Docstring")
   m)

funFour =
#(define-scheme-function (m) (ly:music?)
   ;; This is not a docstring but the expression that the function returns.
   (_i "String"))

#(for-each
  (lambda (fun)
    (ly:message "Found docstring: ~s" (procedure-documentation (ly:music-function-extract fun))))
  (list funOne funTwo funThree funFour))

#(when (not (equal? "String" (funFour #{ #})))
   (ly:error "failed test syntax-function-docstring.ly"))



% ****************************************************************
% end ly snippet
% ****************************************************************
