/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import liquibase.change.AbstractChange;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.logging.LogFactory;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.resource.ResourceAccessor;
import liquibase.sql.Sql;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CommentStatement;
import liquibase.statement.core.RuntimeStatement;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;

@DatabaseChange(name="executeCommand", description="Executes a system command. Because this refactoring doesn't generate SQL like most, using LiquiBase commands such as migrateSQL may not work as expected. Therefore, if at all possible use refactorings that generate SQL.", priority=1)
public class ExecuteShellCommandChange
extends AbstractChange {
    private String executable;
    private List<String> os;
    private List<String> args = new ArrayList<String>();
    protected List<String> finalCommandArray;

    @Override
    public boolean generateStatementsVolatile(Database database) {
        return true;
    }

    @Override
    public boolean generateRollbackStatementsVolatile(Database database) {
        return true;
    }

    @DatabaseChangeProperty(description="Name of the executable to run", exampleValue="mysqldump", requiredForDatabase={"all"})
    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public void addArg(String arg) {
        this.args.add(arg);
    }

    public List<String> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    public void setOs(String os) {
        this.os = StringUtils.splitAndTrim(os, ",");
    }

    @DatabaseChangeProperty(description="List of operating systems on which to execute the command (taken from the os.name Java system property)", exampleValue="Windows 7")
    public List<String> getOs() {
        return this.os;
    }

    @Override
    public ValidationErrors validate(Database database) {
        return new ValidationErrors();
    }

    @Override
    public Warnings warn(Database database) {
        return new Warnings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqlStatement[] generateStatements(Database database) {
        String currentOS;
        boolean shouldRun = true;
        if (this.os != null && this.os.size() > 0 && !this.os.contains(currentOS = System.getProperty("os.name"))) {
            shouldRun = false;
            LogFactory.getLogger().info("Not executing on os " + currentOS + " when " + this.os + " was specified");
        }
        boolean nonExecutedMode = false;
        Executor executor = ExecutorService.getInstance().getExecutor(database);
        if (executor instanceof LoggingExecutor) {
            nonExecutedMode = true;
        }
        this.finalCommandArray = this.createFinalCommandArray(database);
        if (shouldRun && !nonExecutedMode) {
            return new SqlStatement[]{new RuntimeStatement(){

                @Override
                public Sql[] generate(Database database) {
                    try {
                        ExecuteShellCommandChange.this.executeCommand(database);
                    }
                    catch (Exception e) {
                        throw new UnexpectedLiquibaseException("Error executing command: " + e.getLocalizedMessage(), e);
                    }
                    return null;
                }
            }};
        }
        if (nonExecutedMode) {
            try {
                SqlStatement[] sqlStatementArray = new SqlStatement[]{new CommentStatement(this.getCommandString())};
                return sqlStatementArray;
            }
            finally {
                this.nonExecutedCleanup();
            }
        }
        return new SqlStatement[0];
    }

    protected void nonExecutedCleanup() {
    }

    protected List<String> createFinalCommandArray(Database database) {
        ArrayList<String> commandArray = new ArrayList<String>();
        commandArray.add(this.getExecutable());
        commandArray.addAll(this.getArgs());
        return commandArray;
    }

    protected void executeCommand(Database database) throws Exception {
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        ByteArrayOutputStream inputStream = new ByteArrayOutputStream();
        ProcessBuilder pb = this.createProcessBuilder(database);
        Process p = pb.start();
        int returnCode = 0;
        try {
            StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), errorStream);
            StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), inputStream);
            errorGobbler.start();
            outputGobbler.start();
            returnCode = p.waitFor();
            errorGobbler.finish();
            outputGobbler.finish();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        LogFactory.getLogger().severe(errorStream.toString());
        LogFactory.getLogger().info(inputStream.toString());
        if (returnCode != 0) {
            throw new RuntimeException(this.getCommandString() + " returned an code of " + returnCode);
        }
    }

    protected ProcessBuilder createProcessBuilder(Database database) {
        ProcessBuilder pb = new ProcessBuilder(this.finalCommandArray);
        pb.redirectErrorStream(true);
        return pb;
    }

    @Override
    public String getConfirmationMessage() {
        return "Shell command '" + this.getCommandString() + "' executed";
    }

    protected String getCommandString() {
        return this.getExecutable() + " " + StringUtils.join(this.args, " ");
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }

    @Override
    protected void customLoadLogic(ParsedNode parsedNode, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        ParsedNode argsNode = parsedNode.getChild(null, "args");
        if (argsNode == null) {
            argsNode = parsedNode;
        }
        for (ParsedNode arg : argsNode.getChildren(null, "arg")) {
            this.addArg(arg.getChildValue((String)null, "value", String.class));
        }
        String passedValue = StringUtils.trimToNull(parsedNode.getChildValue((String)null, "os", String.class));
        if (passedValue == null) {
            this.os = new ArrayList<String>();
        } else {
            List<String> os = StringUtils.splitAndTrim(StringUtils.trimToEmpty(parsedNode.getChildValue((String)null, "os", String.class)), ",");
            if (os.size() == 1 && os.get(0).equals("")) {
                this.os = null;
            } else if (os.size() > 0) {
                this.os = os;
            }
        }
    }

    @Override
    public String toString() {
        return "external process '" + this.getExecutable() + "' " + this.getArgs();
    }

    private class StreamGobbler
    extends Thread {
        private final OutputStream outputStream;
        private InputStream processStream;

        private StreamGobbler(InputStream processStream, ByteArrayOutputStream outputStream) {
            this.processStream = processStream;
            this.outputStream = outputStream;
        }

        @Override
        public void run() {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.processStream);
                while (this.processStream != null) {
                    if (bufferedInputStream.available() > 0) {
                        StreamUtil.copy(bufferedInputStream, this.outputStream);
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        public void finish() {
            InputStream processStream = this.processStream;
            this.processStream = null;
            try {
                StreamUtil.copy(processStream, this.outputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

