/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.SimpleStepExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyChildNodeTest;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.SchemaNodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInListType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSet;

public final class AxisExpression
extends Expression {
    private byte axis;
    private NodeTest test;
    private ItemType itemType = null;
    private ContextItemStaticInfo staticInfo = ContextItemStaticInfo.DEFAULT;
    private int computedCardinality = -1;
    private boolean doneWarnings = false;

    public AxisExpression(byte axis, NodeTest nodeTest) {
        this.axis = axis;
        this.test = nodeTest;
    }

    public void setAxis(byte axis) {
        this.axis = axis;
    }

    public String getExpressionName() {
        return "axisStep";
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        Expression e2 = super.simplify(visitor);
        if (e2 != this) {
            return e2;
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        boolean skipChecks;
        boolean bl = skipChecks = this.doneWarnings && this.staticInfo.getItemType().equals(contextInfo.getItemType());
        if (contextInfo.getItemType() == ErrorType.getInstance()) {
            XPathException err = new XPathException("Axis step " + this.toString() + " cannot be used here: the context item is absent");
            err.setIsTypeError(true);
            err.setErrorCode("XPDY0002");
            err.setLocator(this);
            throw err;
        }
        this.staticInfo = contextInfo;
        Configuration config = visitor.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        int relation = th.relationship(contextInfo.getItemType(), AnyNodeTest.getInstance());
        if (relation == 4) {
            XPathException err = new XPathException("Axis step " + this.toString() + " cannot be used here: the context item is not a node");
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0020");
            err.setLocator(this);
            throw err;
        }
        if (relation == 3 || relation == 1) {
            ContextItemExpression exp = new ContextItemExpression();
            ExpressionTool.copyLocationInfo(this, exp);
            RoleLocator role = new RoleLocator(14, AxisInfo.axisName[this.axis], 0);
            role.setErrorCode("XPTY0020");
            ItemChecker checker = new ItemChecker(exp, AnyNodeTest.getInstance(), role);
            ExpressionTool.copyLocationInfo(this, checker);
            SimpleStepExpression step = new SimpleStepExpression(checker, this);
            ExpressionTool.copyLocationInfo(this, step);
            return step;
        }
        StaticContext env = visitor.getStaticContext();
        if (skipChecks) {
            return this;
        }
        this.doneWarnings = true;
        ItemType contextType = contextInfo.getItemType();
        if (contextType instanceof NodeTest) {
            int origin = contextType.getPrimitiveType();
            if (origin != 0 && AxisInfo.isAlwaysEmpty(this.axis, origin)) {
                visitor.issueWarning("The " + AxisInfo.axisName[this.axis] + " axis starting at " + (origin == 1 || origin == 2 ? "an " : "a ") + NodeKindTest.nodeKindName(origin) + " node will never select anything", this);
                return Literal.makeEmptySequence(this.getContainer());
            }
            if (this.test != null) {
                SchemaType ct;
                SchemaType contentType;
                IntSet selectedElementNames;
                NodeTest elementTest;
                IntSet outermostElementNames;
                int kind = this.test.getPrimitiveType();
                if (kind != 0 && !AxisInfo.containsNodeKind(this.axis, kind)) {
                    visitor.issueWarning("The " + AxisInfo.axisName[this.axis] + " axis will never select any " + NodeKindTest.nodeKindName(kind) + " nodes", this);
                    return Literal.makeEmptySequence(this.getContainer());
                }
                if (this.axis == 12 && kind != 0 && origin != 0 && kind != origin) {
                    visitor.issueWarning("The self axis will never select any " + NodeKindTest.nodeKindName(kind) + " nodes when starting at " + (origin == 1 || origin == 2 ? "an " : "a ") + NodeKindTest.nodeKindName(origin) + " node", this);
                    return Literal.makeEmptySequence(this.getContainer());
                }
                if (this.axis == 12) {
                    this.itemType = new CombinedNodeTest(this.test, 23, (NodeTest)contextType);
                }
                if (contextType instanceof DocumentNodeTest && kind == 1 && (outermostElementNames = (elementTest = ((DocumentNodeTest)contextType).getElementTest()).getRequiredNodeNames()) != null && (selectedElementNames = this.test.getRequiredNodeNames()) != null) {
                    if (this.axis == 3) {
                        if (selectedElementNames.intersect(outermostElementNames).isEmpty()) {
                            visitor.issueWarning("Starting at a document node, the step is selecting an element whose name is not among the names of child elements permitted for this document node type", this);
                            return Literal.makeEmptySequence(this.getContainer());
                        }
                        if (env.isSchemaAware() && elementTest instanceof SchemaNodeTest && outermostElementNames.size() == 1) {
                            IntIterator oeni = outermostElementNames.iterator();
                            int outermostElementName = oeni.hasNext() ? oeni.next() : -1;
                            SchemaDeclaration decl = config.getElementDeclaration(outermostElementName);
                            if (decl == null) {
                                visitor.issueWarning("Element " + config.getNamePool().getDisplayName(outermostElementName) + " is not declared in the schema", this);
                                this.itemType = elementTest;
                            } else {
                                SchemaType contentType2 = decl.getType();
                                this.itemType = new CombinedNodeTest(elementTest, 23, new ContentTypeTest(1, contentType2, config, true));
                            }
                        } else {
                            this.itemType = elementTest;
                        }
                        return this;
                    }
                    if (this.axis == 4) {
                        boolean canMatchOutermost;
                        boolean bl2 = canMatchOutermost = !selectedElementNames.intersect(outermostElementNames).isEmpty();
                        if (!canMatchOutermost) {
                            Expression path = ExpressionTool.makePathExpression(new AxisExpression(3, elementTest), new AxisExpression(4, this.test), false);
                            ExpressionTool.copyLocationInfo(this, path);
                            return path.typeCheck(visitor, contextInfo);
                        }
                    }
                }
                if ((contentType = ((NodeTest)contextType).getContentType()) == AnyType.getInstance()) {
                    return this;
                }
                if (!env.isSchemaAware() && (ct = this.test.getContentType()) != AnyType.getInstance() && ct != Untyped.getInstance() && ct != AnySimpleType.getInstance() && ct != BuiltInAtomicType.ANY_ATOMIC && ct != BuiltInAtomicType.UNTYPED_ATOMIC && ct != BuiltInAtomicType.STRING) {
                    visitor.issueWarning("The " + AxisInfo.axisName[this.axis] + " axis will never select any typed nodes, " + "because the expression is being compiled in an environment that is not schema-aware", this);
                    return Literal.makeEmptySequence(this.getContainer());
                }
                int targetfp = this.test.getFingerprint();
                if (contentType.isSimpleType()) {
                    if (!(this.axis != 3 && this.axis != 4 && this.axis != 5 || kind != 1 && kind != 2 && kind != 9)) {
                        visitor.issueWarning("The " + AxisInfo.axisName[this.axis] + " axis will never select any " + NodeKindTest.nodeKindName(kind) + " nodes when starting at " + (origin == 2 ? "an attribute node" : AxisExpression.getStartingNodeDescription(contentType)), this);
                    } else if (this.axis == 3 && kind == 3 && visitor.getParentExpression() instanceof Atomizer) {
                        visitor.issueWarning("Selecting the text nodes of an element with simple content may give the wrong answer in the presence of comments or processing instructions. It is usually better to omit the '/text()' step", this);
                    } else if (this.axis == 2) {
                        Iterator<? extends SchemaType> extensions = config.getExtensionsOfType(contentType);
                        boolean found = false;
                        if (targetfp == -1) {
                            while (extensions.hasNext()) {
                                ComplexType extension = (ComplexType)extensions.next();
                                if (!extension.allowsAttributes()) continue;
                                found = true;
                                break;
                            }
                        } else {
                            while (extensions.hasNext()) {
                                ComplexType extension = (ComplexType)extensions.next();
                                try {
                                    if (extension.getAttributeUseType(targetfp) == null) continue;
                                    found = true;
                                    break;
                                }
                                catch (SchemaException e) {
                                }
                            }
                        }
                        if (!found) {
                            visitor.issueWarning("The " + AxisInfo.axisName[this.axis] + " axis will never select " + (targetfp == -1 ? "any attribute nodes" : "an attribute node named " + AxisExpression.getDiagnosticName(targetfp, env)) + " when starting at " + AxisExpression.getStartingNodeDescription(contentType), this);
                        }
                    }
                } else {
                    if (!(!((ComplexType)contentType).isSimpleContent() || this.axis != 3 && this.axis != 4 && this.axis != 5 || kind != 1 && kind != 9)) {
                        visitor.issueWarning("The " + AxisInfo.axisName[this.axis] + " axis will never select any " + NodeKindTest.nodeKindName(kind) + " nodes when starting at " + AxisExpression.getStartingNodeDescription(contentType) + ", as this type requires simple content", this);
                        return Literal.makeEmptySequence(this.getContainer());
                    }
                    if (((ComplexType)contentType).isEmptyContent() && (this.axis == 3 || this.axis == 4 || this.axis == 5)) {
                        Iterator<? extends SchemaType> iter = config.getExtensionsOfType(contentType);
                        while (iter.hasNext()) {
                            ComplexType extension = (ComplexType)iter.next();
                            if (extension.isEmptyContent()) continue;
                            return this;
                        }
                        visitor.issueWarning("The " + AxisInfo.axisName[this.axis] + " axis will never select any" + " nodes when starting at " + AxisExpression.getStartingNodeDescription(contentType) + ", as this type requires empty content", this);
                        return Literal.makeEmptySequence(this.getContainer());
                    }
                    if (this.axis == 2) {
                        if (targetfp == -1) {
                            if (!((ComplexType)contentType).allowsAttributes()) {
                                visitor.issueWarning("The complex type " + contentType.getDescription() + " allows no attributes other than the standard attributes in the xsi namespace", this);
                            }
                        } else {
                            try {
                                SimpleType schemaType = targetfp == 641 ? BuiltInAtomicType.QNAME : (targetfp == 643 ? BuiltInListType.ANY_URIS : (targetfp == 644 ? BuiltInAtomicType.ANY_URI : (targetfp == 642 ? BuiltInAtomicType.BOOLEAN : ((ComplexType)contentType).getAttributeUseType(targetfp))));
                                if (schemaType == null) {
                                    visitor.issueWarning("The complex type " + contentType.getDescription() + " does not allow an attribute named " + AxisExpression.getDiagnosticName(targetfp, env), this);
                                    return Literal.makeEmptySequence(this.getContainer());
                                }
                                this.itemType = new CombinedNodeTest(this.test, 23, new ContentTypeTest(2, schemaType, config, false));
                            }
                            catch (SchemaException e) {}
                        }
                    } else if (this.axis == 3 && kind == 1) {
                        try {
                            SchemaType schemaType;
                            int childElement = targetfp;
                            if (targetfp == -1) {
                                if (((ComplexType)contentType).containsElementWildcard()) {
                                    return this;
                                }
                                IntHashSet children = new IntHashSet();
                                ((ComplexType)contentType).gatherAllPermittedChildren(children, false);
                                if (children.isEmpty()) {
                                    visitor.issueWarning("The complex type " + contentType.getDescription() + " does not allow children", this);
                                    return Literal.makeEmptySequence(this.getContainer());
                                }
                                if (children.size() == 1) {
                                    IntIterator iter = children.iterator();
                                    if (iter.hasNext()) {
                                        childElement = iter.next();
                                    }
                                } else {
                                    return this;
                                }
                            }
                            if ((schemaType = ((ComplexType)contentType).getElementParticleType(childElement, true)) == null) {
                                visitor.issueWarning("The complex type " + contentType.getDescription() + " does not allow a child element named " + AxisExpression.getDiagnosticName(childElement, env), this);
                                return Literal.makeEmptySequence(this.getContainer());
                            }
                            this.itemType = new CombinedNodeTest(this.test, 23, new ContentTypeTest(1, schemaType, visitor.getConfiguration(), true));
                            this.computedCardinality = ((ComplexType)contentType).getElementParticleCardinality(childElement, true);
                            visitor.resetStaticProperties();
                            if (this.computedCardinality == 8192) {
                                visitor.issueWarning("The complex type " + contentType.getDescription() + " appears not to allow a child element named " + AxisExpression.getDiagnosticName(childElement, env), this);
                                return Literal.makeEmptySequence(this.getContainer());
                            }
                            if (!Cardinality.allowsMany(this.computedCardinality)) {
                                return FirstItemExpression.makeFirstItemExpression(this);
                            }
                        }
                        catch (SchemaException e) {}
                    } else if (this.axis == 4 && kind == 1 && targetfp != -1) {
                        try {
                            IntHashSet descendants = new IntHashSet();
                            ((ComplexType)contentType).gatherAllPermittedDescendants(descendants);
                            if (descendants.contains(-1)) {
                                return this;
                            }
                            if (descendants.contains(targetfp)) {
                                SchemaType st;
                                IntHashSet children = new IntHashSet();
                                ((ComplexType)contentType).gatherAllPermittedChildren(children, false);
                                IntHashSet usefulChildren = new IntHashSet();
                                boolean considerSelf = false;
                                boolean considerDescendants = false;
                                IntIterator child = children.iterator();
                                while (child.hasNext()) {
                                    SchemaType st2;
                                    int c = child.next();
                                    if (c == targetfp) {
                                        usefulChildren.add(c);
                                        considerSelf = true;
                                    }
                                    if ((st2 = ((ComplexType)contentType).getElementParticleType(c, true)) == null) {
                                        throw new AssertionError((Object)("Can't find type for child element " + c));
                                    }
                                    if (!(st2 instanceof ComplexType)) continue;
                                    IntHashSet subDescendants = new IntHashSet();
                                    ((ComplexType)st2).gatherAllPermittedDescendants(subDescendants);
                                    if (!subDescendants.contains(targetfp)) continue;
                                    usefulChildren.add(c);
                                    considerDescendants = true;
                                }
                                this.itemType = this.test;
                                if (considerDescendants && (st = ((ComplexType)contentType).getDescendantElementType(targetfp)) != AnyType.getInstance()) {
                                    this.itemType = new CombinedNodeTest(this.test, 23, new ContentTypeTest(1, st, config, true));
                                }
                                if (usefulChildren.size() < children.size()) {
                                    NodeTest childTest = this.makeUnionNodeTest(usefulChildren, visitor.getConfiguration().getNamePool());
                                    AxisExpression first = new AxisExpression(3, childTest);
                                    ExpressionTool.copyLocationInfo(this, first);
                                    byte nextAxis = considerSelf ? (considerDescendants ? (byte)5 : 12) : (byte)4;
                                    AxisExpression next = new AxisExpression(nextAxis, (NodeTest)this.itemType);
                                    ExpressionTool.copyLocationInfo(this, next);
                                    Expression path = ExpressionTool.makePathExpression(first, next, false);
                                    ExpressionTool.copyLocationInfo(this, path);
                                    return path.typeCheck(visitor, contextInfo);
                                }
                            } else {
                                visitor.issueWarning("The complex type " + contentType.getDescription() + " does not allow a descendant element named " + AxisExpression.getDiagnosticName(targetfp, env), this);
                            }
                        }
                        catch (SchemaException e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                }
            }
        }
        return this;
    }

    private static String getDiagnosticName(int fp, StaticContext env) {
        NamePool pool = env.getNamePool();
        String uri = pool.getURI(fp);
        if (uri.equals("")) {
            return pool.getLocalName(fp);
        }
        NamespaceResolver resolver = env.getNamespaceResolver();
        Iterator<String> it = resolver.iteratePrefixes();
        while (it.hasNext()) {
            String prefix = it.next();
            if (!uri.equals(resolver.getURIForPrefix(prefix, true))) continue;
            if (prefix.length() == 0) {
                return "Q{" + uri + "}" + pool.getLocalName(fp);
            }
            return prefix + ":" + pool.getLocalName(fp);
        }
        return "Q{" + uri + "}" + pool.getLocalName(fp);
    }

    private static String getStartingNodeDescription(SchemaType type) {
        String s = type.getDescription();
        if (s.startsWith("of element")) {
            return "a valid element named" + s.substring("of element".length());
        }
        if (s.startsWith("of attribute")) {
            return "a valid attribute named" + s.substring("of attribute".length());
        }
        return "a node with " + (type.isSimpleType() ? "simple" : "complex") + " type " + s;
    }

    private NodeTest makeUnionNodeTest(IntHashSet elements, NamePool pool) {
        NodeTest test = null;
        IntIterator iter = elements.iterator();
        while (iter.hasNext()) {
            int fp = iter.next();
            NameTest nextTest = new NameTest(1, fp, pool);
            if (test == null) {
                test = nextTest;
                continue;
            }
            test = new CombinedNodeTest(test, 1, nextTest);
        }
        return test;
    }

    public ItemType getContextItemType() {
        return this.staticInfo.getItemType();
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) {
        this.staticInfo = contextInfo;
        return this;
    }

    public boolean equals(Object other) {
        if (!(other instanceof AxisExpression)) {
            return false;
        }
        if (this.axis != ((AxisExpression)other).axis) {
            return false;
        }
        if (this.test == null) {
            return ((AxisExpression)other).test == null;
        }
        return this.test.toString().equals(((AxisExpression)other).test.toString());
    }

    public int hashCode() {
        int h = 9375162 + this.axis << 20;
        if (this.test != null) {
            h ^= this.test.getPrimitiveType() << 16;
            h ^= this.test.getFingerprint();
        }
        return h;
    }

    public Expression copy() {
        AxisExpression a2 = new AxisExpression(this.axis, this.test);
        a2.itemType = this.itemType;
        a2.staticInfo = this.staticInfo;
        a2.computedCardinality = this.computedCardinality;
        a2.doneWarnings = this.doneWarnings;
        ExpressionTool.copyLocationInfo(this, a2);
        return a2;
    }

    public int computeSpecialProperties() {
        return 0xC10000 | (AxisInfo.isForwards[this.axis] ? 131072 : 262144) | (AxisInfo.isPeerAxis[this.axis] || AxisExpression.isPeerNodeTest(this.test) ? 524288 : 0) | (AxisInfo.isSubtreeAxis[this.axis] ? 0x100000 : 0) | (this.axis == 2 || this.axis == 8 ? 0x200000 : 0);
    }

    private static boolean isPeerNodeTest(NodeTest test) {
        if (test == null) {
            return false;
        }
        int mask = test.getNodeKindMask();
        if ((mask & 2) != 0) {
            return false;
        }
        if ((mask & 0x200) != 0) {
            return mask == 512;
        }
        return true;
    }

    public final ItemType getItemType() {
        if (this.itemType != null) {
            return this.itemType;
        }
        short p = AxisInfo.principalNodeType[this.axis];
        switch (p) {
            case 2: 
            case 13: {
                return NodeKindTest.makeNodeKindTest(p);
            }
        }
        if (this.test == null) {
            return AnyNodeTest.getInstance();
        }
        return this.test;
    }

    public int getIntrinsicDependencies() {
        return 2;
    }

    public final int computeCardinality() {
        NodeTest originNodeType;
        if (this.computedCardinality != -1) {
            return this.computedCardinality;
        }
        NodeTest nodeTest = this.test;
        ItemType contextItemType = this.staticInfo.getItemType();
        if (contextItemType instanceof NodeTest) {
            originNodeType = (NodeTest)contextItemType;
        } else if (contextItemType instanceof AnyItemType) {
            originNodeType = AnyNodeTest.getInstance();
        } else {
            return 57344;
        }
        if (this.axis == 2 && nodeTest instanceof NameTest) {
            SchemaType contentType = originNodeType.getContentType();
            if (contentType instanceof ComplexType) {
                try {
                    return ((ComplexType)contentType).getAttributeUseCardinality(nodeTest.getFingerprint());
                }
                catch (SchemaException err) {
                    return 24576;
                }
            }
            if (contentType instanceof SimpleType) {
                return 8192;
            }
            return 24576;
        }
        if (this.axis == 4 && nodeTest instanceof NameTest && nodeTest.getPrimitiveType() == 1) {
            SchemaType contentType = originNodeType.getContentType();
            if (contentType instanceof ComplexType) {
                try {
                    return ((ComplexType)contentType).getDescendantElementCardinality(nodeTest.getFingerprint());
                }
                catch (SchemaException err) {
                    return 57344;
                }
            }
            return 8192;
        }
        if (this.axis == 12) {
            return 24576;
        }
        return 57344;
    }

    public boolean isSubtreeExpression() {
        return AxisInfo.isSubtreeAxis[this.axis];
    }

    public byte getAxis() {
        return this.axis;
    }

    public NodeTest getNodeTest() {
        return this.test;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        if (pathMapNodeSet == null) {
            ContextItemExpression cie = new ContextItemExpression();
            cie.setContainer(this.getContainer());
            pathMapNodeSet = new PathMap.PathMapNodeSet(pathMap.makeNewRoot(cie));
        }
        return pathMapNodeSet.createArc(this.axis, this.test == null ? AnyNodeTest.getInstance() : this.test);
    }

    public boolean isContextPossiblyUndefined() {
        return this.staticInfo.isPossiblyAbsent();
    }

    public Pattern toPattern(Configuration config, boolean is30) throws XPathException {
        NodeTestPattern pat;
        NodeTest test = this.getNodeTest();
        if (test == null) {
            test = AnyNodeTest.getInstance();
        }
        if (test instanceof AnyNodeTest && (this.axis == 3 || this.axis == 4 || this.axis == 12)) {
            test = AnyChildNodeTest.getInstance();
        }
        int kind = test.getPrimitiveType();
        if (this.axis == 12) {
            pat = new NodeTestPattern(test);
        } else if (this.axis == 2) {
            pat = kind == 0 ? new NodeTestPattern(NodeKindTest.ATTRIBUTE) : (!AxisInfo.containsNodeKind(this.axis, kind) ? new NodeTestPattern(ErrorType.getInstance()) : new NodeTestPattern(test));
        } else if (this.axis == 3 || this.axis == 4 || this.axis == 5) {
            pat = kind != 0 && !AxisInfo.containsNodeKind(this.axis, kind) ? new NodeTestPattern(ErrorType.getInstance()) : new NodeTestPattern(test);
        } else if (this.axis == 8) {
            pat = kind == 0 ? new NodeTestPattern(NodeKindTest.NAMESPACE) : (!AxisInfo.containsNodeKind(this.axis, kind) ? new NodeTestPattern(ErrorType.getInstance()) : new NodeTestPattern(test));
        } else {
            throw new XPathException("Only downwards axes are allowed in a pattern", "XTSE0340");
        }
        pat.setPackageData(this.getContainer().getPackageData());
        return pat;
    }

    public AxisIterator iterate(XPathContext context) throws XPathException {
        Item item = context.getContextItem();
        if (item == null) {
            XPathException err = new XPathException("The context item for axis step " + this.toString() + " is absent");
            err.setErrorCode("XPDY0002");
            err.setXPathContext(context);
            err.setLocator(this);
            err.setIsTypeError(true);
            throw err;
        }
        try {
            if (this.test == null) {
                return ((NodeInfo)item).iterateAxis(this.axis);
            }
            return ((NodeInfo)item).iterateAxis(this.axis, this.test);
        }
        catch (ClassCastException cce) {
            XPathException err = new XPathException("The context item for axis step " + this.toString() + " is not a node");
            err.setErrorCode("XPTY0020");
            err.setXPathContext(context);
            err.setLocator(this);
            err.setIsTypeError(true);
            throw err;
        }
        catch (UnsupportedOperationException err) {
            if (err.getCause() instanceof XPathException) {
                XPathException ec = (XPathException)err.getCause();
                ec.maybeSetLocation(this);
                ec.maybeSetContext(context);
                throw ec;
            }
            this.dynamicError(err.getMessage(), "XPST0010", context);
            return null;
        }
    }

    public AxisIterator iterate(NodeInfo origin) {
        if (this.test == null) {
            return origin.iterateAxis(this.axis);
        }
        return origin.iterateAxis(this.axis, this.test);
    }

    public void explain(ExpressionPresenter destination) {
        destination.startElement("axis");
        destination.emitAttribute("name", AxisInfo.axisName[this.axis]);
        destination.emitAttribute("nodeTest", this.test == null ? "node()" : this.test.toString());
        destination.endElement();
    }

    public String toString() {
        FastStringBuffer fsb = new FastStringBuffer(16);
        fsb.append(AxisInfo.axisName[this.axis]);
        fsb.append("::");
        fsb.append(this.test == null ? "node()" : this.test.toString());
        return fsb.toString();
    }

    public String toShortString() {
        FastStringBuffer fsb = new FastStringBuffer(16);
        if (this.axis != 3) {
            if (this.axis == 2) {
                fsb.append("@");
            } else {
                fsb.append(AxisInfo.axisName[this.axis]);
                fsb.append("::");
            }
        }
        if (this.test == null) {
            fsb.append("node()");
        } else if (this.test instanceof NameTest) {
            fsb.append(((NameTest)this.test).getNodeName().getDisplayName());
        } else {
            fsb.append(this.test.toString());
        }
        return fsb.toString();
    }
}

