/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.StarNode;
import org.jruby.ast.visitor.NodeVisitor;

public class ArrayPatternNode
extends Node {
    private ListNode preArgs;
    private final Node restArg;
    private final ListNode postArgs;
    private Node constant;

    public ArrayPatternNode(int line, ListNode preArgs, Node restArg, ListNode postArgs) {
        super(line, false);
        this.preArgs = preArgs;
        this.restArg = restArg;
        this.postArgs = postArgs;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visitArrayPatternNode(this);
    }

    @Override
    public List<Node> childNodes() {
        return ArrayPatternNode.createList(this.preArgs, this.restArg, this.postArgs, this.constant);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARRAYPATTERNNODE;
    }

    public void setConstant(Node constant) {
        this.constant = constant;
    }

    public boolean hasConstant() {
        return this.constant != null;
    }

    public Node getConstant() {
        return this.constant;
    }

    public Node[] getPre() {
        return this.preArgs == null ? null : this.preArgs.children();
    }

    public ListNode getPreArgs() {
        return this.preArgs;
    }

    public Node[] getPost() {
        return this.postArgs == null ? null : this.postArgs.children();
    }

    public ListNode getPostArgs() {
        return this.postArgs;
    }

    public void setPreArgs(ListNode preArgs) {
        this.preArgs = preArgs;
    }

    public Node getRestArg() {
        return this.restArg;
    }

    public boolean hasRestArg() {
        return this.restArg != null;
    }

    public boolean isNamedRestArg() {
        return !(this.restArg instanceof StarNode);
    }

    public boolean usesRestNum() {
        if (this.restArg == null) {
            return false;
        }
        boolean named = !(this.restArg instanceof StarNode);
        return named || !named && this.postArgsNum() > 0;
    }

    public int preArgsNum() {
        return this.preArgs == null ? 0 : this.preArgs.size();
    }

    public int postArgsNum() {
        return this.postArgs == null ? 0 : this.postArgs.size();
    }

    public int minimumArgsNum() {
        return this.preArgsNum() + this.postArgsNum();
    }
}

