/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals.c14n;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XMLUtils {
    private XMLUtils() {
    }

    public static String getFullTextChildrenFromElement(Element element) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 3) continue;
            stringBuilder.append(((Text)node).getData());
        }
        return stringBuilder.toString();
    }

    public static Document getOwnerDocument(Node node) {
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        try {
            return node.getOwnerDocument();
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException(nullPointerException.getMessage());
        }
    }

    public static Document getOwnerDocument(Set<Node> set) {
        NullPointerException nullPointerException = null;
        for (Node node : set) {
            short s = node.getNodeType();
            if (s == 9) {
                return (Document)node;
            }
            try {
                if (s == 2) {
                    return ((Attr)node).getOwnerElement().getOwnerDocument();
                }
                return node.getOwnerDocument();
            }
            catch (NullPointerException nullPointerException2) {
                nullPointerException = nullPointerException2;
            }
        }
        throw new NullPointerException(nullPointerException.getMessage());
    }

    public static Set<Node> convertNodelistToSet(NodeList nodeList) {
        if (nodeList == null) {
            return new HashSet<Node>();
        }
        int n = nodeList.getLength();
        HashSet<Node> hashSet = new HashSet<Node>(n);
        for (int i = 0; i < n; ++i) {
            hashSet.add(nodeList.item(i));
        }
        return hashSet;
    }

    public static void circumventBug2650(Document document) {
        Element element = document.getDocumentElement();
        Attr attr = element.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        if (attr == null) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        }
        XMLUtils.circumventBug2650internal(document);
    }

    private static void circumventBug2650internal(Node node) {
        Node node2 = null;
        Node node3 = null;
        while (true) {
            switch (node.getNodeType()) {
                case 1: {
                    Element element = (Element)node;
                    if (!element.hasChildNodes()) break;
                    if (element.hasAttributes()) {
                        NamedNodeMap namedNodeMap = element.getAttributes();
                        int n = namedNodeMap.getLength();
                        for (Node node4 = element.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                            if (node4.getNodeType() != 1) continue;
                            Element element2 = (Element)node4;
                            for (int i = 0; i < n; ++i) {
                                Attr attr = (Attr)namedNodeMap.item(i);
                                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || element2.hasAttributeNS("http://www.w3.org/2000/xmlns/", attr.getLocalName())) continue;
                                element2.setAttributeNS("http://www.w3.org/2000/xmlns/", attr.getName(), attr.getNodeValue());
                            }
                        }
                    }
                }
                case 5: 
                case 9: {
                    node2 = node;
                    node3 = node.getFirstChild();
                }
            }
            while (node3 == null && node2 != null) {
                node3 = node2.getNextSibling();
                node2 = node2.getParentNode();
            }
            if (node3 == null) {
                return;
            }
            node = node3;
            node3 = node.getNextSibling();
        }
    }

    public static Text selectNodeText(Node node, String string, String string2, int n) {
        Node node2 = XMLUtils.selectNode(node, string, string2, n);
        if (node2 == null) {
            return null;
        }
        for (node2 = node2.getFirstChild(); node2 != null && node2.getNodeType() != 3; node2 = node2.getNextSibling()) {
        }
        return (Text)node2;
    }

    public static Element selectNode(Node node, String string, String string2, int n) {
        while (node != null) {
            if (node.getNamespaceURI() != null && node.getNamespaceURI().equals(string) && node.getLocalName().equals(string2)) {
                if (n == 0) {
                    return (Element)node;
                }
                --n;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static Element[] selectNodes(Node node, String string, String string2) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        while (node != null) {
            if (node.getNamespaceURI() != null && node.getNamespaceURI().equals(string) && node.getLocalName().equals(string2)) {
                arrayList.add((Element)node);
            }
            node = node.getNextSibling();
        }
        return arrayList.toArray(new Element[arrayList.size()]);
    }

    public static Set<Node> excludeNodeFromSet(Node node, Set<Node> set) {
        HashSet<Node> hashSet = new HashSet<Node>();
        for (Node node2 : set) {
            if (XMLUtils.isDescendantOrSelf(node, node2)) continue;
            hashSet.add(node2);
        }
        return hashSet;
    }

    public static String getStrFromNode(Node node) {
        if (node.getNodeType() == 3) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (node2.getNodeType() != 3) continue;
                stringBuilder.append(((Text)node2).getData());
            }
            return stringBuilder.toString();
        }
        if (node.getNodeType() == 2) {
            return ((Attr)node).getNodeValue();
        }
        if (node.getNodeType() == 7) {
            return ((ProcessingInstruction)node).getNodeValue();
        }
        return null;
    }

    public static boolean isDescendantOrSelf(Node node, Node node2) {
        if (node == node2) {
            return true;
        }
        Node node3 = node2;
        while (node3 != null) {
            if (node3 == node) {
                return true;
            }
            if (node3.getNodeType() == 2) {
                node3 = ((Attr)node3).getOwnerElement();
                continue;
            }
            node3 = node3.getParentNode();
        }
        return false;
    }

    public static String getAttributeValue(Element element, String string) {
        Attr attr = element.getAttributeNodeNS(null, string);
        return attr == null ? null : attr.getValue();
    }

    public static boolean protectAgainstWrappingAttack(Node node, String string) {
        Node node2 = node.getParentNode();
        Element element = null;
        String string2 = string.trim();
        if (string2.charAt(0) == '#') {
            string2 = string2.substring(1);
        }
        while (node != null) {
            Element element2;
            NamedNodeMap namedNodeMap;
            if (node.getNodeType() == 1 && (namedNodeMap = (element2 = (Element)node).getAttributes()) != null) {
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    if (!attr.isId() || !string2.equals(attr.getValue())) continue;
                    if (element == null) {
                        element = attr.getOwnerElement();
                        continue;
                    }
                    return false;
                }
            }
            Node node3 = node;
            if ((node = node.getFirstChild()) == null) {
                node = node3.getNextSibling();
            }
            while (node == null) {
                if ((node3 = node3.getParentNode()) == node2) {
                    return true;
                }
                node = node3.getNextSibling();
            }
        }
        return true;
    }

    public static boolean protectAgainstWrappingAttack(Node node, Element element, String string) {
        Node node2 = node.getParentNode();
        String string2 = string.trim();
        if (string2.charAt(0) == '#') {
            string2 = string2.substring(1);
        }
        while (node != null) {
            Element element2;
            NamedNodeMap namedNodeMap;
            if (node.getNodeType() == 1 && (namedNodeMap = (element2 = (Element)node).getAttributes()) != null) {
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    if (!attr.isId() || !string2.equals(attr.getValue()) || element2 == element) continue;
                    return false;
                }
            }
            Node node3 = node;
            if ((node = node.getFirstChild()) == null) {
                node = node3.getNextSibling();
            }
            while (node == null) {
                if ((node3 = node3.getParentNode()) == node2) {
                    return true;
                }
                node = node3.getNextSibling();
            }
        }
        return true;
    }
}

