/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.util.Objects;
import org.snmp4j.SecureTarget;
import org.snmp4j.Target;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;

public class UserTarget<A extends Address>
extends SecureTarget<A> {
    private static final long serialVersionUID = -1426511355567423746L;
    protected OctetString authoritativeEngineID = new OctetString();

    public UserTarget() {
        this.setSecurityModel(3);
    }

    public UserTarget(UserTarget<A> userTarget) {
        this(userTarget.getAddress(), userTarget.getSecurityName(), userTarget.getAuthoritativeEngineID(), userTarget.securityLevel);
        this.securityModel = userTarget.securityModel;
        this.setRetries(userTarget.getRetries());
        this.setTimeout(userTarget.getTimeout());
        this.setVersion(userTarget.getVersion());
        this.setMaxSizeRequestPDU(userTarget.getMaxSizeRequestPDU());
        this.setPreferredTransports(userTarget.getPreferredTransports());
    }

    public UserTarget(A address, OctetString securityName, byte[] authoritativeEngineID) {
        super(address, securityName);
        this.setAuthoritativeEngineID(authoritativeEngineID);
        this.setSecurityModel(3);
    }

    public UserTarget(A address, OctetString securityName, byte[] authoritativeEngineID, int securityLevel) {
        super(address, securityName);
        this.setAuthoritativeEngineID(authoritativeEngineID);
        this.setSecurityLevel(securityLevel);
        this.setSecurityModel(3);
    }

    public void setAuthoritativeEngineID(byte[] authoritativeEngineID) {
        this.authoritativeEngineID.setValue(authoritativeEngineID);
    }

    public byte[] getAuthoritativeEngineID() {
        return this.authoritativeEngineID.getValue();
    }

    @Override
    public String toString() {
        return "UserTarget[" + this.toStringAbstractTarget() + ", authoritativeEngineID=" + String.valueOf(this.authoritativeEngineID) + ", securityLevel=" + this.securityLevel + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserTarget that = (UserTarget)o;
        return Objects.equals(this.authoritativeEngineID, that.authoritativeEngineID);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.authoritativeEngineID != null ? this.authoritativeEngineID.hashCode() : 0);
        return result;
    }

    @Override
    public Target<A> duplicate() {
        UserTarget copy = new UserTarget(this.getAddress(), this.securityName, this.authoritativeEngineID.getValue(), this.securityLevel);
        copy.setRetries(this.getRetries());
        copy.setTimeout(this.getTimeout());
        copy.setMaxSizeRequestPDU(this.getMaxSizeRequestPDU());
        copy.setSecurityModel(this.getSecurityModel());
        copy.setVersion(this.getVersion());
        copy.setPreferredTransports(this.getPreferredTransports());
        return copy;
    }
}

