/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDescriptorBufferInfo;
import org.lwjgl.vulkan.VkDescriptorImageInfo;
import org.lwjgl.vulkan.VkWriteDescriptorSetAccelerationStructureKHR;
import org.lwjgl.vulkan.VkWriteDescriptorSetAccelerationStructureNV;
import org.lwjgl.vulkan.VkWriteDescriptorSetInlineUniformBlock;
import org.lwjgl.vulkan.VkWriteDescriptorSetInlineUniformBlockEXT;

public class VkWriteDescriptorSet
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DSTSET;
    public static final int DSTBINDING;
    public static final int DSTARRAYELEMENT;
    public static final int DESCRIPTORCOUNT;
    public static final int DESCRIPTORTYPE;
    public static final int PIMAGEINFO;
    public static final int PBUFFERINFO;
    public static final int PTEXELBUFFERVIEW;

    public VkWriteDescriptorSet(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkWriteDescriptorSet.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkWriteDescriptorSet.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkWriteDescriptorSet.npNext(this.address());
    }

    @NativeType(value="VkDescriptorSet")
    public long dstSet() {
        return VkWriteDescriptorSet.ndstSet(this.address());
    }

    @NativeType(value="uint32_t")
    public int dstBinding() {
        return VkWriteDescriptorSet.ndstBinding(this.address());
    }

    @NativeType(value="uint32_t")
    public int dstArrayElement() {
        return VkWriteDescriptorSet.ndstArrayElement(this.address());
    }

    @NativeType(value="uint32_t")
    public int descriptorCount() {
        return VkWriteDescriptorSet.ndescriptorCount(this.address());
    }

    @NativeType(value="VkDescriptorType")
    public int descriptorType() {
        return VkWriteDescriptorSet.ndescriptorType(this.address());
    }

    @Nullable
    @NativeType(value="VkDescriptorImageInfo const *")
    public VkDescriptorImageInfo.Buffer pImageInfo() {
        return VkWriteDescriptorSet.npImageInfo(this.address());
    }

    @Nullable
    @NativeType(value="VkDescriptorBufferInfo const *")
    public VkDescriptorBufferInfo.Buffer pBufferInfo() {
        return VkWriteDescriptorSet.npBufferInfo(this.address());
    }

    @Nullable
    @NativeType(value="VkBufferView const *")
    public LongBuffer pTexelBufferView() {
        return VkWriteDescriptorSet.npTexelBufferView(this.address());
    }

    public VkWriteDescriptorSet sType(@NativeType(value="VkStructureType") int value) {
        VkWriteDescriptorSet.nsType(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet sType$Default() {
        return this.sType(35);
    }

    public VkWriteDescriptorSet pNext(@NativeType(value="void const *") long value) {
        VkWriteDescriptorSet.npNext(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet pNext(VkWriteDescriptorSetAccelerationStructureKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkWriteDescriptorSet pNext(VkWriteDescriptorSetAccelerationStructureNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkWriteDescriptorSet pNext(VkWriteDescriptorSetInlineUniformBlock value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkWriteDescriptorSet pNext(VkWriteDescriptorSetInlineUniformBlockEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkWriteDescriptorSet dstSet(@NativeType(value="VkDescriptorSet") long value) {
        VkWriteDescriptorSet.ndstSet(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet dstBinding(@NativeType(value="uint32_t") int value) {
        VkWriteDescriptorSet.ndstBinding(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet dstArrayElement(@NativeType(value="uint32_t") int value) {
        VkWriteDescriptorSet.ndstArrayElement(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet descriptorCount(@NativeType(value="uint32_t") int value) {
        VkWriteDescriptorSet.ndescriptorCount(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet descriptorType(@NativeType(value="VkDescriptorType") int value) {
        VkWriteDescriptorSet.ndescriptorType(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet pImageInfo(@Nullable @NativeType(value="VkDescriptorImageInfo const *") VkDescriptorImageInfo.Buffer value) {
        VkWriteDescriptorSet.npImageInfo(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet pBufferInfo(@Nullable @NativeType(value="VkDescriptorBufferInfo const *") VkDescriptorBufferInfo.Buffer value) {
        VkWriteDescriptorSet.npBufferInfo(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet pTexelBufferView(@Nullable @NativeType(value="VkBufferView const *") LongBuffer value) {
        VkWriteDescriptorSet.npTexelBufferView(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet set(int sType, long pNext, long dstSet, int dstBinding, int dstArrayElement, int descriptorCount, int descriptorType, @Nullable VkDescriptorImageInfo.Buffer pImageInfo, @Nullable VkDescriptorBufferInfo.Buffer pBufferInfo, @Nullable LongBuffer pTexelBufferView) {
        this.sType(sType);
        this.pNext(pNext);
        this.dstSet(dstSet);
        this.dstBinding(dstBinding);
        this.dstArrayElement(dstArrayElement);
        this.descriptorCount(descriptorCount);
        this.descriptorType(descriptorType);
        this.pImageInfo(pImageInfo);
        this.pBufferInfo(pBufferInfo);
        this.pTexelBufferView(pTexelBufferView);
        return this;
    }

    public VkWriteDescriptorSet set(VkWriteDescriptorSet src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkWriteDescriptorSet malloc() {
        return (VkWriteDescriptorSet)VkWriteDescriptorSet.wrap(VkWriteDescriptorSet.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkWriteDescriptorSet calloc() {
        return (VkWriteDescriptorSet)VkWriteDescriptorSet.wrap(VkWriteDescriptorSet.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkWriteDescriptorSet create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkWriteDescriptorSet)VkWriteDescriptorSet.wrap(VkWriteDescriptorSet.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkWriteDescriptorSet create(long address) {
        return (VkWriteDescriptorSet)VkWriteDescriptorSet.wrap(VkWriteDescriptorSet.class, (long)address);
    }

    @Nullable
    public static VkWriteDescriptorSet createSafe(long address) {
        return address == 0L ? null : (VkWriteDescriptorSet)VkWriteDescriptorSet.wrap(VkWriteDescriptorSet.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkWriteDescriptorSet.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkWriteDescriptorSet.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkWriteDescriptorSet.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkWriteDescriptorSet.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkWriteDescriptorSet.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkWriteDescriptorSet.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkWriteDescriptorSet.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkWriteDescriptorSet mallocStack() {
        return VkWriteDescriptorSet.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkWriteDescriptorSet callocStack() {
        return VkWriteDescriptorSet.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkWriteDescriptorSet mallocStack(MemoryStack stack) {
        return VkWriteDescriptorSet.malloc(stack);
    }

    @Deprecated
    public static VkWriteDescriptorSet callocStack(MemoryStack stack) {
        return VkWriteDescriptorSet.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkWriteDescriptorSet.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkWriteDescriptorSet.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkWriteDescriptorSet.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkWriteDescriptorSet.calloc(capacity, stack);
    }

    public static VkWriteDescriptorSet malloc(MemoryStack stack) {
        return (VkWriteDescriptorSet)VkWriteDescriptorSet.wrap(VkWriteDescriptorSet.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkWriteDescriptorSet calloc(MemoryStack stack) {
        return (VkWriteDescriptorSet)VkWriteDescriptorSet.wrap(VkWriteDescriptorSet.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkWriteDescriptorSet.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkWriteDescriptorSet.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long ndstSet(long struct) {
        return UNSAFE.getLong(null, struct + (long)DSTSET);
    }

    public static int ndstBinding(long struct) {
        return UNSAFE.getInt(null, struct + (long)DSTBINDING);
    }

    public static int ndstArrayElement(long struct) {
        return UNSAFE.getInt(null, struct + (long)DSTARRAYELEMENT);
    }

    public static int ndescriptorCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DESCRIPTORCOUNT);
    }

    public static int ndescriptorType(long struct) {
        return UNSAFE.getInt(null, struct + (long)DESCRIPTORTYPE);
    }

    @Nullable
    public static VkDescriptorImageInfo.Buffer npImageInfo(long struct) {
        return VkDescriptorImageInfo.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PIMAGEINFO)), VkWriteDescriptorSet.ndescriptorCount(struct));
    }

    @Nullable
    public static VkDescriptorBufferInfo.Buffer npBufferInfo(long struct) {
        return VkDescriptorBufferInfo.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PBUFFERINFO)), VkWriteDescriptorSet.ndescriptorCount(struct));
    }

    @Nullable
    public static LongBuffer npTexelBufferView(long struct) {
        return MemoryUtil.memLongBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PTEXELBUFFERVIEW)), (int)VkWriteDescriptorSet.ndescriptorCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ndstSet(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DSTSET, value);
    }

    public static void ndstBinding(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DSTBINDING, value);
    }

    public static void ndstArrayElement(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DSTARRAYELEMENT, value);
    }

    public static void ndescriptorCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DESCRIPTORCOUNT, value);
    }

    public static void ndescriptorType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DESCRIPTORTYPE, value);
    }

    public static void npImageInfo(long struct, @Nullable VkDescriptorImageInfo.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PIMAGEINFO), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npBufferInfo(long struct, @Nullable VkDescriptorBufferInfo.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PBUFFERINFO), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npTexelBufferView(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PTEXELBUFFERVIEW), (long)MemoryUtil.memAddressSafe((LongBuffer)value));
    }

    static {
        Struct.Layout layout = VkWriteDescriptorSet.__struct((Struct.Member[])new Struct.Member[]{VkWriteDescriptorSet.__member((int)4), VkWriteDescriptorSet.__member((int)POINTER_SIZE), VkWriteDescriptorSet.__member((int)8), VkWriteDescriptorSet.__member((int)4), VkWriteDescriptorSet.__member((int)4), VkWriteDescriptorSet.__member((int)4), VkWriteDescriptorSet.__member((int)4), VkWriteDescriptorSet.__member((int)POINTER_SIZE), VkWriteDescriptorSet.__member((int)POINTER_SIZE), VkWriteDescriptorSet.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DSTSET = layout.offsetof(2);
        DSTBINDING = layout.offsetof(3);
        DSTARRAYELEMENT = layout.offsetof(4);
        DESCRIPTORCOUNT = layout.offsetof(5);
        DESCRIPTORTYPE = layout.offsetof(6);
        PIMAGEINFO = layout.offsetof(7);
        PBUFFERINFO = layout.offsetof(8);
        PTEXELBUFFERVIEW = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<VkWriteDescriptorSet, Buffer>
    implements NativeResource {
        private static final VkWriteDescriptorSet ELEMENT_FACTORY = VkWriteDescriptorSet.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkWriteDescriptorSet getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkWriteDescriptorSet.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkWriteDescriptorSet.npNext(this.address());
        }

        @NativeType(value="VkDescriptorSet")
        public long dstSet() {
            return VkWriteDescriptorSet.ndstSet(this.address());
        }

        @NativeType(value="uint32_t")
        public int dstBinding() {
            return VkWriteDescriptorSet.ndstBinding(this.address());
        }

        @NativeType(value="uint32_t")
        public int dstArrayElement() {
            return VkWriteDescriptorSet.ndstArrayElement(this.address());
        }

        @NativeType(value="uint32_t")
        public int descriptorCount() {
            return VkWriteDescriptorSet.ndescriptorCount(this.address());
        }

        @NativeType(value="VkDescriptorType")
        public int descriptorType() {
            return VkWriteDescriptorSet.ndescriptorType(this.address());
        }

        @Nullable
        @NativeType(value="VkDescriptorImageInfo const *")
        public VkDescriptorImageInfo.Buffer pImageInfo() {
            return VkWriteDescriptorSet.npImageInfo(this.address());
        }

        @Nullable
        @NativeType(value="VkDescriptorBufferInfo const *")
        public VkDescriptorBufferInfo.Buffer pBufferInfo() {
            return VkWriteDescriptorSet.npBufferInfo(this.address());
        }

        @Nullable
        @NativeType(value="VkBufferView const *")
        public LongBuffer pTexelBufferView() {
            return VkWriteDescriptorSet.npTexelBufferView(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkWriteDescriptorSet.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(35);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkWriteDescriptorSet.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkWriteDescriptorSetAccelerationStructureKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkWriteDescriptorSetAccelerationStructureNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkWriteDescriptorSetInlineUniformBlock value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkWriteDescriptorSetInlineUniformBlockEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer dstSet(@NativeType(value="VkDescriptorSet") long value) {
            VkWriteDescriptorSet.ndstSet(this.address(), value);
            return this;
        }

        public Buffer dstBinding(@NativeType(value="uint32_t") int value) {
            VkWriteDescriptorSet.ndstBinding(this.address(), value);
            return this;
        }

        public Buffer dstArrayElement(@NativeType(value="uint32_t") int value) {
            VkWriteDescriptorSet.ndstArrayElement(this.address(), value);
            return this;
        }

        public Buffer descriptorCount(@NativeType(value="uint32_t") int value) {
            VkWriteDescriptorSet.ndescriptorCount(this.address(), value);
            return this;
        }

        public Buffer descriptorType(@NativeType(value="VkDescriptorType") int value) {
            VkWriteDescriptorSet.ndescriptorType(this.address(), value);
            return this;
        }

        public Buffer pImageInfo(@Nullable @NativeType(value="VkDescriptorImageInfo const *") VkDescriptorImageInfo.Buffer value) {
            VkWriteDescriptorSet.npImageInfo(this.address(), value);
            return this;
        }

        public Buffer pBufferInfo(@Nullable @NativeType(value="VkDescriptorBufferInfo const *") VkDescriptorBufferInfo.Buffer value) {
            VkWriteDescriptorSet.npBufferInfo(this.address(), value);
            return this;
        }

        public Buffer pTexelBufferView(@Nullable @NativeType(value="VkBufferView const *") LongBuffer value) {
            VkWriteDescriptorSet.npTexelBufferView(this.address(), value);
            return this;
        }
    }
}

