/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct VRTextureBounds_t")
public class VRTextureBounds
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int UMIN;
    public static final int VMIN;
    public static final int UMAX;
    public static final int VMAX;

    public VRTextureBounds(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VRTextureBounds.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float uMin() {
        return VRTextureBounds.nuMin(this.address());
    }

    public float vMin() {
        return VRTextureBounds.nvMin(this.address());
    }

    public float uMax() {
        return VRTextureBounds.nuMax(this.address());
    }

    public float vMax() {
        return VRTextureBounds.nvMax(this.address());
    }

    public VRTextureBounds uMin(float value) {
        VRTextureBounds.nuMin(this.address(), value);
        return this;
    }

    public VRTextureBounds vMin(float value) {
        VRTextureBounds.nvMin(this.address(), value);
        return this;
    }

    public VRTextureBounds uMax(float value) {
        VRTextureBounds.nuMax(this.address(), value);
        return this;
    }

    public VRTextureBounds vMax(float value) {
        VRTextureBounds.nvMax(this.address(), value);
        return this;
    }

    public VRTextureBounds set(float uMin, float vMin, float uMax, float vMax) {
        this.uMin(uMin);
        this.vMin(vMin);
        this.uMax(uMax);
        this.vMax(vMax);
        return this;
    }

    public VRTextureBounds set(VRTextureBounds src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VRTextureBounds malloc() {
        return (VRTextureBounds)VRTextureBounds.wrap(VRTextureBounds.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VRTextureBounds calloc() {
        return (VRTextureBounds)VRTextureBounds.wrap(VRTextureBounds.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VRTextureBounds create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VRTextureBounds)VRTextureBounds.wrap(VRTextureBounds.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VRTextureBounds create(long address) {
        return (VRTextureBounds)VRTextureBounds.wrap(VRTextureBounds.class, (long)address);
    }

    @Nullable
    public static VRTextureBounds createSafe(long address) {
        return address == 0L ? null : (VRTextureBounds)VRTextureBounds.wrap(VRTextureBounds.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VRTextureBounds.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VRTextureBounds.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VRTextureBounds.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VRTextureBounds.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VRTextureBounds.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VRTextureBounds.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VRTextureBounds.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VRTextureBounds mallocStack() {
        return VRTextureBounds.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VRTextureBounds callocStack() {
        return VRTextureBounds.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VRTextureBounds mallocStack(MemoryStack stack) {
        return VRTextureBounds.malloc(stack);
    }

    @Deprecated
    public static VRTextureBounds callocStack(MemoryStack stack) {
        return VRTextureBounds.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VRTextureBounds.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VRTextureBounds.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VRTextureBounds.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VRTextureBounds.calloc(capacity, stack);
    }

    public static VRTextureBounds malloc(MemoryStack stack) {
        return (VRTextureBounds)VRTextureBounds.wrap(VRTextureBounds.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VRTextureBounds calloc(MemoryStack stack) {
        return (VRTextureBounds)VRTextureBounds.wrap(VRTextureBounds.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VRTextureBounds.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VRTextureBounds.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static float nuMin(long struct) {
        return UNSAFE.getFloat(null, struct + (long)UMIN);
    }

    public static float nvMin(long struct) {
        return UNSAFE.getFloat(null, struct + (long)VMIN);
    }

    public static float nuMax(long struct) {
        return UNSAFE.getFloat(null, struct + (long)UMAX);
    }

    public static float nvMax(long struct) {
        return UNSAFE.getFloat(null, struct + (long)VMAX);
    }

    public static void nuMin(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)UMIN, value);
    }

    public static void nvMin(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)VMIN, value);
    }

    public static void nuMax(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)UMAX, value);
    }

    public static void nvMax(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)VMAX, value);
    }

    static {
        Struct.Layout layout = VRTextureBounds.__struct((Struct.Member[])new Struct.Member[]{VRTextureBounds.__member((int)4), VRTextureBounds.__member((int)4), VRTextureBounds.__member((int)4), VRTextureBounds.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        UMIN = layout.offsetof(0);
        VMIN = layout.offsetof(1);
        UMAX = layout.offsetof(2);
        VMAX = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VRTextureBounds, Buffer>
    implements NativeResource {
        private static final VRTextureBounds ELEMENT_FACTORY = VRTextureBounds.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VRTextureBounds getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float uMin() {
            return VRTextureBounds.nuMin(this.address());
        }

        public float vMin() {
            return VRTextureBounds.nvMin(this.address());
        }

        public float uMax() {
            return VRTextureBounds.nuMax(this.address());
        }

        public float vMax() {
            return VRTextureBounds.nvMax(this.address());
        }

        public Buffer uMin(float value) {
            VRTextureBounds.nuMin(this.address(), value);
            return this;
        }

        public Buffer vMin(float value) {
            VRTextureBounds.nvMin(this.address(), value);
            return this;
        }

        public Buffer uMax(float value) {
            VRTextureBounds.nuMax(this.address(), value);
            return this;
        }

        public Buffer vMax(float value) {
            VRTextureBounds.nvMax(this.address(), value);
            return this;
        }
    }
}

