/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_colorf")
public class NkColorf
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int R;
    public static final int G;
    public static final int B;
    public static final int A;

    public NkColorf(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkColorf.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float r() {
        return NkColorf.nr(this.address());
    }

    public float g() {
        return NkColorf.ng(this.address());
    }

    public float b() {
        return NkColorf.nb(this.address());
    }

    public float a() {
        return NkColorf.na(this.address());
    }

    public NkColorf r(float value) {
        NkColorf.nr(this.address(), value);
        return this;
    }

    public NkColorf g(float value) {
        NkColorf.ng(this.address(), value);
        return this;
    }

    public NkColorf b(float value) {
        NkColorf.nb(this.address(), value);
        return this;
    }

    public NkColorf a(float value) {
        NkColorf.na(this.address(), value);
        return this;
    }

    public NkColorf set(float r, float g, float b, float a) {
        this.r(r);
        this.g(g);
        this.b(b);
        this.a(a);
        return this;
    }

    public NkColorf set(NkColorf src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkColorf malloc() {
        return (NkColorf)NkColorf.wrap(NkColorf.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NkColorf calloc() {
        return (NkColorf)NkColorf.wrap(NkColorf.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NkColorf create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NkColorf)NkColorf.wrap(NkColorf.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NkColorf create(long address) {
        return (NkColorf)NkColorf.wrap(NkColorf.class, (long)address);
    }

    @Nullable
    public static NkColorf createSafe(long address) {
        return address == 0L ? null : (NkColorf)NkColorf.wrap(NkColorf.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NkColorf.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NkColorf.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NkColorf.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkColorf.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NkColorf.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkColorf.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkColorf.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static NkColorf mallocStack() {
        return NkColorf.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkColorf callocStack() {
        return NkColorf.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkColorf mallocStack(MemoryStack stack) {
        return NkColorf.malloc(stack);
    }

    @Deprecated
    public static NkColorf callocStack(MemoryStack stack) {
        return NkColorf.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkColorf.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkColorf.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkColorf.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkColorf.calloc(capacity, stack);
    }

    public static NkColorf malloc(MemoryStack stack) {
        return (NkColorf)NkColorf.wrap(NkColorf.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkColorf calloc(MemoryStack stack) {
        return (NkColorf)NkColorf.wrap(NkColorf.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)NkColorf.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)NkColorf.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static float nr(long struct) {
        return UNSAFE.getFloat(null, struct + (long)R);
    }

    public static float ng(long struct) {
        return UNSAFE.getFloat(null, struct + (long)G);
    }

    public static float nb(long struct) {
        return UNSAFE.getFloat(null, struct + (long)B);
    }

    public static float na(long struct) {
        return UNSAFE.getFloat(null, struct + (long)A);
    }

    public static void nr(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)R, value);
    }

    public static void ng(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)G, value);
    }

    public static void nb(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)B, value);
    }

    public static void na(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)A, value);
    }

    static {
        Struct.Layout layout = NkColorf.__struct((Struct.Member[])new Struct.Member[]{NkColorf.__member((int)4), NkColorf.__member((int)4), NkColorf.__member((int)4), NkColorf.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        R = layout.offsetof(0);
        G = layout.offsetof(1);
        B = layout.offsetof(2);
        A = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<NkColorf, Buffer>
    implements NativeResource {
        private static final NkColorf ELEMENT_FACTORY = NkColorf.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkColorf getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float r() {
            return NkColorf.nr(this.address());
        }

        public float g() {
            return NkColorf.ng(this.address());
        }

        public float b() {
            return NkColorf.nb(this.address());
        }

        public float a() {
            return NkColorf.na(this.address());
        }

        public Buffer r(float value) {
            NkColorf.nr(this.address(), value);
            return this;
        }

        public Buffer g(float value) {
            NkColorf.ng(this.address(), value);
            return this;
        }

        public Buffer b(float value) {
            NkColorf.nb(this.address(), value);
            return this;
        }

        public Buffer a(float value) {
            NkColorf.na(this.address(), value);
            return this;
        }
    }
}

