/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.nuklear.NkHandle;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_command")
public class NkCommand
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int USERDATA;

    public NkCommand(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkCommand.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="enum nk_command_type")
    public int type() {
        return NkCommand.ntype(this.address());
    }

    @NativeType(value="nk_size")
    public long next() {
        return NkCommand.nnext(this.address());
    }

    @NativeType(value="nk_handle")
    public NkHandle userdata() {
        return NkCommand.nuserdata(this.address());
    }

    public static NkCommand create(long address) {
        return (NkCommand)NkCommand.wrap(NkCommand.class, (long)address);
    }

    @Nullable
    public static NkCommand createSafe(long address) {
        return address == 0L ? null : (NkCommand)NkCommand.wrap(NkCommand.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkCommand.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkCommand.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static NkHandle nuserdata(long struct) {
        return NkHandle.create(struct + (long)USERDATA);
    }

    static {
        Struct.Layout layout = NkCommand.__struct((Struct.Member[])new Struct.Member[]{NkCommand.__member((int)4), NkCommand.__member((int)POINTER_SIZE), NkCommand.__member((int)NkHandle.SIZEOF, (int)NkHandle.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        USERDATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<NkCommand, Buffer> {
        private static final NkCommand ELEMENT_FACTORY = NkCommand.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkCommand getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="enum nk_command_type")
        public int type() {
            return NkCommand.ntype(this.address());
        }

        @NativeType(value="nk_size")
        public long next() {
            return NkCommand.nnext(this.address());
        }

        @NativeType(value="nk_handle")
        public NkHandle userdata() {
            return NkCommand.nuserdata(this.address());
        }
    }
}

