/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.parser.functions;

import de.focus_shift.jollyday.core.spi.FixedWeekdayBetweenFixed;
import java.time.LocalDate;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.StreamSupport;

public class FindWeekDayBetween
implements Function<FixedWeekdayBetweenFixed, LocalDate>,
Iterable<LocalDate> {
    private final LocalDate from;
    private final LocalDate to;

    public FindWeekDayBetween(LocalDate from, LocalDate to) {
        this.from = from;
        this.to = to;
    }

    @Override
    public LocalDate apply(FixedWeekdayBetweenFixed fwm) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 1040), false).filter(date -> date.getDayOfWeek() == fwm.weekday()).findFirst().orElse(null);
    }

    @Override
    public Iterator<LocalDate> iterator() {
        return new FindWeekDayBetweenIterator(this.from, this.to);
    }

    private static final class FindWeekDayBetweenIterator
    implements Iterator<LocalDate> {
        private LocalDate cursor;
        private final LocalDate endDate;

        FindWeekDayBetweenIterator(LocalDate startDate, LocalDate endDate) {
            this.cursor = startDate;
            this.endDate = endDate;
        }

        @Override
        public boolean hasNext() {
            return this.cursor.isBefore(this.endDate) || this.cursor.isEqual(this.endDate);
        }

        @Override
        public LocalDate next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next date is after endDate which is not in range anymore.");
            }
            LocalDate current = this.cursor;
            this.cursor = this.cursor.plusDays(1L);
            return current;
        }
    }
}

