/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.events;

import java.io.Closeable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.events.EventFactory;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.internal.events.EventHandler;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ThreadedEventHandler
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger(ThreadedEventHandler.class);
    private final Thread thread;
    private final Event notifyEvent = new Event("notify", Map.of());
    private final BlockingQueue<Event> queue = new LinkedBlockingQueue<Event>();
    private final AtomicBoolean running = new AtomicBoolean(true);

    ThreadedEventHandler(Map<String, Set<EventSubscriber>> typedEventSubscribers, Map<String, EventFactory> typedEventFactories) {
        this.thread = new Thread(() -> {
            Throwable throwable = null;
            Object var4_5 = null;
            try (EventHandler worker = new EventHandler(typedEventSubscribers, typedEventFactories);){
                while (true) {
                    if (!this.running.get()) {
                        return;
                    }
                    try {
                        this.logger.trace("wait for event");
                        Event event = this.queue.poll(1L, TimeUnit.HOURS);
                        this.logger.trace("inspect event: {}", (Object)event);
                        if (event == null) {
                            this.logger.debug("Hey, you have really very few events.");
                            continue;
                        }
                        if (event.equals((Object)this.notifyEvent)) continue;
                        worker.handleEvent(event);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                    catch (RuntimeException ex) {
                        this.logger.error("Error on event handling.", (Throwable)ex);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }, "OH-OSGiEventManager");
    }

    void open() {
        this.thread.start();
    }

    @Override
    public void close() {
        this.running.set(false);
        this.queue.add(this.notifyEvent);
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    void handleEvent(Event event) {
        this.queue.add(event);
    }
}

