/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.http.internal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openhab.core.io.http.Handler;
import org.openhab.core.io.http.WrappingHttpContext;
import org.openhab.core.io.http.internal.BundleHttpContext;
import org.openhab.core.io.http.internal.DefaultHandlerContext;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContext;

@Component(service={HttpContext.class, WrappingHttpContext.class})
@HttpWhiteboardContext(path="/", name="oh-dfl-http-ctx")
public class OpenHABHttpContext
implements WrappingHttpContext {
    private final List<Handler> handlers = new CopyOnWriteArrayList<Handler>();

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ArrayDeque<Handler> queue = new ArrayDeque<Handler>(this.handlers);
        DefaultHandlerContext handlerContext = new DefaultHandlerContext(queue);
        handlerContext.execute(request, response);
        return !handlerContext.hasError();
    }

    public URL getResource(String name) {
        return null;
    }

    public String getMimeType(String name) {
        return null;
    }

    @Override
    public HttpContext wrap(Bundle bundle) {
        return new BundleHttpContext(this, bundle);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addHandler(Handler handler) {
        this.handlers.add(handler);
        this.handlers.sort(Comparator.comparingInt(Handler::getPriority));
    }

    public void removeHandler(Handler handler) {
        this.handlers.remove(handler);
    }
}

