/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.voice.text;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.config.core.ConfigParser;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.MetadataKey;
import org.openhab.core.items.MetadataRegistry;
import org.openhab.core.items.events.ItemEventFactory;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.StringType;
import org.openhab.core.types.Command;
import org.openhab.core.types.CommandDescription;
import org.openhab.core.types.CommandOption;
import org.openhab.core.types.State;
import org.openhab.core.types.StateDescription;
import org.openhab.core.types.TypeParser;
import org.openhab.core.voice.DialogContext;
import org.openhab.core.voice.text.ASTNode;
import org.openhab.core.voice.text.Expression;
import org.openhab.core.voice.text.ExpressionAlternatives;
import org.openhab.core.voice.text.ExpressionCardinality;
import org.openhab.core.voice.text.ExpressionIdentifier;
import org.openhab.core.voice.text.ExpressionLet;
import org.openhab.core.voice.text.ExpressionMatch;
import org.openhab.core.voice.text.ExpressionSequence;
import org.openhab.core.voice.text.HumanLanguageInterpreter;
import org.openhab.core.voice.text.InterpretationException;
import org.openhab.core.voice.text.InterpretationResult;
import org.openhab.core.voice.text.Rule;
import org.openhab.core.voice.text.TokenList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractRuleBasedInterpreter
implements HumanLanguageInterpreter {
    private static final String JSGF = "JSGF";
    private static final Set<String> SUPPORTED_GRAMMERS = Set.of("JSGF");
    private static final String OK = "ok";
    private static final String SORRY = "sorry";
    private static final String ERROR = "error";
    private static final String STATE_CURRENT = "state_current";
    private static final String STATE_ALREADY_SINGULAR = "state_already_singular";
    private static final String MULTIPLE_OBJECTS = "multiple_objects";
    private static final String NO_OBJECTS = "no_objects";
    private static final String COMMAND_NOT_ACCEPTED = "command_not_accepted";
    private static final String CMD = "cmd";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    public static final String IS_TEMPLATE_CONFIGURATION = "isTemplate";
    public static final String IS_SILENT_CONFIGURATION = "isSilent";
    public static final String IS_FORCED_CONFIGURATION = "isForced";
    private static final String NAME_TOKEN = "$name$";
    private static final String CMD_TOKEN = "$cmd$";
    private static final String DYN_CMD_TOKEN = "$*$";
    private static final Set<String> CUSTOM_RULE_TOKENS = Set.of("$name$", "$cmd$", "$*$");
    private static final String LANGUAGE_SUPPORT = "LanguageSupport";
    private static final String SYNONYMS_NAMESPACE = "synonyms";
    private static final String SEMANTICS_NAMESPACE = "semantics";
    private final MetadataRegistry metadataRegistry;
    private final Logger logger = LoggerFactory.getLogger(AbstractRuleBasedInterpreter.class);
    private final Map<Locale, List<Rule>> languageRules = new HashMap<Locale, List<Rule>>();
    private final Map<Locale, Set<String>> allItemTokens = new HashMap<Locale, Set<String>>();
    private final Map<Locale, Map<Item, ItemInterpretationMetadata>> itemTokens = new HashMap<Locale, Map<Item, ItemInterpretationMetadata>>();
    private final ItemRegistry itemRegistry;
    private final EventPublisher eventPublisher;
    private final RegistryChangeListener<Item> registryChangeListener = new RegistryChangeListener<Item>(){

        public void added(Item element) {
            AbstractRuleBasedInterpreter.this.invalidate();
        }

        public void removed(Item element) {
            AbstractRuleBasedInterpreter.this.invalidate();
        }

        public void updated(Item oldElement, Item element) {
            AbstractRuleBasedInterpreter.this.invalidate();
        }
    };
    private final RegistryChangeListener<Metadata> synonymsChangeListener = new RegistryChangeListener<Metadata>(){

        public void added(Metadata element) {
            this.invalidateIfSynonymsMetadata(element);
        }

        public void removed(Metadata element) {
            this.invalidateIfSynonymsMetadata(element);
        }

        public void updated(Metadata oldElement, Metadata element) {
            this.invalidateIfSynonymsMetadata(element);
        }

        private void invalidateIfSynonymsMetadata(Metadata metadata) {
            if (metadata.getUID().getNamespace().equals(AbstractRuleBasedInterpreter.SYNONYMS_NAMESPACE)) {
                AbstractRuleBasedInterpreter.this.invalidate();
            }
        }
    };

    protected AbstractRuleBasedInterpreter(EventPublisher eventPublisher, ItemRegistry itemRegistry, MetadataRegistry metadataRegistry) {
        this.eventPublisher = eventPublisher;
        this.itemRegistry = itemRegistry;
        this.metadataRegistry = metadataRegistry;
        itemRegistry.addRegistryChangeListener(this.registryChangeListener);
        metadataRegistry.addRegistryChangeListener(this.synonymsChangeListener);
    }

    protected void deactivate() {
        this.itemRegistry.removeRegistryChangeListener(this.registryChangeListener);
    }

    protected abstract void createRules(@Nullable Locale var1);

    @Override
    public String interpret(Locale locale, String text) throws InterpretationException {
        return this.interpret(locale, text, null);
    }

    @Override
    public String interpret(Locale locale, String text, @Nullable DialogContext dialogContext) throws InterpretationException {
        ResourceBundle language = ResourceBundle.getBundle(LANGUAGE_SUPPORT, locale);
        Rule[] rules = this.getRules(locale);
        if (rules.length == 0) {
            throw new InterpretationException(locale.getDisplayLanguage(Locale.ENGLISH) + " is not supported at the moment.");
        }
        TokenList tokens = new TokenList(this.tokenize(locale, text));
        if (tokens.eof()) {
            throw new InterpretationException(language.getString(SORRY));
        }
        InterpretationResult lastResult = null;
        String locationItem = dialogContext != null ? dialogContext.locationItem() : null;
        Rule[] ruleArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            Rule rule = ruleArray[n2];
            InterpretationResult result = rule.execute(language, tokens, locationItem);
            if (result.isSuccess()) {
                return result.getResponse();
            }
            if (!InterpretationResult.SYNTAX_ERROR.equals(result)) {
                lastResult = result;
            }
            ++n2;
        }
        if (lastResult != null && lastResult.getException() != null) {
            throw lastResult.getException();
        }
        throw new InterpretationException(language.getString(SORRY));
    }

    private void invalidate() {
        this.allItemTokens.clear();
        this.itemTokens.clear();
        this.languageRules.clear();
    }

    Set<String> getAllItemTokens(Locale locale) {
        Set<String> localeTokens = this.allItemTokens.get(locale);
        if (localeTokens == null) {
            localeTokens = new HashSet<String>();
            this.allItemTokens.put(locale, localeTokens);
            for (Item item : this.itemRegistry.getAll()) {
                localeTokens.addAll(this.tokenize(locale, item.getLabel()));
                String[] stringArray = this.getItemSynonyms(item);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String synonym = stringArray[n2];
                    localeTokens.addAll(this.tokenize(locale, synonym));
                    ++n2;
                }
            }
        }
        return localeTokens;
    }

    Map<Item, ItemInterpretationMetadata> getItemTokens(Locale locale) {
        Map<Item, ItemInterpretationMetadata> localeTokens = this.itemTokens.get(locale);
        if (localeTokens == null) {
            localeTokens = new HashMap<Item, ItemInterpretationMetadata>();
            this.itemTokens.put(locale, localeTokens);
            for (Item item : this.itemRegistry.getItems()) {
                if (!item.getGroupNames().isEmpty()) continue;
                this.addItem(locale, localeTokens, new ArrayList<List<String>>(), item, new ArrayList<String>());
            }
        }
        return localeTokens;
    }

    private String[] getItemSynonyms(Item item) {
        MetadataKey key = new MetadataKey(SYNONYMS_NAMESPACE, item.getName());
        Metadata synonymsMetadata = (Metadata)this.metadataRegistry.get((Object)key);
        return synonymsMetadata != null ? synonymsMetadata.getValue().split(",") : new String[]{};
    }

    private void addItem(Locale locale, Map<Item, ItemInterpretationMetadata> target, List<List<String>> tokens, Item item, ArrayList<String> locationParentNames) {
        this.addItem(locale, target, tokens, item, item.getLabel(), locationParentNames);
        String[] stringArray = this.getItemSynonyms(item);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String synonym = stringArray[n2];
            this.addItem(locale, target, tokens, item, synonym, locationParentNames);
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addItem(Locale locale, Map<Item, ItemInterpretationMetadata> target, List<List<String>> tokens, Item item, @Nullable String itemLabel, ArrayList<String> locationParentNames) {
        ArrayList<List<String>> nt = new ArrayList<List<String>>(tokens);
        nt.add(this.tokenize(locale, itemLabel));
        ItemInterpretationMetadata metadata = target.computeIfAbsent(item, k -> new ItemInterpretationMetadata());
        metadata.pathToItem.add(nt);
        metadata.locationParentNames.addAll(locationParentNames);
        Item item2 = item;
        if (item2 instanceof GroupItem) {
            void groupItem;
            GroupItem groupItem2 = (GroupItem)item2;
            GroupItem cfr_ignored_0 = (GroupItem)item2;
            if (item.hasTag("Location")) {
                locationParentNames.add(item.getName());
            }
            for (Item member : groupItem.getMembers()) {
                this.addItem(locale, target, nt, member, locationParentNames);
            }
        }
    }

    protected Expression name() {
        return this.name(null);
    }

    protected Expression name(@Nullable Expression stopper) {
        return this.tag(NAME, (Object)this.star(new ExpressionIdentifier(this, stopper)));
    }

    private Expression value() {
        return this.value(null);
    }

    private Expression value(@Nullable Expression stopper) {
        return this.tag(VALUE, (Object)this.star(new ExpressionIdentifier(this, stopper)));
    }

    private @Nullable List<@NonNull Rule> getLanguageRules(@Nullable Locale locale) {
        if (!this.languageRules.containsKey(locale)) {
            this.createRules(locale);
        }
        return this.languageRules.get(locale);
    }

    public Rule[] getRules(Locale locale) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        HashSet<List<Rule>> ruleSets = new HashSet<List<Rule>>();
        List<Rule> ruleSet = this.getLanguageRules(locale);
        if (ruleSet != null) {
            ruleSets.add(ruleSet);
            rules.addAll(ruleSet);
        }
        String language = locale.getLanguage();
        for (Map.Entry<Locale, List<Rule>> entry : this.languageRules.entrySet()) {
            Locale ruleLocale = entry.getKey();
            if (!ruleLocale.getLanguage().equals(language) || ruleSets.contains(ruleSet = entry.getValue())) continue;
            ruleSets.add(ruleSet);
            rules.addAll(ruleSet);
        }
        return rules.toArray(new Rule[0]);
    }

    protected void addRules(Locale locale, Rule ... rules) {
        List ruleSet = this.languageRules.computeIfAbsent(locale, k -> new ArrayList());
        ruleSet.addAll(Arrays.asList(rules));
    }

    protected Rule itemRule(Object headExpression) {
        return this.itemRule(headExpression, null);
    }

    protected Rule itemRule(Object headExpression, @Nullable Object tailExpression) {
        return this.restrictedItemRule(ItemFilter.all(), headExpression, tailExpression, false, false);
    }

    protected Rule restrictedItemRule(Set<Item> allowedItems, Object headExpression, @Nullable Object tailExpression) {
        return this.restrictedItemRule(ItemFilter.forItems(allowedItems), headExpression, tailExpression, false, false);
    }

    protected Rule restrictedItemRule(ItemFilter itemFilter, Object headExpression, @Nullable Object tailExpression, boolean isForced, boolean isSilent) {
        Expression tail = this.exp(tailExpression);
        ExpressionSequence expression = tail == null ? this.seq(headExpression, this.name()) : this.seq(headExpression, this.name(tail), tail);
        return new Rule(expression, itemFilter, isForced, isSilent){

            /*
             * WARNING - void declaration
             */
            @Override
            public InterpretationResult interpretAST(ResourceBundle language, ASTNode node, Rule.InterpretationContext context) {
                SingleCommandSupplier commandSupplier;
                String[] name = node.findValueAsStringArray(AbstractRuleBasedInterpreter.NAME);
                ASTNode cmdNode = node.findNode(AbstractRuleBasedInterpreter.CMD);
                Object tag = cmdNode.getTag();
                Object value = cmdNode.getValue();
                Object object = tag;
                if (object instanceof ItemCommandSupplier) {
                    void supplier;
                    ItemCommandSupplier itemCommandSupplier = (ItemCommandSupplier)object;
                    ItemCommandSupplier cfr_ignored_0 = (ItemCommandSupplier)object;
                    commandSupplier = supplier;
                } else {
                    Object object2 = value;
                    if (object2 instanceof Number) {
                        void number;
                        Number number2 = (Number)object2;
                        Number cfr_ignored_1 = (Number)object2;
                        commandSupplier = new SingleCommandSupplier((Command)new DecimalType((Number)number.longValue()));
                    } else {
                        commandSupplier = new SingleCommandSupplier((Command)new StringType(cmdNode.getValueAsString()));
                    }
                }
                if (name != null) {
                    try {
                        return new InterpretationResult(true, AbstractRuleBasedInterpreter.this.executeSingle(language, name, commandSupplier, context));
                    }
                    catch (InterpretationException ex) {
                        return new InterpretationResult(ex);
                    }
                }
                return InterpretationResult.SEMANTIC_ERROR;
            }
        };
    }

    protected Rule restrictedDynamicItemRule(final Item item, ItemFilter itemFilter, Object headExpression, Object midExpression, @Nullable Object tailExpression, boolean isNameFirst, boolean isForced, boolean isSilent) {
        Expression firstValue;
        Expression head = Objects.requireNonNull(this.exp(headExpression));
        Expression mid = Objects.requireNonNull(this.exp(midExpression));
        @Nullable Expression tail = this.exp(tailExpression);
        Expression expression = firstValue = isNameFirst ? this.name(mid) : this.value(mid);
        Expression secondValue = tail != null ? (isNameFirst ? this.value(tail) : this.name(tail)) : (isNameFirst ? this.value() : this.name());
        ExpressionSequence expression2 = tail == null ? this.seq(head, firstValue, mid, secondValue) : this.seq(head, firstValue, mid, secondValue, tail);
        final HashMap<String, String> itemValuesByLabel = this.getItemValuesByLabel(item);
        return new Rule(expression2, itemFilter, isForced, isSilent){

            @Override
            public InterpretationResult interpretAST(ResourceBundle language, ASTNode node, Rule.InterpretationContext context) {
                String[] name = node.findValueAsStringArray(AbstractRuleBasedInterpreter.NAME);
                CharSequence[] value = node.findValueAsStringArray(AbstractRuleBasedInterpreter.VALUE);
                if (name != null && value != null) {
                    try {
                        TextCommandSupplier commandSupplier = new TextCommandSupplier(String.join((CharSequence)" ", value), item.getAcceptedCommandTypes(), itemValuesByLabel);
                        return new InterpretationResult(true, AbstractRuleBasedInterpreter.this.executeSingle(language, name, commandSupplier, context));
                    }
                    catch (InterpretationException ex) {
                        return new InterpretationResult(ex);
                    }
                }
                return InterpretationResult.SEMANTIC_ERROR;
            }
        };
    }

    protected Rule customDynamicRule(final Item item, ItemFilter itemFilter, Object headExpression, @Nullable Object tailExpression, boolean isForced, boolean isSilent) {
        Expression tail = this.exp(tailExpression);
        ExpressionSequence expression = tail == null ? this.seq(headExpression, this.value(null)) : this.seq(headExpression, this.value(tail), tail);
        final HashMap<String, String> valuesByLabel = this.getItemValuesByLabel(item);
        return new Rule(expression, itemFilter, isForced, isSilent){

            @Override
            public InterpretationResult interpretAST(ResourceBundle language, ASTNode node, Rule.InterpretationContext context) {
                CharSequence[] commandParts = node.findValueAsStringArray(AbstractRuleBasedInterpreter.VALUE);
                if (commandParts != null && commandParts.length > 0) {
                    try {
                        TextCommandSupplier commandSupplier = new TextCommandSupplier(String.join((CharSequence)" ", commandParts).trim(), item.getAcceptedCommandTypes(), valuesByLabel);
                        return new InterpretationResult(true, AbstractRuleBasedInterpreter.this.executeCustom(language, commandSupplier, context));
                    }
                    catch (InterpretationException ex) {
                        return new InterpretationResult(ex);
                    }
                }
                return InterpretationResult.SEMANTIC_ERROR;
            }
        };
    }

    private HashMap<String, String> getItemValuesByLabel(Item item) {
        CommandDescription commandDesc;
        HashMap<String, String> valuesByLabel = new HashMap<String, String>();
        StateDescription stateDescription = item.getStateDescription();
        if (stateDescription != null) {
            stateDescription.getOptions().forEach(op -> {
                String label = op.getLabel();
                if (label != null) {
                    valuesByLabel.put(label, op.getValue());
                }
            });
        }
        if ((commandDesc = item.getCommandDescription()) != null) {
            commandDesc.getCommandOptions().forEach(op -> {
                String label = op.getLabel();
                if (label != null) {
                    valuesByLabel.put(label, op.getCommand());
                }
            });
        }
        return valuesByLabel;
    }

    protected Rule customCommandRule(ItemFilter itemFilter, Object cmdExpression, boolean isForced, boolean isSilent) {
        return new Rule(Objects.requireNonNull(this.exp(cmdExpression)), itemFilter, isForced, isSilent){

            /*
             * WARNING - void declaration
             */
            @Override
            public InterpretationResult interpretAST(ResourceBundle language, ASTNode node, Rule.InterpretationContext context) {
                SingleCommandSupplier commandSupplier;
                ASTNode cmdNode = node.findNode(AbstractRuleBasedInterpreter.CMD);
                Object tag = cmdNode.getTag();
                Object value = cmdNode.getValue();
                Object object = tag;
                if (object instanceof ItemCommandSupplier) {
                    void supplier;
                    ItemCommandSupplier itemCommandSupplier = (ItemCommandSupplier)object;
                    ItemCommandSupplier cfr_ignored_0 = (ItemCommandSupplier)object;
                    commandSupplier = supplier;
                } else {
                    Object object2 = value;
                    if (object2 instanceof Number) {
                        void number;
                        Number number2 = (Number)object2;
                        Number cfr_ignored_1 = (Number)object2;
                        commandSupplier = new SingleCommandSupplier((Command)new DecimalType((Number)number.longValue()));
                    } else {
                        commandSupplier = new SingleCommandSupplier((Command)new StringType(cmdNode.getValueAsString()));
                    }
                }
                try {
                    return new InterpretationResult(true, AbstractRuleBasedInterpreter.this.executeCustom(language, commandSupplier, context));
                }
                catch (InterpretationException ex) {
                    return new InterpretationResult(ex);
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    protected @Nullable Expression exp(@Nullable Object obj) {
        Object object = obj;
        if (object instanceof Expression) {
            void expression;
            Expression expression2 = (Expression)object;
            Expression cfr_ignored_0 = (Expression)object;
            return expression;
        }
        return obj == null ? null : new ExpressionMatch(obj.toString());
    }

    protected Expression[] exps(Object ... objects) {
        ArrayList<Expression> result = new ArrayList<Expression>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            Expression e = this.exp(object);
            if (e != null) {
                result.add(e);
            }
            ++n2;
        }
        return result.toArray(new Expression[0]);
    }

    protected Expression tag(String name, Object expression) {
        return this.tag(name, expression, null);
    }

    protected Expression tag(Object expression, Object tag) {
        return this.tag(null, expression, tag);
    }

    protected Expression tag(@Nullable String name, Object expression, @Nullable Object tag) {
        return new ExpressionLet(name, this.exp(expression), null, tag);
    }

    protected Expression cmd(Object expression) {
        return this.cmd(expression, (Command)null);
    }

    protected Expression cmd(Object expression, @Nullable Command command) {
        return this.tag(CMD, expression, command != null ? new SingleCommandSupplier(command) : null);
    }

    protected Expression cmd(Object expression, @Nullable ItemCommandSupplier command) {
        return this.tag(CMD, expression, command);
    }

    protected ExpressionAlternatives alt(Object ... expressions) {
        return new ExpressionAlternatives(this.exps(expressions));
    }

    protected ExpressionSequence seq(Object ... expressions) {
        return new ExpressionSequence(this.exps(expressions));
    }

    protected ExpressionCardinality opt(Object expression) {
        return new ExpressionCardinality(this.exp(expression), false, true);
    }

    protected ExpressionCardinality star(Object expression) {
        return new ExpressionCardinality(this.exp(expression), false, false);
    }

    protected ExpressionCardinality plus(Object expression) {
        return new ExpressionCardinality(this.exp(expression), true, false);
    }

    protected String executeSingle(ResourceBundle language, String[] labelFragments, ItemCommandSupplier commandSupplier, Rule.InterpretationContext context) throws InterpretationException {
        List<Item> items = this.getMatchingItems(language, labelFragments, commandSupplier, context);
        if (items.isEmpty()) {
            if (!this.getMatchingItems(language, labelFragments, null, context).isEmpty()) {
                throw new InterpretationException(language.getString(COMMAND_NOT_ACCEPTED).replace("<cmd>", commandSupplier.getCommandLabel()));
            }
            throw new InterpretationException(language.getString(NO_OBJECTS));
        }
        if (items.size() > 1) {
            throw new InterpretationException(language.getString(MULTIPLE_OBJECTS));
        }
        Item item = items.get(0);
        Command command = commandSupplier.getItemCommand(item);
        if (command == null) {
            this.logger.warn("Failed resolving item command");
            return language.getString(ERROR);
        }
        return this.trySendCommand(language, item, command, context.isForced(), context.isSilent());
    }

    protected String executeCustom(ResourceBundle language, ItemCommandSupplier itemCommandSupplier, Rule.InterpretationContext context) throws InterpretationException {
        Set filteredCompatibleEntries;
        Map<Item, ItemInterpretationMetadata> itemsMap = this.getItemTokens(language.getLocale());
        Set compatibleItemEntries = itemsMap.entrySet().stream().filter(itemEntry -> context.itemFilter().filterItem((Item)itemEntry.getKey(), this.metadataRegistry)).collect(Collectors.toSet());
        if (compatibleItemEntries.isEmpty()) {
            throw new InterpretationException(language.getString(NO_OBJECTS));
        }
        if (compatibleItemEntries.size() > 1 && context.locationItem() != null && (filteredCompatibleEntries = compatibleItemEntries.stream().filter(itemEntry -> ((ItemInterpretationMetadata)itemEntry.getValue()).locationParentNames.contains(context.locationItem())).collect(Collectors.toSet())).size() == 1) {
            this.logger.debug("Collision resolved based on location context");
            compatibleItemEntries = filteredCompatibleEntries;
        }
        if (compatibleItemEntries.size() > 1) {
            throw new InterpretationException(language.getString(MULTIPLE_OBJECTS));
        }
        Item item = compatibleItemEntries.stream().map(Map.Entry::getKey).findFirst().get();
        Command command = itemCommandSupplier.getItemCommand(item);
        if (command == null) {
            this.logger.warn("Failed creating command");
            return language.getString(ERROR);
        }
        return this.trySendCommand(language, item, command, context.isForced(), context.isSilent());
    }

    /*
     * WARNING - void declaration
     */
    private String trySendCommand(ResourceBundle language, Item item, Command command, boolean isForced, boolean isSilent) {
        block5: {
            Command command2 = command;
            if (command2 instanceof State) {
                State state = (State)command2;
                State cfr_ignored_0 = (State)command2;
                try {
                    String stateText;
                    void newState;
                    State oldState = item.getStateAs(newState.getClass());
                    if (isForced || !newState.equals(oldState)) break block5;
                    String template = language.getString(STATE_ALREADY_SINGULAR);
                    String cmdName = "state_" + command.toString().toLowerCase();
                    try {
                        stateText = language.getString(cmdName);
                    }
                    catch (Exception e) {
                        stateText = language.getString(STATE_CURRENT);
                    }
                    return template.replace("<state>", stateText);
                }
                catch (Exception ex) {
                    this.logger.debug("Failed constructing response: {}", (Object)ex.getMessage());
                    return language.getString(ERROR);
                }
            }
        }
        this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)item.getName(), (Command)command));
        return !isSilent ? language.getString(OK) : "";
    }

    protected List<Item> getMatchingItems(ResourceBundle language, String[] labelFragments, @Nullable ItemCommandSupplier commandSupplier, Rule.InterpretationContext context) {
        Item matchByLocation;
        String locationContext;
        HashMap<Item, ItemInterpretationMetadata> itemsData = new HashMap<Item, ItemInterpretationMetadata>();
        HashMap<Item, ItemInterpretationMetadata> exactMatchItemsData = new HashMap<Item, ItemInterpretationMetadata>();
        HashMap<Item, ItemInterpretationMetadata> exactMatchOnTargetItemsData = new HashMap<Item, ItemInterpretationMetadata>();
        Map<Item, ItemInterpretationMetadata> map = this.getItemTokens(language.getLocale());
        for (Map.Entry<Item, ItemInterpretationMetadata> entry : map.entrySet()) {
            Item item = entry.getKey();
            ItemInterpretationMetadata interpretationMetadata = entry.getValue();
            if (!context.itemFilter().filterItem(item, this.metadataRegistry)) {
                this.logger.trace("Item {} discarded, not allowed for this rule", (Object)item.getName());
                continue;
            }
            for (List<List<String>> itemLabelFragmentsPath : interpretationMetadata.pathToItem) {
                List commandTypes;
                boolean exactMatch = false;
                boolean exactMatchOnTarget = false;
                this.logger.trace("Checking tokens {} against the item tokens {}", (Object)labelFragments, itemLabelFragmentsPath);
                List<String> lowercaseLabelFragments = Arrays.stream(labelFragments).map(lf -> lf.toLowerCase(language.getLocale())).toList();
                ArrayList<String> unmatchedFragments = new ArrayList<String>(lowercaseLabelFragments);
                if (itemLabelFragmentsPath.get(itemLabelFragmentsPath.size() - 1).equals(lowercaseLabelFragments)) {
                    exactMatch = true;
                    exactMatchOnTarget = true;
                    unmatchedFragments.clear();
                } else {
                    for (List<String> itemLabelFragments : itemLabelFragmentsPath) {
                        if (itemLabelFragments.equals(lowercaseLabelFragments)) {
                            exactMatch = true;
                            unmatchedFragments.clear();
                            break;
                        }
                        unmatchedFragments.removeAll(itemLabelFragments);
                    }
                }
                boolean allMatched = unmatchedFragments.isEmpty();
                this.logger.trace("Matched: {}", (Object)allMatched);
                this.logger.trace("Exact match: {}", (Object)exactMatch);
                this.logger.trace("Exact match on target: {}", (Object)exactMatchOnTarget);
                if (!allMatched) continue;
                List<Object> list = commandTypes = commandSupplier != null ? commandSupplier.getCommandClasses(null) : List.of();
                if (commandSupplier != null) {
                    if (!commandTypes.stream().anyMatch(item.getAcceptedCommandTypes()::contains)) continue;
                }
                AbstractRuleBasedInterpreter.insertDiscardingMembers(itemsData, item, interpretationMetadata);
                if (exactMatch) {
                    AbstractRuleBasedInterpreter.insertDiscardingMembers(exactMatchItemsData, item, interpretationMetadata);
                }
                if (!exactMatchOnTarget) continue;
                AbstractRuleBasedInterpreter.insertDiscardingMembers(exactMatchOnTargetItemsData, item, interpretationMetadata);
            }
        }
        if (this.logger.isTraceEnabled()) {
            List commandTypes = commandSupplier != null ? commandSupplier.getCommandClasses(null) : List.of();
            String typeDetails = !commandTypes.isEmpty() ? " that accept " + commandTypes.stream().map(Class::getSimpleName).distinct().collect(Collectors.joining(" or ")) : "";
            this.logger.trace("Partial matched items against {}{}: {}", new Object[]{labelFragments, typeDetails, itemsData.keySet().stream().map(Item::getName).collect(Collectors.joining(", "))});
            this.logger.trace("Exact matched items against {}{}: {}", new Object[]{labelFragments, typeDetails, exactMatchItemsData.keySet().stream().map(Item::getName).collect(Collectors.joining(", "))});
            this.logger.trace("Exact matched on target items against {}{}: {}", new Object[]{labelFragments, typeDetails, exactMatchOnTargetItemsData.keySet().stream().map(Item::getName).collect(Collectors.joining(", "))});
        }
        if ((locationContext = context.locationItem()) != null && itemsData.size() > 1) {
            this.logger.trace("Filtering {} matched items based on location '{}'", (Object)itemsData.size(), (Object)locationContext);
            matchByLocation = this.filterMatchedItemsByLocation(itemsData, locationContext);
            if (matchByLocation != null) {
                return List.of(matchByLocation);
            }
        }
        if (locationContext != null && exactMatchItemsData.size() > 1) {
            this.logger.trace("Filtering {} exact matched items based on location '{}'", (Object)exactMatchItemsData.size(), (Object)locationContext);
            matchByLocation = this.filterMatchedItemsByLocation(exactMatchItemsData, locationContext);
            if (matchByLocation != null) {
                return List.of(matchByLocation);
            }
        }
        if (locationContext != null && exactMatchOnTargetItemsData.size() > 1) {
            this.logger.trace("Filtering {} exact matched on target items based on location '{}'", (Object)exactMatchOnTargetItemsData.size(), (Object)locationContext);
            matchByLocation = this.filterMatchedItemsByLocation(exactMatchOnTargetItemsData, locationContext);
            if (matchByLocation != null) {
                return List.of(matchByLocation);
            }
        }
        if (itemsData.size() == 1) {
            return new ArrayList<Item>(itemsData.keySet());
        }
        if (exactMatchItemsData.size() == 1) {
            return new ArrayList<Item>(exactMatchItemsData.keySet());
        }
        if (exactMatchOnTargetItemsData.size() == 1) {
            return new ArrayList<Item>(exactMatchOnTargetItemsData.keySet());
        }
        return new ArrayList<Item>(itemsData.keySet());
    }

    private @Nullable Item filterMatchedItemsByLocation(Map<Item, ItemInterpretationMetadata> itemsData, String locationContext) {
        List<Map.Entry> itemsFilteredByLocation = itemsData.entrySet().stream().filter(entry -> ((ItemInterpretationMetadata)entry.getValue()).locationParentNames.contains(locationContext)).toList();
        if (itemsFilteredByLocation.size() != 1) {
            return null;
        }
        this.logger.trace("Unique match by location found in '{}', taking prevalence", (Object)locationContext);
        return (Item)itemsFilteredByLocation.get(0).getKey();
    }

    private static void insertDiscardingMembers(Map<Item, ItemInterpretationMetadata> items, Item item, ItemInterpretationMetadata interpretationMetadata) {
        String name = item.getName();
        boolean insert = items.keySet().stream().noneMatch(i -> name.startsWith(i.getName()));
        if (insert) {
            items.keySet().removeIf(matchedItem -> matchedItem.getName().startsWith(name));
            items.put(item, interpretationMetadata);
        }
    }

    protected List<String> tokenize(Locale locale, @Nullable String text) {
        return this.tokenize(locale, text, false);
    }

    protected List<String> tokenize(Locale locale, @Nullable String text, boolean customRuleCompat) {
        String extraAllowedChars;
        if (text == null) {
            return List.of();
        }
        String string = extraAllowedChars = customRuleCompat ? Pattern.quote("$|?") : "";
        String specialCharactersRegex = Locale.FRENCH.getLanguage().equalsIgnoreCase(locale.getLanguage()) ? "[^\\w\\s\u00e0\u00e2\u00e4\u00e7\u00e9\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u00f9\u00fb\u00fc" + extraAllowedChars + "]" : ("es".equalsIgnoreCase(locale.getLanguage()) ? "[^\\w\\s\u00e1\u00e9\u00ed\u00f3\u00fa\u00ef\u00fc\u00f1\u00e7" + extraAllowedChars + "]" : "[^\\w\\s" + extraAllowedChars + "]");
        return Arrays.stream(text.toLowerCase(locale).replaceAll("[\\']", "").replaceAll(specialCharactersRegex, " ").split("\\s")).filter(i -> !i.isBlank()).map(String::trim).toList();
    }

    protected List<Rule> parseItemCustomRules(Locale locale, Item item, String ruleText, Metadata metadata) {
        boolean isTemplate = (Boolean)ConfigParser.valueAsOrElse(metadata.getConfiguration().get(IS_TEMPLATE_CONFIGURATION), Boolean.class, (Object)false);
        boolean isSilent = (Boolean)ConfigParser.valueAsOrElse(metadata.getConfiguration().get(IS_SILENT_CONFIGURATION), Boolean.class, (Object)false);
        boolean isForced = (Boolean)ConfigParser.valueAsOrElse(metadata.getConfiguration().get(IS_FORCED_CONFIGURATION), Boolean.class, (Object)false);
        boolean isItemRule = false;
        boolean isCommandRule = false;
        boolean isDynamicRule = false;
        if (ruleText.startsWith(NAME_TOKEN) || ruleText.startsWith(DYN_CMD_TOKEN)) {
            this.logger.warn("Rule can not start with {} or {}: {}", new Object[]{NAME_TOKEN, DYN_CMD_TOKEN, ruleText});
            return List.of();
        }
        boolean containsMultiple = CUSTOM_RULE_TOKENS.stream().anyMatch(token -> {
            int firstIndex = token.indexOf((String)token);
            return firstIndex != -1 && token.indexOf((String)token, firstIndex + 1) != -1;
        });
        if (containsMultiple) {
            this.logger.warn("Rule can not contains {}, {} or {} multiple times: {}", new Object[]{NAME_TOKEN, CMD_TOKEN, DYN_CMD_TOKEN, ruleText});
            return List.of();
        }
        if (ruleText.contains(NAME_TOKEN)) {
            isItemRule = true;
        }
        if (ruleText.contains(CMD_TOKEN)) {
            isCommandRule = true;
        }
        if (ruleText.contains(DYN_CMD_TOKEN)) {
            isDynamicRule = true;
        }
        if (isCommandRule && isDynamicRule) {
            this.logger.warn("Rule can not contain {} and {}: {}", new Object[]{CMD_TOKEN, DYN_CMD_TOKEN, ruleText});
            return List.of();
        }
        if (!isCommandRule && !isDynamicRule) {
            this.logger.warn("Rule should contain {} or {}: {}", new Object[]{CMD_TOKEN, DYN_CMD_TOKEN, ruleText});
            return List.of();
        }
        try {
            ItemFilter itemsFilter;
            ItemFilter itemFilter = itemsFilter = isTemplate ? ItemFilter.forSimilarItem(item, (Metadata)this.metadataRegistry.get((Object)new MetadataKey(SEMANTICS_NAMESPACE, item.getName()))) : ItemFilter.forItem(item);
            if (isItemRule && isCommandRule) {
                String[] ruleParts = ruleText.split(Pattern.quote(NAME_TOKEN));
                String headPart = ruleParts[0];
                String tailPart = ruleParts.length > 1 ? ruleParts[1] : null;
                CommandDescription itemCMDs = item.getCommandDescription();
                if (itemCMDs == null || itemCMDs.getCommandOptions().isEmpty()) {
                    throw new ParseException("Missing item " + item.getName() + " command description.", 0);
                }
                ArrayList<Rule> rules = new ArrayList<Rule>();
                for (CommandOption cmd : itemCMDs.getCommandOptions()) {
                    String label = cmd.getLabel();
                    if (label == null) {
                        label = cmd.getCommand();
                    }
                    String value = cmd.getCommand();
                    String[] cmdInfo = new String[]{label, value};
                    Expression head = Objects.requireNonNull(this.parseCustomRuleSegment(locale, headPart, false, item, cmdInfo));
                    Expression tail = tailPart != null ? this.parseCustomRuleSegment(locale, tailPart, true, item, cmdInfo) : null;
                    rules.add(this.restrictedItemRule(itemsFilter, head, tail, isForced, isSilent));
                }
                return rules;
            }
            if (isItemRule && isDynamicRule) {
                String[] ruleParts = (String[])Arrays.stream(ruleText.split(Pattern.quote(NAME_TOKEN))).map(s -> s.split(Pattern.quote(DYN_CMD_TOKEN))).flatMap(Arrays::stream).toArray(String[]::new);
                if (ruleParts.length > 3) {
                    throw new ParseException("Incorrectly rule segments: " + ruleText, 0);
                }
                Expression head = Objects.requireNonNull(this.parseCustomRuleSegment(locale, ruleParts[0], false, item, null));
                Expression mid = Objects.requireNonNull(this.parseCustomRuleSegment(locale, ruleParts[1], false, item, null));
                Expression tail = ruleParts.length > 2 ? this.parseCustomRuleSegment(locale, ruleParts[2], true, item, null) : null;
                boolean isNameFirst = ruleText.indexOf(NAME_TOKEN) < ruleText.indexOf(DYN_CMD_TOKEN);
                return List.of(this.restrictedDynamicItemRule(item, itemsFilter, head, mid, tail, isNameFirst, isForced, isSilent));
            }
            if (isDynamicRule) {
                String[] ruleParts = ruleText.split(Pattern.quote(DYN_CMD_TOKEN));
                if (ruleParts.length > 2) {
                    throw new ParseException("Incorrectly rule segments: " + ruleText, 0);
                }
                Expression head = Objects.requireNonNull(this.parseCustomRuleSegment(locale, ruleParts[0], false, item, null));
                Expression tail = ruleParts.length > 1 ? this.parseCustomRuleSegment(locale, ruleParts[1], true, item, null) : null;
                return List.of(this.customDynamicRule(item, itemsFilter, head, tail, isForced, isSilent));
            }
            if (isCommandRule) {
                CommandDescription itemCMDs = item.getCommandDescription();
                if (itemCMDs == null || itemCMDs.getCommandOptions().isEmpty()) {
                    throw new ParseException("Missing item " + item.getName() + " command description.", 0);
                }
                ArrayList<Rule> rules = new ArrayList<Rule>();
                for (CommandOption cmd : itemCMDs.getCommandOptions()) {
                    String label = cmd.getLabel();
                    if (label == null) {
                        label = cmd.getCommand();
                    }
                    String value = cmd.getCommand();
                    String[] cmdInfo = new String[]{label, value};
                    Expression expression = Objects.requireNonNull(this.parseCustomRuleSegment(locale, ruleText, false, item, cmdInfo));
                    rules.add(this.customCommandRule(itemsFilter, expression, isForced, isSilent));
                }
                return rules;
            }
            throw new ParseException("Unable to parse rule: " + ruleText, 0);
        }
        catch (ParseException e) {
            this.logger.warn("Unable to parse item {} rule '{}': {}", new Object[]{item.getName(), ruleText, e.getMessage()});
            return List.of();
        }
    }

    /*
     * WARNING - void declaration
     */
    private @Nullable Expression parseCustomRuleSegment(Locale locale, String text, boolean allowEmpty, Item item, String @Nullable [] cmdData) throws ParseException {
        ArrayList<Expression> subExpressions = new ArrayList<Expression>();
        boolean headHasNonOptional = true;
        for (String s : this.tokenize(locale, text, true)) {
            String trim = s.trim();
            Expression expression = this.parseItemRuleTokenText(locale, trim, item, cmdData);
            Expression expression2 = expression;
            if (expression2 instanceof ExpressionCardinality) {
                void expressionCardinality;
                ExpressionCardinality cfr_ignored_0 = (ExpressionCardinality)expression2;
                ExpressionCardinality cfr_ignored_1 = (ExpressionCardinality)expression2;
                if (!expressionCardinality.isAtLeastOne()) {
                    headHasNonOptional = false;
                }
            } else {
                headHasNonOptional = false;
            }
            subExpressions.add(expression);
        }
        if (headHasNonOptional) {
            if (allowEmpty) {
                return null;
            }
            throw new ParseException("Rule segment contains only optional elements: " + text, 0);
        }
        ExpressionSequence sequenceExpression = this.seq(subExpressions.toArray());
        return sequenceExpression;
    }

    private Expression parseItemRuleTokenText(Locale locale, String tokenText, Item item, String @Nullable [] cmdData) throws ParseException {
        boolean optional = false;
        if (tokenText.equals(CMD_TOKEN) && cmdData != null) {
            ExpressionSequence cmdExpression = this.seq(this.tokenize(locale, cmdData[0]).toArray());
            return this.cmd((Object)cmdExpression, TypeParser.parseCommand((List)item.getAcceptedCommandTypes(), (String)cmdData[1]));
        }
        if (tokenText.endsWith("?")) {
            tokenText = tokenText.substring(0, tokenText.length() - 1);
            optional = true;
        }
        if (tokenText.contains("?")) {
            throw new ParseException("The character '?' can only be used at the end of the expression", 0);
        }
        if ("|".equals(tokenText)) {
            throw new ParseException("The character '|' can not be used alone", 0);
        }
        ExpressionSequence expression = this.seq(tokenText.contains("|") ? this.alt(Arrays.stream(tokenText.split("\\|")).filter(s -> !s.isBlank()).toArray()) : tokenText);
        if (optional) {
            return this.opt(expression);
        }
        return expression;
    }

    @Override
    public Set<String> getSupportedGrammarFormats() {
        return SUPPORTED_GRAMMERS;
    }

    @Override
    public @Nullable String getGrammar(Locale locale, String format) {
        if (!JSGF.equals(format)) {
            return null;
        }
        JSGFGenerator generator = new JSGFGenerator(ResourceBundle.getBundle(LANGUAGE_SUPPORT, locale));
        return generator.getGrammar();
    }

    protected static interface ItemCommandSupplier {
        public @Nullable Command getItemCommand(Item var1);

        public String getCommandLabel();

        public List<Class<? extends Command>> getCommandClasses(@Nullable Item var1);
    }

    public record ItemFilter(Set<String> itemNames, Set<String> excludedItemNames, Set<String> itemTags, Set<String> itemSemantics) {
        private static final ItemFilter ALL_INSTANCE = new ItemFilter(Set.of(), Set.of(), Set.of(), Set.of());

        public boolean filterItem(Item item, MetadataRegistry metadataRegistry) {
            if (!this.itemNames.isEmpty() && !this.itemNames.contains(item.getName())) {
                return false;
            }
            if (!this.excludedItemNames.isEmpty() && this.excludedItemNames.contains(item.getName())) {
                return false;
            }
            if (!(this.itemTags.isEmpty() || item.getTags().size() == this.itemTags.size() && item.getTags().containsAll(this.itemTags))) {
                return false;
            }
            Metadata semanticsMetadata = (Metadata)metadataRegistry.get((Object)new MetadataKey(AbstractRuleBasedInterpreter.SEMANTICS_NAMESPACE, item.getName()));
            return this.itemSemantics.isEmpty() || semanticsMetadata != null && this.itemSemantics.contains(semanticsMetadata.getValue());
        }

        public static ItemFilter all() {
            return ALL_INSTANCE;
        }

        public static ItemFilter forItem(Item item) {
            return new ItemFilter(Set.of(item.getName()), Set.of(), Set.of(), Set.of());
        }

        public static ItemFilter forItems(Set<Item> item) {
            return new ItemFilter(item.stream().map(Item::getName).collect(Collectors.toSet()), Set.of(), Set.of(), Set.of());
        }

        public static ItemFilter forSimilarItem(Item item, @Nullable Metadata semantic) {
            return new ItemFilter(Set.of(), Set.of(item.getName()), item.getTags(), semantic != null ? Set.of(semantic.getValue()) : Set.of());
        }
    }

    private static class ItemInterpretationMetadata {
        final List<List<List<String>>> pathToItem = new ArrayList<List<List<String>>>();
        final List<String> locationParentNames = new ArrayList<String>();

        ItemInterpretationMetadata() {
        }
    }

    private class JSGFGenerator {
        private ResourceBundle language;
        private Map<Expression, Integer> ids = new HashMap<Expression, Integer>();
        private Set<Expression> exported = new HashSet<Expression>();
        private Set<Expression> shared = new HashSet<Expression>();
        private int counter = 0;
        private Set<String> identifierExcludes = new HashSet<String>();
        private Set<String> identifiers = new HashSet<String>();
        private StringBuilder builder = new StringBuilder();

        JSGFGenerator(ResourceBundle language) {
            this.language = language;
        }

        private void addChildren(Expression exp) {
            for (Expression se : exp.getChildExpressions()) {
                this.addExpression(se);
            }
        }

        private int addExpression(Expression exp) {
            if (this.ids.containsKey(exp)) {
                this.shared.add(exp);
                return this.ids.get(exp);
            }
            int id = this.counter++;
            this.ids.put(exp, id);
            this.addChildren(exp);
            return id;
        }

        private int addExportedExpression(Expression exp) {
            this.shared.add(exp);
            this.exported.add(exp);
            return this.addExpression(exp);
        }

        private Expression unwrapLet(Expression expression) {
            Expression exp = expression;
            while (exp instanceof ExpressionLet) {
                exp = ((ExpressionLet)expression).getSubExpression();
            }
            return exp;
        }

        private void emit(@Nullable Object obj) {
            this.builder.append(obj);
        }

        private void emitName(Expression expression) {
            this.emit("r");
            this.emit(this.ids.get(this.unwrapLet(expression)));
        }

        private void emitReference(Expression expression) {
            this.emit("<");
            this.emitName(expression);
            this.emit(">");
        }

        private void emitDefinition(Expression expression) {
            if (this.exported.contains(expression)) {
                this.emit("public ");
            }
            this.emit("<");
            this.emitName(expression);
            this.emit("> = ");
            this.emitExpression(expression);
            this.emit(";\n\n");
        }

        private void emitUse(Expression expression) {
            if (this.shared.contains(expression)) {
                this.emitReference(expression);
            } else {
                this.emitExpression(expression);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void emitExpression(Expression expression) {
            Expression unwrappedExpression = this.unwrapLet(expression);
            Expression expression2 = unwrappedExpression;
            if (expression2 instanceof ExpressionMatch) {
                void match;
                ExpressionMatch expressionMatch = (ExpressionMatch)expression2;
                ExpressionMatch cfr_ignored_0 = (ExpressionMatch)expression2;
                this.emitMatchExpression((ExpressionMatch)match);
            } else {
                Expression expression3 = unwrappedExpression;
                if (expression3 instanceof ExpressionSequence) {
                    void sequence;
                    ExpressionSequence expressionSequence = (ExpressionSequence)expression3;
                    ExpressionSequence cfr_ignored_1 = (ExpressionSequence)expression3;
                    this.emitSequenceExpression((ExpressionSequence)sequence);
                } else {
                    Expression expression4 = unwrappedExpression;
                    if (expression4 instanceof ExpressionAlternatives) {
                        void alternatives;
                        ExpressionAlternatives expressionAlternatives = (ExpressionAlternatives)expression4;
                        ExpressionAlternatives cfr_ignored_2 = (ExpressionAlternatives)expression4;
                        this.emitAlternativesExpression((ExpressionAlternatives)alternatives);
                    } else {
                        Expression expression5 = unwrappedExpression;
                        if (expression5 instanceof ExpressionCardinality) {
                            void cardinality;
                            ExpressionCardinality expressionCardinality = (ExpressionCardinality)expression5;
                            ExpressionCardinality cfr_ignored_3 = (ExpressionCardinality)expression5;
                            this.emitCardinalExpression((ExpressionCardinality)cardinality);
                        } else {
                            Expression expression6 = unwrappedExpression;
                            if (expression6 instanceof ExpressionIdentifier) {
                                void identifier;
                                ExpressionIdentifier expressionIdentifier = (ExpressionIdentifier)expression6;
                                ExpressionIdentifier cfr_ignored_4 = (ExpressionIdentifier)expression6;
                                this.emitItemIdentifierExpression((ExpressionIdentifier)identifier);
                            }
                        }
                    }
                }
            }
        }

        private void emitMatchExpression(ExpressionMatch expression) {
            this.emit(expression.getPattern());
        }

        private void emitSequenceExpression(ExpressionSequence expression) {
            this.emitGroup(" ", expression.getChildExpressions());
        }

        private void emitAlternativesExpression(ExpressionAlternatives expression) {
            this.emitGroup(" | ", expression.getChildExpressions());
        }

        private void emitCardinalExpression(ExpressionCardinality expression) {
            if (!expression.isAtLeastOne() && !expression.isAtMostOne()) {
                this.emitUse(expression.getSubExpression());
                this.emit("*");
            } else if (expression.isAtLeastOne()) {
                this.emitUse(expression.getSubExpression());
                this.emit("+");
            } else if (expression.isAtMostOne()) {
                this.emit("[");
                this.emitUse(expression.getSubExpression());
                this.emit("]");
            } else {
                this.emitUse(expression.getSubExpression());
            }
        }

        private void emitItemIdentifierExpression(ExpressionIdentifier expression) {
            Set<Object> excludes;
            HashSet<String> remainder = new HashSet<String>(this.identifierExcludes);
            Expression stopper = expression.getStopper();
            Set<Object> set = excludes = stopper == null ? new HashSet() : stopper.getFirsts(this.language);
            if (!excludes.isEmpty()) {
                remainder.removeAll(excludes);
                if (!remainder.isEmpty()) {
                    this.emit("(");
                }
                this.emit("<idbase>");
                for (String token : remainder) {
                    this.emit(" | ");
                    this.emit(token);
                }
                if (!remainder.isEmpty()) {
                    this.emit(")");
                }
            } else {
                this.emit("<idpart>");
            }
        }

        private void emitGroup(String separator, List<Expression> expressions) {
            int l = expressions.size();
            if (l > 0) {
                this.emit("(");
            }
            int i = 0;
            while (i < l) {
                if (i > 0) {
                    this.emit(separator);
                }
                this.emitUse(expressions.get(i));
                ++i;
            }
            if (l > 0) {
                this.emit(")");
            }
        }

        private void emitSet(Set<String> set, String separator) {
            boolean sep = false;
            for (String p : set) {
                if (sep) {
                    this.emit(separator);
                } else {
                    sep = true;
                }
                this.emit(p);
            }
        }

        /*
         * WARNING - void declaration
         */
        protected String getGrammar() {
            Rule[] rules = AbstractRuleBasedInterpreter.this.getRules(this.language.getLocale());
            this.identifiers.addAll(AbstractRuleBasedInterpreter.this.getAllItemTokens(this.language.getLocale()));
            Object object = rules;
            int n = rules.length;
            int n2 = 0;
            while (n2 < n) {
                Rule rule = object[n2];
                Expression e = rule.getExpression();
                this.addExportedExpression(e);
                ++n2;
            }
            for (Expression e : this.ids.keySet()) {
                void identifier;
                object = e;
                if (!(object instanceof ExpressionIdentifier)) continue;
                ExpressionIdentifier cfr_ignored_0 = (ExpressionIdentifier)object;
                ExpressionIdentifier cfr_ignored_1 = (ExpressionIdentifier)object;
                Expression stopper = identifier.getStopper();
                if (stopper == null) continue;
                this.identifierExcludes.addAll(stopper.getFirsts(this.language));
            }
            this.emit("#JSGF V1.0;\n\n");
            if (!this.identifierExcludes.isEmpty()) {
                HashSet<String> identifierBase = new HashSet<String>(this.identifiers);
                identifierBase.removeAll(this.identifierExcludes);
                this.emit("<idbase> = ");
                this.emitSet(identifierBase, " | ");
                this.emit(";\n\n<idpart> = <idbase> | ");
                this.emitSet(this.identifierExcludes, " | ");
                this.emit(";\n\n");
            } else {
                this.emit("<idpart> = ");
                this.emitSet(this.identifiers, " | ");
                this.emit(";\n\n");
            }
            for (Expression e : this.shared) {
                this.emitDefinition(e);
            }
            return this.builder.toString();
        }
    }

    private record SingleCommandSupplier(Command command) implements ItemCommandSupplier
    {
        @Override
        public @Nullable Command getItemCommand(Item ignored) {
            return this.command;
        }

        @Override
        public String getCommandLabel() {
            return this.command.toFullString();
        }

        @Override
        public List<Class<? extends Command>> getCommandClasses(@Nullable Item ignored) {
            return List.of(this.command.getClass());
        }
    }

    private record TextCommandSupplier(String text, List<Class<? extends Command>> allowedCommands, Map<String, String> transformations) implements ItemCommandSupplier
    {
        @Override
        public @Nullable Command getItemCommand(Item item) {
            return TypeParser.parseCommand((List)item.getAcceptedCommandTypes(), (String)this.transformations.getOrDefault(this.text, this.text));
        }

        @Override
        public String getCommandLabel() {
            return this.text;
        }

        @Override
        public List<Class<? extends Command>> getCommandClasses(@Nullable Item ignored) {
            return this.allowedCommands;
        }
    }
}

