/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) + u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(2666666666666666518ul, 170ul, 188ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) + u64vec3(167ul, 66ul, 187ul)) => u64vec3(1333333333333333426ul, 151ul, 281ul)
 * (u64vec3(167ul, 66ul, 187ul) + u64vec3(1333333333333333259ul, 85ul, 94ul)) => u64vec3(1333333333333333426ul, 151ul, 281ul)
 * (u64vec3(167ul, 66ul, 187ul) + u64vec3(167ul, 66ul, 187ul)) => u64vec3(334ul, 132ul, 374ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) + u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(2666666666666666518ul, 170ul, 188ul))) ? 1 : -1] array0;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) + u64vec3(167ul, 66ul, 187ul)), u64vec3(1333333333333333426ul, 151ul, 281ul))) ? 1 : -1] array1;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) + u64vec3(1333333333333333259ul, 85ul, 94ul)), u64vec3(1333333333333333426ul, 151ul, 281ul))) ? 1 : -1] array2;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) + u64vec3(167ul, 66ul, 187ul)), u64vec3(334ul, 132ul, 374ul))) ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
