/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * pow(vec3(0.0, 0.0, 0.6666667), vec3(0.6666667, 2.0, -2.0)) => vec3(0.0, 0.0, 2.2499998)
 * pow(vec3(0.6666667, 0.6666667, 0.6666667), vec3(-0.6666667, 0.6666667, 2.0)) => vec3(1.3103707, 0.7631428, 0.44444448)
 * pow(vec3(1.3333334, 1.3333334, 1.3333334), vec3(-2.0, -0.6666667, 0.6666667)) => vec3(0.56249994, 0.8254818, 1.2114137)
 * pow(vec3(1.3333334, 2.0, 2.0), vec3(2.0, -2.0, -0.6666667)) => vec3(1.7777779, 0.25, 0.62996054)
 * pow(vec3(2.0, 2.0, 0.0), vec3(0.6666667, 2.0, 0.6666667)) => vec3(1.587401, 4.0, 0.0)
 */
#version 120

void main()
{
  float[distance(pow(vec3(0.0, 0.0, 0.6666667), vec3(0.6666667, 2.0, -2.0)), vec3(0.0, 0.0, 2.2499998)) <= 2.2499999e-05 ? 1 : -1] array0;
  float[distance(pow(vec3(0.6666667, 0.6666667, 0.6666667), vec3(-0.6666667, 0.6666667, 2.0)), vec3(1.3103707, 0.7631428, 0.44444448)) <= 1.5801865e-05 ? 1 : -1] array1;
  float[distance(pow(vec3(1.3333334, 1.3333334, 1.3333334), vec3(-2.0, -0.6666667, 0.6666667)), vec3(0.56249994, 0.8254818, 1.2114137)) <= 1.5701431e-05 ? 1 : -1] array2;
  float[distance(pow(vec3(1.3333334, 2.0, 2.0), vec3(2.0, -2.0, -0.6666667)), vec3(1.7777779, 0.25, 0.62996054)) <= 1.9025889e-05 ? 1 : -1] array3;
  float[distance(pow(vec3(2.0, 2.0, 0.0), vec3(0.6666667, 2.0, 0.6666667)), vec3(1.587401, 4.0, 0.0)) <= 4.3034684e-05 ? 1 : -1] array4;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length());
}
