/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * round(vec3(-2.0, -1.4285715, -0.85714287)) => vec3(-2.0, -1.0, -1.0)
 * round(vec3(-0.2857143, 0.2857143, 0.85714287)) => vec3(-0.0, 0.0, 1.0)
 * round(vec3(1.4285715, 2.0, -2.0)) => vec3(1.0, 2.0, -2.0)
 */
#version 130

void main()
{
  float[distance(round(vec3(-2.0, -1.4285715, -0.85714287)), vec3(-2.0, -1.0, -1.0)) <= 2.4494897e-05 ? 1 : -1] array0;
  float[distance(round(vec3(-0.2857143, 0.2857143, 0.85714287)), vec3(-0.0, 0.0, 1.0)) <= 1e-05 ? 1 : -1] array1;
  float[distance(round(vec3(1.4285715, 2.0, -2.0)), vec3(1.0, 2.0, -2.0)) <= 3e-05 ? 1 : -1] array2;
  gl_Position = vec4(array0.length() + array1.length() + array2.length());
}
