/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.EnumSet;
import java.util.Locale;
import net.sf.mpxj.DataType;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.LocaleData;

public enum ConstraintField implements FieldType
{
    UNIQUE_ID(DataType.INTEGER),
    TASK1(DataType.INTEGER),
    TASK2(DataType.INTEGER);

    public static final int MAX_VALUE;
    private static final ConstraintField[] TYPE_VALUES;
    private int m_value;
    private DataType m_dataType;
    private FieldType m_unitsType;

    private ConstraintField(DataType dataType) {
        this.m_dataType = dataType;
    }

    @Override
    public FieldTypeClass getFieldTypeClass() {
        return FieldTypeClass.CONSTRAINT;
    }

    @Override
    public String getName() {
        return this.getName(Locale.ENGLISH);
    }

    @Override
    public String getName(Locale locale) {
        String[] stringArray = LocaleData.getStringArray(locale, "CONSTRAINT_COLUMNS");
        String string = null;
        if (this.m_value >= 0 && this.m_value < stringArray.length) {
            string = stringArray[this.m_value];
        }
        return string;
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    @Override
    public DataType getDataType() {
        return this.m_dataType;
    }

    @Override
    public FieldType getUnitsType() {
        return this.m_unitsType;
    }

    public String toString() {
        return this.getName();
    }

    public static ConstraintField getInstance(int n) {
        ConstraintField constraintField = null;
        if (n >= 0 && n < MAX_VALUE) {
            constraintField = TYPE_VALUES[n];
        }
        return constraintField;
    }

    static {
        MAX_VALUE = EnumSet.allOf(ConstraintField.class).size();
        TYPE_VALUES = new ConstraintField[MAX_VALUE];
        int n = 0;
        for (ConstraintField constraintField : EnumSet.allOf(ConstraintField.class)) {
            constraintField.m_value = n++;
            ConstraintField.TYPE_VALUES[constraintField.getValue()] = constraintField;
        }
    }
}

