/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EarnedValueMethod;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FieldTypeClass;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectEntity;
import net.sf.mpxj.ProjectEntityWithID;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.RecurringTask;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskMode;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.TaskFieldLists;
import net.sf.mpxj.listener.FieldListener;

public final class Task
extends ProjectEntity
implements Comparable<Task>,
ProjectEntityWithID,
FieldContainer,
ChildTaskContainer {
    private Object[] m_array = new Object[TaskField.MAX_VALUE];
    private Task m_parent;
    private List<Task> m_children = new LinkedList<Task>();
    private List<ResourceAssignment> m_assignments = new LinkedList<ResourceAssignment>();
    private RecurringTask m_recurringTask;
    private boolean m_eventsEnabled = true;
    private boolean m_null;
    private String m_wbsLevel;
    private boolean m_resumeValid;
    private String m_externalTaskProject;
    private TimeUnit m_levelingDelayFormat;
    private Duration m_actualWorkProtected;
    private Duration m_actualOvertimeWorkProtected;
    private boolean m_expanded = true;
    private List<DateRange> m_splits;
    private Date m_splitsComplete;
    private SubProject m_subProject;
    private List<FieldListener> m_listeners;

    Task(ProjectFile projectFile, Task task) {
        super(projectFile);
        this.setType(TaskType.FIXED_UNITS);
        this.setConstraintType(ConstraintType.AS_SOON_AS_POSSIBLE);
        this.setTaskMode(TaskMode.AUTO_SCHEDULED);
        this.setActive(true);
        this.set((FieldType)TaskField.PREDECESSORS, new LinkedList());
        this.set((FieldType)TaskField.SUCCESSORS, new LinkedList());
        this.m_parent = task;
        ProjectConfig projectConfig = projectFile.getProjectConfig();
        if (projectConfig.getAutoTaskUniqueID()) {
            this.setUniqueID(projectConfig.getNextTaskUniqueID());
        }
        if (projectConfig.getAutoTaskID()) {
            this.setID(projectConfig.getNextTaskID());
        }
        if (projectConfig.getAutoWBS()) {
            this.generateWBS(task);
        }
        if (projectConfig.getAutoOutlineNumber()) {
            this.generateOutlineNumber(task);
        }
        if (projectConfig.getAutoOutlineLevel()) {
            if (task == null) {
                this.setOutlineLevel(1);
            } else {
                this.setOutlineLevel(NumberHelper.getInt(task.getOutlineLevel()) + 1);
            }
        }
    }

    public void generateWBS(Task task) {
        String string;
        if (task == null) {
            string = NumberHelper.getInt(this.getUniqueID()) == 0 ? "0" : Integer.toString(this.getParentFile().getChildTasks().size() + 1);
        } else {
            string = task.getWBS();
            int n = task.getChildTasks().size() + 1;
            string = string.equals("0") ? Integer.toString(n) : string + "." + n;
        }
        this.setWBS(string);
    }

    public void generateOutlineNumber(Task task) {
        String string;
        if (task == null) {
            string = NumberHelper.getInt(this.getUniqueID()) == 0 ? "0" : Integer.toString(this.getParentFile().getChildTasks().size() + 1);
        } else {
            string = task.getOutlineNumber();
            int n = string.lastIndexOf(".0");
            if (n != -1) {
                string = string.substring(0, n);
            }
            int n2 = task.getChildTasks().size() + 1;
            string = string.equals("0") ? Integer.toString(n2) : string + "." + n2;
        }
        this.setOutlineNumber(string);
    }

    public void setNotes(String string) {
        this.set((FieldType)TaskField.NOTES, string);
    }

    @Override
    public Task addTask() {
        ProjectFile projectFile = this.getParentFile();
        Task task = new Task(projectFile, this);
        this.m_children.add(task);
        projectFile.getTasks().add(task);
        this.setSummary(true);
        return task;
    }

    public void addChildTask(Task task, int n) {
        int n2 = NumberHelper.getInt(this.getOutlineLevel());
        if (n2 + 1 == n) {
            this.m_children.add(task);
            this.setSummary(true);
        } else if (!this.m_children.isEmpty()) {
            this.m_children.get(this.m_children.size() - 1).addChildTask(task, n);
        }
    }

    public void addChildTask(Task task) {
        task.m_parent = this;
        this.m_children.add(task);
        this.setSummary(true);
        if (this.getParentFile().getProjectConfig().getAutoOutlineLevel()) {
            task.setOutlineLevel(NumberHelper.getInt(this.getOutlineLevel()) + 1);
        }
    }

    public void addChildTaskBefore(Task task, Task task2) {
        int n = this.m_children.indexOf(task2);
        if (n == -1) {
            this.m_children.add(task);
        } else {
            this.m_children.add(n, task);
        }
        task.m_parent = this;
        this.setSummary(true);
        if (this.getParentFile().getProjectConfig().getAutoOutlineLevel()) {
            task.setOutlineLevel(NumberHelper.getInt(this.getOutlineLevel()) + 1);
        }
    }

    public void removeChildTask(Task task) {
        if (this.m_children.remove(task)) {
            task.m_parent = null;
        }
        this.setSummary(!this.m_children.isEmpty());
    }

    public void clearChildTasks() {
        this.m_children.clear();
        this.setSummary(false);
    }

    public RecurringTask addRecurringTask() {
        if (this.m_recurringTask == null) {
            this.m_recurringTask = new RecurringTask();
        }
        return this.m_recurringTask;
    }

    public RecurringTask getRecurringTask() {
        return this.m_recurringTask;
    }

    public ResourceAssignment addResourceAssignment(Resource resource) {
        ResourceAssignment resourceAssignment = this.getExistingResourceAssignment(resource);
        if (resourceAssignment == null) {
            resourceAssignment = new ResourceAssignment(this.getParentFile(), this);
            this.m_assignments.add(resourceAssignment);
            this.getParentFile().getResourceAssignments().add(resourceAssignment);
            resourceAssignment.setTaskUniqueID(this.getUniqueID());
            resourceAssignment.setWork(this.getDuration());
            resourceAssignment.setUnits(ResourceAssignment.DEFAULT_UNITS);
            if (resource != null) {
                resourceAssignment.setResourceUniqueID(resource.getUniqueID());
                resource.addResourceAssignment(resourceAssignment);
            }
        }
        return resourceAssignment;
    }

    public void addResourceAssignment(ResourceAssignment resourceAssignment) {
        if (this.getExistingResourceAssignment(resourceAssignment.getResource()) == null) {
            this.m_assignments.add(resourceAssignment);
            this.getParentFile().getResourceAssignments().add(resourceAssignment);
            Resource resource = resourceAssignment.getResource();
            if (resource != null) {
                resource.addResourceAssignment(resourceAssignment);
            }
        }
    }

    private ResourceAssignment getExistingResourceAssignment(Resource resource) {
        ResourceAssignment resourceAssignment = null;
        Integer n = null;
        if (resource != null) {
            Integer n2;
            Iterator<ResourceAssignment> iterator = this.m_assignments.iterator();
            n = resource.getUniqueID();
            while (iterator.hasNext() && ((n2 = (resourceAssignment = iterator.next()).getResourceUniqueID()) == null || !n2.equals(n))) {
                resourceAssignment = null;
            }
        }
        return resourceAssignment;
    }

    public List<ResourceAssignment> getResourceAssignments() {
        return this.m_assignments;
    }

    void removeResourceAssignment(ResourceAssignment resourceAssignment) {
        this.m_assignments.remove(resourceAssignment);
    }

    public Relation addPredecessor(Task task, RelationType relationType, Duration duration) {
        if (duration == null) {
            duration = Duration.getInstance(0, TimeUnit.DAYS);
        }
        List list = (List)this.getCachedValue(TaskField.PREDECESSORS);
        Relation relation2 = null;
        for (Relation relation2 : list) {
            if (relation2.getTargetTask() == task) {
                if (relation2.getType() == relationType && relation2.getLag().compareTo(duration) == 0) break;
                relation2 = null;
                break;
            }
            relation2 = null;
        }
        if (relation2 == null) {
            relation2 = new Relation(this, task, relationType, duration);
            list.add(relation2);
        }
        List list2 = (List)task.getCachedValue(TaskField.SUCCESSORS);
        Relation relation32 = null;
        for (Relation relation32 : list2) {
            if (relation32.getTargetTask() == this) {
                if (relation32.getType() == relationType && relation32.getLag().compareTo(duration) == 0) break;
                relation32 = null;
                break;
            }
            relation32 = null;
        }
        if (relation32 == null) {
            relation32 = new Relation(task, this, relationType, duration);
            list2.add(relation32);
        }
        return relation2;
    }

    public void setPercentageComplete(Number number) {
        this.set((FieldType)TaskField.PERCENT_COMPLETE, number);
    }

    public void setPercentageWorkComplete(Number number) {
        this.set((FieldType)TaskField.PERCENT_WORK_COMPLETE, number);
    }

    public void setActualCost(Number number) {
        this.set((FieldType)TaskField.ACTUAL_COST, number);
    }

    public void setActualDuration(Duration duration) {
        this.set((FieldType)TaskField.ACTUAL_DURATION, duration);
    }

    public void setActualFinish(Date date) {
        this.set((FieldType)TaskField.ACTUAL_FINISH, date);
    }

    public void setActualStart(Date date) {
        this.set((FieldType)TaskField.ACTUAL_START, date);
    }

    public void setActualWork(Duration duration) {
        this.set((FieldType)TaskField.ACTUAL_WORK, duration);
    }

    public void setBaselineCost(Number number) {
        this.set((FieldType)TaskField.BASELINE_COST, number);
    }

    public void setBaselineDuration(Duration duration) {
        this.set((FieldType)TaskField.BASELINE_DURATION, duration);
    }

    public void setBaselineFinish(Date date) {
        this.set((FieldType)TaskField.BASELINE_FINISH, date);
    }

    public void setBaselineStart(Date date) {
        this.set((FieldType)TaskField.BASELINE_START, date);
    }

    public void setBaselineWork(Duration duration) {
        this.set((FieldType)TaskField.BASELINE_WORK, duration);
    }

    public void setBCWP(Number number) {
        this.set((FieldType)TaskField.BCWP, number);
    }

    public void setBCWS(Number number) {
        this.set((FieldType)TaskField.BCWS, number);
    }

    public void setConfirmed(boolean bl) {
        this.set((FieldType)TaskField.CONFIRMED, bl);
    }

    public void setConstraintDate(Date date) {
        this.set((FieldType)TaskField.CONSTRAINT_DATE, date);
    }

    public void setConstraintType(ConstraintType constraintType) {
        this.set((FieldType)TaskField.CONSTRAINT_TYPE, constraintType);
    }

    public void setContact(String string) {
        this.set((FieldType)TaskField.CONTACT, string);
    }

    public void setCost(Number number) {
        this.set((FieldType)TaskField.COST, number);
    }

    public void setCost(int n, Number number) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_COST, n), number);
    }

    public Number getCost(int n) {
        return (Number)this.getCachedValue(this.selectField(TaskFieldLists.CUSTOM_COST, n));
    }

    public void setCostVariance(Number number) {
        this.set((FieldType)TaskField.COST_VARIANCE, number);
    }

    public void setCreateDate(Date date) {
        this.set((FieldType)TaskField.CREATED, date);
    }

    public void setCritical(boolean bl) {
        this.set((FieldType)TaskField.CRITICAL, bl);
    }

    public void setCV(Number number) {
        this.set((FieldType)TaskField.CV, number);
    }

    public void setLevelingDelay(Duration duration) {
        this.set((FieldType)TaskField.LEVELING_DELAY, duration);
    }

    public void setDuration(Duration duration) {
        this.set((FieldType)TaskField.DURATION, duration);
    }

    public void setDurationText(String string) {
        this.set((FieldType)TaskField.DURATION_TEXT, string);
    }

    public void setManualDuration(Duration duration) {
        this.set((FieldType)TaskField.MANUAL_DURATION, duration);
    }

    public Duration getManualDuration() {
        return (Duration)this.getCachedValue(TaskField.MANUAL_DURATION);
    }

    public void setDurationVariance(Duration duration) {
        this.set((FieldType)TaskField.DURATION_VARIANCE, duration);
    }

    public void setEarlyFinish(Date date) {
        this.set((FieldType)TaskField.EARLY_FINISH, date);
    }

    public void setEarlyStart(Date date) {
        this.set((FieldType)TaskField.EARLY_START, date);
    }

    public void setFinish(Date date) {
        this.set((FieldType)TaskField.FINISH, date);
    }

    public void setFinishText(String string) {
        this.set((FieldType)TaskField.FINISH_TEXT, string);
    }

    public void setFinishVariance(Duration duration) {
        this.set((FieldType)TaskField.FINISH_VARIANCE, duration);
    }

    public void setFixedCost(Number number) {
        this.set((FieldType)TaskField.FIXED_COST, number);
    }

    public void setFreeSlack(Duration duration) {
        this.set((FieldType)TaskField.FREE_SLACK, duration);
    }

    public void setHideBar(boolean bl) {
        this.set((FieldType)TaskField.HIDE_BAR, bl);
    }

    @Override
    public void setID(Integer n) {
        ProjectFile projectFile = this.getParentFile();
        Integer n2 = this.getID();
        if (n2 != null) {
            projectFile.getTasks().unmapID(n2);
        }
        projectFile.getTasks().mapID(n, this);
        this.set((FieldType)TaskField.ID, n);
    }

    public void setLateFinish(Date date) {
        this.set((FieldType)TaskField.LATE_FINISH, date);
    }

    public void setLateStart(Date date) {
        this.set((FieldType)TaskField.LATE_START, date);
    }

    public void setLinkedFields(boolean bl) {
        this.set((FieldType)TaskField.LINKED_FIELDS, bl);
    }

    public void setMarked(boolean bl) {
        this.set((FieldType)TaskField.MARKED, bl);
    }

    public void setMilestone(boolean bl) {
        this.set((FieldType)TaskField.MILESTONE, bl);
    }

    public void setName(String string) {
        this.set((FieldType)TaskField.NAME, string);
    }

    public void setObjects(Integer n) {
        this.set((FieldType)TaskField.OBJECTS, n);
    }

    public void setOutlineLevel(Integer n) {
        this.set((FieldType)TaskField.OUTLINE_LEVEL, n);
    }

    public void setOutlineNumber(String string) {
        this.set((FieldType)TaskField.OUTLINE_NUMBER, string);
    }

    public void setPriority(Priority priority) {
        this.set((FieldType)TaskField.PRIORITY, priority);
    }

    public void setProject(String string) {
        this.set((FieldType)TaskField.PROJECT, string);
    }

    public void setRemainingCost(Number number) {
        this.set((FieldType)TaskField.REMAINING_COST, number);
    }

    public void setRemainingDuration(Duration duration) {
        this.set((FieldType)TaskField.REMAINING_DURATION, duration);
    }

    public void setRemainingWork(Duration duration) {
        this.set((FieldType)TaskField.REMAINING_WORK, duration);
    }

    public void setResourceGroup(String string) {
        this.set((FieldType)TaskField.RESOURCE_GROUP, string);
    }

    public void setResourceInitials(String string) {
        this.set((FieldType)TaskField.RESOURCE_INITIALS, string);
    }

    public void setResourceNames(String string) {
        this.set((FieldType)TaskField.RESOURCE_NAMES, string);
    }

    public void setResume(Date date) {
        this.set((FieldType)TaskField.RESUME, date);
    }

    public void setRollup(boolean bl) {
        this.set((FieldType)TaskField.ROLLUP, bl);
    }

    public void setStart(Date date) {
        this.set((FieldType)TaskField.START, date);
    }

    public void setStartText(String string) {
        this.set((FieldType)TaskField.START_TEXT, string);
    }

    public void setStartVariance(Duration duration) {
        this.set((FieldType)TaskField.START_VARIANCE, duration);
    }

    public void setStop(Date date) {
        this.set((FieldType)TaskField.STOP, date);
    }

    public void setSubprojectName(String string) {
        this.set((FieldType)TaskField.SUBPROJECT_FILE, string);
    }

    public void setSummary(boolean bl) {
        this.set((FieldType)TaskField.SUMMARY, bl);
    }

    public void setSV(Number number) {
        this.set((FieldType)TaskField.SV, number);
    }

    public void setTotalSlack(Duration duration) {
        this.set((FieldType)TaskField.TOTAL_SLACK, duration);
    }

    @Override
    public void setUniqueID(Integer n) {
        this.set((FieldType)TaskField.UNIQUE_ID, n);
    }

    public void setUpdateNeeded(boolean bl) {
        this.set((FieldType)TaskField.UPDATE_NEEDED, bl);
    }

    public void setWBS(String string) {
        this.set((FieldType)TaskField.WBS, string);
    }

    public void setWork(Duration duration) {
        this.set((FieldType)TaskField.WORK, duration);
    }

    public void setWorkVariance(Duration duration) {
        this.set((FieldType)TaskField.WORK_VARIANCE, duration);
    }

    public Number getPercentageComplete() {
        return (Number)this.getCachedValue(TaskField.PERCENT_COMPLETE);
    }

    public Number getPercentageWorkComplete() {
        return (Number)this.getCachedValue(TaskField.PERCENT_WORK_COMPLETE);
    }

    public Number getActualCost() {
        return (Number)this.getCachedValue(TaskField.ACTUAL_COST);
    }

    public Duration getActualDuration() {
        return (Duration)this.getCachedValue(TaskField.ACTUAL_DURATION);
    }

    public Date getActualFinish() {
        return (Date)this.getCachedValue(TaskField.ACTUAL_FINISH);
    }

    public Date getActualStart() {
        return (Date)this.getCachedValue(TaskField.ACTUAL_START);
    }

    public Duration getActualWork() {
        return (Duration)this.getCachedValue(TaskField.ACTUAL_WORK);
    }

    public Number getBaselineCost() {
        return (Number)this.getCachedValue(TaskField.BASELINE_COST);
    }

    public Duration getBaselineDuration() {
        Object object = this.getCachedValue(TaskField.BASELINE_DURATION);
        if (object == null) {
            object = this.getCachedValue(TaskField.BASELINE_ESTIMATED_DURATION);
        }
        if (!(object instanceof Duration)) {
            object = null;
        }
        return (Duration)object;
    }

    public String getBaselineDurationText() {
        Object object = this.getCachedValue(TaskField.BASELINE_DURATION);
        if (object == null) {
            object = this.getCachedValue(TaskField.BASELINE_ESTIMATED_DURATION);
        }
        if (!(object instanceof String)) {
            object = null;
        }
        return (String)object;
    }

    public void setBaselineDurationText(String string) {
        this.set((FieldType)TaskField.BASELINE_DURATION, string);
    }

    public Date getBaselineFinish() {
        Object object = this.getCachedValue(TaskField.BASELINE_FINISH);
        if (object == null) {
            object = this.getCachedValue(TaskField.BASELINE_ESTIMATED_FINISH);
        }
        if (!(object instanceof Date)) {
            object = null;
        }
        return (Date)object;
    }

    public String getBaselineFinishText() {
        Object object = this.getCachedValue(TaskField.BASELINE_FINISH);
        if (object == null) {
            object = this.getCachedValue(TaskField.BASELINE_ESTIMATED_FINISH);
        }
        if (!(object instanceof String)) {
            object = null;
        }
        return (String)object;
    }

    public void setBaselineFinishText(String string) {
        this.set((FieldType)TaskField.BASELINE_FINISH, string);
    }

    public Date getBaselineStart() {
        Object object = this.getCachedValue(TaskField.BASELINE_START);
        if (object == null) {
            object = this.getCachedValue(TaskField.BASELINE_ESTIMATED_START);
        }
        if (!(object instanceof Date)) {
            object = null;
        }
        return (Date)object;
    }

    public String getBaselineStartText() {
        Object object = this.getCachedValue(TaskField.BASELINE_START);
        if (object == null) {
            object = this.getCachedValue(TaskField.BASELINE_ESTIMATED_START);
        }
        if (!(object instanceof String)) {
            object = null;
        }
        return (String)object;
    }

    public void setBaselineStartText(String string) {
        this.set((FieldType)TaskField.BASELINE_START, string);
    }

    public Duration getBaselineWork() {
        return (Duration)this.getCachedValue(TaskField.BASELINE_WORK);
    }

    public Number getBCWP() {
        return (Number)this.getCachedValue(TaskField.BCWP);
    }

    public Number getBCWS() {
        return (Number)this.getCachedValue(TaskField.BCWS);
    }

    public boolean getConfirmed() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.CONFIRMED));
    }

    public Date getConstraintDate() {
        return (Date)this.getCachedValue(TaskField.CONSTRAINT_DATE);
    }

    public ConstraintType getConstraintType() {
        return (ConstraintType)this.getCachedValue(TaskField.CONSTRAINT_TYPE);
    }

    public String getContact() {
        return (String)this.getCachedValue(TaskField.CONTACT);
    }

    public Number getCost() {
        return (Number)this.getCachedValue(TaskField.COST);
    }

    public Number getCostVariance() {
        Number number = (Number)this.getCachedValue(TaskField.COST_VARIANCE);
        if (number == null) {
            Number number2 = this.getCost();
            Number number3 = this.getBaselineCost();
            if (number2 != null && number3 != null) {
                number = NumberHelper.getDouble(number2.doubleValue() - number3.doubleValue());
                this.set((FieldType)TaskField.COST_VARIANCE, number);
            }
        }
        return number;
    }

    public Date getCreateDate() {
        return (Date)this.getCachedValue(TaskField.CREATED);
    }

    public boolean getCritical() {
        Boolean bl = (Boolean)this.getCachedValue(TaskField.CRITICAL);
        if (bl == null) {
            Duration duration = this.getTotalSlack();
            ProjectProperties projectProperties = this.getParentFile().getProjectProperties();
            int n = NumberHelper.getInt(projectProperties.getCriticalSlackLimit());
            if (n != 0 && duration.getDuration() != 0.0 && duration.getUnits() != TimeUnit.DAYS) {
                duration = duration.convertUnits(TimeUnit.DAYS, projectProperties);
            }
            bl = duration.getDuration() <= (double)n && NumberHelper.getInt(this.getPercentageComplete()) != 100 && (this.getTaskMode() == TaskMode.AUTO_SCHEDULED || this.getDurationText() == null && this.getStartText() == null && this.getFinishText() == null);
            this.set((FieldType)TaskField.CRITICAL, bl);
        }
        return BooleanHelper.getBoolean(bl);
    }

    public Number getCV() {
        Number number = (Number)this.getCachedValue(TaskField.CV);
        if (number == null) {
            number = NumberHelper.getDouble(this.getBCWP()) - NumberHelper.getDouble(this.getACWP());
            this.set((FieldType)TaskField.CV, number);
        }
        return number;
    }

    public Duration getLevelingDelay() {
        return (Duration)this.getCachedValue(TaskField.LEVELING_DELAY);
    }

    public Duration getDuration() {
        return (Duration)this.getCachedValue(TaskField.DURATION);
    }

    public String getDurationText() {
        return (String)this.getCachedValue(TaskField.DURATION_TEXT);
    }

    public void setDuration(int n, Duration duration) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_DURATION, n), duration);
    }

    public Duration getDuration(int n) {
        return (Duration)this.getCachedValue(this.selectField(TaskFieldLists.CUSTOM_DURATION, n));
    }

    public Duration getDurationVariance() {
        Duration duration = (Duration)this.getCachedValue(TaskField.DURATION_VARIANCE);
        if (duration == null) {
            Duration duration2 = this.getDuration();
            Duration duration3 = this.getBaselineDuration();
            if (duration2 != null && duration3 != null) {
                duration = Duration.getInstance(duration2.getDuration() - duration3.convertUnits(duration2.getUnits(), this.getParentFile().getProjectProperties()).getDuration(), duration2.getUnits());
                this.set((FieldType)TaskField.DURATION_VARIANCE, duration);
            }
        }
        return duration;
    }

    public Date getEarlyFinish() {
        return (Date)this.getCachedValue(TaskField.EARLY_FINISH);
    }

    public Date getEarlyStart() {
        return (Date)this.getCachedValue(TaskField.EARLY_START);
    }

    public Date getFinish() {
        return (Date)this.getCachedValue(TaskField.FINISH);
    }

    public String getFinishText() {
        return (String)this.getCachedValue(TaskField.FINISH_TEXT);
    }

    public void setFinish(int n, Date date) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_FINISH, n), date);
    }

    public Date getFinish(int n) {
        return (Date)this.getCachedValue(this.selectField(TaskFieldLists.CUSTOM_FINISH, n));
    }

    public Duration getFinishVariance() {
        Duration duration = (Duration)this.getCachedValue(TaskField.FINISH_VARIANCE);
        if (duration == null) {
            TimeUnit timeUnit = this.getParentFile().getProjectProperties().getDefaultDurationUnits();
            duration = DateHelper.getVariance(this, this.getBaselineFinish(), this.getFinish(), timeUnit);
            this.set((FieldType)TaskField.FINISH_VARIANCE, duration);
        }
        return duration;
    }

    public Number getFixedCost() {
        return (Number)this.getCachedValue(TaskField.FIXED_COST);
    }

    public void setFlag(int n, boolean bl) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_FLAG, n), bl);
    }

    public boolean getFlag(int n) {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(this.selectField(TaskFieldLists.CUSTOM_FLAG, n)));
    }

    public Duration getFreeSlack() {
        return (Duration)this.getCachedValue(TaskField.FREE_SLACK);
    }

    public boolean getHideBar() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.HIDE_BAR));
    }

    @Override
    public Integer getID() {
        return (Integer)this.getCachedValue(TaskField.ID);
    }

    public Date getLateFinish() {
        return (Date)this.getCachedValue(TaskField.LATE_FINISH);
    }

    public Date getLateStart() {
        return (Date)this.getCachedValue(TaskField.LATE_START);
    }

    public boolean getLinkedFields() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.LINKED_FIELDS));
    }

    public boolean getMarked() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.MARKED));
    }

    public boolean getMilestone() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.MILESTONE));
    }

    public String getName() {
        return (String)this.getCachedValue(TaskField.NAME);
    }

    public String getNotes() {
        String string = (String)this.getCachedValue(TaskField.NOTES);
        return string == null ? "" : string;
    }

    public void setNumber(int n, Number number) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_NUMBER, n), number);
    }

    public Number getNumber(int n) {
        return (Number)this.getCachedValue(this.selectField(TaskFieldLists.CUSTOM_NUMBER, n));
    }

    public Integer getObjects() {
        return (Integer)this.getCachedValue(TaskField.OBJECTS);
    }

    public Integer getOutlineLevel() {
        return (Integer)this.getCachedValue(TaskField.OUTLINE_LEVEL);
    }

    public String getOutlineNumber() {
        return (String)this.getCachedValue(TaskField.OUTLINE_NUMBER);
    }

    public List<Relation> getPredecessors() {
        return (List)this.getCachedValue(TaskField.PREDECESSORS);
    }

    public List<Relation> getSuccessors() {
        return (List)this.getCachedValue(TaskField.SUCCESSORS);
    }

    public Priority getPriority() {
        return (Priority)this.getCachedValue(TaskField.PRIORITY);
    }

    public String getProject() {
        return (String)this.getCachedValue(TaskField.PROJECT);
    }

    public Number getRemainingCost() {
        return (Number)this.getCachedValue(TaskField.REMAINING_COST);
    }

    public Duration getRemainingDuration() {
        return (Duration)this.getCachedValue(TaskField.REMAINING_DURATION);
    }

    public Duration getRemainingWork() {
        return (Duration)this.getCachedValue(TaskField.REMAINING_WORK);
    }

    public String getResourceGroup() {
        return (String)this.getCachedValue(TaskField.RESOURCE_GROUP);
    }

    public String getResourceInitials() {
        return (String)this.getCachedValue(TaskField.RESOURCE_INITIALS);
    }

    public String getResourceNames() {
        return (String)this.getCachedValue(TaskField.RESOURCE_NAMES);
    }

    public Date getResume() {
        return (Date)this.getCachedValue(TaskField.RESUME);
    }

    public boolean getRollup() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.ROLLUP));
    }

    public Date getStart() {
        return (Date)this.getCachedValue(TaskField.START);
    }

    public String getStartText() {
        return (String)this.getCachedValue(TaskField.START_TEXT);
    }

    public void setStart(int n, Date date) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_START, n), date);
    }

    public Date getStart(int n) {
        return (Date)this.getCachedValue(this.selectField(TaskFieldLists.CUSTOM_START, n));
    }

    public Duration getStartVariance() {
        Duration duration = (Duration)this.getCachedValue(TaskField.START_VARIANCE);
        if (duration == null) {
            TimeUnit timeUnit = this.getParentFile().getProjectProperties().getDefaultDurationUnits();
            duration = DateHelper.getVariance(this, this.getBaselineStart(), this.getStart(), timeUnit);
            this.set((FieldType)TaskField.START_VARIANCE, duration);
        }
        return duration;
    }

    public Date getStop() {
        return (Date)this.getCachedValue(TaskField.STOP);
    }

    public String getSubprojectName() {
        return (String)this.getCachedValue(TaskField.SUBPROJECT_FILE);
    }

    public boolean getSummary() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.SUMMARY));
    }

    public Number getSV() {
        Number number = (Number)this.getCachedValue(TaskField.SV);
        if (number == null) {
            Number number2 = this.getBCWP();
            Number number3 = this.getBCWS();
            if (number2 != null && number3 != null) {
                number = NumberHelper.getDouble(number2.doubleValue() - number3.doubleValue());
                this.set((FieldType)TaskField.SV, number);
            }
        }
        return number;
    }

    public void setText(int n, String string) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_TEXT, n), string);
    }

    public String getText(int n) {
        return (String)this.getCachedValue(this.selectField(TaskFieldLists.CUSTOM_TEXT, n));
    }

    public void setOutlineCode(int n, String string) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_OUTLINE_CODE, n), string);
    }

    public String getOutlineCode(int n) {
        return (String)this.getCachedValue(this.selectField(TaskFieldLists.CUSTOM_OUTLINE_CODE, n));
    }

    public Duration getTotalSlack() {
        Duration duration = (Duration)this.getCachedValue(TaskField.TOTAL_SLACK);
        if (duration == null) {
            Duration duration2 = this.getDuration();
            if (duration2 == null) {
                duration2 = Duration.getInstance(0, TimeUnit.DAYS);
            }
            TimeUnit timeUnit = duration2.getUnits();
            Duration duration3 = this.getStartSlack();
            if (duration3 == null) {
                duration3 = Duration.getInstance(0, timeUnit);
            } else if (duration3.getUnits() != timeUnit) {
                duration3 = duration3.convertUnits(timeUnit, this.getParentFile().getProjectProperties());
            }
            Duration duration4 = this.getFinishSlack();
            if (duration4 == null) {
                duration4 = Duration.getInstance(0, timeUnit);
            } else if (duration4.getUnits() != timeUnit) {
                duration4 = duration4.convertUnits(timeUnit, this.getParentFile().getProjectProperties());
            }
            double d = duration3.getDuration();
            double d2 = duration4.getDuration();
            duration = d == 0.0 || d2 == 0.0 ? (d != 0.0 ? duration3 : duration4) : (d < d2 ? duration3 : duration4);
            this.set((FieldType)TaskField.TOTAL_SLACK, duration);
        }
        return duration;
    }

    @Override
    public Integer getUniqueID() {
        return (Integer)this.getCachedValue(TaskField.UNIQUE_ID);
    }

    public boolean getUpdateNeeded() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.UPDATE_NEEDED));
    }

    public String getWBS() {
        return (String)this.getCachedValue(TaskField.WBS);
    }

    public Duration getWork() {
        return (Duration)this.getCachedValue(TaskField.WORK);
    }

    public Duration getWorkVariance() {
        Duration duration = (Duration)this.getCachedValue(TaskField.WORK_VARIANCE);
        if (duration == null) {
            Duration duration2 = this.getWork();
            Duration duration3 = this.getBaselineWork();
            if (duration2 != null && duration3 != null) {
                duration = Duration.getInstance(duration2.getDuration() - duration3.convertUnits(duration2.getUnits(), this.getParentFile().getProjectProperties()).getDuration(), duration2.getUnits());
                this.set((FieldType)TaskField.WORK_VARIANCE, duration);
            }
        }
        return duration;
    }

    public Task getParentTask() {
        return this.m_parent;
    }

    @Override
    public List<Task> getChildTasks() {
        return this.m_children;
    }

    @Override
    public int compareTo(Task task) {
        int n;
        int n2 = NumberHelper.getInt(this.getID());
        return n2 < (n = NumberHelper.getInt(task.getID())) ? -1 : (n2 == n ? 0 : 1);
    }

    public boolean getEstimated() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.ESTIMATED));
    }

    public void setEstimated(boolean bl) {
        this.set((FieldType)TaskField.ESTIMATED, bl);
    }

    public Date getDeadline() {
        return (Date)this.getCachedValue(TaskField.DEADLINE);
    }

    public void setDeadline(Date date) {
        this.set((FieldType)TaskField.DEADLINE, date);
    }

    public TaskType getType() {
        return (TaskType)this.getCachedValue(TaskField.TYPE);
    }

    public void setType(TaskType taskType) {
        this.set((FieldType)TaskField.TYPE, taskType);
    }

    public boolean getNull() {
        return this.m_null;
    }

    public void setNull(boolean bl) {
        this.m_null = bl;
    }

    public String getWBSLevel() {
        return this.m_wbsLevel;
    }

    public void setWBSLevel(String string) {
        this.m_wbsLevel = string;
    }

    public boolean getResumeValid() {
        return this.m_resumeValid;
    }

    public void setResumeValid(boolean bl) {
        this.m_resumeValid = bl;
    }

    public boolean getRecurring() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.RECURRING));
    }

    public void setRecurring(boolean bl) {
        this.set((FieldType)TaskField.RECURRING, bl);
    }

    public boolean getOverAllocated() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.OVERALLOCATED));
    }

    public void setOverAllocated(boolean bl) {
        this.set((FieldType)TaskField.OVERALLOCATED, bl);
    }

    public Integer getSubprojectTaskUniqueID() {
        return (Integer)this.getCachedValue(TaskField.SUBPROJECT_UNIQUE_TASK_ID);
    }

    public void setSubprojectTaskUniqueID(Integer n) {
        this.set((FieldType)TaskField.SUBPROJECT_UNIQUE_TASK_ID, n);
    }

    public Integer getSubprojectTaskID() {
        return (Integer)this.getCachedValue(TaskField.SUBPROJECT_TASK_ID);
    }

    public void setSubprojectTaskID(Integer n) {
        this.set((FieldType)TaskField.SUBPROJECT_TASK_ID, n);
    }

    public void setSubprojectTasksUniqueIDOffset(Integer n) {
        this.set((FieldType)TaskField.SUBPROJECT_TASKS_UNIQUEID_OFFSET, n);
    }

    public Integer getSubprojectTasksUniqueIDOffset() {
        return (Integer)this.getCachedValue(TaskField.SUBPROJECT_TASKS_UNIQUEID_OFFSET);
    }

    public boolean getSubprojectReadOnly() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.SUBPROJECT_READ_ONLY));
    }

    public void setSubprojectReadOnly(boolean bl) {
        this.set((FieldType)TaskField.SUBPROJECT_READ_ONLY, bl);
    }

    public boolean getExternalTask() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.EXTERNAL_TASK));
    }

    public void setExternalTask(boolean bl) {
        this.set((FieldType)TaskField.EXTERNAL_TASK, bl);
    }

    public String getExternalTaskProject() {
        return this.m_externalTaskProject;
    }

    public void setExternalTaskProject(String string) {
        this.m_externalTaskProject = string;
    }

    public Number getACWP() {
        return (Number)this.getCachedValue(TaskField.ACWP);
    }

    public void setACWP(Number number) {
        this.set((FieldType)TaskField.ACWP, number);
    }

    public TimeUnit getLevelingDelayFormat() {
        return this.m_levelingDelayFormat;
    }

    public void setLevelingDelayFormat(TimeUnit timeUnit) {
        this.m_levelingDelayFormat = timeUnit;
    }

    public boolean getIgnoreResourceCalendar() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.IGNORE_RESOURCE_CALENDAR));
    }

    public void setIgnoreResourceCalendar(boolean bl) {
        this.set((FieldType)TaskField.IGNORE_RESOURCE_CALENDAR, bl);
    }

    public Number getPhysicalPercentComplete() {
        return (Number)this.getCachedValue(TaskField.PHYSICAL_PERCENT_COMPLETE);
    }

    public void setPhysicalPercentComplete(Number number) {
        this.set((FieldType)TaskField.PHYSICAL_PERCENT_COMPLETE, number);
    }

    public EarnedValueMethod getEarnedValueMethod() {
        return (EarnedValueMethod)this.getCachedValue(TaskField.EARNED_VALUE_METHOD);
    }

    public void setEarnedValueMethod(EarnedValueMethod earnedValueMethod) {
        this.set((FieldType)TaskField.EARNED_VALUE_METHOD, earnedValueMethod);
    }

    public Duration getActualWorkProtected() {
        return this.m_actualWorkProtected;
    }

    public void setActualWorkProtected(Duration duration) {
        this.m_actualWorkProtected = duration;
    }

    public Duration getActualOvertimeWorkProtected() {
        return this.m_actualOvertimeWorkProtected;
    }

    public void setActualOvertimeWorkProtected(Duration duration) {
        this.m_actualOvertimeWorkProtected = duration;
    }

    public Duration getRegularWork() {
        return (Duration)this.getCachedValue(TaskField.REGULAR_WORK);
    }

    public void setRegularWork(Duration duration) {
        this.set((FieldType)TaskField.REGULAR_WORK, duration);
    }

    public void setEffortDriven(boolean bl) {
        this.set((FieldType)TaskField.EFFORT_DRIVEN, bl);
    }

    public boolean getEffortDriven() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.EFFORT_DRIVEN));
    }

    public void setDate(int n, Date date) {
        this.set((FieldType)this.selectField(TaskFieldLists.CUSTOM_DATE, n), date);
    }

    public Date getDate(int n) {
        return (Date)this.getCachedValue(this.selectField(TaskFieldLists.CUSTOM_DATE, n));
    }

    public Number getOvertimeCost() {
        return (Number)this.getCachedValue(TaskField.OVERTIME_COST);
    }

    public void setOvertimeCost(Number number) {
        this.set((FieldType)TaskField.OVERTIME_COST, number);
    }

    public Number getActualOvertimeCost() {
        return (Number)this.getCachedValue(TaskField.ACTUAL_OVERTIME_COST);
    }

    public void setActualOvertimeCost(Number number) {
        this.set((FieldType)TaskField.ACTUAL_OVERTIME_COST, number);
    }

    public Duration getActualOvertimeWork() {
        return (Duration)this.getCachedValue(TaskField.ACTUAL_OVERTIME_WORK);
    }

    public void setActualOvertimeWork(Duration duration) {
        this.set((FieldType)TaskField.ACTUAL_OVERTIME_WORK, duration);
    }

    public AccrueType getFixedCostAccrual() {
        return (AccrueType)this.getCachedValue(TaskField.FIXED_COST_ACCRUAL);
    }

    public void setFixedCostAccrual(AccrueType accrueType) {
        this.set((FieldType)TaskField.FIXED_COST_ACCRUAL, accrueType);
    }

    public String getHyperlink() {
        return (String)this.getCachedValue(TaskField.HYPERLINK);
    }

    public String getHyperlinkAddress() {
        return (String)this.getCachedValue(TaskField.HYPERLINK_ADDRESS);
    }

    public String getHyperlinkSubAddress() {
        return (String)this.getCachedValue(TaskField.HYPERLINK_SUBADDRESS);
    }

    public void setHyperlink(String string) {
        this.set((FieldType)TaskField.HYPERLINK, string);
    }

    public void setHyperlinkAddress(String string) {
        this.set((FieldType)TaskField.HYPERLINK_ADDRESS, string);
    }

    public void setHyperlinkSubAddress(String string) {
        this.set((FieldType)TaskField.HYPERLINK_SUBADDRESS, string);
    }

    public boolean getLevelAssignments() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.LEVEL_ASSIGNMENTS));
    }

    public void setLevelAssignments(boolean bl) {
        this.set((FieldType)TaskField.LEVEL_ASSIGNMENTS, bl);
    }

    public boolean getLevelingCanSplit() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.LEVELING_CAN_SPLIT));
    }

    public void setLevelingCanSplit(boolean bl) {
        this.set((FieldType)TaskField.LEVELING_CAN_SPLIT, bl);
    }

    public Duration getOvertimeWork() {
        return (Duration)this.getCachedValue(TaskField.OVERTIME_WORK);
    }

    public void setOvertimeWork(Duration duration) {
        this.set((FieldType)TaskField.OVERTIME_WORK, duration);
    }

    public Date getPreleveledStart() {
        return (Date)this.getCachedValue(TaskField.PRELEVELED_START);
    }

    public Date getPreleveledFinish() {
        return (Date)this.getCachedValue(TaskField.PRELEVELED_FINISH);
    }

    public void setPreleveledStart(Date date) {
        this.set((FieldType)TaskField.PRELEVELED_START, date);
    }

    public void setPreleveledFinish(Date date) {
        this.set((FieldType)TaskField.PRELEVELED_FINISH, date);
    }

    public Duration getRemainingOvertimeWork() {
        return (Duration)this.getCachedValue(TaskField.REMAINING_OVERTIME_WORK);
    }

    public void setRemainingOvertimeWork(Duration duration) {
        this.set((FieldType)TaskField.REMAINING_OVERTIME_WORK, duration);
    }

    public Number getRemainingOvertimeCost() {
        return (Number)this.getCachedValue(TaskField.REMAINING_OVERTIME_COST);
    }

    public void setRemainingOvertimeCost(Number number) {
        this.set((FieldType)TaskField.REMAINING_OVERTIME_COST, number);
    }

    public ProjectCalendar getCalendar() {
        return (ProjectCalendar)this.getCachedValue(TaskField.CALENDAR);
    }

    public void setCalendarUniqueID(Integer n) {
        this.set((FieldType)TaskField.CALENDAR_UNIQUE_ID, n);
    }

    public Integer getCalendarUniqueID() {
        return (Integer)this.getCachedValue(TaskField.CALENDAR_UNIQUE_ID);
    }

    public void setCalendar(ProjectCalendar projectCalendar) {
        this.set((FieldType)TaskField.CALENDAR, projectCalendar);
        this.setCalendarUniqueID(projectCalendar == null ? null : projectCalendar.getUniqueID());
    }

    public boolean getExpanded() {
        return this.m_expanded;
    }

    public void setExpanded(boolean bl) {
        this.m_expanded = bl;
    }

    public void setStartSlack(Duration duration) {
        this.set((FieldType)TaskField.START_SLACK, duration);
    }

    public void setFinishSlack(Duration duration) {
        this.set((FieldType)TaskField.FINISH_SLACK, duration);
    }

    public Duration getStartSlack() {
        Duration duration;
        Duration duration2 = (Duration)this.getCachedValue(TaskField.START_SLACK);
        if (duration2 == null && (duration = this.getDuration()) != null) {
            duration2 = DateHelper.getVariance(this, this.getLateStart(), this.getEarlyStart(), duration.getUnits());
            this.set((FieldType)TaskField.START_SLACK, duration2);
        }
        return duration2;
    }

    public Duration getFinishSlack() {
        Duration duration;
        Duration duration2 = (Duration)this.getCachedValue(TaskField.FINISH_SLACK);
        if (duration2 == null && (duration = this.getDuration()) != null) {
            duration2 = DateHelper.getVariance(this, this.getLateFinish(), this.getEarlyFinish(), duration.getUnits());
            this.set((FieldType)TaskField.FINISH_SLACK, duration2);
        }
        return duration2;
    }

    public Object getFieldByAlias(String string) {
        return this.getCachedValue(this.getParentFile().getCustomFields().getFieldByAlias(FieldTypeClass.TASK, string));
    }

    public void setFieldByAlias(String string, Object object) {
        this.set(this.getParentFile().getCustomFields().getFieldByAlias(FieldTypeClass.TASK, string), object);
    }

    public List<DateRange> getSplits() {
        return this.m_splits;
    }

    public void setSplits(List<DateRange> list) {
        this.m_splits = list;
    }

    public Date getSplitCompleteDuration() {
        return this.m_splitsComplete;
    }

    public void setSplitCompleteDuration(Date date) {
        this.m_splitsComplete = date;
    }

    public void remove() {
        this.getParentFile().removeTask(this);
    }

    public SubProject getSubProject() {
        return this.m_subProject;
    }

    public void setSubProject(SubProject subProject) {
        this.m_subProject = subProject;
    }

    public Number getEnterpriseCost(int n) {
        return (Number)this.getCachedValue(this.selectField(TaskFieldLists.ENTERPRISE_COST, n));
    }

    public void setEnterpriseCost(int n, Number number) {
        this.set((FieldType)this.selectField(TaskFieldLists.ENTERPRISE_COST, n), number);
    }

    public Date getEnterpriseDate(int n) {
        return (Date)this.getCachedValue(this.selectField(TaskFieldLists.ENTERPRISE_DATE, n));
    }

    public void setEnterpriseDate(int n, Date date) {
        this.set((FieldType)this.selectField(TaskFieldLists.ENTERPRISE_DATE, n), date);
    }

    public Duration getEnterpriseDuration(int n) {
        return (Duration)this.getCachedValue(this.selectField(TaskFieldLists.ENTERPRISE_DURATION, n));
    }

    public void setEnterpriseDuration(int n, Duration duration) {
        this.set((FieldType)this.selectField(TaskFieldLists.ENTERPRISE_DURATION, n), duration);
    }

    public boolean getEnterpriseFlag(int n) {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(this.selectField(TaskFieldLists.ENTERPRISE_FLAG, n)));
    }

    public void setEnterpriseFlag(int n, boolean bl) {
        this.set((FieldType)this.selectField(TaskFieldLists.ENTERPRISE_FLAG, n), bl);
    }

    public Number getEnterpriseNumber(int n) {
        return (Number)this.getCachedValue(this.selectField(TaskFieldLists.ENTERPRISE_NUMBER, n));
    }

    public void setEnterpriseNumber(int n, Number number) {
        this.set((FieldType)this.selectField(TaskFieldLists.ENTERPRISE_NUMBER, n), number);
    }

    public String getEnterpriseText(int n) {
        return (String)this.getCachedValue(this.selectField(TaskFieldLists.ENTERPRISE_TEXT, n));
    }

    public void setEnterpriseText(int n, String string) {
        this.set((FieldType)this.selectField(TaskFieldLists.ENTERPRISE_TEXT, n), string);
    }

    public String getEnterpriseCustomField(int n) {
        return (String)this.getCachedValue(this.selectField(TaskFieldLists.ENTERPRISE_CUSTOM_FIELD, n));
    }

    public void setEnterpriseCustomField(int n, String string) {
        this.set((FieldType)this.selectField(TaskFieldLists.ENTERPRISE_CUSTOM_FIELD, n), string);
    }

    public void setBaselineCost(int n, Number number) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_COSTS, n), number);
    }

    public void setBaselineDuration(int n, Duration duration) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_DURATIONS, n), duration);
    }

    public void setBaselineFinish(int n, Date date) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_FINISHES, n), date);
    }

    public void setBaselineStart(int n, Date date) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_STARTS, n), date);
    }

    public void setBaselineWork(int n, Duration duration) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_WORKS, n), duration);
    }

    public Number getBaselineCost(int n) {
        return (Number)this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_COSTS, n));
    }

    public Duration getBaselineDuration(int n) {
        Object object = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_DURATIONS, n));
        if (object == null) {
            object = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_ESTIMATED_DURATIONS, n));
        }
        if (!(object instanceof Duration)) {
            object = null;
        }
        return (Duration)object;
    }

    public String getBaselineDurationText(int n) {
        Object object = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_DURATIONS, n));
        if (object == null) {
            object = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_ESTIMATED_DURATIONS, n));
        }
        if (!(object instanceof String)) {
            object = null;
        }
        return (String)object;
    }

    public void setBaselineDurationText(int n, String string) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_DURATIONS, n), string);
    }

    public Date getBaselineFinish(int n) {
        Object object = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_FINISHES, n));
        if (object == null) {
            object = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_ESTIMATED_FINISHES, n));
        }
        if (!(object instanceof Date)) {
            object = null;
        }
        return (Date)object;
    }

    public String getBaselineFinishText(int n) {
        Object object = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_FINISHES, n));
        if (object == null) {
            object = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_ESTIMATED_FINISHES, n));
        }
        if (!(object instanceof String)) {
            object = null;
        }
        return (String)object;
    }

    public void setBaselineFinishText(int n, String string) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_FINISHES, n), string);
    }

    public Date getBaselineStart(int n) {
        Object object = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_STARTS, n));
        if (object == null) {
            object = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_ESTIMATED_STARTS, n));
        }
        if (!(object instanceof Date)) {
            object = null;
        }
        return (Date)object;
    }

    public String getBaselineStartText(int n) {
        Object object = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_STARTS, n));
        if (object == null) {
            object = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_ESTIMATED_STARTS, n));
        }
        if (!(object instanceof String)) {
            object = null;
        }
        return (String)object;
    }

    public void setBaselineStartText(int n, String string) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_STARTS, n), string);
    }

    public Duration getBaselineWork(int n) {
        return (Duration)this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_WORKS, n));
    }

    public Date getCompleteThrough() {
        Date date = (Date)this.getCachedValue(TaskField.COMPLETE_THROUGH);
        if (date == null) {
            int n = NumberHelper.getInt(this.getPercentageComplete());
            switch (n) {
                case 0: {
                    break;
                }
                case 100: {
                    date = this.getActualFinish();
                    break;
                }
                default: {
                    Date date2 = this.getActualStart();
                    Duration duration = this.getDuration();
                    if (date2 == null || duration == null) break;
                    double d = duration.getDuration() * (double)n / 100.0;
                    duration = Duration.getInstance(d, duration.getUnits());
                    ProjectCalendar projectCalendar = this.getEffectiveCalendar();
                    date = projectCalendar.getDate(date2, duration, true);
                    break;
                }
            }
            this.set((FieldType)TaskField.COMPLETE_THROUGH, date);
        }
        return date;
    }

    public Date getSummaryProgress() {
        Date date = (Date)this.getCachedValue(TaskField.SUMMARY_PROGRESS);
        return date;
    }

    public void setSummaryProgress(Date date) {
        this.set((FieldType)TaskField.SUMMARY_PROGRESS, date);
    }

    public UUID getGUID() {
        return (UUID)this.getCachedValue(TaskField.GUID);
    }

    public void setGUID(UUID uUID) {
        this.set((FieldType)TaskField.GUID, uUID);
    }

    public TaskMode getTaskMode() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.TASK_MODE)) ? TaskMode.MANUALLY_SCHEDULED : TaskMode.AUTO_SCHEDULED;
    }

    public void setTaskMode(TaskMode taskMode) {
        this.set((FieldType)TaskField.TASK_MODE, taskMode == TaskMode.MANUALLY_SCHEDULED);
    }

    public boolean getActive() {
        return BooleanHelper.getBoolean((Boolean)this.getCachedValue(TaskField.ACTIVE));
    }

    public void setActive(boolean bl) {
        this.set((FieldType)TaskField.ACTIVE, bl);
    }

    public Duration getBaselineEstimatedDuration() {
        return (Duration)this.getCachedValue(TaskField.BASELINE_ESTIMATED_DURATION);
    }

    public void setBaselineEstimatedDuration(Duration duration) {
        this.set((FieldType)TaskField.BASELINE_ESTIMATED_DURATION, duration);
    }

    public void setBaselineEstimatedDuration(int n, Duration duration) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_ESTIMATED_DURATIONS, n), duration);
    }

    public Duration getBaselineEstimatedDuration(int n) {
        Object object = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_ESTIMATED_DURATIONS, n));
        if (!(object instanceof Duration)) {
            object = null;
        }
        return (Duration)object;
    }

    public Date getBaselineEstimatedStart() {
        return (Date)this.getCachedValue(TaskField.BASELINE_ESTIMATED_START);
    }

    public void setBaselineEstimatedStart(Date date) {
        this.set((FieldType)TaskField.BASELINE_ESTIMATED_START, date);
    }

    public Date getBaselineEstimatedStart(int n) {
        Object object = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_ESTIMATED_STARTS, n));
        if (!(object instanceof Date)) {
            object = null;
        }
        return (Date)object;
    }

    public void setBaselineEstimatedStart(int n, Date date) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_ESTIMATED_STARTS, n), date);
    }

    public Date getBaselineEstimatedFinish() {
        return (Date)this.getCachedValue(TaskField.BASELINE_ESTIMATED_FINISH);
    }

    public void setBaselineEstimatedFinish(Date date) {
        this.set((FieldType)TaskField.BASELINE_ESTIMATED_FINISH, date);
    }

    public Date getBaselineEstimatedFinish(int n) {
        Object object = this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_ESTIMATED_FINISHES, n));
        if (!(object instanceof Date)) {
            object = null;
        }
        return (Date)object;
    }

    public void setBaselineEstimatedFinish(int n, Date date) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_ESTIMATED_FINISHES, n), date);
    }

    public void setBaselineFixedCost(Number number) {
        this.set((FieldType)TaskField.BASELINE_FIXED_COST, number);
    }

    public Number getBaselineFixedCost() {
        return (Number)this.getCachedValue(TaskField.BASELINE_FIXED_COST);
    }

    public void setBaselineFixedCost(int n, Number number) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_FIXED_COSTS, n), number);
    }

    public Number getBaselineFixedCost(int n) {
        return (Number)this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_FIXED_COSTS, n));
    }

    public AccrueType getBaselineFixedCostAccrual() {
        return (AccrueType)this.getCachedValue(TaskField.BASELINE_FIXED_COST_ACCRUAL);
    }

    public void setBaselineFixedCostAccrual(AccrueType accrueType) {
        this.set((FieldType)TaskField.BASELINE_FIXED_COST_ACCRUAL, accrueType);
    }

    public void setBaselineFixedCostAccrual(int n, AccrueType accrueType) {
        this.set((FieldType)this.selectField(TaskFieldLists.BASELINE_FIXED_COST_ACCRUALS, n), accrueType);
    }

    public AccrueType getBaselineFixedCostAccrual(int n) {
        return (AccrueType)this.getCachedValue(this.selectField(TaskFieldLists.BASELINE_FIXED_COST_ACCRUALS, n));
    }

    public ProjectCalendar getEffectiveCalendar() {
        ProjectCalendar projectCalendar = this.getCalendar();
        if (projectCalendar == null) {
            projectCalendar = this.getParentFile().getDefaultCalendar();
        }
        return projectCalendar;
    }

    public boolean removePredecessor(Task task, RelationType relationType, Duration duration) {
        boolean bl = false;
        List<Relation> list = this.getPredecessors();
        if (!list.isEmpty()) {
            List<Relation> list2;
            if (duration == null) {
                duration = Duration.getInstance(0, TimeUnit.DAYS);
            }
            if ((bl = this.removeRelation(list, task, relationType, duration)) && !(list2 = task.getSuccessors()).isEmpty()) {
                this.removeRelation(list2, this, relationType, duration);
            }
        }
        return bl;
    }

    private boolean removeRelation(List<Relation> list, Task task, RelationType relationType, Duration duration) {
        boolean bl = false;
        for (Relation relation : list) {
            if (relation.getTargetTask() != task || relation.getType() != relationType || relation.getLag().compareTo(duration) != 0) continue;
            bl = list.remove(relation);
            break;
        }
        return bl;
    }

    private TaskField selectField(TaskField[] taskFieldArray, int n) {
        if (n < 1 || n > taskFieldArray.length) {
            throw new IllegalArgumentException(n + " is not a valid field index");
        }
        return taskFieldArray[n - 1];
    }

    @Override
    public Object getCachedValue(FieldType fieldType) {
        return fieldType == null ? null : this.m_array[fieldType.getValue()];
    }

    @Override
    public Object getCurrentValue(FieldType fieldType) {
        Object object = null;
        if (fieldType != null) {
            switch ((TaskField)fieldType) {
                case PARENT_TASK_UNIQUE_ID: {
                    object = this.m_parent == null ? Integer.valueOf(-1) : this.m_parent.getUniqueID();
                    break;
                }
                case START_VARIANCE: {
                    object = this.getStartVariance();
                    break;
                }
                case FINISH_VARIANCE: {
                    object = this.getFinishVariance();
                    break;
                }
                case START_SLACK: {
                    object = this.getStartSlack();
                    break;
                }
                case FINISH_SLACK: {
                    object = this.getFinishSlack();
                    break;
                }
                case COST_VARIANCE: {
                    object = this.getCostVariance();
                    break;
                }
                case DURATION_VARIANCE: {
                    object = this.getDurationVariance();
                    break;
                }
                case WORK_VARIANCE: {
                    object = this.getWorkVariance();
                    break;
                }
                case CV: {
                    object = this.getCV();
                    break;
                }
                case SV: {
                    object = this.getSV();
                    break;
                }
                case TOTAL_SLACK: {
                    object = this.getTotalSlack();
                    break;
                }
                case CRITICAL: {
                    object = this.getCritical();
                    break;
                }
                case COMPLETE_THROUGH: {
                    object = this.getCompleteThrough();
                    break;
                }
                default: {
                    object = this.m_array[fieldType.getValue()];
                }
            }
        }
        return object;
    }

    @Override
    public void set(FieldType fieldType, Object object) {
        if (fieldType != null) {
            int n = fieldType.getValue();
            if (this.m_eventsEnabled) {
                this.fireFieldChangeEvent((TaskField)fieldType, this.m_array[n], object);
            }
            this.m_array[n] = object;
        }
    }

    private void fireFieldChangeEvent(TaskField taskField, Object object, Object object2) {
        switch (taskField) {
            case UNIQUE_ID: {
                ProjectFile projectFile = this.getParentFile();
                if (object != null) {
                    projectFile.getTasks().unmapUniqueID((Integer)object);
                }
                projectFile.getTasks().mapUniqueID((Integer)object2, this);
                break;
            }
            case START: 
            case BASELINE_START: {
                this.m_array[TaskField.START_VARIANCE.getValue()] = null;
                break;
            }
            case FINISH: 
            case BASELINE_FINISH: {
                this.m_array[TaskField.FINISH_VARIANCE.getValue()] = null;
                break;
            }
            case COST: 
            case BASELINE_COST: {
                this.m_array[TaskField.COST_VARIANCE.getValue()] = null;
                break;
            }
            case DURATION: {
                this.m_array[TaskField.DURATION_VARIANCE.getValue()] = null;
                this.m_array[TaskField.COMPLETE_THROUGH.getValue()] = null;
                break;
            }
            case BASELINE_DURATION: {
                this.m_array[TaskField.DURATION_VARIANCE.getValue()] = null;
                break;
            }
            case WORK: 
            case BASELINE_WORK: {
                this.m_array[TaskField.WORK_VARIANCE.getValue()] = null;
                break;
            }
            case BCWP: 
            case ACWP: {
                this.m_array[TaskField.CV.getValue()] = null;
                this.m_array[TaskField.SV.getValue()] = null;
                break;
            }
            case BCWS: {
                this.m_array[TaskField.SV.getValue()] = null;
                break;
            }
            case START_SLACK: 
            case FINISH_SLACK: {
                this.m_array[TaskField.TOTAL_SLACK.getValue()] = null;
                this.m_array[TaskField.CRITICAL.getValue()] = null;
                break;
            }
            case EARLY_FINISH: 
            case LATE_FINISH: {
                this.m_array[TaskField.FINISH_SLACK.getValue()] = null;
                this.m_array[TaskField.TOTAL_SLACK.getValue()] = null;
                this.m_array[TaskField.CRITICAL.getValue()] = null;
                break;
            }
            case EARLY_START: 
            case LATE_START: {
                this.m_array[TaskField.START_SLACK.getValue()] = null;
                this.m_array[TaskField.TOTAL_SLACK.getValue()] = null;
                this.m_array[TaskField.CRITICAL.getValue()] = null;
                break;
            }
            case ACTUAL_START: 
            case PERCENT_COMPLETE: {
                this.m_array[TaskField.COMPLETE_THROUGH.getValue()] = null;
                break;
            }
        }
        if (this.m_listeners != null) {
            for (FieldListener fieldListener : this.m_listeners) {
                fieldListener.fieldChange(this, taskField, object, object2);
            }
        }
    }

    @Override
    public void addFieldListener(FieldListener fieldListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new LinkedList<FieldListener>();
        }
        this.m_listeners.add(fieldListener);
    }

    @Override
    public void removeFieldListener(FieldListener fieldListener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(fieldListener);
        }
    }

    private void set(FieldType fieldType, boolean bl) {
        this.set(fieldType, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public String toString() {
        return "[Task id=" + this.getID() + " uniqueID=" + this.getUniqueID() + " name=" + this.getName() + (this.getExternalTask() ? " [EXTERNAL uid=" + this.getSubprojectTaskUniqueID() + " id=" + this.getSubprojectTaskID() + "]" : "]") + (this.getSubProject() == null ? "" : " project=" + this.getSubProject());
    }

    public boolean isPredecessor(Task task) {
        return this.isRelated(task, this.getPredecessors());
    }

    public boolean isSucessor(Task task) {
        return this.isRelated(task, this.getSuccessors());
    }

    private boolean isRelated(Task task, List<Relation> list) {
        boolean bl = false;
        for (Relation relation : list) {
            if (relation.getTargetTask().getUniqueID().intValue() != task.getUniqueID().intValue()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void disableEvents() {
        this.m_eventsEnabled = false;
    }

    public void enableEvents() {
        this.m_eventsEnabled = true;
    }
}

