# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("winbio.dll")
prototypes = \
    {
        #
        'WinBioEnumServiceProviders': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"BiometricFactor": SimTypeInt(signed=False, label="UInt32"), "BspId": SimTypeBottom(label="Guid"), "Description": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "Vendor": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "Version": SimStruct({"MajorVersion": SimTypeInt(signed=False, label="UInt32"), "MinorVersion": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_VERSION", pack=False, align=None)}, name="WINBIO_BSP_SCHEMA", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Factor", "BspSchemaArray", "BspCount"]),
        #
        'WinBioEnumBiometricUnits': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"UnitId": SimTypeInt(signed=False, label="UInt32"), "PoolType": SimTypeInt(signed=False, label="UInt32"), "BiometricFactor": SimTypeInt(signed=False, label="UInt32"), "SensorSubType": SimTypeInt(signed=False, label="UInt32"), "Capabilities": SimTypeInt(signed=False, label="UInt32"), "DeviceInstanceId": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "Description": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "Manufacturer": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "Model": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "SerialNumber": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "FirmwareVersion": SimStruct({"MajorVersion": SimTypeInt(signed=False, label="UInt32"), "MinorVersion": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_VERSION", pack=False, align=None)}, name="WINBIO_UNIT_SCHEMA", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Factor", "UnitSchemaArray", "UnitCount"]),
        #
        'WinBioEnumDatabases': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"BiometricFactor": SimTypeInt(signed=False, label="UInt32"), "DatabaseId": SimTypeBottom(label="Guid"), "DataFormat": SimTypeBottom(label="Guid"), "Attributes": SimTypeInt(signed=False, label="UInt32"), "FilePath": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "ConnectionString": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256)}, name="WINBIO_STORAGE_SCHEMA", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Factor", "StorageSchemaArray", "StorageCount"]),
        #
        'WinBioAsyncOpenFramework': SimTypeFunction([SimTypeInt(signed=False, label="WINBIO_ASYNC_NOTIFICATION_METHOD"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"SessionHandle": SimTypeInt(signed=False, label="UInt32"), "Operation": SimTypeInt(signed=False, label="UInt32"), "SequenceNumber": SimTypeLongLong(signed=False, label="UInt64"), "TimeStamp": SimTypeLongLong(signed=True, label="Int64"), "ApiStatus": SimTypeBottom(label="HRESULT"), "UnitId": SimTypeInt(signed=False, label="UInt32"), "UserData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Parameters": SimUnion({"Verify": SimStruct({"Match": SimTypeBottom(label="BOOLEAN"), "RejectDetail": SimTypeInt(signed=False, label="UInt32")}, name="_Verify_e__Struct", pack=False, align=None), "Identify": SimStruct({"Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "SubFactor": SimTypeChar(label="Byte"), "RejectDetail": SimTypeInt(signed=False, label="UInt32")}, name="_Identify_e__Struct", pack=False, align=None), "EnrollBegin": SimStruct({"SubFactor": SimTypeChar(label="Byte")}, name="_EnrollBegin_e__Struct", pack=False, align=None), "EnrollCapture": SimStruct({"RejectDetail": SimTypeInt(signed=False, label="UInt32")}, name="_EnrollCapture_e__Struct", pack=False, align=None), "EnrollCommit": SimStruct({"Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "IsNewTemplate": SimTypeBottom(label="BOOLEAN")}, name="_EnrollCommit_e__Struct", pack=False, align=None), "EnumEnrollments": SimStruct({"Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "SubFactorCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "SubFactorArray": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="_EnumEnrollments_e__Struct", pack=False, align=None), "CaptureSample": SimStruct({"Sample": SimTypePointer(SimStruct({"HeaderBlock": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_BIR_DATA", pack=False, align=None), "StandardDataBlock": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_BIR_DATA", pack=False, align=None), "VendorDataBlock": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_BIR_DATA", pack=False, align=None), "SignatureBlock": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_BIR_DATA", pack=False, align=None)}, name="WINBIO_BIR", pack=False, align=None), offset=0), "SampleSize": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "RejectDetail": SimTypeInt(signed=False, label="UInt32")}, name="_CaptureSample_e__Struct", pack=False, align=None), "DeleteTemplate": SimStruct({"Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "SubFactor": SimTypeChar(label="Byte")}, name="_DeleteTemplate_e__Struct", pack=False, align=None), "GetProperty": SimStruct({"PropertyType": SimTypeInt(signed=False, label="UInt32"), "PropertyId": SimTypeInt(signed=False, label="UInt32"), "Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "SubFactor": SimTypeChar(label="Byte"), "PropertyBufferSize": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "PropertyBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="_GetProperty_e__Struct", pack=False, align=None), "SetProperty": SimStruct({"PropertyType": SimTypeInt(signed=False, label="UInt32"), "PropertyId": SimTypeInt(signed=False, label="UInt32"), "Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "SubFactor": SimTypeChar(label="Byte"), "PropertyBufferSize": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "PropertyBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="_SetProperty_e__Struct", pack=False, align=None), "GetEvent": SimStruct({"Event": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Parameters": SimUnion({"Unclaimed": SimStruct({"UnitId": SimTypeInt(signed=False, label="UInt32"), "RejectDetail": SimTypeInt(signed=False, label="UInt32")}, name="_Unclaimed_e__Struct", pack=False, align=None), "UnclaimedIdentify": SimStruct({"UnitId": SimTypeInt(signed=False, label="UInt32"), "Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "SubFactor": SimTypeChar(label="Byte"), "RejectDetail": SimTypeInt(signed=False, label="UInt32")}, name="_UnclaimedIdentify_e__Struct", pack=False, align=None), "Error": SimStruct({"ErrorCode": SimTypeBottom(label="HRESULT")}, name="_Error_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="WINBIO_EVENT", pack=False, align=None)}, name="_GetEvent_e__Struct", pack=False, align=None), "ControlUnit": SimStruct({"Component": SimTypeInt(signed=False, label="WINBIO_COMPONENT"), "ControlCode": SimTypeInt(signed=False, label="UInt32"), "OperationStatus": SimTypeInt(signed=False, label="UInt32"), "SendBuffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SendBufferSize": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ReceiveBuffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ReceiveBufferSize": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ReceiveDataSize": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="_ControlUnit_e__Struct", pack=False, align=None), "EnumServiceProviders": SimStruct({"BspCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "BspSchemaArray": SimTypePointer(SimStruct({"BiometricFactor": SimTypeInt(signed=False, label="UInt32"), "BspId": SimTypeBottom(label="Guid"), "Description": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "Vendor": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "Version": SimStruct({"MajorVersion": SimTypeInt(signed=False, label="UInt32"), "MinorVersion": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_VERSION", pack=False, align=None)}, name="WINBIO_BSP_SCHEMA", pack=False, align=None), offset=0)}, name="_EnumServiceProviders_e__Struct", pack=False, align=None), "EnumBiometricUnits": SimStruct({"UnitCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "UnitSchemaArray": SimTypePointer(SimStruct({"UnitId": SimTypeInt(signed=False, label="UInt32"), "PoolType": SimTypeInt(signed=False, label="UInt32"), "BiometricFactor": SimTypeInt(signed=False, label="UInt32"), "SensorSubType": SimTypeInt(signed=False, label="UInt32"), "Capabilities": SimTypeInt(signed=False, label="UInt32"), "DeviceInstanceId": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "Description": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "Manufacturer": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "Model": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "SerialNumber": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "FirmwareVersion": SimStruct({"MajorVersion": SimTypeInt(signed=False, label="UInt32"), "MinorVersion": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_VERSION", pack=False, align=None)}, name="WINBIO_UNIT_SCHEMA", pack=False, align=None), offset=0)}, name="_EnumBiometricUnits_e__Struct", pack=False, align=None), "EnumDatabases": SimStruct({"StorageCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "StorageSchemaArray": SimTypePointer(SimStruct({"BiometricFactor": SimTypeInt(signed=False, label="UInt32"), "DatabaseId": SimTypeBottom(label="Guid"), "DataFormat": SimTypeBottom(label="Guid"), "Attributes": SimTypeInt(signed=False, label="UInt32"), "FilePath": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "ConnectionString": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256)}, name="WINBIO_STORAGE_SCHEMA", pack=False, align=None), offset=0)}, name="_EnumDatabases_e__Struct", pack=False, align=None), "VerifyAndReleaseTicket": SimStruct({"Match": SimTypeBottom(label="BOOLEAN"), "RejectDetail": SimTypeInt(signed=False, label="UInt32"), "Ticket": SimTypeLongLong(signed=False, label="UInt64")}, name="_VerifyAndReleaseTicket_e__Struct", pack=False, align=None), "IdentifyAndReleaseTicket": SimStruct({"Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "SubFactor": SimTypeChar(label="Byte"), "RejectDetail": SimTypeInt(signed=False, label="UInt32"), "Ticket": SimTypeLongLong(signed=False, label="UInt64")}, name="_IdentifyAndReleaseTicket_e__Struct", pack=False, align=None), "EnrollSelect": SimStruct({"SelectorValue": SimTypeLongLong(signed=False, label="UInt64")}, name="_EnrollSelect_e__Struct", pack=False, align=None), "MonitorPresence": SimStruct({"ChangeType": SimTypeInt(signed=False, label="UInt32"), "PresenceCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "PresenceArray": SimTypePointer(SimStruct({"Factor": SimTypeInt(signed=False, label="UInt32"), "SubFactor": SimTypeChar(label="Byte"), "Status": SimTypeBottom(label="HRESULT"), "RejectDetail": SimTypeInt(signed=False, label="UInt32"), "Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "TrackingId": SimTypeLongLong(signed=False, label="UInt64"), "Ticket": SimTypeLongLong(signed=False, label="UInt64"), "Properties": SimUnion({"FacialFeatures": SimStruct({"BoundingBox": SimTypeBottom(label="RECT"), "Distance": SimTypeInt(signed=True, label="Int32"), "OpaqueEngineData": SimStruct({"AdapterId": SimTypeBottom(label="Guid"), "Data": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 77)}, name="_OpaqueEngineData_e__Struct", pack=False, align=None)}, name="_FacialFeatures_e__Struct", pack=False, align=None), "Iris": SimStruct({"EyeBoundingBox_1": SimTypeBottom(label="RECT"), "EyeBoundingBox_2": SimTypeBottom(label="RECT"), "PupilCenter_1": SimTypeBottom(label="POINT"), "PupilCenter_2": SimTypeBottom(label="POINT"), "Distance": SimTypeInt(signed=True, label="Int32")}, name="_Iris_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Authorization": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="_Authorization_e__Struct", pack=False, align=None)}, name="WINBIO_PRESENCE", pack=False, align=None), offset=0)}, name="_MonitorPresence_e__Struct", pack=False, align=None), "GetProtectionPolicy": SimStruct({"Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "Policy": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "DatabaseId": SimTypeBottom(label="Guid"), "UserState": SimTypeLongLong(signed=False, label="UInt64"), "PolicySize": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Policy": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 128)}, name="WINBIO_PROTECTION_POLICY", pack=False, align=None)}, name="_GetProtectionPolicy_e__Struct", pack=False, align=None), "NotifyUnitStatusChange": SimStruct({"ExtendedStatus": SimStruct({"Availability": SimTypeInt(signed=False, label="UInt32"), "ReasonCode": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_EXTENDED_UNIT_STATUS", pack=False, align=None)}, name="_NotifyUnitStatusChange_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="WINBIO_ASYNC_RESULT", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["AsyncResult"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["NotificationMethod", "TargetWindow", "MessageCode", "CallbackRoutine", "UserData", "AsynchronousOpen", "FrameworkHandle"]),
        #
        'WinBioCloseFramework': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["FrameworkHandle"]),
        #
        'WinBioAsyncEnumServiceProviders': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["FrameworkHandle", "Factor"]),
        #
        'WinBioAsyncEnumBiometricUnits': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["FrameworkHandle", "Factor"]),
        #
        'WinBioAsyncEnumDatabases': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["FrameworkHandle", "Factor"]),
        #
        'WinBioAsyncMonitorFrameworkChanges': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["FrameworkHandle", "ChangeTypes"]),
        #
        'WinBioOpenSession': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="WINBIO_POOL"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Factor", "PoolType", "Flags", "UnitArray", "UnitCount", "DatabaseId", "SessionHandle"]),
        #
        'WinBioAsyncOpenSession': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="WINBIO_POOL"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="WINBIO_ASYNC_NOTIFICATION_METHOD"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"SessionHandle": SimTypeInt(signed=False, label="UInt32"), "Operation": SimTypeInt(signed=False, label="UInt32"), "SequenceNumber": SimTypeLongLong(signed=False, label="UInt64"), "TimeStamp": SimTypeLongLong(signed=True, label="Int64"), "ApiStatus": SimTypeBottom(label="HRESULT"), "UnitId": SimTypeInt(signed=False, label="UInt32"), "UserData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Parameters": SimUnion({"Verify": SimStruct({"Match": SimTypeBottom(label="BOOLEAN"), "RejectDetail": SimTypeInt(signed=False, label="UInt32")}, name="_Verify_e__Struct", pack=False, align=None), "Identify": SimStruct({"Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "SubFactor": SimTypeChar(label="Byte"), "RejectDetail": SimTypeInt(signed=False, label="UInt32")}, name="_Identify_e__Struct", pack=False, align=None), "EnrollBegin": SimStruct({"SubFactor": SimTypeChar(label="Byte")}, name="_EnrollBegin_e__Struct", pack=False, align=None), "EnrollCapture": SimStruct({"RejectDetail": SimTypeInt(signed=False, label="UInt32")}, name="_EnrollCapture_e__Struct", pack=False, align=None), "EnrollCommit": SimStruct({"Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "IsNewTemplate": SimTypeBottom(label="BOOLEAN")}, name="_EnrollCommit_e__Struct", pack=False, align=None), "EnumEnrollments": SimStruct({"Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "SubFactorCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "SubFactorArray": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="_EnumEnrollments_e__Struct", pack=False, align=None), "CaptureSample": SimStruct({"Sample": SimTypePointer(SimStruct({"HeaderBlock": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_BIR_DATA", pack=False, align=None), "StandardDataBlock": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_BIR_DATA", pack=False, align=None), "VendorDataBlock": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_BIR_DATA", pack=False, align=None), "SignatureBlock": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_BIR_DATA", pack=False, align=None)}, name="WINBIO_BIR", pack=False, align=None), offset=0), "SampleSize": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "RejectDetail": SimTypeInt(signed=False, label="UInt32")}, name="_CaptureSample_e__Struct", pack=False, align=None), "DeleteTemplate": SimStruct({"Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "SubFactor": SimTypeChar(label="Byte")}, name="_DeleteTemplate_e__Struct", pack=False, align=None), "GetProperty": SimStruct({"PropertyType": SimTypeInt(signed=False, label="UInt32"), "PropertyId": SimTypeInt(signed=False, label="UInt32"), "Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "SubFactor": SimTypeChar(label="Byte"), "PropertyBufferSize": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "PropertyBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="_GetProperty_e__Struct", pack=False, align=None), "SetProperty": SimStruct({"PropertyType": SimTypeInt(signed=False, label="UInt32"), "PropertyId": SimTypeInt(signed=False, label="UInt32"), "Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "SubFactor": SimTypeChar(label="Byte"), "PropertyBufferSize": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "PropertyBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="_SetProperty_e__Struct", pack=False, align=None), "GetEvent": SimStruct({"Event": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Parameters": SimUnion({"Unclaimed": SimStruct({"UnitId": SimTypeInt(signed=False, label="UInt32"), "RejectDetail": SimTypeInt(signed=False, label="UInt32")}, name="_Unclaimed_e__Struct", pack=False, align=None), "UnclaimedIdentify": SimStruct({"UnitId": SimTypeInt(signed=False, label="UInt32"), "Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "SubFactor": SimTypeChar(label="Byte"), "RejectDetail": SimTypeInt(signed=False, label="UInt32")}, name="_UnclaimedIdentify_e__Struct", pack=False, align=None), "Error": SimStruct({"ErrorCode": SimTypeBottom(label="HRESULT")}, name="_Error_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="WINBIO_EVENT", pack=False, align=None)}, name="_GetEvent_e__Struct", pack=False, align=None), "ControlUnit": SimStruct({"Component": SimTypeInt(signed=False, label="WINBIO_COMPONENT"), "ControlCode": SimTypeInt(signed=False, label="UInt32"), "OperationStatus": SimTypeInt(signed=False, label="UInt32"), "SendBuffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "SendBufferSize": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ReceiveBuffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ReceiveBufferSize": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ReceiveDataSize": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="_ControlUnit_e__Struct", pack=False, align=None), "EnumServiceProviders": SimStruct({"BspCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "BspSchemaArray": SimTypePointer(SimStruct({"BiometricFactor": SimTypeInt(signed=False, label="UInt32"), "BspId": SimTypeBottom(label="Guid"), "Description": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "Vendor": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "Version": SimStruct({"MajorVersion": SimTypeInt(signed=False, label="UInt32"), "MinorVersion": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_VERSION", pack=False, align=None)}, name="WINBIO_BSP_SCHEMA", pack=False, align=None), offset=0)}, name="_EnumServiceProviders_e__Struct", pack=False, align=None), "EnumBiometricUnits": SimStruct({"UnitCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "UnitSchemaArray": SimTypePointer(SimStruct({"UnitId": SimTypeInt(signed=False, label="UInt32"), "PoolType": SimTypeInt(signed=False, label="UInt32"), "BiometricFactor": SimTypeInt(signed=False, label="UInt32"), "SensorSubType": SimTypeInt(signed=False, label="UInt32"), "Capabilities": SimTypeInt(signed=False, label="UInt32"), "DeviceInstanceId": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "Description": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "Manufacturer": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "Model": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "SerialNumber": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "FirmwareVersion": SimStruct({"MajorVersion": SimTypeInt(signed=False, label="UInt32"), "MinorVersion": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_VERSION", pack=False, align=None)}, name="WINBIO_UNIT_SCHEMA", pack=False, align=None), offset=0)}, name="_EnumBiometricUnits_e__Struct", pack=False, align=None), "EnumDatabases": SimStruct({"StorageCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "StorageSchemaArray": SimTypePointer(SimStruct({"BiometricFactor": SimTypeInt(signed=False, label="UInt32"), "DatabaseId": SimTypeBottom(label="Guid"), "DataFormat": SimTypeBottom(label="Guid"), "Attributes": SimTypeInt(signed=False, label="UInt32"), "FilePath": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256), "ConnectionString": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 256)}, name="WINBIO_STORAGE_SCHEMA", pack=False, align=None), offset=0)}, name="_EnumDatabases_e__Struct", pack=False, align=None), "VerifyAndReleaseTicket": SimStruct({"Match": SimTypeBottom(label="BOOLEAN"), "RejectDetail": SimTypeInt(signed=False, label="UInt32"), "Ticket": SimTypeLongLong(signed=False, label="UInt64")}, name="_VerifyAndReleaseTicket_e__Struct", pack=False, align=None), "IdentifyAndReleaseTicket": SimStruct({"Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "SubFactor": SimTypeChar(label="Byte"), "RejectDetail": SimTypeInt(signed=False, label="UInt32"), "Ticket": SimTypeLongLong(signed=False, label="UInt64")}, name="_IdentifyAndReleaseTicket_e__Struct", pack=False, align=None), "EnrollSelect": SimStruct({"SelectorValue": SimTypeLongLong(signed=False, label="UInt64")}, name="_EnrollSelect_e__Struct", pack=False, align=None), "MonitorPresence": SimStruct({"ChangeType": SimTypeInt(signed=False, label="UInt32"), "PresenceCount": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "PresenceArray": SimTypePointer(SimStruct({"Factor": SimTypeInt(signed=False, label="UInt32"), "SubFactor": SimTypeChar(label="Byte"), "Status": SimTypeBottom(label="HRESULT"), "RejectDetail": SimTypeInt(signed=False, label="UInt32"), "Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "TrackingId": SimTypeLongLong(signed=False, label="UInt64"), "Ticket": SimTypeLongLong(signed=False, label="UInt64"), "Properties": SimUnion({"FacialFeatures": SimStruct({"BoundingBox": SimTypeBottom(label="RECT"), "Distance": SimTypeInt(signed=True, label="Int32"), "OpaqueEngineData": SimStruct({"AdapterId": SimTypeBottom(label="Guid"), "Data": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 77)}, name="_OpaqueEngineData_e__Struct", pack=False, align=None)}, name="_FacialFeatures_e__Struct", pack=False, align=None), "Iris": SimStruct({"EyeBoundingBox_1": SimTypeBottom(label="RECT"), "EyeBoundingBox_2": SimTypeBottom(label="RECT"), "PupilCenter_1": SimTypeBottom(label="POINT"), "PupilCenter_2": SimTypeBottom(label="POINT"), "Distance": SimTypeInt(signed=True, label="Int32")}, name="_Iris_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Authorization": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="_Authorization_e__Struct", pack=False, align=None)}, name="WINBIO_PRESENCE", pack=False, align=None), offset=0)}, name="_MonitorPresence_e__Struct", pack=False, align=None), "GetProtectionPolicy": SimStruct({"Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "Policy": SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "DatabaseId": SimTypeBottom(label="Guid"), "UserState": SimTypeLongLong(signed=False, label="UInt64"), "PolicySize": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Policy": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 128)}, name="WINBIO_PROTECTION_POLICY", pack=False, align=None)}, name="_GetProtectionPolicy_e__Struct", pack=False, align=None), "NotifyUnitStatusChange": SimStruct({"ExtendedStatus": SimStruct({"Availability": SimTypeInt(signed=False, label="UInt32"), "ReasonCode": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_EXTENDED_UNIT_STATUS", pack=False, align=None)}, name="_NotifyUnitStatusChange_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="WINBIO_ASYNC_RESULT", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["AsyncResult"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Factor", "PoolType", "Flags", "UnitArray", "UnitCount", "DatabaseId", "NotificationMethod", "TargetWindow", "MessageCode", "CallbackRoutine", "UserData", "AsynchronousOpen", "SessionHandle"]),
        #
        'WinBioCloseSession': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle"]),
        #
        'WinBioVerify': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "Identity", "SubFactor", "UnitId", "Match", "RejectDetail"]),
        #
        'WinBioVerifyWithCallback': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeBottom(label="HRESULT"), SimTypeInt(signed=False, label="UInt32"), SimTypeBottom(label="BOOLEAN"), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["VerifyCallbackContext", "OperationStatus", "UnitId", "Match", "RejectDetail"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "Identity", "SubFactor", "VerifyCallback", "VerifyCallbackContext"]),
        #
        'WinBioIdentify': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "UnitId", "Identity", "SubFactor", "RejectDetail"]),
        #
        'WinBioIdentifyWithCallback': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeBottom(label="HRESULT"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), offset=0), SimTypeChar(label="Byte"), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["IdentifyCallbackContext", "OperationStatus", "UnitId", "Identity", "SubFactor", "RejectDetail"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "IdentifyCallback", "IdentifyCallbackContext"]),
        #
        'WinBioWait': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle"]),
        #
        'WinBioCancel': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle"]),
        #
        'WinBioLocateSensor': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "UnitId"]),
        #
        'WinBioLocateSensorWithCallback': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeBottom(label="HRESULT"), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["LocateCallbackContext", "OperationStatus", "UnitId"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "LocateCallback", "LocateCallbackContext"]),
        #
        'WinBioEnrollBegin': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeChar(label="Byte"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "SubFactor", "UnitId"]),
        #
        'WinBioEnrollSelect': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "SelectorValue"]),
        #
        'WinBioEnrollCapture': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "RejectDetail"]),
        #
        'WinBioEnrollCaptureWithCallback': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeBottom(label="HRESULT"), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["EnrollCallbackContext", "OperationStatus", "RejectDetail"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "EnrollCallback", "EnrollCallbackContext"]),
        #
        'WinBioEnrollCommit': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "Identity", "IsNewTemplate"]),
        #
        'WinBioEnrollDiscard': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle"]),
        #
        'WinBioEnumEnrollments': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "UnitId", "Identity", "SubFactorArray", "SubFactorCount"]),
        #
        'WinBioRegisterEventMonitor': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeBottom(label="HRESULT"), SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Parameters": SimUnion({"Unclaimed": SimStruct({"UnitId": SimTypeInt(signed=False, label="UInt32"), "RejectDetail": SimTypeInt(signed=False, label="UInt32")}, name="_Unclaimed_e__Struct", pack=False, align=None), "UnclaimedIdentify": SimStruct({"UnitId": SimTypeInt(signed=False, label="UInt32"), "Identity": SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), "SubFactor": SimTypeChar(label="Byte"), "RejectDetail": SimTypeInt(signed=False, label="UInt32")}, name="_UnclaimedIdentify_e__Struct", pack=False, align=None), "Error": SimStruct({"ErrorCode": SimTypeBottom(label="HRESULT")}, name="_Error_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="WINBIO_EVENT", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["EventCallbackContext", "OperationStatus", "Event"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "EventMask", "EventCallback", "EventCallbackContext"]),
        #
        'WinBioUnregisterEventMonitor': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle"]),
        #
        'WinBioMonitorPresence': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "UnitId"]),
        #
        'WinBioCaptureSample': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeChar(label="Byte"), SimTypeChar(label="Byte"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"HeaderBlock": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_BIR_DATA", pack=False, align=None), "StandardDataBlock": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_BIR_DATA", pack=False, align=None), "VendorDataBlock": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_BIR_DATA", pack=False, align=None), "SignatureBlock": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_BIR_DATA", pack=False, align=None)}, name="WINBIO_BIR", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "Purpose", "Flags", "UnitId", "Sample", "SampleSize", "RejectDetail"]),
        #
        'WinBioCaptureSampleWithCallback': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeChar(label="Byte"), SimTypeChar(label="Byte"), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeBottom(label="HRESULT"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"HeaderBlock": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_BIR_DATA", pack=False, align=None), "StandardDataBlock": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_BIR_DATA", pack=False, align=None), "VendorDataBlock": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_BIR_DATA", pack=False, align=None), "SignatureBlock": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Offset": SimTypeInt(signed=False, label="UInt32")}, name="WINBIO_BIR_DATA", pack=False, align=None)}, name="WINBIO_BIR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["CaptureCallbackContext", "OperationStatus", "UnitId", "Sample", "SampleSize", "RejectDetail"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "Purpose", "Flags", "CaptureCallback", "CaptureCallbackContext"]),
        #
        'WinBioDeleteTemplate': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), offset=0), SimTypeChar(label="Byte")], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "UnitId", "Identity", "SubFactor"]),
        #
        'WinBioLockUnit': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "UnitId"]),
        #
        'WinBioUnlockUnit': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "UnitId"]),
        #
        'WinBioControlUnit': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="WINBIO_COMPONENT"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "UnitId", "Component", "ControlCode", "SendBuffer", "SendBufferSize", "ReceiveBuffer", "ReceiveBufferSize", "ReceiveDataSize", "OperationStatus"]),
        #
        'WinBioControlUnitPrivileged': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="WINBIO_COMPONENT"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "UnitId", "Component", "ControlCode", "SendBuffer", "SendBufferSize", "ReceiveBuffer", "ReceiveBufferSize", "ReceiveDataSize", "OperationStatus"]),
        #
        'WinBioGetProperty': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "PropertyType", "PropertyId", "UnitId", "Identity", "SubFactor", "PropertyBuffer", "PropertyBufferSize"]),
        #
        'WinBioSetProperty': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle", "PropertyType", "PropertyId", "UnitId", "Identity", "SubFactor", "PropertyBuffer", "PropertyBufferSize"]),
        #
        'WinBioFree': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Address"]),
        #
        'WinBioSetCredential': SimTypeFunction([SimTypeInt(signed=False, label="WINBIO_CREDENTIAL_TYPE"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="WINBIO_CREDENTIAL_FORMAT")], SimTypeInt(signed=True, label="Int32"), arg_names=["Type", "Credential", "CredentialSize", "Format"]),
        #
        'WinBioRemoveCredential': SimTypeFunction([SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), SimTypeInt(signed=False, label="WINBIO_CREDENTIAL_TYPE")], SimTypeInt(signed=True, label="Int32"), arg_names=["Identity", "Type"]),
        #
        'WinBioRemoveAllCredentials': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        #
        'WinBioRemoveAllDomainCredentials': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        #
        'WinBioGetCredentialState': SimTypeFunction([SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), SimTypeInt(signed=False, label="WINBIO_CREDENTIAL_TYPE"), SimTypePointer(SimTypeInt(signed=False, label="WINBIO_CREDENTIAL_STATE"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Identity", "Type", "CredentialState"]),
        #
        'WinBioLogonIdentifiedUser': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["SessionHandle"]),
        #
        'WinBioGetEnrolledFactors': SimTypeFunction([SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="UInt32"), "Value": SimUnion({"Null": SimTypeInt(signed=False, label="UInt32"), "Wildcard": SimTypeInt(signed=False, label="UInt32"), "TemplateGuid": SimTypeBottom(label="Guid"), "AccountSid": SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "Data": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 68)}, name="_AccountSid_e__Struct", pack=False, align=None), "SecureId": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 32)}, name="<anon>", label="None")}, name="WINBIO_IDENTITY", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AccountOwner", "EnrolledFactors"]),
        #
        'WinBioGetEnabledSetting': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="WINBIO_SETTING_SOURCE"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Value", "Source"]),
        #
        'WinBioGetLogonSetting': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="WINBIO_SETTING_SOURCE"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Value", "Source"]),
        #
        'WinBioGetDomainLogonSetting': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="WINBIO_SETTING_SOURCE"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Value", "Source"]),
        #
        'WinBioAcquireFocus': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        #
        'WinBioReleaseFocus': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
    }

lib.set_prototypes(prototypes)
