# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx_vmc_app.infra.linked_vpcs.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class ConnectedServices(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx_vmc_app.infra.linked_vpcs.connected_services'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ConnectedServicesStub)
        self._VAPI_OPERATION_IDS = {}


    def list(self,
             linked_vpc_id,
             ):
        """
        List connected services to given linked vpc ID. The response consist of
        all available services along with their status.

        :type  linked_vpc_id: :class:`str`
        :param linked_vpc_id: linked vpc id (required)
        :rtype: :class:`com.vmware.nsx_vmc_app.model_client.ConnectedServiceListResult`
        :return: com.vmware.nsx_vmc_app.model.ConnectedServiceListResult
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('list',
                            {
                            'linked_vpc_id': linked_vpc_id,
                            })

    def update(self,
               linked_vpc_id,
               service_name,
               connected_service_status,
               ):
        """
        Connect/Disconnect the service to the given linked vpc. For example,
        connect S3. The user will know what services are available through the
        GET call. If the user is trying to connect/disconnect an unknown
        service, the POST call will throw a 400 Bad Request error.

        :type  linked_vpc_id: :class:`str`
        :param linked_vpc_id: linked vpc id (required)
        :type  service_name: :class:`str`
        :param service_name: connected service name, e.g. s3 (required)
        :type  connected_service_status: :class:`com.vmware.nsx_vmc_app.model_client.ConnectedServiceStatus`
        :param connected_service_status: (required)
        :rtype: :class:`com.vmware.nsx_vmc_app.model_client.ConnectedServiceStatus`
        :return: com.vmware.nsx_vmc_app.model.ConnectedServiceStatus
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('update',
                            {
                            'linked_vpc_id': linked_vpc_id,
                            'service_name': service_name,
                            'connected_service_status': connected_service_status,
                            })
class _ConnectedServicesStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'linked_vpc_id': type.StringType(),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/cloud-service/api/v1/infra/linked-vpcs/{linked-vpc-id}/connected-services',
            path_variables={
                'linked_vpc_id': 'linked-vpc-id',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for update operation
        update_input_type = type.StructType('operation-input', {
            'linked_vpc_id': type.StringType(),
            'service_name': type.StringType(),
            'connected_service_status': type.ReferenceType('com.vmware.nsx_vmc_app.model_client', 'ConnectedServiceStatus'),
        })
        update_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        update_input_value_validator_list = [
        ]
        update_output_validator_list = [
        ]
        update_rest_metadata = OperationRestMetadata(
            http_method='PUT',
            url_template='/cloud-service/api/v1/infra/linked-vpcs/{linked-vpc-id}/connected-services/{service-name}',
            request_body_parameter='connected_service_status',
            path_variables={
                'linked_vpc_id': 'linked-vpc-id',
                'service_name': 'service-name',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'list': {
                'input_type': list_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_vmc_app.model_client', 'ConnectedServiceListResult'),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'update': {
                'input_type': update_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx_vmc_app.model_client', 'ConnectedServiceStatus'),
                'errors': update_error_dict,
                'input_value_validator_list': update_input_value_validator_list,
                'output_validator_list': update_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'list': list_rest_metadata,
            'update': update_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx_vmc_app.infra.linked_vpcs.connected_services',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'ConnectedServices': ConnectedServices,
    }

