/*
*  RAL -- Rubrica Addressbook Library
*  file: company.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_COMPANY_H
#define _R_COMPANY_H

#include <glib.h>
#include <glib-object.h>

#include "card.h"


#define R_COMPANY_CARD_TYPE          (r_company_card_get_type())

#define R_COMPANY_CARD(obj)          (G_TYPE_CHECK_INSTANCE_CAST((obj),   \
                                      R_COMPANY_CARD_TYPE,                \
                                      RCompanyCard))

#define R_COMPANY_CARD_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST((klass),    \
                                      R_COMPANY_CARD_TYPE,                \
                                      RCompanyCardClass))

#define IS_R_COMPANY_CARD(obj)       (G_TYPE_CHECK_INSTANCE_TYPE((obj),   \
                                      R_COMPANY_CARD_TYPE))

#define IS_R_COMPANY_CARD_CLASS(kls) (G_TYPE_CHECK_CLASS_TYPE((kls),      \
                                      R_COMPANY_CARD_TYPE))

#define R_COMPANY_CARD_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS((kls),   \
                                       R_COMPANY_CARD_TYPE,               \
                                       RCompanyCardClass))


typedef struct _RCompanyCard        RCompanyCard;
typedef struct _RCompanyCardClass   RCompanyCardClass;
typedef struct _RCompanyCardPrivate RCompanyCardPrivate;



struct _RCompanyCard
{
  RCard parent;
  
  RCompanyCardPrivate* priv;
};


struct _RCompanyCardClass
{
  RCardClass parent;
};



GType r_company_card_get_type (void);


RCompanyCard* r_company_card_new (void);





#endif
