/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.IndexedSeqOps;
import scala.collection.IndexedSeqView;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.generic.DefaultSerializable;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.ArrayDeque$;
import scala.collection.mutable.ArrayDequeOps;
import scala.collection.mutable.IndexedBuffer;
import scala.collection.mutable.IndexedSeq$;
import scala.reflect.ClassTag;

public class ArrayDeque<A>
extends AbstractBuffer<A>
implements DefaultSerializable,
ArrayDequeOps<A, ArrayDeque, ArrayDeque<A>>,
IndexedBuffer<A> {
    private Object[] array;
    private int scala$collection$mutable$ArrayDeque$$start;
    private int scala$collection$mutable$ArrayDeque$$end;

    @Override
    public final Object clone() {
        return ArrayDequeOps.clone$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object copySliceToArray(int srcStart, Object dest, int destStart, int maxItems) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ArrayDequeOps.copySliceToArray$(this, (int)var1_1, var2_2, (int)var3_3, maxItems);
    }

    @Override
    public Object reverse() {
        return ArrayDequeOps.reverse$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object slice(int from, int until) {
        void var2_2;
        void var1_1;
        return ArrayDequeOps.slice$(this, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterator<ArrayDeque<A>> sliding(int window, int step) {
        void var2_2;
        void var1_1;
        return ArrayDequeOps.sliding$(this, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterator<ArrayDeque<A>> grouped(int n) {
        void var1_1;
        return ArrayDequeOps.grouped$(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object distinctBy(Function1 f) {
        void var1_1;
        return StrictOptimizedSeqOps.distinctBy$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object prepended(Object elem) {
        void var1_1;
        return StrictOptimizedSeqOps.prepended$(this, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object appended(Object elem) {
        void var1_1;
        return StrictOptimizedSeqOps.appended$(this, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object appendedAll(IterableOnce suffix) {
        void var1_1;
        return StrictOptimizedSeqOps.appendedAll$(this, (IterableOnce)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tuple2<ArrayDeque<A>, ArrayDeque<A>> partition(Function1<A, Object> p) {
        void var1_1;
        return StrictOptimizedIterableOps.partition$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <A1, A2> Tuple2<ArrayDeque<A1>, ArrayDeque<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        void var1_1;
        return StrictOptimizedIterableOps.unzip$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object map(Function1 f) {
        void var1_1;
        return StrictOptimizedIterableOps.map$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object flatMap(Function1 f) {
        void var1_1;
        return StrictOptimizedIterableOps.flatMap$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object collect(PartialFunction pf) {
        void var1_1;
        return StrictOptimizedIterableOps.collect$(this, (PartialFunction)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object flatten(Function1 toIterableOnce) {
        void var1_1;
        return StrictOptimizedIterableOps.flatten$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object zip(IterableOnce that) {
        void var1_1;
        return StrictOptimizedIterableOps.zip$(this, (IterableOnce)var1_1);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object filter(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filter$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object filterNot(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filterNot$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        void var2_2;
        void var1_1;
        return StrictOptimizedIterableOps.filterImpl$(this, (Function1)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object dropRight(int n) {
        void var1_1;
        return StrictOptimizedIterableOps.dropRight$(this, (int)var1_1);
    }

    @Override
    public Iterator<A> iterator() {
        return IndexedSeqOps.iterator$(this);
    }

    @Override
    public Iterator<A> reverseIterator() {
        return IndexedSeqOps.reverseIterator$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B$> B$ foldRight(B$ z, Function2<A, B$, B$> op) {
        void var2_2;
        void var1_1;
        return (B$)IndexedSeqOps.foldRight$(this, (Object)var1_1, (Function2)var2_2);
    }

    @Override
    public IndexedSeqView<A> view() {
        return IndexedSeqOps.view$(this);
    }

    @Override
    public Iterable<A> reversed() {
        return IndexedSeqOps.reversed$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object take(int n) {
        void var1_1;
        return IndexedSeqOps.take$(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object drop(int n) {
        void var1_1;
        return IndexedSeqOps.drop$(this, (int)var1_1);
    }

    @Override
    public A head() {
        return (A)IndexedSeqOps.head$(this);
    }

    @Override
    public Option<A> headOption() {
        return IndexedSeqOps.headOption$(this);
    }

    @Override
    public A last() {
        return (A)IndexedSeqOps.last$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int lengthCompare(int len) {
        void var1_1;
        return IndexedSeqOps.lengthCompare$(this, (int)var1_1);
    }

    @Override
    public Object[] array() {
        return this.array;
    }

    /*
     * WARNING - void declaration
     */
    public void array_$eq(Object[] x$1) {
        void var1_1;
        this.array = var1_1;
    }

    public int scala$collection$mutable$ArrayDeque$$start() {
        return this.scala$collection$mutable$ArrayDeque$$start;
    }

    /*
     * WARNING - void declaration
     */
    public void scala$collection$mutable$ArrayDeque$$start_$eq(int x$1) {
        void var1_1;
        this.scala$collection$mutable$ArrayDeque$$start = var1_1;
    }

    public int scala$collection$mutable$ArrayDeque$$end() {
        return this.scala$collection$mutable$ArrayDeque$$end;
    }

    /*
     * WARNING - void declaration
     */
    public void scala$collection$mutable$ArrayDeque$$end_$eq(int x$1) {
        void var1_1;
        this.scala$collection$mutable$ArrayDeque$$end = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void reset(Object[] array, int start, int end) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!((array.length & array.length - 1) == 0)) {
            throw new AssertionError((Object)new StringBuilder(18).append("assertion failed: ").append((Object)"Array.length must be power of 2").toString());
        }
        int requireBounds_until = array.length;
        if (start < 0 || start >= requireBounds_until) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(start).append(" is out of bounds (min 0, max ").append(requireBounds_until - 1).append(")").toString());
        }
        requireBounds_until = array.length;
        if (end < 0 || end >= requireBounds_until) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(end).append(" is out of bounds (min 0, max ").append(requireBounds_until - 1).append(")").toString());
        }
        this.array_$eq((Object[])var1_1);
        this.scala$collection$mutable$ArrayDeque$$start_$eq((int)var2_2);
        this.scala$collection$mutable$ArrayDeque$$end_$eq((int)var3_3);
    }

    @Override
    public int knownSize() {
        return IndexedSeqOps.knownSize$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public A apply(int idx) {
        void var1_1;
        int requireBounds_until = this.length();
        if (idx < 0 || idx >= requireBounds_until) {
            void var2_2;
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(idx).append(" is out of bounds (min 0, max ").append((int)(var2_2 - true)).append(")").toString());
        }
        return (A)this.array()[this.start_$plus((int)var1_1)];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(int idx, A elem) {
        void var2_2;
        int requireBounds_until = this.length();
        if (idx < 0 || idx >= requireBounds_until) {
            void var3_3;
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(idx).append(" is out of bounds (min 0, max ").append((int)(var3_3 - true)).append(")").toString());
        }
        this.array()[this.start_$plus((int)var1_1)] = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ArrayDeque<A> addOne(A elem) {
        void var1_1;
        ArrayDeque arrayDeque = this;
        arrayDeque.ensureSize(arrayDeque.length() + 1);
        return this.scala$collection$mutable$ArrayDeque$$appendAssumingCapacity(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ArrayDeque<A> prepend(A elem) {
        void var1_1;
        ArrayDeque arrayDeque = this;
        arrayDeque.ensureSize(arrayDeque.length() + 1);
        return this.scala$collection$mutable$ArrayDeque$$prependAssumingCapacity(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ArrayDeque<A> scala$collection$mutable$ArrayDeque$$appendAssumingCapacity(A elem) {
        void var1_1;
        this.array()[this.scala$collection$mutable$ArrayDeque$$end()] = var1_1;
        ArrayDeque arrayDeque = this;
        arrayDeque.scala$collection$mutable$ArrayDeque$$end_$eq(arrayDeque.scala$collection$mutable$ArrayDeque$$end() + 1 & this.array().length - 1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayDeque<A> scala$collection$mutable$ArrayDeque$$prependAssumingCapacity(A elem) {
        void var1_1;
        ArrayDeque arrayDeque = this;
        arrayDeque.scala$collection$mutable$ArrayDeque$$start_$eq(arrayDeque.scala$collection$mutable$ArrayDeque$$start() - 1 & this.array().length - 1);
        this.array()[this.scala$collection$mutable$ArrayDeque$$start()] = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayDeque<A> prependAll(IterableOnce<A> elems2) {
        Iterator it = elems2.iterator();
        if (it.nonEmpty()) {
            int n;
            int n2 = this.length();
            int elems2 = elems2.knownSize();
            if (elems2 < 0) {
                void var1_3;
                IndexedSeq$ toFactory_factory = IndexedSeq$.MODULE$;
                this.prependAll((IterableOnce)it.to(new IterableFactory.ToFactory(var1_3)));
            } else if (n + n2 >= this.array().length) {
                void finalLength = n + n2;
                Object[] array2 = ArrayDeque$.MODULE$.alloc((int)finalLength);
                it.copyToArray(array2);
                this.copySliceToArray(0, array2, n, n2);
                this.reset(array2, 0, (int)finalLength);
            } else {
                for (int i = 0; i < n; ++i) {
                    void _set_elem;
                    A array2 = it.next();
                    int _set_idx = i - n;
                    this.array()[this.start_$plus((int)_set_idx)] = _set_elem;
                }
                ArrayDeque arrayDeque = this;
                arrayDeque.scala$collection$mutable$ArrayDeque$$start_$eq(arrayDeque.scala$collection$mutable$ArrayDeque$$start() - n & this.array().length - 1);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ArrayDeque<A> addAll(IterableOnce<A> elems) {
        int n = elems.knownSize();
        if (n > 0) {
            this.ensureSize(n + this.length());
            elems.iterator().foreach((Function1<Object, ArrayDeque> & Serializable)elem -> {
                void var1_1;
                return this.scala$collection$mutable$ArrayDeque$$appendAssumingCapacity(var1_1);
            });
        } else {
            void var1_1;
            var1_1.iterator().foreach((Function1<Object, ArrayDeque> & Serializable)elem -> {
                void var1_1;
                return (ArrayDeque)this.$plus$eq(var1_1);
            });
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void remove(int idx, int count) {
        void var2_2;
        if (count > 0) {
            void var3_4;
            int i;
            int requireBounds_until = this.length();
            if (idx < 0 || idx >= requireBounds_until) {
                throw new IndexOutOfBoundsException(new StringBuilder(31).append(idx).append(" is out of bounds (min 0, max ").append(requireBounds_until - 1).append(")").toString());
            }
            int n = this.length();
            int removals = Math.min(n - idx, count);
            int finalLength = n - removals;
            int suffixStart = idx + removals;
            if (this.array().length > 128 && this.array().length - finalLength - (finalLength >> 1) > finalLength) {
                void var2_3;
                Object[] array2 = ArrayDeque$.MODULE$.alloc(finalLength);
                this.copySliceToArray(0, array2, 0, idx);
                this.copySliceToArray(suffixStart, array2, idx, n);
                this.reset((Object[])var2_3, 0, finalLength);
                return;
            }
            if (2 * idx <= finalLength) {
                for (i = suffixStart - 1; i >= var2_2; --i) {
                    void var3_5;
                    int _get_idx = i - var2_2;
                    Object _set_elem = this.array()[this.start_$plus(_get_idx)];
                    this.array()[this.start_$plus((int)i)] = var3_5;
                }
                while (i >= 0) {
                    this.array()[this.start_$plus((int)i)] = null;
                    --i;
                }
                ArrayDeque arrayDeque = this;
                arrayDeque.scala$collection$mutable$ArrayDeque$$start_$eq(arrayDeque.start_$plus((int)var2_2));
                return;
            }
            while (i < finalLength) {
                Object _set_elem;
                int _get_idx = i + var2_2;
                this.array()[this.start_$plus((int)i)] = _set_elem = this.array()[this.start_$plus(_get_idx)];
                ++i;
            }
            while (i < var3_4) {
                this.array()[this.start_$plus((int)i)] = null;
                ++i;
            }
            ArrayDeque arrayDeque = this;
            arrayDeque.scala$collection$mutable$ArrayDeque$$end_$eq(arrayDeque.scala$collection$mutable$ArrayDeque$$end() - var2_2 & this.array().length - 1);
            return;
        }
        if (!(var2_2 == false)) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)ArrayDeque.$anonfun$remove$1((int)var2_2)).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public A remove(int idx) {
        void var2_2;
        void var1_1;
        A elem = this.apply(idx);
        this.remove((int)var1_1, 1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ArrayDeque<A> subtractOne(A elem) {
        int idx = this.indexOf(elem);
        if (idx >= 0) {
            void var1_2;
            this.remove((int)var1_2, 1);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public A removeHead(boolean resizeInternalRepr) {
        void var2_2;
        void var1_1;
        if (this.isEmpty()) {
            throw new NoSuchElementException("empty collection");
        }
        Object removeHeadAssumingNonEmpty_elem = this.array()[this.scala$collection$mutable$ArrayDeque$$start()];
        this.array()[this.scala$collection$mutable$ArrayDeque$$start()] = null;
        ArrayDeque arrayDeque = this;
        arrayDeque.scala$collection$mutable$ArrayDeque$$start_$eq(arrayDeque.start_$plus(1));
        if (var1_1 != false) {
            ArrayDeque arrayDeque2 = this;
            arrayDeque2.scala$collection$mutable$ArrayDeque$$resize(arrayDeque2.length());
        }
        return var2_2;
    }

    public boolean removeHead$default$1() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void ensureSize(int hint) {
        if (hint > this.length() && hint >= this.array().length) {
            void var1_1;
            this.scala$collection$mutable$ArrayDeque$$resize((int)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int length() {
        void var1_1;
        int scala$collection$mutable$ArrayDeque$$end_$minus_idx = this.scala$collection$mutable$ArrayDeque$$start();
        return this.scala$collection$mutable$ArrayDeque$$end() - var1_1 & this.array().length - 1;
    }

    @Override
    public boolean isEmpty() {
        return this.scala$collection$mutable$ArrayDeque$$start() == this.scala$collection$mutable$ArrayDeque$$end();
    }

    @Override
    public ArrayDeque<A> klone() {
        return new ArrayDeque<A>((Object[])this.array().clone(), this.scala$collection$mutable$ArrayDeque$$start(), this.scala$collection$mutable$ArrayDeque$$end());
    }

    @Override
    public SeqFactory<ArrayDeque> iterableFactory() {
        return ArrayDeque$.MODULE$;
    }

    @Override
    public void clear() {
        while (this.nonEmpty()) {
            this.array();
            this.scala$collection$mutable$ArrayDeque$$start();
            this.array()[this.scala$collection$mutable$ArrayDeque$$start()] = null;
            ArrayDeque arrayDeque = this;
            arrayDeque.scala$collection$mutable$ArrayDeque$$start_$eq(arrayDeque.start_$plus(1));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ArrayDeque<A> ofArray(Object[] array, int end) {
        void var2_2;
        void var1_1;
        return new ArrayDeque<A>((Object[])var1_1, 0, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B> int copyToArray(Object dest, int destStart, int len) {
        void elemsToCopyToArray_destLen;
        int n = Array.getLength(dest);
        int elemsToCopyToArray_srcLen = this.length();
        int copied = Math.max(Math.min(Math.min(len, elemsToCopyToArray_srcLen), (int)(elemsToCopyToArray_destLen - destStart)), 0);
        if (copied > 0) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.copySliceToArray(0, var1_1, (int)var2_2, (int)var3_3);
        }
        return copied;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <B> Object toArray(ClassTag<B> evidence$1) {
        void var1_1;
        return this.copySliceToArray(0, var1_1.newArray(this.length()), 0, this.length());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int start_$plus(int idx) {
        void var1_1;
        return this.scala$collection$mutable$ArrayDeque$$start() + var1_1 & this.array().length - 1;
    }

    /*
     * WARNING - void declaration
     */
    public void scala$collection$mutable$ArrayDeque$$resize(int len) {
        if (len >= this.array().length || this.array().length > 16 && this.array().length - len > len) {
            void var2_3;
            void var1_2;
            int n = this.length();
            Object[] array2 = (Object[])this.copySliceToArray(0, ArrayDeque$.MODULE$.alloc(len), 0, n);
            this.reset((Object[])var1_2, 0, (int)var2_3);
            return;
        }
    }

    @Override
    public String stringPrefix() {
        return "ArrayDeque";
    }

    public static final /* synthetic */ String $anonfun$remove$1(int count$1) {
        int n;
        return new StringBuilder(38).append("removing negative number of elements: ").append(n).toString();
    }

    /*
     * WARNING - void declaration
     */
    public ArrayDeque(Object[] array, int start, int end) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.array = var1_1;
        this.scala$collection$mutable$ArrayDeque$$start = var2_2;
        this.scala$collection$mutable$ArrayDeque$$end = var3_3;
        ArrayDeque arrayDeque = this;
        arrayDeque.reset(arrayDeque.array(), this.scala$collection$mutable$ArrayDeque$$start(), this.scala$collection$mutable$ArrayDeque$$end());
    }

    /*
     * WARNING - void declaration
     */
    public ArrayDeque(int initialSize) {
        this(ArrayDeque$.MODULE$.alloc((int)var1_1), 0, 0);
        void var1_1;
    }
}

