/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.semanticdb;

import dotty.tools.dotc.semanticdb.Diagnostic;
import dotty.tools.dotc.semanticdb.Diagnostic$Severity$ERROR$;
import dotty.tools.dotc.semanticdb.Diagnostic$Severity$INFORMATION$;
import dotty.tools.dotc.semanticdb.Diagnostic$Severity$WARNING$;
import dotty.tools.dotc.semanticdb.Language;
import dotty.tools.dotc.semanticdb.Language$JAVA$;
import dotty.tools.dotc.semanticdb.Language$SCALA$;
import dotty.tools.dotc.semanticdb.Language$UNKNOWN_LANGUAGE$;
import dotty.tools.dotc.semanticdb.Language$Unrecognized$;
import dotty.tools.dotc.semanticdb.PPrint$package$;
import dotty.tools.dotc.semanticdb.PrinterSymtab;
import dotty.tools.dotc.semanticdb.PrinterSymtab$;
import dotty.tools.dotc.semanticdb.Range;
import dotty.tools.dotc.semanticdb.Scala3$;
import dotty.tools.dotc.semanticdb.Scala3$StringOps$;
import dotty.tools.dotc.semanticdb.Schema;
import dotty.tools.dotc.semanticdb.Schema$LEGACY$;
import dotty.tools.dotc.semanticdb.Schema$SEMANTICDB3$;
import dotty.tools.dotc.semanticdb.Schema$SEMANTICDB4$;
import dotty.tools.dotc.semanticdb.Schema$Unrecognized$;
import dotty.tools.dotc.semanticdb.SymbolInformation;
import dotty.tools.dotc.semanticdb.SymbolInformationPrinter;
import dotty.tools.dotc.semanticdb.SymbolOccurrence;
import dotty.tools.dotc.semanticdb.Synthetic;
import dotty.tools.dotc.semanticdb.SyntheticPrinter;
import dotty.tools.dotc.semanticdb.TextDocument;
import dotty.tools.dotc.semanticdb.TextDocuments;
import dotty.tools.dotc.semanticdb.TextDocuments$;
import dotty.tools.dotc.semanticdb.internal.MD5$;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourceFile$;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;

public final class Tools$
implements Serializable {
    public static final Tools$ MODULE$ = new Tools$();

    private Tools$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Tools$.class);
    }

    public String mkURIstring(Path path) {
        Iterable uriParts = (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)path).asScala().map((Function1 & Serializable)part -> new URI(null, null, new java.lang.StringBuilder(1).append("/").append(part.toString()).toString(), null));
        return StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(uriParts.mkString()), "/");
    }

    public TextDocument loadTextDocument(Path scalaAbsolutePath, Path scalaRelativePath, Path semanticdbAbsolutePath) {
        String reluri = this.mkURIstring(scalaRelativePath);
        TextDocuments sdocs = this.parseTextDocuments(semanticdbAbsolutePath);
        Option option = sdocs.documents().find((Function1 & Serializable)_$1 -> {
            String string = _$1.uri();
            String string2 = reluri;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (None$.MODULE$.equals(option)) {
            throw new NoSuchElementException(String.valueOf(scalaRelativePath));
        }
        if (option instanceof Some) {
            TextDocument document = (TextDocument)((Some)option).value();
            String text = new String(Files.readAllBytes(scalaAbsolutePath), StandardCharsets.UTF_8);
            String md5FingerprintOnDisk = MD5$.MODULE$.compute(text);
            String string = document.md5();
            String string2 = md5FingerprintOnDisk;
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new IllegalArgumentException(new java.lang.StringBuilder(18).append("stale semanticdb: ").append(scalaRelativePath).toString());
            }
            return document.copy(document.copy$default$1(), document.copy$default$2(), text, document.copy$default$4(), document.copy$default$5(), document.copy$default$6(), document.copy$default$7(), document.copy$default$8(), document.copy$default$9());
        }
        throw new MatchError((Object)option);
    }

    public TextDocument loadTextDocumentUnsafe(Path scalaAbsolutePath, Path semanticdbAbsolutePath) {
        Seq<TextDocument> docs = this.parseTextDocuments(semanticdbAbsolutePath).documents();
        if (docs.length() != 1) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        TextDocument textDocument = (TextDocument)docs.head();
        String string = new String(Files.readAllBytes(scalaAbsolutePath), StandardCharsets.UTF_8);
        Schema schema = textDocument.copy$default$1();
        String string2 = textDocument.copy$default$2();
        String string3 = textDocument.copy$default$4();
        Language language = textDocument.copy$default$5();
        Seq<SymbolInformation> seq = textDocument.copy$default$6();
        Seq<SymbolOccurrence> seq2 = textDocument.copy$default$7();
        Seq<Diagnostic> seq3 = textDocument.copy$default$8();
        Seq<Synthetic> seq4 = textDocument.copy$default$9();
        return textDocument.copy(schema, string2, string, string3, language, seq, seq2, seq3, seq4);
    }

    /*
     * WARNING - void declaration
     */
    private TextDocuments parseTextDocuments(Path path) {
        void var3_2;
        byte[] x$proxy1 = Files.readAllBytes(path);
        if (x$proxy1 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        void bytes = var3_2;
        return (TextDocuments)TextDocuments$.MODULE$.parseFrom((byte[])bytes);
    }

    public StringBuilder metac(TextDocument doc, Path realPath, StringBuilder sb) {
        LazyRef lazyRef = new LazyRef();
        PrinterSymtab symtab = PrinterSymtab$.MODULE$.fromTextDocument(doc);
        SymbolInformationPrinter symPrinter = new SymbolInformationPrinter(symtab);
        String realURI = realPath.toString();
        SyntheticPrinter synthPrinter = new SyntheticPrinter(symtab, this.sourceFile$1(lazyRef, doc));
        StringBuilder sb$proxy1 = sb.append(realURI);
        sb$proxy1.append((Object)System.lineSeparator());
        StringBuilder sb$proxy2 = sb.append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("-"), realURI.length()));
        sb$proxy2.append((Object)System.lineSeparator());
        sb.append((Object)System.lineSeparator());
        StringBuilder sb$proxy3 = sb.append("Summary:");
        sb$proxy3.append((Object)System.lineSeparator());
        StringBuilder sb$proxy4 = sb.append("Schema => ").append(this.schemaString(doc.schema()));
        sb$proxy4.append((Object)System.lineSeparator());
        StringBuilder sb$proxy5 = sb.append("Uri => ").append(doc.uri());
        sb$proxy5.append((Object)System.lineSeparator());
        StringBuilder sb$proxy6 = sb.append("Text => empty");
        sb$proxy6.append((Object)System.lineSeparator());
        StringBuilder sb$proxy7 = sb.append("Language => ").append(this.languageString(doc.language()));
        sb$proxy7.append((Object)System.lineSeparator());
        StringBuilder sb$proxy8 = sb.append("Symbols => ").append(doc.symbols().length()).append(" entries");
        sb$proxy8.append((Object)System.lineSeparator());
        StringBuilder sb$proxy9 = sb.append("Occurrences => ").append(doc.occurrences().length()).append(" entries");
        sb$proxy9.append((Object)System.lineSeparator());
        if (doc.diagnostics().nonEmpty()) {
            StringBuilder sb$proxy10 = sb.append("Diagnostics => ").append(doc.diagnostics().length()).append(" entries");
            sb$proxy10.append((Object)System.lineSeparator());
        }
        if (doc.synthetics().nonEmpty()) {
            StringBuilder sb$proxy11 = sb.append("Synthetics => ").append(doc.synthetics().length()).append(" entries");
            sb$proxy11.append((Object)System.lineSeparator());
        }
        sb.append((Object)System.lineSeparator());
        StringBuilder sb$proxy12 = sb.append("Symbols:");
        sb$proxy12.append((Object)System.lineSeparator());
        ((IterableOnceOps)doc.symbols().sorted(Scala3$.MODULE$.given_Ordering_SymbolInformation())).foreach((Function1)(JProcedure1 & Serializable)s -> MODULE$.processSymbol((SymbolInformation)s, symPrinter, sb));
        sb.append((Object)System.lineSeparator());
        StringBuilder sb$proxy13 = sb.append("Occurrences:");
        sb$proxy13.append((Object)System.lineSeparator());
        ((IterableOnceOps)doc.occurrences().sorted(Scala3$.MODULE$.given_Ordering_SymbolOccurrence())).foreach((Function1)(JProcedure1 & Serializable)occ -> this.processOccurrence((SymbolOccurrence)occ, sb, this.sourceFile$1(lazyRef, doc)));
        sb.append((Object)System.lineSeparator());
        if (doc.diagnostics().nonEmpty()) {
            StringBuilder sb$proxy14 = sb.append("Diagnostics:");
            sb$proxy14.append((Object)System.lineSeparator());
            ((IterableOnceOps)doc.diagnostics().sorted(Scala3$.MODULE$.given_Ordering_Diagnostic())).foreach((Function1)(JProcedure1 & Serializable)d -> MODULE$.processDiag((Diagnostic)d, sb));
            sb.append((Object)System.lineSeparator());
        }
        if (doc.synthetics().nonEmpty()) {
            StringBuilder sb$proxy15 = sb.append("Synthetics:");
            sb$proxy15.append((Object)System.lineSeparator());
            ((IterableOnceOps)doc.synthetics().sorted(Scala3$.MODULE$.given_Ordering_Synthetic())).foreach((Function1)(JProcedure1 & Serializable)s -> MODULE$.processSynth((Synthetic)s, synthPrinter, sb));
            sb.append((Object)System.lineSeparator());
        }
        return sb;
    }

    private String schemaString(Schema schema) {
        Schema schema2 = schema;
        if (Schema$SEMANTICDB3$.MODULE$.equals(schema2)) {
            return "SemanticDB v3";
        }
        if (Schema$SEMANTICDB4$.MODULE$.equals(schema2)) {
            return "SemanticDB v4";
        }
        if (Schema$LEGACY$.MODULE$.equals(schema2)) {
            return "SemanticDB legacy";
        }
        if (schema2 instanceof Schema.Unrecognized) {
            Schema.Unrecognized unrecognized = Schema$Unrecognized$.MODULE$.unapply((Schema.Unrecognized)schema2);
            int n = unrecognized._1();
            return "unknown";
        }
        throw new MatchError((Object)schema2);
    }

    private String languageString(Language language) {
        Language language2;
        block6: {
            block5: {
                language2 = language;
                if (Language$SCALA$.MODULE$.equals(language2)) {
                    return "Scala";
                }
                if (Language$JAVA$.MODULE$.equals(language2)) {
                    return "Java";
                }
                if (Language$UNKNOWN_LANGUAGE$.MODULE$.equals(language2)) break block5;
                if (!(language2 instanceof Language.Unrecognized)) break block6;
                Language.Unrecognized unrecognized = Language$Unrecognized$.MODULE$.unapply((Language.Unrecognized)language2);
                int n = unrecognized._1();
            }
            return "unknown";
        }
        throw new MatchError((Object)language2);
    }

    private void processSymbol(SymbolInformation info, SymbolInformationPrinter printer, StringBuilder sb) {
        StringBuilder sb$proxy16 = sb.append(printer.pprintSymbolInformation(info));
        sb$proxy16.append((Object)System.lineSeparator());
    }

    private void processSynth(Synthetic synth, SyntheticPrinter printer, StringBuilder sb) {
        StringBuilder sb$proxy17 = sb.append(printer.pprint(synth));
        sb$proxy17.append((Object)System.lineSeparator());
    }

    private void processDiag(Diagnostic d, StringBuilder sb) {
        StringBuilder stringBuilder;
        Option<Range> option = d.range();
        if (option instanceof Some) {
            Range range = (Range)((Some)option).value();
            PPrint$package$.MODULE$.processRange(sb, range);
            stringBuilder = BoxedUnit.UNIT;
        } else {
            stringBuilder = sb.append("[):");
        }
        sb.append(" ");
        Diagnostic.Severity severity = d.severity();
        StringBuilder stringBuilder2 = Diagnostic$Severity$ERROR$.MODULE$.equals(severity) ? sb.append("[error]") : (Diagnostic$Severity$WARNING$.MODULE$.equals(severity) ? sb.append("[warning]") : (Diagnostic$Severity$INFORMATION$.MODULE$.equals(severity) ? sb.append("[info]") : sb.append("[unknown]")));
        sb.append(" ");
        sb.append(d.message());
        sb.append((Object)System.lineSeparator());
    }

    private void processOccurrence(SymbolOccurrence occ, StringBuilder sb, SourceFile sourceFile) {
        StringBuilder stringBuilder;
        Option<Range> option = occ.range();
        if (option instanceof Some) {
            Range range = (Range)((Some)option).value();
            PPrint$package$.MODULE$.processRange(sb, range);
            if (!(range.endLine() != range.startLine() || range.startCharacter() == range.endCharacter() || Scala3$StringOps$.MODULE$.isConstructor(occ.symbol()) && occ.role().isDefinition())) {
                String line = sourceFile.lineContent(sourceFile.lineToOffset(range.startLine()));
                if (range.startCharacter() > line.length() || range.endCharacter() > line.length()) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)new java.lang.StringBuilder(42).append("Line is only ").append(line.length()).append(" - start line was ").append(range.startLine()).append(" in source ").append(sourceFile.name()).toString());
                }
                sb.append(" ").append((Object)line.substring(range.startCharacter(), range.endCharacter()));
                stringBuilder = BoxedUnit.UNIT;
            } else {
                stringBuilder = BoxedUnit.UNIT;
            }
        } else {
            stringBuilder = sb.append("[):");
        }
        StringBuilder sb$proxy18 = sb.append(occ.role().isReference() ? " -> " : " <- ").append(occ.symbol());
        sb$proxy18.append((Object)System.lineSeparator());
    }

    private final SourceFile sourceFile$lzyINIT1$1(LazyRef sourceFile$lzy1$1, TextDocument doc$1) {
        SourceFile sourceFile;
        LazyRef lazyRef = sourceFile$lzy1$1;
        synchronized (lazyRef) {
            sourceFile = (SourceFile)(sourceFile$lzy1$1.initialized() ? sourceFile$lzy1$1.value() : sourceFile$lzy1$1.initialize((Object)SourceFile$.MODULE$.virtual(doc$1.uri(), doc$1.text(), SourceFile$.MODULE$.virtual$default$3())));
        }
        return sourceFile;
    }

    private final SourceFile sourceFile$1(LazyRef sourceFile$lzy1$2, TextDocument doc$2) {
        return (SourceFile)(sourceFile$lzy1$2.initialized() ? sourceFile$lzy1$2.value() : this.sourceFile$lzyINIT1$1(sourceFile$lzy1$2, doc$2));
    }
}

