/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.certificate.ocsp;

import de.rub.nds.asn1.Asn1Encodable;
import de.rub.nds.asn1.model.Asn1EncapsulatingBitString;
import de.rub.nds.asn1.model.Asn1EncapsulatingOctetString;
import de.rub.nds.asn1.model.Asn1EndOfContent;
import de.rub.nds.asn1.model.Asn1Enumerated;
import de.rub.nds.asn1.model.Asn1Explicit;
import de.rub.nds.asn1.model.Asn1Integer;
import de.rub.nds.asn1.model.Asn1Null;
import de.rub.nds.asn1.model.Asn1ObjectIdentifier;
import de.rub.nds.asn1.model.Asn1PrimitiveGeneralizedTime;
import de.rub.nds.asn1.model.Asn1PrimitiveOctetString;
import de.rub.nds.asn1.model.Asn1Sequence;
import de.rub.nds.tlsattacker.core.certificate.ocsp.CertificateStatus;
import de.rub.nds.tlsattacker.core.util.Asn1ToolInitializer;
import java.math.BigInteger;
import java.util.List;

public class CertificateStatusParser {
    public static CertificateStatus parseCertificateStatus(Asn1Sequence certStatusSeq) {
        Asn1ToolInitializer.initAsn1Tool();
        CertificateStatus certificateStatus = new CertificateStatus();
        certificateStatus.setCertificateStatusSequence(certStatusSeq);
        String hashAlgorithmIdentifier = null;
        byte[] issuerNameHash = null;
        byte[] issuerKeyHash = null;
        BigInteger serialNumber = null;
        Integer certificateStatusValue = null;
        String revocationTime = null;
        Integer revocationReason = null;
        String timeOfLastUpdate = null;
        String timeOfNextUpdate = null;
        Asn1Sequence requestInformation = (Asn1Sequence)certStatusSeq.getChildren().get(0);
        Asn1Sequence hashAlgorithmSequence = (Asn1Sequence)requestInformation.getChildren().get(0);
        hashAlgorithmIdentifier = ((Asn1ObjectIdentifier)hashAlgorithmSequence.getChildren().get(0)).getValue();
        Asn1Encodable issuerNameHashObject = (Asn1Encodable)requestInformation.getChildren().get(1);
        Asn1Encodable issuerKeyHashObject = (Asn1Encodable)requestInformation.getChildren().get(2);
        if (issuerNameHashObject instanceof Asn1PrimitiveOctetString) {
            issuerNameHash = ((Asn1PrimitiveOctetString)issuerNameHashObject).getValue();
        } else if (issuerNameHashObject instanceof Asn1EncapsulatingOctetString) {
            issuerNameHash = (byte[])((Asn1EncapsulatingOctetString)issuerNameHashObject).getContent().getValue();
        }
        if (issuerKeyHashObject instanceof Asn1PrimitiveOctetString) {
            issuerKeyHash = ((Asn1PrimitiveOctetString)issuerKeyHashObject).getValue();
        } else if (issuerKeyHashObject instanceof Asn1EncapsulatingOctetString) {
            issuerKeyHash = (byte[])((Asn1EncapsulatingOctetString)issuerKeyHashObject).getContent().getValue();
        }
        Asn1Encodable serialNumberObject = (Asn1Encodable)requestInformation.getChildren().get(3);
        if (serialNumberObject instanceof Asn1Integer) {
            serialNumber = ((Asn1Integer)serialNumberObject).getValue();
        } else if (serialNumberObject instanceof Asn1EncapsulatingBitString) {
            Asn1EncapsulatingBitString serialNumberBitStringObject = (Asn1EncapsulatingBitString)serialNumberObject;
            serialNumber = new BigInteger(1, (byte[])serialNumberBitStringObject.getContent().getValue());
        }
        Asn1Encodable certStatusObject = (Asn1Encodable)certStatusSeq.getChildren().get(1);
        if (certStatusObject instanceof Asn1Null || certStatusObject instanceof Asn1EndOfContent) {
            certificateStatusValue = 0;
        } else if (certStatusObject instanceof Asn1Explicit) {
            Asn1Explicit certStatusExplicitObject = (Asn1Explicit)certStatusObject;
            switch (certStatusExplicitObject.getOffset()) {
                case 1: {
                    certificateStatusValue = 1;
                    List revocationObjects = certStatusExplicitObject.getChildren();
                    revocationTime = ((Asn1PrimitiveGeneralizedTime)revocationObjects.get(0)).getValue();
                    if (revocationObjects.size() <= 1 || !(revocationObjects.get(1) instanceof Asn1Explicit)) break;
                    revocationReason = ((Asn1Enumerated)revocationObjects.get(1)).getValue().intValue();
                    break;
                }
                case 2: {
                    certificateStatusValue = 2;
                }
            }
        }
        Asn1PrimitiveGeneralizedTime timeOfLastUpdateObject = (Asn1PrimitiveGeneralizedTime)certStatusSeq.getChildren().get(2);
        timeOfLastUpdate = timeOfLastUpdateObject.getValue();
        block7: for (int i = 3; i < certStatusSeq.getChildren().size(); ++i) {
            Asn1Encodable nextObject = (Asn1Encodable)certStatusSeq.getChildren().get(i);
            if (!(nextObject instanceof Asn1Explicit)) continue;
            Asn1Explicit nextExplicitObject = (Asn1Explicit)nextObject;
            switch (nextExplicitObject.getOffset()) {
                case 0: {
                    timeOfNextUpdate = ((Asn1PrimitiveGeneralizedTime)nextExplicitObject.getChildren().get(0)).getValue();
                    continue block7;
                }
            }
        }
        certificateStatus.setHashAlgorithmIdentifier(hashAlgorithmIdentifier);
        certificateStatus.setIssuerNameHash(issuerNameHash);
        certificateStatus.setIssuerKeyHash(issuerKeyHash);
        certificateStatus.setSerialNumber(serialNumber);
        certificateStatus.setCertificateStatus(certificateStatusValue);
        certificateStatus.setRevocationTime(revocationTime);
        certificateStatus.setRevocationReason(revocationReason);
        certificateStatus.setTimeOfLastUpdate(timeOfLastUpdate);
        certificateStatus.setTimeOfNextUpdate(timeOfNextUpdate);
        return certificateStatus;
    }
}

