/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.ec;

import de.rub.nds.tlsattacker.core.crypto.ec.FieldElement;
import java.io.Serializable;
import java.math.BigInteger;

public class FieldElementFp
extends FieldElement
implements Serializable {
    public FieldElementFp(BigInteger data, BigInteger modulus) {
        super(data.mod(modulus), modulus);
    }

    private FieldElementFp() {
        super(null, null);
    }

    @Override
    public FieldElement add(FieldElement f) {
        BigInteger tmp = this.getData().add(f.getData());
        tmp = tmp.mod(this.getModulus());
        return new FieldElementFp(tmp, this.getModulus());
    }

    @Override
    public FieldElement mult(FieldElement f) {
        BigInteger tmp = this.getData().multiply(f.getData());
        tmp = tmp.mod(this.getModulus());
        return new FieldElementFp(tmp, this.getModulus());
    }

    @Override
    public FieldElement addInv() {
        BigInteger tmp = this.getData().negate();
        tmp = tmp.mod(this.getModulus());
        return new FieldElementFp(tmp, this.getModulus());
    }

    @Override
    public FieldElement multInv() {
        if (this.getData().equals(BigInteger.ZERO)) {
            throw new ArithmeticException();
        }
        BigInteger tmp = this.getData().modInverse(this.getModulus());
        return new FieldElementFp(tmp, this.getModulus());
    }
}

