/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.factory.HandlerFactory;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EncryptedServerNameIndicationExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.HRRKeyShareExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.EncryptedServerNameIndicationExtensionPreparator;
import de.rub.nds.tlsattacker.core.state.TlsContext;

public abstract class HandshakeMessageHandler<ProtocolMessage extends HandshakeMessage>
extends ProtocolMessageHandler<ProtocolMessage> {
    public HandshakeMessageHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    protected void adjustExtensions(ProtocolMessage message, HandshakeMessageType handshakeMessageType) {
        if (((HandshakeMessage)message).getExtensions() != null) {
            for (ExtensionMessage extension : ((HandshakeMessage)message).getExtensions()) {
                if (extension instanceof HRRKeyShareExtensionMessage) {
                    handshakeMessageType = HandshakeMessageType.HELLO_RETRY_REQUEST;
                }
                ExtensionHandler handler = HandlerFactory.getExtensionHandler(this.tlsContext, extension.getExtensionTypeConstant(), handshakeMessageType);
                handler.adjustTLSContext(extension);
            }
        }
    }

    @Override
    public void prepareAfterParse(ProtocolMessage handshakeMessage) {
        super.prepareAfterParse(handshakeMessage);
        if (((HandshakeMessage)handshakeMessage).getExtensions() != null) {
            for (ExtensionMessage extensionMessage : ((HandshakeMessage)handshakeMessage).getExtensions()) {
                HandshakeMessageType handshakeMessageType = ((HandshakeMessage)handshakeMessage).getHandshakeMessageType();
                ExtensionHandler extensionHhandler = HandlerFactory.getExtensionHandler(this.tlsContext, extensionMessage.getExtensionTypeConstant(), handshakeMessageType);
                if (!(extensionMessage instanceof EncryptedServerNameIndicationExtensionMessage)) continue;
                EncryptedServerNameIndicationExtensionPreparator preparator = (EncryptedServerNameIndicationExtensionPreparator)extensionHhandler.getPreparator(extensionMessage);
                if (handshakeMessage instanceof ClientHelloMessage) {
                    preparator.setClientHelloMessage((ClientHelloMessage)handshakeMessage);
                }
                preparator.prepareAfterParse();
            }
        }
    }
}

