/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ExtensionHandler<Message extends ExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final TlsContext context;

    public ExtensionHandler(TlsContext context) {
        this.context = context;
    }

    public abstract ExtensionParser getParser(byte[] var1, int var2);

    public abstract ExtensionPreparator getPreparator(Message var1);

    public abstract ExtensionSerializer getSerializer(Message var1);

    public final void adjustTLSContext(Message message) {
        this.markExtensionInContext(message);
        this.adjustTLSExtensionContext(message);
    }

    public abstract void adjustTLSExtensionContext(Message var1);

    private void markExtensionInContext(Message message) {
        ExtensionType extType = ((ExtensionMessage)message).getExtensionTypeConstant();
        ConnectionEndType talkingConEndType = this.context.getTalkingConnectionEndType();
        if (talkingConEndType == ConnectionEndType.CLIENT) {
            this.context.addProposedExtension(extType);
            LOGGER.debug("Marked extension '" + extType.name() + "' as proposed");
        } else if (talkingConEndType == ConnectionEndType.SERVER) {
            this.context.addNegotiatedExtension(extType);
            LOGGER.debug("Marked extension '" + extType.name() + "' as negotiated");
        }
    }
}

