/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.handler.SSL2ClientHelloHandler;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2HandshakeMessage;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class SSL2ClientHelloMessage
extends SSL2HandshakeMessage {
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    private ModifiableByteArray protocolVersion;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger cipherSuiteLength;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger sessionIdLength;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger challengeLength;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.TLS_CONSTANT)
    private ModifiableByteArray cipherSuites;
    private ModifiableByteArray sessionId;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.KEY_MATERIAL)
    private ModifiableByteArray challenge;

    public SSL2ClientHelloMessage() {
        super(HandshakeMessageType.SSL2_CLIENT_HELLO);
    }

    public SSL2ClientHelloMessage(Config config) {
        this();
    }

    @Override
    public String toCompactString() {
        return "SSL2 ClientHello Message";
    }

    public ModifiableByteArray getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(ModifiableByteArray protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public void setProtocolVersion(byte[] protocolVersion) {
        this.protocolVersion = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.protocolVersion, (byte[])protocolVersion);
    }

    public ModifiableInteger getCipherSuiteLength() {
        return this.cipherSuiteLength;
    }

    public void setCipherSuiteLength(ModifiableInteger cipherSuiteLength) {
        this.cipherSuiteLength = cipherSuiteLength;
    }

    public void setCipherSuiteLength(int cipherSuiteLength) {
        this.cipherSuiteLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.cipherSuiteLength, (Integer)cipherSuiteLength);
    }

    public ModifiableByteArray getCipherSuites() {
        return this.cipherSuites;
    }

    public void setCipherSuites(ModifiableByteArray cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public void setCipherSuites(byte[] cipherSuites) {
        this.cipherSuites = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.cipherSuites, (byte[])cipherSuites);
    }

    public ModifiableByteArray getChallenge() {
        return this.challenge;
    }

    public void setChallenge(ModifiableByteArray challenge) {
        this.challenge = challenge;
    }

    public void setChallenge(byte[] challenge) {
        this.challenge = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.challenge, (byte[])challenge);
    }

    public ModifiableInteger getSessionIdLength() {
        return this.sessionIdLength;
    }

    public void setSessionIdLength(ModifiableInteger sessionIdLength) {
        this.sessionIdLength = sessionIdLength;
    }

    public void setSessionIDLength(int sessionIDLength) {
        this.sessionIdLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.sessionIdLength, (Integer)sessionIDLength);
    }

    public ModifiableInteger getChallengeLength() {
        return this.challengeLength;
    }

    public void setChallengeLength(int challengeLength) {
        this.challengeLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.challengeLength, (Integer)challengeLength);
    }

    public void setChallengeLength(ModifiableInteger challengeLength) {
        this.challengeLength = challengeLength;
    }

    public ModifiableByteArray getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(ModifiableByteArray sessionId) {
        this.sessionId = sessionId;
    }

    public void setSessionID(byte[] sessionID) {
        this.sessionId = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.sessionId, (byte[])sessionID);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SSL2ClientHelloMessage:");
        sb.append("\n  Protocol Version: ");
        if (this.getProtocolVersion() != null && this.getProtocolVersion().getValue() != null) {
            sb.append((Object)ProtocolVersion.getProtocolVersion((byte[])this.getProtocolVersion().getValue()));
        } else {
            sb.append("null");
        }
        sb.append("\n  Type: ");
        if (this.getType() != null && this.getType().getValue() != null) {
            sb.append(this.getType().getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  Supported CipherSuites: ");
        if (this.getCipherSuites() != null && this.getCipherSuites().getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getCipherSuites().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  Challange: ");
        if (this.getChallenge() != null && this.getChallenge().getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getChallenge().getValue())));
        } else {
            sb.append("null");
        }
        sb.append("\n  SessionID: ");
        if (this.getSessionId() != null && this.getSessionId().getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.getSessionId().getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public SSL2ClientHelloHandler getHandler(TlsContext context) {
        return new SSL2ClientHelloHandler(context);
    }
}

