/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message.extension;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.alpn.AlpnEntry;
import java.util.LinkedList;
import java.util.List;

public class AlpnExtensionMessage
extends ExtensionMessage {
    @ModifiableVariableProperty
    private ModifiableInteger alpnExtensionLength;
    @ModifiableVariableProperty
    private ModifiableByteArray alpnAnnouncedProtocols;
    @HoldsModifiableVariable
    private List<AlpnEntry> alpnEntryList = new LinkedList<AlpnEntry>();

    public AlpnExtensionMessage() {
        super(ExtensionType.ALPN);
    }

    public AlpnExtensionMessage(Config config) {
        super(ExtensionType.ALPN);
        for (String string : config.getAlpnAnnouncedProtocols()) {
            this.alpnEntryList.add(new AlpnEntry(string.getBytes()));
        }
    }

    public List<AlpnEntry> getAlpnEntryList() {
        return this.alpnEntryList;
    }

    public void setAlpnEntryList(List<AlpnEntry> alpnEntryList) {
        this.alpnEntryList = alpnEntryList;
    }

    public ModifiableInteger getAlpnExtensionLength() {
        return this.alpnExtensionLength;
    }

    public void setAlpnExtensionLength(ModifiableInteger alpnExtensionLength) {
        this.alpnExtensionLength = alpnExtensionLength;
    }

    public void setAlpnExtensionLength(int alpnExtensionLength) {
        this.alpnExtensionLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.alpnExtensionLength, (Integer)alpnExtensionLength);
    }

    public ModifiableByteArray getAlpnAnnouncedProtocols() {
        return this.alpnAnnouncedProtocols;
    }

    public void setAlpnAnnouncedProtocols(ModifiableByteArray alpnAnnouncedProtocols) {
        this.alpnAnnouncedProtocols = alpnAnnouncedProtocols;
    }

    public void setAlpnAnnouncedProtocols(byte[] alpnAnnouncedProtocols) {
        this.alpnAnnouncedProtocols = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.alpnAnnouncedProtocols, (byte[])alpnAnnouncedProtocols);
    }
}

