/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import de.rub.nds.tlsattacker.core.protocol.parser.Parser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyShareEntryParser
extends Parser<KeyShareEntry> {
    private static final Logger LOGGER = LogManager.getLogger();
    private KeyShareEntry entry;

    public KeyShareEntryParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public KeyShareEntry parse() {
        LOGGER.debug("Parsing KeyShareEntry");
        this.entry = new KeyShareEntry();
        this.parseKeyShareGroup(this.entry);
        if (this.getBytesLeft() > 0) {
            this.parseKeyShareLength(this.entry);
            this.parseKeyShare(this.entry);
        }
        this.entry.setGroupConfig(NamedGroup.getNamedGroup((byte[])this.entry.getGroup().getValue()));
        return this.entry;
    }

    private void parseKeyShareGroup(KeyShareEntry pair) {
        pair.setGroup(this.parseByteArrayField(2));
        LOGGER.debug("KeyShareGroup: " + ArrayConverter.bytesToHexString((byte[])((byte[])pair.getGroup().getValue())));
    }

    private void parseKeyShareLength(KeyShareEntry pair) {
        pair.setPublicKeyLength(this.parseIntField(2));
        LOGGER.debug("KeyShareLength: " + pair.getPublicKeyLength().getValue());
    }

    private void parseKeyShare(KeyShareEntry pair) {
        pair.setPublicKey(this.parseByteArrayField((Integer)pair.getPublicKeyLength().getValue()));
        LOGGER.debug("KeyShare: " + ArrayConverter.bytesToHexString((byte[])((byte[])pair.getPublicKey().getValue())));
    }
}

