/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.PskClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskClientKeyExchangePreparator
extends ClientKeyExchangePreparator<PskClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private byte[] premasterSecret;
    private byte[] clientRandom;
    private final PskClientKeyExchangeMessage msg;
    private ByteArrayOutputStream outputStream;

    public PskClientKeyExchangePreparator(Chooser chooser, PskClientKeyExchangeMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        this.msg.setIdentity(this.chooser.getPSKIdentity());
        this.msg.setIdentityLength(((byte[])this.msg.getIdentity().getValue()).length);
        this.msg.prepareComputations();
        this.premasterSecret = this.generatePremasterSecret();
        this.preparePremasterSecret(this.msg);
        this.prepareClientServerRandom(this.msg);
    }

    public byte[] generatePremasterSecret() {
        this.outputStream = new ByteArrayOutputStream();
        try {
            this.outputStream.write(ArrayConverter.intToBytes((int)this.chooser.getConfig().getDefaultPSKKey().length, (int)2));
            this.outputStream.write(ArrayConverter.intToBytes((int)0, (int)this.chooser.getConfig().getDefaultPSKKey().length));
            this.outputStream.write(ArrayConverter.intToBytes((int)this.chooser.getConfig().getDefaultPSKKey().length, (int)2));
            this.outputStream.write(this.chooser.getConfig().getDefaultPSKKey());
        }
        catch (IOException ex) {
            LOGGER.warn("Encountered exception while writing to ByteArrayOutputStream.");
            LOGGER.debug((Object)ex);
        }
        byte[] tempPremasterSecret = this.outputStream.toByteArray();
        return tempPremasterSecret;
    }

    private void preparePremasterSecret(PskClientKeyExchangeMessage msg) {
        msg.getComputations().setPremasterSecret(this.premasterSecret);
        LOGGER.debug("PremasterSecret: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getComputations().getPremasterSecret().getValue())));
    }

    private void prepareClientServerRandom(PskClientKeyExchangeMessage msg) {
        this.clientRandom = ArrayConverter.concatenate((byte[][])new byte[][]{this.chooser.getClientRandom(), this.chooser.getServerRandom()});
        msg.getComputations().setClientServerRandom(this.clientRandom);
        LOGGER.debug("ClientServerRandom: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getComputations().getClientServerRandom().getValue())));
    }

    @Override
    public void prepareAfterParse(boolean clientMode) {
        if (!clientMode) {
            this.msg.prepareComputations();
            this.premasterSecret = this.generatePremasterSecret();
            this.preparePremasterSecret(this.msg);
            this.prepareClientServerRandom(this.msg);
        }
    }
}

