/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.crypto.SignatureCalculator;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.protocol.message.SrpServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ServerKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SrpServerKeyExchangePreparator
extends ServerKeyExchangePreparator<SrpServerKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private BigInteger publicKey;
    private SignatureAndHashAlgorithm selectedSignatureHashAlgo;
    private byte[] signature;
    private final SrpServerKeyExchangeMessage msg;

    public SrpServerKeyExchangePreparator(Chooser chooser, SrpServerKeyExchangeMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        this.msg.prepareComputations();
        this.setComputedModulus(this.msg);
        this.setComputedGenerator(this.msg);
        this.setComputedSalt(this.msg);
        this.setComputedPrivateKey(this.msg);
        this.setSRPIdentity(this.msg);
        this.setSRPPassword(this.msg);
        BigInteger modulus = (BigInteger)this.msg.getComputations().getModulus().getValue();
        BigInteger generator = (BigInteger)this.msg.getComputations().getGenerator().getValue();
        BigInteger privateKey = (BigInteger)this.msg.getComputations().getPrivateKey().getValue();
        byte[] identity = (byte[])this.msg.getComputations().getSRPIdentity().getValue();
        byte[] password = (byte[])this.msg.getComputations().getSRPPassword().getValue();
        byte[] salt = (byte[])this.msg.getComputations().getSalt().getValue();
        this.publicKey = this.generatePublicKey(modulus, generator, privateKey, identity, password, salt);
        this.publicKey.mod(modulus);
        this.prepareModulus(this.msg);
        this.prepareModulusLength(this.msg);
        this.prepareGenerator(this.msg);
        this.prepareGeneratorLength(this.msg);
        this.prepareSalt(this.msg);
        this.prepareSaltLength(this.msg);
        this.preparePublicKey(this.msg);
        this.preparePublicKeyLength(this.msg);
        this.selectedSignatureHashAlgo = this.chooser.getSelectedSigHashAlgorithm();
        this.prepareSignatureAndHashAlgorithm(this.msg);
        this.prepareClientServerRandom(this.msg);
        this.signature = new byte[0];
        try {
            this.signature = this.generateSignature(this.selectedSignatureHashAlgo);
        }
        catch (CryptoException E) {
            LOGGER.warn("Could not generate Signature! Using empty one instead!", (Throwable)E);
        }
        this.prepareSignature(this.msg);
        this.prepareSignatureLength(this.msg);
    }

    private BigInteger generatePublicKey(BigInteger modulus, BigInteger generator, BigInteger privateKey, byte[] identity, byte[] password, byte[] salt) {
        BigInteger k = this.calculateSRP6Multiplier(modulus, generator);
        BigInteger x = this.calculateX(salt, identity, password);
        BigInteger v = generator.modPow(x, modulus);
        BigInteger helpValue1 = k.multiply(v);
        BigInteger helpValue2 = helpValue1.mod(modulus);
        helpValue1 = generator.modPow(privateKey, modulus);
        BigInteger helpValue3 = helpValue1.add(helpValue2);
        BigInteger publickey = helpValue1 = helpValue3.mod(modulus);
        LOGGER.debug("Server-Public-Key: " + ArrayConverter.bytesToHexString((byte[])ArrayConverter.bigIntegerToByteArray((BigInteger)publickey)));
        return publickey;
    }

    public BigInteger calculateX(byte[] salt, byte[] identity, byte[] password) {
        byte[] hashInput1 = ArrayConverter.concatenate((byte[][])new byte[][]{identity, ArrayConverter.hexStringToByteArray((String)"3A"), password});
        LOGGER.debug("HashInput for hashInput1: " + ArrayConverter.bytesToHexString((byte[])hashInput1));
        byte[] hashOutput1 = this.SHAsum(hashInput1);
        LOGGER.debug("Hashvalue for hashInput1: " + ArrayConverter.bytesToHexString((byte[])hashOutput1));
        byte[] hashInput2 = ArrayConverter.concatenate((byte[][])new byte[][]{salt, hashOutput1});
        LOGGER.debug("HashInput for hashInput2: " + ArrayConverter.bytesToHexString((byte[])hashInput2));
        byte[] hashOutput2 = this.SHAsum(hashInput2);
        LOGGER.debug("Hashvalue for hashInput2: " + ArrayConverter.bytesToHexString((byte[])hashOutput2));
        return new BigInteger(1, hashOutput2);
    }

    private BigInteger calculateSRP6Multiplier(BigInteger modulus, BigInteger generator) {
        byte[] paddedGenerator = this.calculatePadding(modulus, generator);
        byte[] hashInput = ArrayConverter.concatenate((byte[][])new byte[][]{ArrayConverter.bigIntegerToByteArray((BigInteger)modulus), paddedGenerator});
        LOGGER.debug("HashInput SRP6Multi: " + ArrayConverter.bytesToHexString((byte[])hashInput));
        byte[] hashOutput = this.SHAsum(hashInput);
        return new BigInteger(1, hashOutput);
    }

    public byte[] SHAsum(byte[] toHash) {
        MessageDigest dig = null;
        try {
            dig = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.warn((Object)ex);
        }
        dig.update(toHash);
        return dig.digest();
    }

    private byte[] calculatePadding(BigInteger modulus, BigInteger topad) {
        byte[] paddingArray;
        int modulusByteLength = ArrayConverter.bigIntegerToByteArray((BigInteger)modulus).length;
        if (modulusByteLength == (paddingArray = ArrayConverter.bigIntegerToByteArray((BigInteger)topad)).length) {
            return paddingArray;
        }
        int paddingByteLength = modulusByteLength - paddingArray.length;
        if (paddingByteLength < 0) {
            LOGGER.warn("Padding ByteLength negative, Using Zero instead");
            paddingByteLength = 0;
        }
        byte[] padding = new byte[paddingByteLength];
        return ArrayConverter.concatenate((byte[][])new byte[][]{padding, paddingArray});
    }

    private byte[] generateToBeSigned() {
        byte[] srpParams = ArrayConverter.concatenate((byte[][])new byte[][]{ArrayConverter.intToBytes((int)((Integer)this.msg.getModulusLength().getValue()), (int)2), (byte[])this.msg.getModulus().getValue(), ArrayConverter.intToBytes((int)((Integer)this.msg.getGeneratorLength().getValue()), (int)2), (byte[])this.msg.getGenerator().getValue(), ArrayConverter.intToBytes((int)((Integer)this.msg.getSaltLength().getValue()), (int)1), (byte[])this.msg.getSalt().getValue(), ArrayConverter.intToBytes((int)((Integer)this.msg.getPublicKeyLength().getValue()), (int)2), (byte[])this.msg.getPublicKey().getValue()});
        return ArrayConverter.concatenate((byte[][])new byte[][]{(byte[])this.msg.getComputations().getClientServerRandom().getValue(), srpParams});
    }

    private byte[] generateSignature(SignatureAndHashAlgorithm algorithm) throws CryptoException {
        return SignatureCalculator.generateSignature(algorithm, this.chooser, this.generateToBeSigned());
    }

    private void prepareGenerator(SrpServerKeyExchangeMessage msg) {
        msg.setGenerator(msg.getComputations().getGenerator().getByteArray());
        LOGGER.debug("Generator: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getGenerator().getValue())));
    }

    private void prepareModulus(SrpServerKeyExchangeMessage msg) {
        msg.setModulus(msg.getComputations().getModulus().getByteArray());
        LOGGER.debug("Modulus: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getModulus().getValue())));
    }

    private void prepareGeneratorLength(SrpServerKeyExchangeMessage msg) {
        msg.setGeneratorLength(((byte[])msg.getGenerator().getValue()).length);
        LOGGER.debug("Generator Length: " + msg.getGeneratorLength().getValue());
    }

    private void prepareSalt(SrpServerKeyExchangeMessage msg) {
        msg.setSalt(msg.getComputations().getSalt());
        LOGGER.debug("Salt: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSalt().getValue())));
    }

    private void prepareSaltLength(SrpServerKeyExchangeMessage msg) {
        msg.setSaltLength(((byte[])msg.getSalt().getValue()).length);
        LOGGER.debug("Salt Length: " + msg.getSaltLength().getValue());
    }

    private void prepareModulusLength(SrpServerKeyExchangeMessage msg) {
        msg.setModulusLength(((byte[])msg.getModulus().getValue()).length);
        LOGGER.debug("Modulus Length: " + msg.getModulusLength().getValue());
    }

    private void preparePublicKey(SrpServerKeyExchangeMessage msg) {
        msg.setPublicKey(this.publicKey.toByteArray());
        LOGGER.debug("PublicKey: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getPublicKey().getValue())));
    }

    private void preparePublicKeyLength(SrpServerKeyExchangeMessage msg) {
        msg.setPublicKeyLength(((byte[])msg.getPublicKey().getValue()).length);
        LOGGER.debug("PublicKeyLength: " + msg.getPublicKeyLength().getValue());
    }

    private void setComputedPrivateKey(SrpServerKeyExchangeMessage msg) {
        msg.getComputations().setPrivateKey(this.chooser.getSRPServerPrivateKey());
        LOGGER.debug("PrivateKey: " + msg.getComputations().getPrivateKey().getValue());
    }

    private void setComputedModulus(SrpServerKeyExchangeMessage msg) {
        msg.getComputations().setModulus(this.chooser.getSRPModulus());
        LOGGER.debug("Modulus used for Computations: " + ((BigInteger)msg.getComputations().getModulus().getValue()).toString(16));
    }

    private void setSRPIdentity(SrpServerKeyExchangeMessage msg) {
        msg.getComputations().setSRPIdentity(this.chooser.getSRPIdentity());
        LOGGER.debug("SRP Identity used for Computations: " + msg.getComputations().getSRPIdentity());
    }

    private void setSRPPassword(SrpServerKeyExchangeMessage msg) {
        msg.getComputations().setSRPPassword(this.chooser.getSRPPassword());
        LOGGER.debug("SRP Password used for Computations: " + msg.getComputations().getSRPPassword());
    }

    private void setComputedSalt(SrpServerKeyExchangeMessage msg) {
        msg.getComputations().setSalt(this.chooser.getSRPServerSalt());
        LOGGER.debug("Salt used for Computations: " + msg.getComputations().getSalt());
    }

    private void setComputedGenerator(SrpServerKeyExchangeMessage msg) {
        msg.getComputations().setGenerator(this.chooser.getSRPGenerator());
        LOGGER.debug("Generator used for Computations: " + ((BigInteger)msg.getComputations().getGenerator().getValue()).toString(16));
    }

    private void prepareSignatureAndHashAlgorithm(SrpServerKeyExchangeMessage msg) {
        msg.setSignatureAndHashAlgorithm(this.selectedSignatureHashAlgo.getByteValue());
        LOGGER.debug("SignatureAlgorithm: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSignatureAndHashAlgorithm().getValue())));
    }

    private void prepareClientServerRandom(SrpServerKeyExchangeMessage msg) {
        msg.getComputations().setClientServerRandom(ArrayConverter.concatenate((byte[][])new byte[][]{this.chooser.getClientRandom(), this.chooser.getServerRandom()}));
        LOGGER.debug("ClientServerRandom: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getComputations().getClientServerRandom().getValue())));
    }

    private void prepareSignature(SrpServerKeyExchangeMessage msg) {
        msg.setSignature(this.signature);
        LOGGER.debug("Signatur: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSignature().getValue())));
    }

    private void prepareSignatureLength(SrpServerKeyExchangeMessage msg) {
        msg.setSignatureLength(((byte[])msg.getSignature().getValue()).length);
        LOGGER.debug("SignatureLength: " + msg.getSignatureLength().getValue());
    }
}

