/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.HelloMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientHelloSerializer
extends HelloMessageSerializer<ClientHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ClientHelloMessage msg;

    public ClientHelloSerializer(ClientHelloMessage message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeHandshakeMessageContent() {
        LOGGER.debug("Serializing ClientHelloMessage");
        this.writeProtocolVersion();
        this.writeRandom();
        this.writeSessionIDLength();
        this.writeSessionID();
        if (this.version.isDTLS()) {
            if (this.msg.getCookie() != null) {
                this.appendByte((Byte)this.msg.getCookieLength().getValue());
                this.appendBytes((byte[])this.msg.getCookie().getValue());
            } else {
                this.appendByte((byte)0);
            }
        }
        this.writeCipherSuiteLength(this.msg);
        this.writeCipherSuites(this.msg);
        this.writeCompressionLength(this.msg);
        this.writeCompressions(this.msg);
        if (this.hasExtensionLengthField()) {
            this.writeExtensionLength(this.msg);
            if (this.hasExtensions()) {
                this.writeExtensionBytes(this.msg);
            }
        }
        return this.getAlreadySerialized();
    }

    private void writeCipherSuiteLength(ClientHelloMessage msg) {
        this.appendInt((Integer)msg.getCipherSuiteLength().getValue(), 2);
        LOGGER.debug("CipherSuiteLength: " + msg.getCipherSuiteLength().getValue());
    }

    private void writeCipherSuites(ClientHelloMessage msg) {
        this.appendBytes((byte[])msg.getCipherSuites().getValue());
        LOGGER.debug("CipherSuite: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getCipherSuites().getValue())));
    }

    private void writeCompressionLength(ClientHelloMessage msg) {
        this.appendInt((Integer)msg.getCompressionLength().getValue(), 1);
        LOGGER.debug("CompressionLength: " + msg.getCompressionLength().getValue());
    }

    private void writeCompressions(ClientHelloMessage msg) {
        this.appendBytes((byte[])msg.getCompressions().getValue());
        LOGGER.debug("Compressions: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getCompressions().getValue())));
    }

    private void writeExtensionLength(ClientHelloMessage msg) {
        this.appendInt((Integer)msg.getExtensionsLength().getValue(), 2);
        LOGGER.debug("ExtensionLength: " + msg.getExtensionsLength().getValue());
    }

    private void writeExtensionBytes(ClientHelloMessage msg) {
        this.appendBytes((byte[])msg.getExtensionBytes().getValue());
        LOGGER.debug("ExtensionBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getExtensionBytes().getValue())));
    }
}

