/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.serializer;

import de.rub.nds.asn1.model.Asn1Field;
import de.rub.nds.asn1.serializer.Asn1RawFieldSerializer;
import de.rub.nds.util.ByteArrayUtils;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Asn1FieldSerializer
extends Asn1RawFieldSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Asn1Field field;

    public Asn1FieldSerializer(Asn1Field field) {
        super(field);
        this.field = field;
    }

    @Override
    public void updateLayers() {
        this.encodeField();
        super.updateLayers();
    }

    private void encodeField() {
        byte[] identifierOctets = this.encodeIdentifier();
        byte[] contentOctets = this.encodeContent();
        byte[] lengthOctets = this.encodeLength(BigInteger.valueOf(contentOctets.length));
        this.field.setIdentifierOctets(identifierOctets);
        this.field.setLengthOctets(lengthOctets);
        this.field.setContentOctets(contentOctets);
    }

    private final byte[] encodeIdentifier() {
        byte firstIdentifierByte = 0;
        firstIdentifierByte = this.encodeTagClass(firstIdentifierByte, (Integer)this.field.getTagClass().getValue());
        firstIdentifierByte = this.encodeIsConstructed(firstIdentifierByte, (Boolean)this.field.getTagConstructed().getValue());
        return this.encodeTagNumber(firstIdentifierByte, (Integer)this.field.getTagNumber().getValue());
    }

    private byte encodeTagClass(byte firstIdentifierByte, int tagClass) {
        return (byte)(firstIdentifierByte | (tagClass & 3) << 6);
    }

    private byte encodeIsConstructed(byte firstIdentifierByte, boolean isConstructed) {
        return isConstructed ? (byte)(firstIdentifierByte | 0x20) : firstIdentifierByte;
    }

    private byte[] encodeTagNumber(byte firstIdentifierByte, int tagNumber) {
        byte[] result = null;
        if (tagNumber < 0) {
            LOGGER.warn("Tag number is smaller than zero. Defaulting to zero!");
            tagNumber = 0;
        }
        if (this.field.getLongTagNumberBytes() == 0 && tagNumber <= 31) {
            result = new byte[]{firstIdentifierByte};
            result[0] = (byte)(result[0] | (byte)(tagNumber & 0x1F));
        } else {
            int longTagNumberBytes = this.field.getLongTagNumberBytes();
            byte[] longEncoding = this.encodeLongTagNumber(firstIdentifierByte, tagNumber);
            if (longEncoding.length < longTagNumberBytes) {
                longEncoding = ByteArrayUtils.merge(new byte[longTagNumberBytes - longEncoding.length], longEncoding);
            }
            firstIdentifierByte = (byte)(firstIdentifierByte | 0x1F);
            result = ByteArrayUtils.merge(new byte[]{firstIdentifierByte}, longEncoding);
        }
        return result;
    }

    private byte[] encodeLongTagNumber(byte firstIdentifierByte, int tagNumber) {
        int tagNumberByteCount = this.getTagNumberByteCount(tagNumber);
        byte[] result = new byte[tagNumberByteCount];
        int moreFlag = 0;
        for (int i = tagNumberByteCount - 1; i >= 0; --i) {
            result[i] = (byte)(moreFlag | tagNumber & 0x7F);
            tagNumber >>= 7;
            moreFlag = -128;
        }
        return result;
    }

    private int getTagNumberByteCount(int tagNumber) {
        int result = 0;
        while (tagNumber > 0) {
            ++result;
            tagNumber >>= 7;
        }
        return result;
    }

    private final byte[] encodeLength(BigInteger contentLength) {
        byte[] result = null;
        this.field.setLength(contentLength);
        BigInteger length = (BigInteger)this.field.getLength().getValue();
        if (length.compareTo(BigInteger.ZERO) == -1) {
            LOGGER.warn("Field length is smaller than zero. Defaulting to zero!");
            length = BigInteger.ZERO;
        }
        result = this.field.getLongLengthBytes() == 0 && length.compareTo(BigInteger.valueOf(127L)) <= 0 ? new byte[]{length.byteValue()} : this.encodeLongLength(length);
        return result;
    }

    private byte[] encodeLongLength(BigInteger length) {
        byte[] result = null;
        byte[] longLength = length.toByteArray();
        int longLengthBytes = this.field.getLongLengthBytes();
        if (longLength[0] == 0) {
            if (longLength.length < longLengthBytes + 1) {
                longLength = ByteArrayUtils.merge(new byte[longLengthBytes + 1 - longLength.length], longLength);
            }
            longLength[0] = (byte)(0x80 | longLength.length - 1);
            result = longLength;
        } else {
            byte[] prefix = new byte[]{(byte)(0x80 | longLength.length)};
            if (longLength.length < longLengthBytes) {
                longLength = ByteArrayUtils.merge(new byte[longLengthBytes - longLength.length], longLength);
            }
            result = ByteArrayUtils.merge(prefix, longLength);
        }
        return result;
    }

    private final byte[] encodeContent() {
        return (byte[])this.field.getContent().getValue();
    }
}

