/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.traccar.api.SimpleObjectResource;
import org.traccar.helper.LogAction;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.model.Report;
import org.traccar.model.UserRestrictions;
import org.traccar.reports.CombinedReportProvider;
import org.traccar.reports.DevicesReportProvider;
import org.traccar.reports.EventsReportProvider;
import org.traccar.reports.RouteReportProvider;
import org.traccar.reports.StopsReportProvider;
import org.traccar.reports.SummaryReportProvider;
import org.traccar.reports.TripsReportProvider;
import org.traccar.reports.common.ReportExecutor;
import org.traccar.reports.common.ReportMailer;
import org.traccar.reports.model.CombinedReportItem;
import org.traccar.reports.model.StopReportItem;
import org.traccar.reports.model.SummaryReportItem;
import org.traccar.reports.model.TripReportItem;
import org.traccar.storage.StorageException;

@Path(value="reports")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ReportResource
extends SimpleObjectResource<Report> {
    private static final String EXCEL = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    @Inject
    private CombinedReportProvider combinedReportProvider;
    @Inject
    private EventsReportProvider eventsReportProvider;
    @Inject
    private RouteReportProvider routeReportProvider;
    @Inject
    private StopsReportProvider stopsReportProvider;
    @Inject
    private SummaryReportProvider summaryReportProvider;
    @Inject
    private TripsReportProvider tripsReportProvider;
    @Inject
    private DevicesReportProvider devicesReportProvider;
    @Inject
    private ReportMailer reportMailer;

    public ReportResource() {
        super(Report.class, "description");
    }

    private Response executeReport(long userId, boolean mail, ReportExecutor executor) {
        if (mail) {
            this.reportMailer.sendAsync(userId, executor);
            return Response.noContent().build();
        }
        StreamingOutput stream = output -> {
            try {
                executor.execute(output);
            }
            catch (StorageException e) {
                throw new WebApplicationException((Throwable)e);
            }
        };
        return Response.ok((Object)stream).header("Content-Disposition", (Object)"attachment; filename=report.xlsx").build();
    }

    @Path(value="combined")
    @GET
    public Collection<CombinedReportItem> getCombined(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to) throws StorageException {
        this.permissionsService.checkRestriction(this.getUserId(), UserRestrictions::getDisableReports);
        LogAction.report(this.getUserId(), false, "combined", from, to, deviceIds, groupIds);
        return this.combinedReportProvider.getObjects(this.getUserId(), deviceIds, groupIds, from, to);
    }

    @Path(value="route")
    @GET
    public Collection<Position> getRoute(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to) throws StorageException {
        this.permissionsService.checkRestriction(this.getUserId(), UserRestrictions::getDisableReports);
        LogAction.report(this.getUserId(), false, "route", from, to, deviceIds, groupIds);
        return this.routeReportProvider.getObjects(this.getUserId(), deviceIds, groupIds, from, to);
    }

    @Path(value="route")
    @GET
    @Produces(value={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public Response getRouteExcel(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to, @QueryParam(value="mail") boolean mail) throws StorageException {
        this.permissionsService.checkRestriction(this.getUserId(), UserRestrictions::getDisableReports);
        return this.executeReport(this.getUserId(), mail, stream -> {
            LogAction.report(this.getUserId(), false, "route", from, to, deviceIds, groupIds);
            this.routeReportProvider.getExcel(stream, this.getUserId(), deviceIds, groupIds, from, to);
        });
    }

    @Path(value="route/{type:xlsx|mail}")
    @GET
    @Produces(value={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public Response getRouteExcel(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to, @PathParam(value="type") String type) throws StorageException {
        return this.getRouteExcel(deviceIds, groupIds, from, to, type.equals("mail"));
    }

    @Path(value="events")
    @GET
    public Collection<Event> getEvents(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="type") List<String> types, @QueryParam(value="alarm") List<String> alarms, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to) throws StorageException {
        this.permissionsService.checkRestriction(this.getUserId(), UserRestrictions::getDisableReports);
        LogAction.report(this.getUserId(), false, "events", from, to, deviceIds, groupIds);
        return this.eventsReportProvider.getObjects(this.getUserId(), deviceIds, groupIds, types, alarms, from, to);
    }

    @Path(value="events")
    @GET
    @Produces(value={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public Response getEventsExcel(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="type") List<String> types, @QueryParam(value="alarm") List<String> alarms, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to, @QueryParam(value="mail") boolean mail) throws StorageException {
        this.permissionsService.checkRestriction(this.getUserId(), UserRestrictions::getDisableReports);
        return this.executeReport(this.getUserId(), mail, stream -> {
            LogAction.report(this.getUserId(), false, "events", from, to, deviceIds, groupIds);
            this.eventsReportProvider.getExcel(stream, this.getUserId(), deviceIds, groupIds, types, alarms, from, to);
        });
    }

    @Path(value="events/{type:xlsx|mail}")
    @GET
    @Produces(value={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public Response getEventsExcel(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="type") List<String> types, @QueryParam(value="alarm") List<String> alarms, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to, @PathParam(value="type") String type) throws StorageException {
        return this.getEventsExcel(deviceIds, groupIds, types, alarms, from, to, type.equals("mail"));
    }

    @Path(value="summary")
    @GET
    public Collection<SummaryReportItem> getSummary(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to, @QueryParam(value="daily") boolean daily) throws StorageException {
        this.permissionsService.checkRestriction(this.getUserId(), UserRestrictions::getDisableReports);
        LogAction.report(this.getUserId(), false, "summary", from, to, deviceIds, groupIds);
        return this.summaryReportProvider.getObjects(this.getUserId(), deviceIds, groupIds, from, to, daily);
    }

    @Path(value="summary")
    @GET
    @Produces(value={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public Response getSummaryExcel(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to, @QueryParam(value="daily") boolean daily, @QueryParam(value="mail") boolean mail) throws StorageException {
        this.permissionsService.checkRestriction(this.getUserId(), UserRestrictions::getDisableReports);
        return this.executeReport(this.getUserId(), mail, stream -> {
            LogAction.report(this.getUserId(), false, "summary", from, to, deviceIds, groupIds);
            this.summaryReportProvider.getExcel(stream, this.getUserId(), deviceIds, groupIds, from, to, daily);
        });
    }

    @Path(value="summary/{type:xlsx|mail}")
    @GET
    @Produces(value={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public Response getSummaryExcel(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to, @QueryParam(value="daily") boolean daily, @PathParam(value="type") String type) throws StorageException {
        return this.getSummaryExcel(deviceIds, groupIds, from, to, daily, type.equals("mail"));
    }

    @Path(value="trips")
    @GET
    public Collection<TripReportItem> getTrips(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to) throws StorageException {
        this.permissionsService.checkRestriction(this.getUserId(), UserRestrictions::getDisableReports);
        LogAction.report(this.getUserId(), false, "trips", from, to, deviceIds, groupIds);
        return this.tripsReportProvider.getObjects(this.getUserId(), deviceIds, groupIds, from, to);
    }

    @Path(value="trips")
    @GET
    @Produces(value={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public Response getTripsExcel(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to, @QueryParam(value="mail") boolean mail) throws StorageException {
        this.permissionsService.checkRestriction(this.getUserId(), UserRestrictions::getDisableReports);
        return this.executeReport(this.getUserId(), mail, stream -> {
            LogAction.report(this.getUserId(), false, "trips", from, to, deviceIds, groupIds);
            this.tripsReportProvider.getExcel(stream, this.getUserId(), deviceIds, groupIds, from, to);
        });
    }

    @Path(value="trips/{type:xlsx|mail}")
    @GET
    @Produces(value={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public Response getTripsExcel(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to, @PathParam(value="type") String type) throws StorageException {
        return this.getTripsExcel(deviceIds, groupIds, from, to, type.equals("mail"));
    }

    @Path(value="stops")
    @GET
    public Collection<StopReportItem> getStops(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to) throws StorageException {
        this.permissionsService.checkRestriction(this.getUserId(), UserRestrictions::getDisableReports);
        LogAction.report(this.getUserId(), false, "stops", from, to, deviceIds, groupIds);
        return this.stopsReportProvider.getObjects(this.getUserId(), deviceIds, groupIds, from, to);
    }

    @Path(value="stops")
    @GET
    @Produces(value={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public Response getStopsExcel(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to, @QueryParam(value="mail") boolean mail) throws StorageException {
        this.permissionsService.checkRestriction(this.getUserId(), UserRestrictions::getDisableReports);
        return this.executeReport(this.getUserId(), mail, stream -> {
            LogAction.report(this.getUserId(), false, "stops", from, to, deviceIds, groupIds);
            this.stopsReportProvider.getExcel(stream, this.getUserId(), deviceIds, groupIds, from, to);
        });
    }

    @Path(value="stops/{type:xlsx|mail}")
    @GET
    @Produces(value={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public Response getStopsExcel(@QueryParam(value="deviceId") List<Long> deviceIds, @QueryParam(value="groupId") List<Long> groupIds, @QueryParam(value="from") Date from, @QueryParam(value="to") Date to, @PathParam(value="type") String type) throws StorageException {
        return this.getStopsExcel(deviceIds, groupIds, from, to, type.equals("mail"));
    }

    @Path(value="devices/{type:xlsx|mail}")
    @GET
    @Produces(value={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public Response getDevicesExcel(@PathParam(value="type") String type) throws StorageException {
        this.permissionsService.checkRestriction(this.getUserId(), UserRestrictions::getDisableReports);
        return this.executeReport(this.getUserId(), type.equals("mail"), stream -> this.devicesReportProvider.getExcel(stream, this.getUserId()));
    }
}

