/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.util;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssProfile;

public enum CssVersion {
    CSS1("css1"),
    CSS2("css2"),
    CSS21("css21"),
    CSS3("css3"),
    CSS_2015("css-2015"),
    CSS("css");

    private final String version;

    private CssVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return this.version;
    }

    public static CssVersion resolve(ApplContext ac, String s) {
        for (CssVersion v : CssVersion.values()) {
            if (!v.toString().equals(s)) continue;
            return v;
        }
        switch (s) {
            case "css3svg": {
                return CSS3;
            }
        }
        CssProfile profile = CssProfile.resolve(ac, s);
        switch (profile) {
            case SVG: 
            case SVGBASIC: 
            case SVGTINY: 
            case TV: 
            case ATSCTV: 
            case MOBILE: {
                return CSS21;
            }
        }
        return CssVersion.getDefault();
    }

    public static CssVersion getDefault() {
        return CSS3;
    }
}

