/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.result;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.result.Result;
import org.hsqldb.rowio.RowOutputInterface;

public final class ResultLob
extends Result {
    long lobID;
    int subType;
    long blockOffset;
    long blockLength;
    byte[] byteBlock;
    char[] charBlock;
    Reader reader;
    InputStream stream;

    private ResultLob() {
        super(18);
    }

    public static ResultLob newLobGetLengthRequest(long l) {
        ResultLob resultLob = new ResultLob();
        resultLob.subType = 10;
        resultLob.lobID = l;
        return resultLob;
    }

    public static ResultLob newLobGetBytesRequest(long l, long l2, int n) {
        ResultLob resultLob = new ResultLob();
        resultLob.subType = 1;
        resultLob.lobID = l;
        resultLob.blockOffset = l2;
        resultLob.blockLength = n;
        return resultLob;
    }

    public static ResultLob newLobGetCharsRequest(long l, long l2, int n) {
        ResultLob resultLob = new ResultLob();
        resultLob.subType = 3;
        resultLob.lobID = l;
        resultLob.blockOffset = l2;
        resultLob.blockLength = n;
        return resultLob;
    }

    public static ResultLob newLobSetBytesRequest(long l, long l2, byte[] byArray) {
        ResultLob resultLob = new ResultLob();
        resultLob.subType = 2;
        resultLob.lobID = l;
        resultLob.blockOffset = l2;
        resultLob.byteBlock = byArray;
        resultLob.blockLength = byArray.length;
        return resultLob;
    }

    public static ResultLob newLobSetCharsRequest(long l, long l2, char[] cArray) {
        ResultLob resultLob = new ResultLob();
        resultLob.subType = 4;
        resultLob.lobID = l;
        resultLob.blockOffset = l2;
        resultLob.charBlock = cArray;
        resultLob.blockLength = cArray.length;
        return resultLob;
    }

    public static ResultLob newLobTruncateRequest(long l, long l2) {
        ResultLob resultLob = new ResultLob();
        resultLob.subType = 9;
        resultLob.lobID = l;
        resultLob.blockOffset = l2;
        return resultLob;
    }

    public static ResultLob newLobGetBytesResponse(long l, long l2, byte[] byArray) {
        ResultLob resultLob = new ResultLob();
        resultLob.subType = 21;
        resultLob.lobID = l;
        resultLob.blockOffset = l2;
        resultLob.byteBlock = byArray;
        resultLob.blockLength = byArray.length;
        return resultLob;
    }

    public static ResultLob newLobGetCharsResponse(long l, long l2, char[] cArray) {
        ResultLob resultLob = new ResultLob();
        resultLob.subType = 23;
        resultLob.lobID = l;
        resultLob.blockOffset = l2;
        resultLob.charBlock = cArray;
        resultLob.blockLength = cArray.length;
        return resultLob;
    }

    public static ResultLob newLobSetResponse(long l, long l2) {
        ResultLob resultLob = new ResultLob();
        resultLob.subType = 22;
        resultLob.lobID = l;
        resultLob.blockLength = l2;
        return resultLob;
    }

    public static ResultLob newLobGetBytePatternPositionRequest(long l, byte[] byArray, long l2) {
        ResultLob resultLob = new ResultLob();
        resultLob.subType = 5;
        resultLob.lobID = l;
        resultLob.blockOffset = l2;
        resultLob.byteBlock = byArray;
        resultLob.blockLength = byArray.length;
        return resultLob;
    }

    public static ResultLob newLobGetBytePatternPositionRequest(long l, long l2, long l3) {
        ResultLob resultLob = new ResultLob();
        resultLob.subType = 5;
        resultLob.lobID = l;
        resultLob.blockOffset = l3;
        return resultLob;
    }

    public static ResultLob newLobGetCharPatternPositionRequest(long l, char[] cArray, long l2) {
        ResultLob resultLob = new ResultLob();
        resultLob.subType = 6;
        resultLob.lobID = l;
        resultLob.blockOffset = l2;
        resultLob.charBlock = cArray;
        resultLob.blockLength = cArray.length;
        return resultLob;
    }

    public static ResultLob newLobGetCharPatternPositionRequest(long l, long l2, long l3) {
        ResultLob resultLob = new ResultLob();
        resultLob.subType = 6;
        resultLob.lobID = l;
        resultLob.blockOffset = l3;
        resultLob.blockLength = l2;
        return resultLob;
    }

    public static ResultLob newLobCreateBlobRequest(long l, long l2, InputStream inputStream, long l3) {
        ResultLob resultLob = new ResultLob();
        resultLob.lobID = l2;
        resultLob.subType = 7;
        resultLob.blockLength = l3;
        resultLob.stream = inputStream;
        return resultLob;
    }

    public static ResultLob newLobCreateClobRequest(long l, long l2, Reader reader, long l3) {
        ResultLob resultLob = new ResultLob();
        resultLob.lobID = l2;
        resultLob.subType = 8;
        resultLob.blockLength = l3;
        resultLob.reader = reader;
        return resultLob;
    }

    public static ResultLob newLobGetTruncateLength(long l) {
        ResultLob resultLob = new ResultLob();
        resultLob.subType = 13;
        resultLob.lobID = l;
        return resultLob;
    }

    public static ResultLob newLobCreateBlobResponse(long l) {
        ResultLob resultLob = new ResultLob();
        resultLob.subType = 27;
        resultLob.lobID = l;
        return resultLob;
    }

    public static ResultLob newLobCreateClobResponse(long l) {
        ResultLob resultLob = new ResultLob();
        resultLob.subType = 28;
        resultLob.lobID = l;
        return resultLob;
    }

    public static ResultLob newLobTruncateResponse(long l, long l2) {
        ResultLob resultLob = new ResultLob();
        resultLob.subType = 29;
        resultLob.lobID = l;
        resultLob.blockLength = l2;
        return resultLob;
    }

    public static ResultLob newLobGetRequest(long l, long l2, long l3) {
        ResultLob resultLob = new ResultLob();
        resultLob.subType = 11;
        resultLob.lobID = l;
        resultLob.blockOffset = l2;
        resultLob.blockLength = l3;
        return resultLob;
    }

    public static ResultLob newLobDuplicateRequest(long l) {
        ResultLob resultLob = new ResultLob();
        resultLob.subType = 12;
        resultLob.lobID = l;
        return resultLob;
    }

    public static ResultLob newLob(DataInputStream dataInputStream, boolean bl) throws IOException {
        ResultLob resultLob = new ResultLob();
        resultLob.databaseID = dataInputStream.readInt();
        resultLob.sessionID = dataInputStream.readLong();
        resultLob.lobID = dataInputStream.readLong();
        resultLob.subType = dataInputStream.readInt();
        switch (resultLob.subType) {
            case 7: 
            case 8: {
                resultLob.blockOffset = dataInputStream.readLong();
                resultLob.blockLength = dataInputStream.readLong();
                resultLob.stream = dataInputStream;
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 12: {
                resultLob.blockOffset = dataInputStream.readLong();
                resultLob.blockLength = dataInputStream.readLong();
                break;
            }
            case 2: 
            case 5: {
                resultLob.blockOffset = dataInputStream.readLong();
                resultLob.blockLength = dataInputStream.readLong();
                resultLob.byteBlock = new byte[(int)resultLob.blockLength];
                dataInputStream.readFully(resultLob.byteBlock);
                break;
            }
            case 4: 
            case 6: {
                resultLob.blockOffset = dataInputStream.readLong();
                resultLob.blockLength = dataInputStream.readLong();
                resultLob.charBlock = new char[(int)resultLob.blockLength];
                for (int i = 0; i < resultLob.charBlock.length; ++i) {
                    resultLob.charBlock[i] = dataInputStream.readChar();
                }
                break;
            }
            case 9: 
            case 10: {
                resultLob.blockOffset = dataInputStream.readLong();
                break;
            }
            case 21: {
                resultLob.blockOffset = dataInputStream.readLong();
                resultLob.blockLength = dataInputStream.readLong();
                resultLob.byteBlock = new byte[(int)resultLob.blockLength];
                dataInputStream.readFully(resultLob.byteBlock);
                break;
            }
            case 23: {
                resultLob.blockOffset = dataInputStream.readLong();
                resultLob.blockLength = dataInputStream.readLong();
                resultLob.charBlock = new char[(int)resultLob.blockLength];
                for (int i = 0; i < resultLob.charBlock.length; ++i) {
                    resultLob.charBlock[i] = dataInputStream.readChar();
                }
                break;
            }
            case 22: 
            case 27: 
            case 28: 
            case 29: {
                resultLob.blockLength = dataInputStream.readLong();
                break;
            }
            case 25: 
            case 26: {
                resultLob.blockOffset = dataInputStream.readLong();
                break;
            }
            default: {
                throw Error.runtimeError(201, "ResultLob");
            }
        }
        if (bl) {
            dataInputStream.readByte();
        }
        return resultLob;
    }

    @Override
    public void write(SessionInterface sessionInterface, DataOutputStream dataOutputStream, RowOutputInterface rowOutputInterface) throws IOException {
        this.writeBody(sessionInterface, dataOutputStream);
        dataOutputStream.writeByte(0);
        dataOutputStream.flush();
    }

    public void writeBody(SessionInterface sessionInterface, DataOutputStream dataOutputStream) throws IOException {
        switch (this.subType) {
            case 7: {
                if (this.blockLength >= 0L) {
                    this.writeCreate(sessionInterface, dataOutputStream);
                    return;
                }
                this.writeCreateByteSegments(sessionInterface, dataOutputStream);
                return;
            }
            case 8: {
                if (this.blockLength >= 0L) {
                    this.writeCreate(sessionInterface, dataOutputStream);
                    return;
                }
                this.writeCreateCharSegments(sessionInterface, dataOutputStream);
                return;
            }
        }
        dataOutputStream.writeByte(this.mode);
        dataOutputStream.writeInt(this.databaseID);
        dataOutputStream.writeLong(this.sessionID);
        dataOutputStream.writeLong(this.lobID);
        dataOutputStream.writeInt(this.subType);
        switch (this.subType) {
            case 2: 
            case 5: {
                dataOutputStream.writeLong(this.blockOffset);
                dataOutputStream.writeLong(this.blockLength);
                dataOutputStream.write(this.byteBlock);
                break;
            }
            case 4: 
            case 6: {
                dataOutputStream.writeLong(this.blockOffset);
                dataOutputStream.writeLong(this.blockLength);
                dataOutputStream.writeChars(this.charBlock);
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 12: {
                dataOutputStream.writeLong(this.blockOffset);
                dataOutputStream.writeLong(this.blockLength);
                break;
            }
            case 9: 
            case 10: {
                dataOutputStream.writeLong(this.blockOffset);
                break;
            }
            case 21: {
                dataOutputStream.writeLong(this.blockOffset);
                dataOutputStream.writeLong(this.blockLength);
                dataOutputStream.write(this.byteBlock);
                break;
            }
            case 23: {
                dataOutputStream.writeLong(this.blockOffset);
                dataOutputStream.writeLong(this.blockLength);
                dataOutputStream.writeChars(this.charBlock);
                break;
            }
            case 22: 
            case 27: 
            case 28: 
            case 29: {
                dataOutputStream.writeLong(this.blockLength);
                break;
            }
            case 25: 
            case 26: {
                dataOutputStream.writeLong(this.blockOffset);
                break;
            }
            default: {
                throw Error.runtimeError(201, "ResultLob");
            }
        }
    }

    private void writeCreate(SessionInterface sessionInterface, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.mode);
        dataOutputStream.writeInt(this.databaseID);
        dataOutputStream.writeLong(this.sessionID);
        dataOutputStream.writeLong(this.lobID);
        dataOutputStream.writeInt(this.subType);
        dataOutputStream.writeLong(this.blockOffset);
        dataOutputStream.writeLong(this.blockLength);
        switch (this.subType) {
            case 7: {
                dataOutputStream.write(this.stream, this.blockLength);
                break;
            }
            case 8: {
                dataOutputStream.write(this.reader, this.blockLength);
            }
        }
    }

    private void writeCreateByteSegments(SessionInterface sessionInterface, DataOutputStream dataOutputStream) throws IOException {
        int n = sessionInterface.getStreamBlockSize();
        long l = this.blockOffset;
        dataOutputStream.writeByte(this.mode);
        dataOutputStream.writeInt(this.databaseID);
        dataOutputStream.writeLong(this.sessionID);
        dataOutputStream.writeLong(this.lobID);
        dataOutputStream.writeInt(this.subType);
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream(n);
        hsqlByteArrayOutputStream.reset();
        hsqlByteArrayOutputStream.write(this.stream, n);
        dataOutputStream.writeLong(l);
        dataOutputStream.writeLong(hsqlByteArrayOutputStream.size());
        dataOutputStream.write(hsqlByteArrayOutputStream.getBuffer(), 0, hsqlByteArrayOutputStream.size());
        l += (long)hsqlByteArrayOutputStream.size();
        if (hsqlByteArrayOutputStream.size() < n) {
            return;
        }
        do {
            hsqlByteArrayOutputStream.reset();
            hsqlByteArrayOutputStream.write(this.stream, n);
            if (hsqlByteArrayOutputStream.size() == 0) break;
            dataOutputStream.writeByte(this.mode);
            dataOutputStream.writeInt(this.databaseID);
            dataOutputStream.writeLong(this.sessionID);
            dataOutputStream.writeLong(this.lobID);
            dataOutputStream.writeInt(2);
            dataOutputStream.writeLong(l);
            dataOutputStream.writeLong(hsqlByteArrayOutputStream.size());
            dataOutputStream.write(hsqlByteArrayOutputStream.getBuffer(), 0, hsqlByteArrayOutputStream.size());
            l += (long)hsqlByteArrayOutputStream.size();
        } while (hsqlByteArrayOutputStream.size() >= n);
    }

    private void writeCreateCharSegments(SessionInterface sessionInterface, DataOutputStream dataOutputStream) throws IOException {
        int n = sessionInterface.getStreamBlockSize();
        long l = this.blockOffset;
        dataOutputStream.writeByte(this.mode);
        dataOutputStream.writeInt(this.databaseID);
        dataOutputStream.writeLong(this.sessionID);
        dataOutputStream.writeLong(this.lobID);
        dataOutputStream.writeInt(this.subType);
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream(n);
        hsqlByteArrayOutputStream.reset();
        hsqlByteArrayOutputStream.write(this.reader, n / 2);
        dataOutputStream.writeLong(l);
        dataOutputStream.writeLong(hsqlByteArrayOutputStream.size() / 2);
        dataOutputStream.write(hsqlByteArrayOutputStream.getBuffer(), 0, hsqlByteArrayOutputStream.size());
        l += (long)(hsqlByteArrayOutputStream.size() / 2);
        if (hsqlByteArrayOutputStream.size() < n) {
            return;
        }
        do {
            hsqlByteArrayOutputStream.reset();
            hsqlByteArrayOutputStream.write(this.reader, n / 2);
            if (hsqlByteArrayOutputStream.size() == 0) break;
            dataOutputStream.writeByte(this.mode);
            dataOutputStream.writeInt(this.databaseID);
            dataOutputStream.writeLong(this.sessionID);
            dataOutputStream.writeLong(this.lobID);
            dataOutputStream.writeInt(4);
            dataOutputStream.writeLong(l);
            dataOutputStream.writeLong(hsqlByteArrayOutputStream.size() / 2);
            dataOutputStream.write(hsqlByteArrayOutputStream.getBuffer(), 0, hsqlByteArrayOutputStream.size());
            l += (long)(hsqlByteArrayOutputStream.size() / 2);
        } while (hsqlByteArrayOutputStream.size() >= n);
    }

    public long getLobID() {
        return this.lobID;
    }

    public int getSubType() {
        return this.subType;
    }

    public long getOffset() {
        return this.blockOffset;
    }

    public long getBlockLength() {
        return this.blockLength;
    }

    public byte[] getByteArray() {
        return this.byteBlock;
    }

    public char[] getCharArray() {
        return this.charBlock;
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    public Reader getReader() {
        return this.reader;
    }

    public static interface LobResultTypes {
        public static final int REQUEST_GET_BYTES = 1;
        public static final int REQUEST_SET_BYTES = 2;
        public static final int REQUEST_GET_CHARS = 3;
        public static final int REQUEST_SET_CHARS = 4;
        public static final int REQUEST_GET_BYTE_PATTERN_POSITION = 5;
        public static final int REQUEST_GET_CHAR_PATTERN_POSITION = 6;
        public static final int REQUEST_CREATE_BYTES = 7;
        public static final int REQUEST_CREATE_CHARS = 8;
        public static final int REQUEST_TRUNCATE = 9;
        public static final int REQUEST_GET_LENGTH = 10;
        public static final int REQUEST_GET_LOB = 11;
        public static final int REQUEST_DUPLICATE_LOB = 12;
        public static final int REQUEST_GET_TRUNCATE_LENGTH = 13;
        public static final int RESPONSE_GET_BYTES = 21;
        public static final int RESPONSE_SET = 22;
        public static final int RESPONSE_GET_CHARS = 23;
        public static final int RESPONSE_GET_BYTE_PATTERN_POSITION = 25;
        public static final int RESPONSE_GET_CHAR_PATTERN_POSITION = 26;
        public static final int RESPONSE_CREATE_BYTES = 27;
        public static final int RESPONSE_CREATE_CHARS = 28;
        public static final int RESPONSE_TRUNCATE = 29;
    }
}

